/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.designtime.DtSimpleTypeExpanded;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.tools.simpletype.SimpletypeCheckCaller;
import com.sap.dictionary.tools.simpletype.SimpletypeConstants;
import com.sap.dictionary.tools.simpletype.SimpletypeDatabaseForm;
import com.sap.dictionary.tools.simpletype.SimpletypeResetCaller;
import com.sap.dictionary.tools.simpletype.SimpletypeTextElement;
import com.sap.dictionary.tools.simpletype.TextPool;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.tssap.util.ui.glpc.section.AbstractSection;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.Set;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SimpletypeDBPropertySection
extends AbstractSection {
    private SimpletypeDatabaseForm mForm = null;
    private Label labelJdbcTypeName;
    public Combo comboJdbcTypeName;
    public Label textlabelJdbcTypeName;
    public String yyJdbcTypeName;
    public Button buttonJdbcTypeName;
    private Label labelDbDefault;
    public Text textDbDefault;
    public String yyDbDefault;
    public Button buttonDbDefault;
    public Button buttonNotNull;
    public BooleanEnum yyNotNull;
    public Button buttonModNotNull;
    public Label markerJdbcTypeName;
    public Label markerDbDefault;
    public Label markerNotNull;
    public Button buttonChange;
    public FocusEvent focusEvent = null;

    public SimpletypeDBPropertySection(IWidgetFactory widgetFactory, int columns, String title, String description, SimpletypeDatabaseForm form) {
        super(widgetFactory, columns, title, description);
        this.mForm = form;
    }

    public SimpletypeDBPropertySection(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description, SimpletypeDatabaseForm form) {
        super(widgetFactory, columns, equalColumns, title, description);
        this.mForm = form;
    }

    protected void preInitSection(IGridLayoutPane glp) {
    }

    protected void postInitSection(IGridLayoutPane glp) {
    }

    public void initSection(IGridLayoutPane glp) {
        String jdbcType;
        SectionModifyListener modListener = new SectionModifyListener();
        ButtonSelectionListener butListener = new ButtonSelectionListener();
        SectionMouseListener mouseListener = new SectionMouseListener();
        SectionFocusListener focusListener = new SectionFocusListener();
        Set hJdbcTypes = DtTypeInfo.getSupportedJdbcTypes();
        Object[] oJdbcTypes = hJdbcTypes.toArray();
        String[] jdbcTypes = new String[oJdbcTypes.length + 1];
        jdbcTypes[0] = "";
        int i = 0;
        while (i < oJdbcTypes.length) {
            jdbcTypes[i + 1] = (String)oJdbcTypes[i];
            ++i;
        }
        this.labelJdbcTypeName = glp.addTextLabel("JDBC Type:", glp.createGridLayoutData(4, 2, 1, 1));
        this.yyJdbcTypeName = jdbcType = this.mForm.getEditor().getJdbcTypeName(this.mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.jdbcLength);
        this.textlabelJdbcTypeName = glp.addTextLabel(jdbcType, glp.createGridLayoutData(4, 2, 3, 1));
        SimpletypeTextElement tDbDefault = new SimpletypeTextElement(this.mForm.getEditor(), glp, "DB Default:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    return new DtSimpleTypeExpanded(((SimpletypeDBPropertySection)SimpletypeDBPropertySection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getDbDefault();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeDBPropertySection.this.checkDbDefault();
            }

            public void setTooltip(Text text) {
                ((SimpletypeDBPropertySection)SimpletypeDBPropertySection.this).mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.setToolTip(text);
            }
        });
        this.labelDbDefault = tDbDefault.wlabel;
        this.textDbDefault = tDbDefault.wtext;
        this.buttonDbDefault = tDbDefault.wbutton;
        this.textDbDefault.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpletypeDBPropertySection.this.updateBuffer();
            }
        });
        this.markerDbDefault = tDbDefault.wmarker;
        this.buttonNotNull = glp.addCheckBox("Not Null", true, glp.createGridLayoutData(1, 2, 2, 1));
        this.buttonNotNull.addSelectionListener((SelectionListener)butListener);
        this.buttonNotNull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpletypeDBPropertySection.this.updateBuffer();
                SimpletypeDBPropertySection.this.checkNotNull();
            }
        });
        this.buttonModNotNull = glp.addPushButton("", glp.createGridLayoutData(3, 2, false, false, 1, 1));
        this.buttonModNotNull.setImage(this.mForm.getEditor().modifyImage);
        this.buttonModNotNull.setToolTipText("Overwrite Base Type");
        this.buttonModNotNull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SimpletypeDBPropertySection.this.buttonNotNull.getEnabled()) {
                    SimpletypeDBPropertySection.this.mForm.getEditor().makeDirty();
                    SimpletypeDBPropertySection.this.buttonNotNull.setEnabled(true);
                    SimpletypeDBPropertySection.this.buttonNotNull.setFocus();
                    SimpletypeDBPropertySection.this.buttonModNotNull.setImage(((SimpletypeDBPropertySection)SimpletypeDBPropertySection.this).mForm.getEditor().resetImage);
                    SimpletypeDBPropertySection.this.buttonModNotNull.setToolTipText("Reset to Base Type");
                } else {
                    SimpletypeDBPropertySection.this.mForm.getEditor().makeDirty();
                    try {
                        SimpletypeDBPropertySection.this.buttonNotNull.setSelection(new DtSimpleTypeExpanded(((SimpletypeDBPropertySection)SimpletypeDBPropertySection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getNotNull());
                    }
                    catch (Exception e1) {
                        SimpletypeDBPropertySection.this.buttonNotNull.setSelection(false);
                    }
                    SimpletypeDBPropertySection.this.buttonNotNull.setEnabled(false);
                    SimpletypeDBPropertySection.this.buttonNotNull.setFocus();
                    SimpletypeDBPropertySection.this.buttonModNotNull.setImage(((SimpletypeDBPropertySection)SimpletypeDBPropertySection.this).mForm.getEditor().modifyImage);
                    SimpletypeDBPropertySection.this.buttonModNotNull.setToolTipText("Overwrite Base Type");
                    SimpletypeDBPropertySection.this.checkNotNull();
                }
                SimpletypeDBPropertySection.this.yyNotNull = SimpletypeDBPropertySection.this.mForm.getEditor().calculateBooleanProperty(SimpletypeDBPropertySection.this.buttonNotNull);
            }
        });
        this.markerNotNull = glp.addImage(SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_ERROR_TSK"), false, glp.createGridLayoutData(3, 2, false, false, 1, 1));
        this.markerNotNull.setVisible(false);
    }

    public void setAllEditable(boolean editable) {
        this.textDbDefault.setEditable(editable);
        this.buttonNotNull.setEnabled(editable);
    }

    public void clearAll() {
        this.textlabelJdbcTypeName.setText("");
        this.yyJdbcTypeName = "";
        this.textDbDefault.setText("");
        this.buttonNotNull.setSelection(true);
    }

    public void adaptModifyButtons() {
        this.setButtonProperties(this.buttonDbDefault, this.textDbDefault);
        if (!this.buttonNotNull.getEnabled()) {
            this.buttonModNotNull.setImage(this.mForm.getEditor().modifyImage);
            this.buttonModNotNull.setToolTipText("Overwrite Base Type");
        } else {
            this.buttonModNotNull.setImage(this.mForm.getEditor().resetImage);
            this.buttonModNotNull.setToolTipText("Reset to Base Type");
        }
        this.buttonModNotNull.setVisible(this.buttonNotNull.getVisible());
    }

    public void setButtonProperties(Button pbutton, Text ptext) {
        if (!ptext.getEditable()) {
            pbutton.setImage(this.mForm.getEditor().modifyImage);
            pbutton.setToolTipText("Overwrite Base Type");
        } else {
            pbutton.setImage(this.mForm.getEditor().resetImage);
            pbutton.setToolTipText("Reset to Base Type");
        }
        pbutton.setVisible(ptext.getVisible());
    }

    public void setModifyButtonsVisible(boolean visible) {
        this.buttonDbDefault.setVisible(visible);
        this.buttonModNotNull.setVisible(visible);
    }

    public void setModifyButtonsEnabled(boolean enabled) {
        this.buttonDbDefault.setEnabled(enabled);
        this.buttonModNotNull.setEnabled(enabled);
    }

    private void checkDbDefault() {
        String message = "";
        if (!this.textDbDefault.getText().equals("")) {
            message = this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.checkValue(this.textDbDefault);
        }
        SimpletypeConstants.setErrorMarker(message, this.labelDbDefault, this.textDbDefault, this.markerDbDefault);
    }

    public void checkNotNull() {
        if (DtTypeInfo.getJdbcTypesWithoutDefault().contains(this.textlabelJdbcTypeName.getText())) {
            if (this.buttonNotNull.getSelection()) {
                this.markerNotNull.setVisible(true);
                this.markerNotNull.setToolTipText(TextPool.getMessage("Databases do not support NotNull for jdbc type &", this.textlabelJdbcTypeName.getText()));
            } else {
                this.markerNotNull.setVisible(false);
            }
        } else {
            this.markerNotNull.setVisible(false);
        }
    }

    public void adaptNotNull(boolean withMessage) {
        if (DtTypeInfo.getJdbcTypesWithoutDefault().contains(this.textlabelJdbcTypeName.getText())) {
            this.buttonNotNull.setSelection(false);
            this.markerNotNull.setVisible(false);
            if (withMessage) {
                SimpletypeConstants.informationMsg("Information", TextPool.getMessage("Databases do not support NotNull for jdbc type &. The NotNull property will be unchecked on the database tab.", this.textlabelJdbcTypeName.getText()));
            }
        }
    }

    public void adaptNotNullOnClose(boolean withMessage) {
        if (DtTypeInfo.getJdbcTypesWithoutDefault().contains(this.yyJdbcTypeName)) {
            if (this.yyNotNull == BooleanEnum.TRUE) {
                this.yyNotNull = BooleanEnum.FALSE;
            }
            if (withMessage) {
                SimpletypeConstants.informationMsg("Information", TextPool.getMessage("Databases do not support NotNull for jdbc type &. The NotNull property will be unchecked on the database tab.", this.textlabelJdbcTypeName.getText()));
            }
        }
    }

    public void updateBuffer() {
        this.yyDbDefault = this.mForm.getEditor().calculateStringProperty(this.textDbDefault);
        this.yyNotNull = this.mForm.getEditor().calculateBooleanProperty(this.buttonNotNull);
        this.yyJdbcTypeName = this.textlabelJdbcTypeName.getText();
    }

    private class SectionFocusListener
    extends FocusAdapter {
        private SectionFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            SimpletypeDBPropertySection.this.mForm.getEditor().clearAllFocusEvents();
            SimpletypeDBPropertySection.this.focusEvent = e;
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class SectionSelectionListener
    extends SelectionAdapter {
        private SectionSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (SimpletypeDBPropertySection.this.focusEvent != null && SimpletypeDBPropertySection.this.focusEvent.getSource() != null && SimpletypeDBPropertySection.this.focusEvent.getSource() instanceof Text) {
                ((Text)SimpletypeDBPropertySection.this.focusEvent.getSource()).setEditable(true);
            }
        }
    }

    private class SectionMouseListener
    extends MouseAdapter {
        private SectionMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (((SimpletypeDBPropertySection)SimpletypeDBPropertySection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.textBaseTypeFullName.getText() != "") {
                if (e.getSource() instanceof Text) {
                    ((Text)e.getSource()).setEditable(true);
                } else if (e.getSource() instanceof Combo) {
                    ((Combo)e.getSource()).setEnabled(true);
                }
            }
        }
    }

    private class ButtonSelectionListener
    extends SelectionAdapter {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SimpletypeDBPropertySection.this.mForm.getEditor().makeDirty();
        }
    }

    private class SectionModifyListener
    implements ModifyListener {
        private SectionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SimpletypeDBPropertySection.this.mForm.getEditor().makeDirty(e.widget);
        }
    }
}

