/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.tools.simpletype.SimpletypePlugin;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class SimpletypeContentProvider
implements ITreeContentProvider,
DevelopmentObjectObserver {
    private static Object[] EMPTY_ARRAY = new Object[0];
    DtSimpleType[] mSimpleTypes;
    List mRootEntries;
    TreeViewer mViewer;
    DtDictionaryRoot mDictionaryRoot;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DtDictionaryRoot) {
            return this.mRootEntries.toArray();
        }
        if (parentElement instanceof SimpleTypePackage) {
            Object[] st = ((SimpleTypePackage)parentElement).getSimpleTypes();
            Arrays.sort(st, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((DtSimpleType)arg0).getName().compareTo(((DtSimpleType)arg1).getName());
                }

                public boolean equals(Object arg0) {
                    return false;
                }
            });
            return st;
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof DtDictionaryRoot) {
            return null;
        }
        if (element instanceof SimpleTypePackage) {
            return this.mDictionaryRoot;
        }
        if (element instanceof DtSimpleType) {
            return null;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null && inputElement instanceof DictionaryRoot) {
            this.mDictionaryRoot = ((DictionaryRoot)inputElement).getDictionary();
            try {
                this.mSimpleTypes = this.mDictionaryRoot.getSimpleTypes();
            }
            catch (LoadException e) {
                SimpletypePlugin.tracer.error("get simple types", (Throwable)e);
            }
            this.mRootEntries = this.getRootEntries(this.mSimpleTypes);
        }
        return new Object[]{this.mDictionaryRoot};
    }

    public void dispose() {
        if (this.mDictionaryRoot != null) {
            this.mDictionaryRoot.detachGlobalObserver((DevelopmentObjectObserver)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mViewer = (TreeViewer)viewer;
        if (oldInput != null && oldInput instanceof DictionaryRoot) {
            ((DictionaryRoot)oldInput).getDictionary().detachGlobalObserver((DevelopmentObjectObserver)this);
        }
        if (newInput != null) {
            ((DictionaryRoot)newInput).getDictionary().attachGlobalObserver((DevelopmentObjectObserver)this);
        }
    }

    public void update(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof DtDictionaryRoot) {
            this.mViewer.refresh((Object)event.getModifiedObject());
        }
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }

    private List getRootEntries(DtSimpleType[] types) {
        String packageName;
        ArrayList<SimpleTypePackage> entries = new ArrayList<SimpleTypePackage>();
        int i = 0;
        while (i < types.length) {
            String typeName = types[i].getName();
            if (!typeName.equals("") && (typeName.charAt(0) >= 'A' && typeName.charAt(0) <= 'Z' || typeName.charAt(0) >= 'a' && typeName.charAt(0) <= 'z')) {
                String stName;
                packageName = types[i].getPackage();
                boolean createPackage = true;
                if (!(packageName == null || packageName.equals("com.sap.dictionary") || packageName.equals("com.sap.dictionary.predefined.objecttypes") || types[i].hasLogicalDictionary() || packageName.equals("com.sap.dictionary.predefined.currency") && !(stName = types[i].getName()).equals("currency") && !stName.equals("currencyNormalized"))) {
                    int j = 0;
                    while (j < entries.size()) {
                        SimpleTypePackage thePackage = (SimpleTypePackage)entries.get(j);
                        if (thePackage.getPackageName().equals(packageName)) {
                            thePackage.addType(types[i]);
                            createPackage = false;
                            break;
                        }
                        ++j;
                    }
                    if (createPackage) {
                        entries.add(new SimpleTypePackage(types[i]));
                    }
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < types.length) {
            packageName = types[i2].getPackage();
            if (packageName == null) {
                entries.add((SimpleTypePackage)types[i2]);
            }
            ++i2;
        }
        Collections.sort(entries, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((SimpleTypePackage)arg0).getPackageName().compareTo(((SimpleTypePackage)arg1).getPackageName());
            }

            public boolean equals(Object arg0) {
                return false;
            }
        });
        return entries;
    }

    public static class DictionaryRoot {
        private DtDictionaryRoot mDictionary;

        DictionaryRoot(DtDictionaryRoot dictionary) {
            this.mDictionary = dictionary;
        }

        public DtDictionaryRoot getDictionary() {
            return this.mDictionary;
        }
    }

    public static class SimpleTypePackage {
        private String mPackageName;
        private List mTypes = new ArrayList();

        public SimpleTypePackage(DtSimpleType type) {
            this.mPackageName = type.getPackage();
            this.mTypes.add(type);
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public void addType(DtSimpleType type) {
            this.mTypes.add(type);
        }

        public DtSimpleType[] getSimpleTypes() {
            DtSimpleType[] types = new DtSimpleType[this.mTypes.size()];
            return this.mTypes.toArray(types);
        }
    }
}

