/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.designtime.DtSimpleTypeChecker;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.tools.simpletype.SimpletypeConstants;
import com.sap.dictionary.tools.simpletype.SimpletypeDefinitionForm;
import com.sap.dictionary.tools.simpletype.SimpletypePlugin;
import com.sap.dictionary.tools.simpletype.SimpletypeSelectionDialog;
import com.sap.dictionary.tools.simpletype.TextPool;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.util.ui.glpc.section.AbstractSection;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SimpletypeBasicInfoSection
extends AbstractSection {
    private SimpletypeDefinitionForm mForm = null;
    private Label labelName;
    public Text textName;
    private Label labelPackage;
    public Text textPackage;
    private Label labelDictionary;
    public Text textDictionary;
    private Label labelBaseTypeFullName;
    public Text textBaseTypeFullName;
    public String yyBaseTypeFullName;
    private Button buttonBrowseBaseType;
    private Button buttonDummy;
    private Label labelBuiltInType;
    public Combo comboBuiltInType;
    public String yyBuiltInType;
    private Label labelDescription;
    public Text textDescription;
    public String yyDescription;
    public DtSimpleType currentBaseType;
    private boolean dirtyBaseTypeName = false;
    private String previousBaseTypeName = "";
    public String previousBuiltInTypeName = "";
    private FocusListener baseTypeFocusListener;

    public SimpletypeBasicInfoSection(IWidgetFactory widgetFactory, int columns, String title, String description, SimpletypeDefinitionForm form) {
        super(widgetFactory, columns, title, description);
        this.mForm = form;
    }

    public SimpletypeBasicInfoSection(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description, SimpletypeDefinitionForm form) {
        super(widgetFactory, columns, equalColumns, title, description);
        this.mForm = form;
    }

    protected void preInitSection(IGridLayoutPane glp) {
    }

    protected void postInitSection(IGridLayoutPane glp) {
    }

    public void initSection(IGridLayoutPane glp) {
        String[] builtInTypes = SimpletypeBasicInfoSection.getBuiltInTypes();
        SectionModifyListener modListener = new SectionModifyListener();
        this.labelName = glp.addTextLabel("Name:", glp.createGridLayoutData(4, 2, 1, 1));
        this.textName = glp.addTextField("", true, glp.createGridLayoutData(4, 2, true, false, 1, 1));
        glp.addTextLabel("");
        this.labelPackage = glp.addTextLabel("Package:", glp.createGridLayoutData(4, 2, 1, 1));
        this.textPackage = glp.addTextField("", true, glp.createGridLayoutData(4, 2, true, false, 1, 1));
        this.buttonDummy = glp.addPushButton("Dummy", glp.createGridLayoutData(1, 2, true, false, 1, 1));
        this.buttonDummy.getShell().setDefaultButton(this.buttonDummy);
        this.buttonDummy.setVisible(false);
        this.labelDictionary = glp.addTextLabel("Dictionary:", glp.createGridLayoutData(4, 2, 1, 1));
        this.textDictionary = glp.addTextField("", true, glp.createGridLayoutData(4, 2, true, false, 1, 1));
        glp.addTextLabel("");
        this.labelBaseTypeFullName = glp.addTextLabel("Base Type:", glp.createGridLayoutData(4, 2, 1, 1));
        this.textBaseTypeFullName = glp.addTextField("", false, glp.createGridLayoutData(4, 2, true, false, 1, 1));
        this.buttonBrowseBaseType = glp.addPushButton("Browse...", glp.createGridLayoutData(1, 2, true, false, 1, 1));
        this.buttonBrowseBaseType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DtSimpleType simpleType;
                SimpletypeSelectionDialog dialog = new SimpletypeSelectionDialog("Simple Type Selection", "Select a simple type in the tree viewer", ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().dictRoot, SimpletypeBasicInfoSection.this.mForm.getEditor());
                if (dialog.open() == 0 && (simpleType = dialog.getSimpleType()) != null) {
                    String lBaseTypeName = simpleType.getTypeName();
                    String lBaseTypePrefix = simpleType.getPackage();
                    String lBaseTypeFullName = "";
                    if (lBaseTypeName != null & lBaseTypePrefix != null) {
                        lBaseTypeFullName = lBaseTypePrefix + "." + lBaseTypeName;
                    }
                    SimpletypeBasicInfoSection.this.textBaseTypeFullName.setText(lBaseTypeFullName);
                    SimpletypeBasicInfoSection.this.textBaseTypeFullName.removeFocusListener(SimpletypeBasicInfoSection.this.baseTypeFocusListener);
                    SimpletypeBasicInfoSection.this.replaceBaseType();
                    SimpletypeBasicInfoSection.this.textBaseTypeFullName.addFocusListener(SimpletypeBasicInfoSection.this.baseTypeFocusListener);
                    SimpletypePlugin.getDefault().activatePartListener();
                }
            }
        });
        this.labelBuiltInType = glp.addTextLabel("Built-In Type:", glp.createGridLayoutData(4, 2, 1, 1));
        this.comboBuiltInType = glp.addComboBox(builtInTypes, "string", true, glp.createGridLayoutData(4, 2, true, false, 1, 1));
        glp.addTextLabel("");
        this.labelDescription = glp.addTextLabel("Description:", glp.createGridLayoutData(4, 2, 1, 1));
        this.textDescription = glp.addTextField("", false, glp.createGridLayoutData(4, 2, true, false, 1, 1));
        this.textDescription.addModifyListener((ModifyListener)modListener);
        glp.addTextLabel("");
        glp.addPlaceholder();
        this.textBaseTypeFullName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean confirmed = true;
                SimpletypeBasicInfoSection.this.mForm.getEditor().makeDirty(e.widget);
                if (!((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().isLoading) {
                    SimpletypeBasicInfoSection.this.dirtyBaseTypeName = true;
                } else {
                    SimpletypeBasicInfoSection.this.previousBaseTypeName = SimpletypeBasicInfoSection.this.textBaseTypeFullName.getText();
                }
                if (SimpletypeBasicInfoSection.this.textBaseTypeFullName.getText().equals("")) {
                    SimpletypeBasicInfoSection.this.mForm.getEditor().setAllEditable(true);
                    SimpletypeBasicInfoSection.this.comboBuiltInType.setEnabled(true);
                    SimpletypeBasicInfoSection.this.setEditableForBuiltInType();
                    SimpletypeBasicInfoSection.this.setVisibleForBuiltInType();
                    SimpletypeBasicInfoSection.this.mForm.getEditor().setChangeButtonsVisible(false);
                    SimpletypeBasicInfoSection.this.mForm.getEditor().setModifyButtonsVisible(false);
                    ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(0, true);
                    ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(1, true);
                } else {
                    SimpletypeBasicInfoSection.this.textDescription.setEditable(true);
                    SimpletypeBasicInfoSection.this.comboBuiltInType.setEnabled(false);
                    ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(0, false);
                    ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(1, false);
                }
            }
        });
        this.baseTypeFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                SimpletypeBasicInfoSection.this.replaceBaseType();
                SimpletypePlugin.getDefault().activatePartListener();
            }
        };
        this.textBaseTypeFullName.addFocusListener(this.baseTypeFocusListener);
        this.comboBuiltInType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean confirmed = true;
                if (!((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().isLoading) {
                    confirmed = SimpletypeConstants.confirmMsg("Replace Built-In Type", "Properties will be cleared from display. Do you want to replace the built-in type?");
                }
                if (confirmed) {
                    if (!((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().isLoading) {
                        SimpletypeBasicInfoSection.this.mForm.getEditor().makeDirty();
                    }
                    SimpletypeBasicInfoSection.this.previousBuiltInTypeName = SimpletypeBasicInfoSection.this.comboBuiltInType.getText();
                    if (SimpletypeBasicInfoSection.this.textBaseTypeFullName.getText().equals("")) {
                        SimpletypeBasicInfoSection.this.setEditableForBuiltInType();
                        SimpletypeBasicInfoSection.this.setVisibleForBuiltInType();
                        SimpletypeBasicInfoSection.this.mForm.getEditor().setModifyButtonsVisible(false);
                        SimpletypeBasicInfoSection.this.mForm.getEditor().clearAll();
                        if (!((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().isLoading) {
                            ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().simpletypeEnumerationForm.enumTableModel.deleteAllEnumerationValues();
                        }
                    }
                } else {
                    ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().isLoading = true;
                    SimpletypeBasicInfoSection.this.comboBuiltInType.setText(SimpletypeBasicInfoSection.this.previousBuiltInTypeName);
                    ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().isLoading = false;
                }
                String jdbcType = SimpletypeBasicInfoSection.this.mForm.getEditor().getJdbcTypeName(SimpletypeBasicInfoSection.this.comboBuiltInType.getText(), ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.lengthConstraintsSection.jdbcLength);
                Label labelJdbcType = ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().simpletypeDatabaseForm.dbPropertySection.textlabelJdbcTypeName;
                if (labelJdbcType != null) {
                    labelJdbcType.setText(jdbcType);
                    ((SimpletypeBasicInfoSection)SimpletypeBasicInfoSection.this).mForm.getEditor().simpletypeDatabaseForm.dbPropertySection.yyJdbcTypeName = jdbcType;
                }
                SimpletypePlugin.getDefault().activatePartListener();
                SimpletypeBasicInfoSection.this.mForm.getEditor().updateBuffer();
            }
        });
    }

    public void setEditableForBuiltInType() {
        String s = this.comboBuiltInType.getText();
        this.mForm.lengthConstraintsSection.setAllEditable(false);
        this.mForm.valueConstraintsSection.setAllEditable(false);
        this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.setAllEditable(false);
        this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(0, false);
        this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(1, false);
        if (s.equals("string")) {
            this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.buttonWithClassRepresentation.setEnabled(true);
        } else {
            this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.buttonWithClassRepresentation.setEnabled(false);
        }
        HashSet hValidConstraints = DtSimpleTypeChecker.getValidConstraints((String)s);
        if (hValidConstraints != null) {
            Object[] oValidConstraints = ((AbstractCollection)hValidConstraints).toArray();
            int i = 0;
            while (i < oValidConstraints.length) {
                this.setValidConstraintsEditable((String)oValidConstraints[i]);
                ++i;
            }
        }
        this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.buttonReadOnly.setEnabled(true);
        HashSet hValidRepresentations = DtSimpleTypeChecker.getValidRepresentations((String)s);
        if (hValidRepresentations != null) {
            Object[] oValidRepresentations = ((AbstractCollection)hValidRepresentations).toArray();
            int i = 0;
            while (i < oValidRepresentations.length) {
                this.setValidRepresentationsEditable((String)oValidRepresentations[i]);
                ++i;
            }
        }
    }

    private void setValidConstraintsEditable(String co) {
        if (co.equals("minInclusive")) {
            this.mForm.valueConstraintsSection.textMinInclusive.setEditable(true);
        } else if (co.equals("maxInclusive")) {
            this.mForm.valueConstraintsSection.textMaxInclusive.setEditable(true);
        } else if (co.equals("minExclusive")) {
            this.mForm.valueConstraintsSection.textMinExclusive.setEditable(true);
        } else if (co.equals("maxExclusive")) {
            this.mForm.valueConstraintsSection.textMaxExclusive.setEditable(true);
        } else if (co.equals("pattern")) {
            this.mForm.valueConstraintsSection.textPattern.setEditable(true);
        } else if (co.equals("length")) {
            this.mForm.lengthConstraintsSection.textLength.setEditable(true);
        } else if (co.equals("minLength")) {
            this.mForm.lengthConstraintsSection.textMinLength.setEditable(true);
        } else if (co.equals("maxLength")) {
            this.mForm.lengthConstraintsSection.textMaxLength.setEditable(true);
        } else if (co.equals("totalDigits")) {
            this.mForm.lengthConstraintsSection.textTotalDigits.setEditable(true);
        } else if (co.equals("fractionDigits")) {
            this.mForm.lengthConstraintsSection.textFractionDigits.setEditable(true);
        } else if (co.equals("enumeration")) {
            this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(0, true);
            this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(1, true);
        }
    }

    private void setValidRepresentationsEditable(String co) {
        if (co.equals("maxExternalLength")) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.textExternalLength.setEditable(true);
        } else if (co.equals("format")) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.textFormat.setEditable(true);
        } else if (co.equals("uppercase")) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.buttonUppercase.setEnabled(true);
        } else if (co.equals("translateFlag")) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.buttonTranslate.setEnabled(true);
        }
    }

    public void setVisibleForBuiltInType() {
        HashSet hValidRepresentations;
        String s = this.comboBuiltInType.getText();
        this.mForm.lengthConstraintsSection.setLengthConstraintsVisible(false);
        this.mForm.lengthConstraintsSection.setDigitsConstraintsVisible(false);
        this.mForm.valueConstraintsSection.setBoundaryConstraintsVisible(false);
        this.mForm.valueConstraintsSection.setPatternConstraintsVisible(false);
        this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.setAllVisible(false);
        HashSet hValidConstraints = DtSimpleTypeChecker.getValidConstraints((String)s);
        if (hValidConstraints != null) {
            Object[] oValidConstraints = ((AbstractCollection)hValidConstraints).toArray();
            int i = 0;
            while (i < oValidConstraints.length) {
                this.setValidConstraintsVisible((String)oValidConstraints[i]);
                ++i;
            }
        }
        if ((hValidRepresentations = DtSimpleTypeChecker.getValidRepresentations((String)s)) != null) {
            Object[] oValidRepresentations = ((AbstractCollection)hValidRepresentations).toArray();
            int i = 0;
            while (i < oValidRepresentations.length) {
                this.setValidRepresentationsVisible((String)oValidRepresentations[i]);
                ++i;
            }
        }
    }

    private void setValidConstraintsVisible(String co) {
        if (co.equals("minInclusive")) {
            this.mForm.valueConstraintsSection.textMinInclusive.setVisible(true);
            this.mForm.valueConstraintsSection.labelMinInclusive.setEnabled(true);
        } else if (co.equals("maxInclusive")) {
            this.mForm.valueConstraintsSection.textMaxInclusive.setVisible(true);
            this.mForm.valueConstraintsSection.labelMaxInclusive.setEnabled(true);
        } else if (co.equals("minExclusive")) {
            this.mForm.valueConstraintsSection.textMinExclusive.setVisible(true);
            this.mForm.valueConstraintsSection.labelMinExclusive.setEnabled(true);
        } else if (co.equals("maxExclusive")) {
            this.mForm.valueConstraintsSection.textMaxExclusive.setVisible(true);
            this.mForm.valueConstraintsSection.labelMaxExclusive.setEnabled(true);
        } else if (co.equals("pattern")) {
            this.mForm.valueConstraintsSection.textPattern.setVisible(false);
            this.mForm.valueConstraintsSection.labelPattern.setEnabled(true);
        } else if (co.equals("length")) {
            this.mForm.lengthConstraintsSection.textLength.setVisible(true);
            this.mForm.lengthConstraintsSection.labelLength.setEnabled(true);
        } else if (co.equals("minLength")) {
            this.mForm.lengthConstraintsSection.textMinLength.setVisible(true);
            this.mForm.lengthConstraintsSection.labelMinLength.setEnabled(true);
        } else if (co.equals("maxLength")) {
            this.mForm.lengthConstraintsSection.textMaxLength.setVisible(true);
            this.mForm.lengthConstraintsSection.labelMaxLength.setEnabled(true);
        } else if (co.equals("totalDigits")) {
            this.mForm.lengthConstraintsSection.textTotalDigits.setVisible(true);
            this.mForm.lengthConstraintsSection.labelTotalDigits.setEnabled(true);
        } else if (co.equals("fractionDigits")) {
            this.mForm.lengthConstraintsSection.textFractionDigits.setVisible(true);
            this.mForm.lengthConstraintsSection.labelFractionDigits.setEnabled(true);
        }
    }

    private void setValidRepresentationsVisible(String co) {
        if (co.equals("maxExternalLength")) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.textExternalLength.setVisible(true);
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.labelExternalLength.setEnabled(true);
        } else if (co.equals("format")) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.textFormat.setVisible(true);
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.labelFormat.setEnabled(true);
        } else if (co.equals("uppercase")) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.buttonUppercase.setData((Object)"V");
        } else if (co.equals("translateFlag")) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.buttonTranslate.setData((Object)"V");
        }
    }

    public void setEditableAndVisible() {
        this.textName.setEditable(false);
        if (this.textBaseTypeFullName.getText().equals("")) {
            this.mForm.getEditor().setModifyButtonsVisible(false);
            this.mForm.getEditor().setChangeButtonsVisible(false);
            this.mForm.getEditor().setAllEditable(true);
            this.textBaseTypeFullName.setEditable(true);
            this.comboBuiltInType.setEnabled(true);
            this.textDescription.setEditable(true);
            this.setEditableForBuiltInType();
            this.setVisibleForBuiltInType();
        } else {
            this.mForm.getEditor().setChangeButtonsVisible(true);
            this.textBaseTypeFullName.setEditable(true);
            this.comboBuiltInType.setEnabled(false);
            this.textDescription.setEditable(true);
            this.setVisibleForBuiltInType();
        }
    }

    public void adaptAllErrorMarkers() {
        if (!this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textLength.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.markerLength.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textMinLength.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.markerMinLength.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textMaxLength.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.markerMaxLength.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textTotalDigits.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.markerTotalDigits.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textFractionDigits.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.markerFractionDigits.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.textMinInclusive.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.markerMinInclusive.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.textMaxInclusive.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.markerMaxInclusive.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.textMinExclusive.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.markerMinExclusive.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.textMaxExclusive.getVisible()) {
            this.mForm.getEditor().simpletypeDefinitionForm.valueConstraintsSection.markerMaxExclusive.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.textFormat.getVisible()) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.markerFormat.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.buttonUppercase.getVisible()) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.markerUppercase.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.buttonTranslate.getVisible()) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.markerTranslate.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.buttonReadOnly.getVisible()) {
            this.mForm.getEditor().simpletypeRepresentationForm.externalRepresentationSection.markerReadOnly.setVisible(false);
        }
        if (!this.mForm.getEditor().simpletypeDatabaseForm.dbPropertySection.textDbDefault.getVisible()) {
            this.mForm.getEditor().simpletypeDatabaseForm.dbPropertySection.markerDbDefault.setVisible(false);
        }
    }

    public void setAllEditable(boolean editable) {
        this.textBaseTypeFullName.setEditable(editable);
        this.buttonBrowseBaseType.setEnabled(editable);
        this.comboBuiltInType.setEnabled(editable);
        this.textDescription.setEditable(editable);
    }

    public String getBaseTypeName(String bt) {
        int li = bt.lastIndexOf(".") + 1;
        try {
            String ls = bt.substring(li);
            return ls;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getBaseTypePrefix(String bt) {
        int li = bt.lastIndexOf(".");
        try {
            String ls = bt.substring(0, li);
            return ls;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replaceBaseType() {
        block16: {
            block17: {
                boolean confirmed;
                block15: {
                    confirmed = true;
                    if (!this.textBaseTypeFullName.getText().equals("")) break block15;
                    if (!this.previousBaseTypeName.equals("")) {
                        if (!SimpletypeConstants.confirmMsg("Remove Base Type", "Properties will be cleared from display. Do you want to remove the base type?")) {
                            this.textBaseTypeFullName.setText(this.previousBaseTypeName);
                            return;
                        }
                        this.mForm.getEditor().setAllEditable(true);
                        this.comboBuiltInType.setEnabled(true);
                        this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(0, true);
                        this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(1, true);
                        this.setEditableForBuiltInType();
                        this.setVisibleForBuiltInType();
                        this.mForm.getEditor().clearAll();
                        this.mForm.getEditor().setChangeButtonsVisible(false);
                        this.mForm.getEditor().setModifyButtonsVisible(false);
                        this.mForm.getEditor().simpletypeEnumerationForm.enumTableModel.deleteAllEnumerationValues();
                    }
                    break block16;
                }
                DtSimpleType lBaseType = null;
                if (!this.dirtyBaseTypeName) break block16;
                if (!this.mForm.getEditor().dictRoot.hasSimpleType(this.getBaseTypePrefix(this.textBaseTypeFullName.getText()), this.getBaseTypeName(this.textBaseTypeFullName.getText()))) break block17;
                try {
                    lBaseType = this.mForm.getEditor().dictRoot.getSimpleType(this.getBaseTypePrefix(this.textBaseTypeFullName.getText()), this.getBaseTypeName(this.textBaseTypeFullName.getText()));
                }
                catch (LoadException e1) {
                    SimpletypeConstants.errMsg("Base Type could not be loaded");
                    return;
                }
                if (lBaseType != null) {
                    if (this.mForm.getEditor().checkForCycle(lBaseType)) {
                        MessageDialog.openError((Shell)this.mForm.getEditor().getSite().getShell(), (String)"Cyclic Dependency", (String)"Base Type depends on current simple type");
                        return;
                    }
                    if (lBaseType.hasLogicalDictionary()) {
                        MessageDialog.openError((Shell)this.mForm.getEditor().getSite().getShell(), (String)"Invalid Base Type", (String)TextPool.getMessage("Simple Type & is imported from an external dictionary. It cannot be used as a base type.", this.textBaseTypeFullName.getText()));
                        return;
                    }
                    String baseTypePackage = this.getBaseTypePrefix(this.textBaseTypeFullName.getText());
                    if (baseTypePackage.equals("com.sap.dictionary") || baseTypePackage.equals("com.sap.dictionary.predefined.objecttypes")) {
                        MessageDialog.openError((Shell)this.mForm.getEditor().getSite().getShell(), (String)"Invalid Base Type", (String)TextPool.getMessage("Simple Type & is a predefined internal dictionary type. It cannot be used as a base type.", this.textBaseTypeFullName.getText()));
                        return;
                    }
                    String lname = this.textName.getText();
                    String lbase = this.textBaseTypeFullName.getText();
                    String lpackage = this.textPackage.getText();
                    confirmed = this.previousBaseTypeName.equals("") ? (this.comboBuiltInType.getText().equals("") ? true : MessageDialog.openConfirm((Shell)this.mForm.getEditor().getSite().getShell(), (String)"Replace Type", (String)"Properties will be cleared from display. Do you want to replace the built-in type with a base type?")) : MessageDialog.openConfirm((Shell)this.mForm.getEditor().getSite().getShell(), (String)"Replace Base Type", (String)"Properties will be cleared from display. Do you want to replace the base type?");
                    if (confirmed) {
                        this.mForm.getEditor().clearAll();
                        this.mForm.getEditor().loadRecursivelySimpleType(lBaseType);
                        this.currentBaseType = lBaseType;
                        if (this.mForm.getEditor().dictSimpleType.hasBaseType()) {
                            if (this.mForm.getEditor().dictSimpleType.getBaseTypeName().equals(lbase)) {
                                this.mForm.getEditor().loadSimpleType(this.mForm.getEditor().dictSimpleType);
                            } else {
                                this.mForm.getEditor().setAllEditable(false);
                            }
                        } else {
                            this.mForm.getEditor().setAllEditable(false);
                        }
                        this.textName.setText(lname);
                        this.textBaseTypeFullName.setText(lbase);
                        this.textPackage.setText(lpackage);
                        this.textDescription.setEditable(true);
                        this.comboBuiltInType.setEnabled(false);
                        this.setVisibleForBuiltInType();
                        this.mForm.getEditor().setChangeButtonsVisible(true);
                        this.mForm.getEditor().adaptModifyButtons();
                        this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(0, false);
                        this.mForm.getEditor().simpletypeEnumerationForm.enumerationSection.setButtonEnabled(1, false);
                        this.mForm.getEditor().simpletypeEnumerationForm.enumTableModel.deleteAllEnumerationValues();
                        break block16;
                    } else {
                        this.mForm.getEditor().isLoading = true;
                        this.textBaseTypeFullName.setText(this.previousBaseTypeName);
                        this.mForm.getEditor().isLoading = false;
                    }
                }
                break block16;
            }
            MessageDialog.openError((Shell)this.mForm.getEditor().getSite().getShell(), (String)"Input Error", (String)TextPool.getMessage("Simple Type & does not exist.", this.textBaseTypeFullName.getText()));
        }
        this.dirtyBaseTypeName = false;
        this.previousBaseTypeName = this.textBaseTypeFullName.getText();
        this.adaptAllErrorMarkers();
        this.mForm.getEditor().updateBuffer();
    }

    public static String[] getBuiltInTypes() {
        HashSet hBuiltInTypes = DtTypeInfo.getBuiltInTypes();
        Object[] oBuiltInTypes = ((AbstractCollection)hBuiltInTypes).toArray();
        TreeSet<String> tBuiltInTypes = new TreeSet<String>();
        int i = 0;
        while (i < oBuiltInTypes.length) {
            String builtInType = (String)oBuiltInTypes[i];
            if (builtInType != null) {
                tBuiltInTypes.add(builtInType);
            }
            ++i;
        }
        oBuiltInTypes = tBuiltInTypes.toArray();
        String[] builtInTypes = new String[oBuiltInTypes.length];
        int i2 = 0;
        while (i2 < oBuiltInTypes.length) {
            builtInTypes[i2] = (String)oBuiltInTypes[i2];
            ++i2;
        }
        return builtInTypes;
    }

    public void updateBuffer() {
        this.yyBaseTypeFullName = this.textBaseTypeFullName.getText();
        this.yyBuiltInType = this.mForm.getEditor().calculateStringPropertyFromCombo(this.comboBuiltInType);
        this.yyDescription = this.mForm.getEditor().calculateStringProperty(this.textDescription);
    }

    private class SectionModifyListener
    implements ModifyListener {
        private SectionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SimpletypeBasicInfoSection.this.updateBuffer();
            SimpletypeBasicInfoSection.this.mForm.getEditor().makeDirty(e.widget);
        }
    }
}

