/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.wizards.typeselection;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.sap.ide.webdynpro.service.core.wizards.typeselection.DictionaryTreeContentProvider;
import com.sap.ide.webdynpro.service.core.wizards.typeselection.DictionaryTreeLabelProvider;
import com.sap.ide.webdynpro.service.core.wizards.typeselection.DictionaryTreeSorter;
import com.sap.ide.webdynpro.service.core.wizards.typeselection.TypeSelectionDialog;
import com.sap.ide.webdynpro.ui.tree.TreeExpandListener;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TypeSelectionPage
extends WizardPage {
    private static final String PAGE_NAME = "TypeSelection";
    private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    private TreeViewer mViewer;
    private Text mTextJavaType;
    private Button mButtonSimpleType;
    private Button mButtonJavaNativeType;
    private Composite mStackComposite;
    private IGridLayoutPane mJavaNativeTypeSelectionPane;
    private IGridLayoutPane mSimpleTypeSelectionPane;
    private IJavaProject mJavaProject;
    private boolean mIsSimpleTypeSelection = true;
    private DtSimpleType mSimpleType;
    private String mQualifiedJavaTypeName;
    private DtDictionaryRoot mDictionaryRoot;
    private MetamodelServices.CompoundType mInitialType;

    public TypeSelectionPage(DtDictionaryRoot dictionaryRoot, DevelopmentObject initialType) {
        super(PAGE_NAME);
        this.setTitle(TextPool.getInstance().getText(431));
        this.setDescription(TextPool.getInstance().getText(432));
        this.mDictionaryRoot = dictionaryRoot;
        if (initialType != null) {
            this.mInitialType = new MetamodelServices.CompoundType(initialType);
        }
    }

    public DtSimpleType getSimpleType() {
        return this.mSimpleType;
    }

    public String getQualifiedJavaNativeTypeName() {
        return this.mQualifiedJavaTypeName;
    }

    public boolean isSimpleTypeSelection() {
        return this.mIsSimpleTypeSelection;
    }

    public void createControl(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new FillLayout());
        this.setControl((Control)contents);
        IGridLayoutPane pane = PaneFactory.createGridLayoutPane((Composite)contents, (int)1);
        this.mButtonSimpleType = pane.addRadioButton(TextPool.getInstance().getText(433), pane.createGridLayoutData(4, 1, true, false));
        TypeSelectionListener typeSelection = new TypeSelectionListener();
        this.mButtonSimpleType.addSelectionListener((SelectionListener)typeSelection);
        this.mButtonJavaNativeType = pane.addRadioButton(TextPool.getInstance().getText(434), pane.createGridLayoutData(4, 1, true, false));
        this.mButtonJavaNativeType.addSelectionListener((SelectionListener)typeSelection);
        pane.addTextLabel("");
        Label separator = pane.addHorizontalSeparator();
        pane.addTextLabel("");
        ISimplePane stackPane = pane.addSimplePane(true, true);
        this.mStackComposite = stackPane.getComposite();
        this.mStackComposite.setLayout((Layout)new StackLayout());
        this.mJavaNativeTypeSelectionPane = PaneFactory.createGridLayoutPane((Composite)stackPane.getComposite(), (int)3);
        this.mJavaNativeTypeSelectionPane.addTextLabel(TextPool.getInstance().getText(434), this.mJavaNativeTypeSelectionPane.createGridLayoutData(1, 1));
        IGridLayoutData gridData = this.mJavaNativeTypeSelectionPane.createGridLayoutData(4, 1, true, false);
        gridData.getGridData().horizontalIndent = 5;
        this.mTextJavaType = this.mJavaNativeTypeSelectionPane.addTextField(false, gridData);
        this.mTextJavaType.addModifyListener((ModifyListener)new JavaTypeModifyListener());
        Button button = this.mJavaNativeTypeSelectionPane.addPushButton(CoreTextPool.getInstance().getText(208), this.mJavaNativeTypeSelectionPane.createGridLayoutData(3, 1));
        button.addSelectionListener((SelectionListener)new TypeSelectionButtonListener());
        this.mViewer = new TreeViewer(stackPane.getComposite(), 2820);
        this.mViewer.setContentProvider((IContentProvider)new DictionaryTreeContentProvider(false, true, false));
        this.mViewer.setLabelProvider((IBaseLabelProvider)new DictionaryTreeLabelProvider());
        this.mViewer.setSorter((ViewerSorter)new DictionaryTreeSorter());
        this.mViewer.addTreeListener((ITreeViewerListener)new TreeExpandListener());
        this.mViewer.setInput((Object)new DictionaryTreeContentProvider.DictionaryRoot(this.mDictionaryRoot));
        this.mViewer.expandToLevel(2);
        this.mViewer.addSelectionChangedListener((ISelectionChangedListener)new SimpleTypeSelectionListener());
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWizardContainer container;
                if (TypeSelectionPage.this.isSimpleTypeSelectionValid((IStructuredSelection)event.getSelection()) && (container = TypeSelectionPage.super.getContainer()) instanceof TypeSelectionDialog) {
                    ((TypeSelectionDialog)container).close();
                }
            }
        });
        if (this.mInitialType != null) {
            if (this.mInitialType.isJavaNativeType()) {
                this.mTextJavaType.setText(this.mInitialType.getQualifiedName());
                this.mButtonJavaNativeType.setSelection(true);
                this.mButtonSimpleType.setSelection(false);
                this.mIsSimpleTypeSelection = false;
                ((StackLayout)this.mStackComposite.getLayout()).topControl = this.mJavaNativeTypeSelectionPane.getComposite();
                this.mTextJavaType.setFocus();
            } else if (this.mInitialType.isSimpleType()) {
                this.mButtonSimpleType.setSelection(true);
                this.mButtonJavaNativeType.setSelection(false);
                this.mIsSimpleTypeSelection = true;
                ((StackLayout)this.mStackComposite.getLayout()).topControl = this.mViewer.getControl();
                if (!this.mInitialType.isBuiltInType()) {
                    this.mViewer.setSelection((ISelection)new StructuredSelection((Object)this.mInitialType.getSimpleType()), true);
                    this.mViewer.getControl().setFocus();
                }
            }
        }
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && (this.mButtonSimpleType.getSelection() && this.mSimpleType != null || this.mButtonJavaNativeType.getSelection() && this.mQualifiedJavaTypeName != null);
    }

    public void setErrorMessage(String errorMessage) {
        this.setPageComplete(errorMessage == null);
        super.setErrorMessage(errorMessage);
    }

    private IJavaProject getJavaProject() {
        if (this.mJavaProject == null) {
            this.mJavaProject = ServicesEclipse.getJavaProject((String)this.mDictionaryRoot.getMetamodel().getName());
        }
        return this.mJavaProject;
    }

    private boolean isSimpleTypeSelectionValid(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty() && selection != null && selection.getFirstElement() instanceof DtSimpleType) {
            this.mSimpleType = (DtSimpleType)selection.getFirstElement();
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(TextPool.getInstance().getText(439));
        return false;
    }

    class TypeSelectionListener
    implements SelectionListener {
        TypeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == TypeSelectionPage.this.mButtonJavaNativeType && ((Button)e.widget).getSelection()) {
                ((StackLayout)((TypeSelectionPage)TypeSelectionPage.this).mStackComposite.getLayout()).topControl = TypeSelectionPage.this.mJavaNativeTypeSelectionPane.getComposite();
                TypeSelectionPage.this.mButtonSimpleType.setSelection(false);
                TypeSelectionPage.this.setErrorMessage(null);
                TypeSelectionPage.this.mIsSimpleTypeSelection = false;
                TypeSelectionPage.this.mStackComposite.layout();
                TypeSelectionPage.this.mTextJavaType.setFocus();
            } else if (e.getSource() == TypeSelectionPage.this.mButtonSimpleType && ((Button)e.widget).getSelection()) {
                ((StackLayout)((TypeSelectionPage)TypeSelectionPage.this).mStackComposite.getLayout()).topControl = TypeSelectionPage.this.mViewer.getControl();
                TypeSelectionPage.this.mButtonJavaNativeType.setSelection(false);
                TypeSelectionPage.this.setErrorMessage(null);
                TypeSelectionPage.this.mIsSimpleTypeSelection = true;
                TypeSelectionPage.this.mStackComposite.layout();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    class SimpleTypeSelectionListener
    implements ISelectionChangedListener {
        SimpleTypeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TypeSelectionPage.this.isSimpleTypeSelectionValid((IStructuredSelection)event.getSelection());
        }
    }

    class JavaTypeModifyListener
    implements ModifyListener {
        JavaTypeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String fullyQualifiedName = TypeSelectionPage.this.mTextJavaType.getText();
            IStatus val = JavaConventions.validateJavaTypeName((String)fullyQualifiedName);
            if (val.getSeverity() == 4) {
                TypeSelectionPage.this.setErrorMessage(TextPool.getInstance().getText(437));
                return;
            }
            IType type = null;
            IJavaProject javaProject = TypeSelectionPage.this.getJavaProject();
            if (javaProject != null && type == null) {
                try {
                    type = javaProject.findType(fullyQualifiedName);
                    if (type == null) {
                        TypeSelectionPage.this.setErrorMessage(TextPool.getInstance().getText(438));
                        return;
                    }
                }
                catch (JavaModelException ex) {
                    ServiceCorePlugin.internalError(this.getClass(), "modifyText", "Failed to locate type within within project", ex, false);
                }
            }
            TypeSelectionPage.this.mQualifiedJavaTypeName = TypeSelectionPage.this.mTextJavaType.getText();
            TypeSelectionPage.this.setErrorMessage(null);
        }
    }

    class TypeSelectionButtonListener
    implements SelectionListener {
        TypeSelectionButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IJavaSearchScope scope = null;
            scope = TypeSelectionPage.this.getJavaProject() != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{TypeSelectionPage.this.getJavaProject()}) : SearchEngine.createWorkspaceScope();
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            try {
                Object[] types;
                SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)TypeSelectionPage.super.getContainer(), (IJavaSearchScope)scope, (int)6, (boolean)false);
                dialog.setTitle(TextPool.getInstance().getText(435));
                dialog.setMessage(TextPool.getInstance().getText(436));
                if (dialog.open() == 0 && (types = dialog.getResult()).length > 0 && types[0] instanceof IType) {
                    TypeSelectionPage.this.mQualifiedJavaTypeName = ((IType)types[0]).getFullyQualifiedName('.');
                    TypeSelectionPage.this.mTextJavaType.setText(TypeSelectionPage.this.mQualifiedJavaTypeName);
                }
            }
            catch (JavaModelException ex) {
                ServiceCorePlugin.internalError(this.getClass(), "widgetSelected", "Failed to open type selection dialog", ex, false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

