/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.wizards.typeselection;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class DictionaryTreeContentProvider
implements ITreeContentProvider,
DevelopmentObjectObserver {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private boolean mBuildStructures;
    private boolean mBuildSimpleTypes;
    private boolean mBuildStructureFields;
    private TreeViewer mViewer;
    private DtDictionaryRoot mDictionaryRoot;
    private List mDictionaries;
    private Map mSimpleTypesForDictionary;
    private Map mStructuresForDictionary;
    private List mNodes;
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure;
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType;

    public DictionaryTreeContentProvider(boolean buildStructures, boolean buildSimpleTypes, boolean buildStructureFields) {
        this.mBuildStructures = buildStructures;
        this.mBuildSimpleTypes = buildSimpleTypes;
        this.mBuildStructureFields = buildStructureFields;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof DtDictionaryRoot) {
            return this.getDictionaries().toArray();
        }
        if (parent instanceof Dictionary) {
            Node node;
            List<Node> children = new ArrayList<Node>();
            if (this.mBuildStructures) {
                node = this.getNode((Dictionary)parent, class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure")) : class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure);
                if (this.isNodeVisible(node)) {
                    children.add(node);
                } else {
                    children = this.getTypesInPackages((Dictionary)parent, class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure")) : class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure);
                }
            }
            if (this.mBuildSimpleTypes) {
                node = this.getNode((Dictionary)parent, class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtSimpleType")) : class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType);
                if (this.isNodeVisible(node)) {
                    children.add(node);
                } else {
                    children.addAll(this.getTypesInPackages((Dictionary)parent, class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtSimpleType")) : class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType));
                }
            }
            return children.toArray();
        }
        if (parent instanceof Node) {
            return this.getTypesInPackages((Node)parent).toArray();
        }
        if (parent instanceof StructurePackage) {
            return ((StructurePackage)parent).getStructures();
        }
        if (parent instanceof SimpleTypePackage) {
            return ((SimpleTypePackage)parent).getSimpleTypes();
        }
        if (parent instanceof DtGeneralStructure && this.mBuildStructureFields) {
            return ((DtGeneralStructure)parent).getStructureElements();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof DtDictionaryRoot) {
            return null;
        }
        if (element instanceof Dictionary) {
            return this.mDictionaryRoot;
        }
        if (element instanceof Node) {
            return ((Node)element).getDictionary();
        }
        if (element instanceof TypePackage) {
            Node node = this.lookupNode((TypePackage)element);
            return this.isNodeVisible(node) ? node : this.getParent(node);
        }
        if (element instanceof DtSimpleType) {
            TypePackage pack = this.lookupPackage((DtSimpleType)element);
            if (pack != null) {
                return pack;
            }
            Node node = this.lookupNode((DtSimpleType)element);
            return this.isNodeVisible(node) ? node : this.getParent(node);
        }
        if (element instanceof DtGeneralStructure) {
            TypePackage pack = this.lookupPackage((DtGeneralStructure)element);
            if (pack != null) {
                return pack;
            }
            Node node = this.lookupNode((DtGeneralStructure)element);
            return this.isNodeVisible(node) ? node : this.getParent(node);
        }
        if (element instanceof DtStructureElement) {
            return ((DtStructureElement)element).getStructure();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof DtSimpleType || element instanceof DtStructureElement) {
            return false;
        }
        if (element instanceof DtGeneralStructure && !this.mBuildStructureFields) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof DictionaryRoot) {
            this.mDictionaryRoot = ((DictionaryRoot)inputElement).getDictionaryRoot();
            return new Object[]{this.mDictionaryRoot};
        }
        return EMPTY_ARRAY;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mViewer = (TreeViewer)viewer;
        this.mDictionaries = null;
        this.mDictionaryRoot = null;
        this.mNodes = null;
        this.mSimpleTypesForDictionary = null;
        this.mStructuresForDictionary = null;
    }

    public void update(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof DtDictionaryRoot) {
            this.mViewer.refresh((Object)event.getModifiedObject());
        }
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }

    private Node getNode(Dictionary dictionary, Class type) {
        if (this.mNodes == null) {
            this.mNodes = new ArrayList();
        }
        Iterator iter = this.mNodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!node.getDictionary().equals(dictionary) || !node.getType().isAssignableFrom(type)) continue;
            return node;
        }
        Node newNode = null;
        if ((class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure")) : class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure).isAssignableFrom(type)) {
            newNode = new StructureNode(dictionary);
        } else if ((class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtSimpleType")) : class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType).isAssignableFrom(type)) {
            newNode = new SimpleTypeNode(dictionary);
        }
        if (newNode != null) {
            this.mNodes.add(newNode);
        }
        return newNode;
    }

    private List getTypesInPackages(Node node) {
        if (node instanceof StructureNode) {
            return this.getTypesInPackages(node.getDictionary(), class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure")) : class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure);
        }
        if (node instanceof SimpleTypeNode) {
            return this.getTypesInPackages(node.getDictionary(), class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtSimpleType")) : class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType);
        }
        return Collections.EMPTY_LIST;
    }

    private List getTypesInPackages(Dictionary dictionary, Class type) {
        ArrayList packages = new ArrayList();
        if ((class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure")) : class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure).isAssignableFrom(type)) {
            packages.addAll(this.getStructuresInPackages(dictionary));
        } else if ((class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType = DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtSimpleType")) : class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType).isAssignableFrom(type)) {
            packages.addAll(this.getSimpleTypesInPackages(dictionary));
        }
        return packages;
    }

    protected boolean filterSimpleType(DtSimpleType type) {
        String packageName = type.getPackage();
        String typeName = type.getName();
        if (!this.isDefaultPackage(packageName)) {
            if (packageName.equals("com.sap.dictionary")) {
                return false;
            }
            if (packageName.startsWith("com.sap.dictionary.predefined.currency") && !typeName.equals("currency") && !typeName.equals("currencyNormalized")) {
                return false;
            }
        }
        return true;
    }

    protected boolean filterStructure(DtGeneralStructure structure) {
        return true;
    }

    protected boolean isNodeVisible(Node node) {
        return node != null && this.mBuildStructures && this.mBuildSimpleTypes;
    }

    private List getDictionaries() {
        if (this.mDictionaries == null) {
            this.mDictionaries = new ArrayList();
            this.mDictionaries.add(new LocalDictionary(this.mDictionaryRoot));
            try {
                DtLogicalDictionary[] logicalDictionaries = this.mDictionaryRoot.getLogicalDictionaries();
                int i = 0;
                while (i < logicalDictionaries.length) {
                    this.mDictionaries.add(new LogicalDictionary(this.mDictionaryRoot, logicalDictionaries[i]));
                    ++i;
                }
            }
            catch (LoadException e) {
                ServiceCorePlugin.internalError(this.getClass(), "getDictionaries()", "Failed to load dictionaries", e, false);
            }
        }
        return this.mDictionaries;
    }

    private TypePackage lookupPackage(DtSimpleType simpleType) {
        this.ensureContentIsBuilt((DtDataType)simpleType);
        Iterator iter = this.mSimpleTypesForDictionary.values().iterator();
        while (iter.hasNext()) {
            List simpleTypes = (List)iter.next();
            Iterator iterator = simpleTypes.iterator();
            while (iterator.hasNext()) {
                Object entry = iterator.next();
                if (!(entry instanceof TypePackage) || !((TypePackage)entry).getPackageName().equals(simpleType.getPackage())) continue;
                return (TypePackage)entry;
            }
        }
        return null;
    }

    private TypePackage lookupPackage(DtGeneralStructure structure) {
        this.ensureContentIsBuilt((DtDataType)structure);
        Iterator iter = this.mStructuresForDictionary.values().iterator();
        while (iter.hasNext()) {
            List simpleTypes = (List)iter.next();
            Iterator iterator = simpleTypes.iterator();
            while (iterator.hasNext()) {
                Object entry = iterator.next();
                if (!(entry instanceof TypePackage) || !((TypePackage)entry).getPackageName().equals(structure.getPackage())) continue;
                return (TypePackage)entry;
            }
        }
        return null;
    }

    private Node lookupNode(TypePackage typePackage) {
        Dictionary dic = typePackage.getDictionary();
        Iterator iter = this.mNodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!node.getDictionary().equals(dic) || (!(class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure == null ? DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure") : class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure).isAssignableFrom(node.getType()) || !(typePackage instanceof StructurePackage)) && (!(class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType == null ? DictionaryTreeContentProvider.class$("com.sap.ide.metamodel.dictionary.datatype.DtSimpleType") : class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType).isAssignableFrom(node.getType()) || !(typePackage instanceof SimpleTypePackage))) continue;
            return node;
        }
        return null;
    }

    private Node lookupNode(DtSimpleType simpleType) {
        this.ensureContentIsBuilt((DtDataType)simpleType);
        Iterator iter = this.mNodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!(node instanceof SimpleTypeNode)) continue;
            DtSimpleType[] types = node.getDictionary().getSimpleTypes();
            int i = 0;
            while (i < types.length) {
                if (types[i].equals(simpleType)) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    private Node lookupNode(DtGeneralStructure structure) {
        this.ensureContentIsBuilt((DtDataType)structure);
        Iterator iter = this.mNodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!(node instanceof StructureNode)) continue;
            DtGeneralStructure[] structures = node.getDictionary().getStructures();
            int i = 0;
            while (i < structures.length) {
                if (structures[i].equals(structure)) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    private void ensureContentIsBuilt(DtDataType type) {
        if (this.mSimpleTypesForDictionary == null || this.mStructuresForDictionary == null) {
            Object[] elements = this.getElements(new DictionaryRoot((DtDictionaryRoot)type.getRoot()));
            int i = 0;
            while (i < elements.length) {
                Object[] children = this.getChildren(elements[i]);
                int j = 0;
                while (j < children.length) {
                    Object[] subChildren = this.getChildren(children[j]);
                    int k = 0;
                    while (k < subChildren.length) {
                        this.getChildren(subChildren[k]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private List getSimpleTypesInPackages(Dictionary dictionary) {
        ArrayList<SimpleTypePackage> simpleTypes;
        if (this.mSimpleTypesForDictionary == null) {
            this.mSimpleTypesForDictionary = new HashMap();
        }
        if ((simpleTypes = (ArrayList<SimpleTypePackage>)this.mSimpleTypesForDictionary.get(dictionary)) == null) {
            simpleTypes = new ArrayList<SimpleTypePackage>();
            this.mSimpleTypesForDictionary.put(dictionary, simpleTypes);
            DtSimpleType[] types = dictionary.getSimpleTypes();
            int i = 0;
            while (i < types.length) {
                String packageName = types[i].getPackage();
                boolean createPackage = true;
                if (!this.isDefaultPackage(packageName)) {
                    int j = 0;
                    while (j < simpleTypes.size()) {
                        SimpleTypePackage thePackage = (SimpleTypePackage)simpleTypes.get(j);
                        if (thePackage.getPackageName().equals(packageName)) {
                            if (this.filterSimpleType(types[i])) {
                                thePackage.addType(types[i]);
                            }
                            createPackage = false;
                            break;
                        }
                        ++j;
                    }
                    if (createPackage && this.filterSimpleType(types[i])) {
                        simpleTypes.add(new SimpleTypePackage(types[i], dictionary));
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < types.length) {
                String packageName = types[i2].getPackage();
                if (this.isDefaultPackage(packageName) && this.filterSimpleType(types[i2])) {
                    simpleTypes.add((SimpleTypePackage)types[i2]);
                }
                ++i2;
            }
        }
        return simpleTypes;
    }

    private List getStructuresInPackages(Dictionary dictionary) {
        ArrayList<StructurePackage> structureList;
        if (this.mStructuresForDictionary == null) {
            this.mStructuresForDictionary = new HashMap();
        }
        if ((structureList = (ArrayList<StructurePackage>)this.mStructuresForDictionary.get(dictionary)) == null) {
            structureList = new ArrayList<StructurePackage>();
            this.mStructuresForDictionary.put(dictionary, structureList);
            DtGeneralStructure[] structures = dictionary.getStructures();
            int i = 0;
            while (i < structures.length) {
                String packageName = structures[i].getPackage();
                boolean createPackage = true;
                if (!this.isDefaultPackage(packageName)) {
                    int j = 0;
                    while (j < structureList.size()) {
                        StructurePackage thePackage = (StructurePackage)structureList.get(j);
                        if (thePackage.getPackageName().equals(packageName)) {
                            if (this.filterStructure(structures[i])) {
                                thePackage.addStructure(structures[i]);
                            }
                            createPackage = false;
                            break;
                        }
                        ++j;
                    }
                    if (createPackage && this.filterStructure(structures[i])) {
                        structureList.add(new StructurePackage(structures[i], dictionary));
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < structures.length) {
                String packageName = structures[i2].getPackage();
                if (this.isDefaultPackage(packageName) && this.filterStructure(structures[i2])) {
                    structureList.add((StructurePackage)structures[i2]);
                }
                ++i2;
            }
        }
        return structureList;
    }

    protected boolean isDefaultPackage(String packageName) {
        return packageName == null || packageName.equals("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class SimpleTypeNode
    extends Node {
        static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType;

        SimpleTypeNode(Dictionary dictionary) {
            super(dictionary, class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType = SimpleTypeNode.class$("com.sap.ide.metamodel.dictionary.datatype.DtSimpleType")) : class$com$sap$ide$metamodel$dictionary$datatype$DtSimpleType);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class StructureNode
    extends Node {
        static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure;

        StructureNode(Dictionary dictionary) {
            super(dictionary, class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure == null ? (class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure = StructureNode.class$("com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure")) : class$com$sap$ide$metamodel$dictionary$datatype$DtGeneralStructure);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static abstract class Node {
        private Dictionary mParentDictionary;
        private Class mType;

        Node(Dictionary dictionary, Class type) {
            this.mParentDictionary = dictionary;
            this.mType = type;
        }

        Dictionary getDictionary() {
            return this.mParentDictionary;
        }

        Class getType() {
            return this.mType;
        }

        public String toString() {
            return "Node: " + this.mParentDictionary.toString() + ", type: " + this.mType;
        }
    }

    static class StructurePackage
    extends TypePackage {
        private List mStructures = new ArrayList();

        StructurePackage(DtGeneralStructure structure, Dictionary dictionary) {
            super(structure.getPackage(), dictionary);
            this.mStructures.add(structure);
        }

        void addStructure(DtGeneralStructure structure) {
            this.mStructures.add(structure);
        }

        DtGeneralStructure[] getStructures() {
            DtGeneralStructure[] structures = new DtGeneralStructure[this.mStructures.size()];
            return this.mStructures.toArray(structures);
        }
    }

    static class SimpleTypePackage
    extends TypePackage {
        private List mTypes = new ArrayList();

        SimpleTypePackage(DtSimpleType type, Dictionary dictionary) {
            super(type.getPackage(), dictionary);
            this.mTypes.add(type);
        }

        void addType(DtSimpleType type) {
            this.mTypes.add(type);
        }

        DtSimpleType[] getSimpleTypes() {
            DtSimpleType[] types = new DtSimpleType[this.mTypes.size()];
            return this.mTypes.toArray(types);
        }
    }

    static abstract class TypePackage {
        private String mPackageName;
        private Dictionary mDictionaryRoot;

        TypePackage(String packageName, Dictionary dictionary) {
            this.mPackageName = packageName;
            this.mDictionaryRoot = dictionary;
        }

        String getPackageName() {
            return this.mPackageName;
        }

        Dictionary getDictionary() {
            return this.mDictionaryRoot;
        }

        public String toString() {
            return "Package: " + this.mPackageName;
        }
    }

    static class LocalDictionary
    extends Dictionary {
        LocalDictionary(DtDictionaryRoot dictionaryRoot) {
            super(dictionaryRoot);
        }

        public String toString() {
            return "Local Dictionary";
        }

        DtGeneralStructure[] getStructures() {
            if (this.mStructures == null) {
                this.mStructures = new ArrayList();
                try {
                    DtGeneralStructure[] structures = this.getDictionaryRoot().getStructures();
                    int i = 0;
                    while (i < structures.length) {
                        if (!structures[i].hasLogicalDictionary()) {
                            this.mStructures.add(structures[i]);
                        }
                        ++i;
                    }
                }
                catch (LoadException e) {
                    ServiceCorePlugin.internalError(this.getClass(), "getStructures", "Failed to load structures from dictionary root", e, false);
                }
            }
            return this.mStructures.toArray(new DtGeneralStructure[this.mStructures.size()]);
        }

        DtSimpleType[] getSimpleTypes() {
            if (this.mSimpleTypes == null) {
                this.mSimpleTypes = new ArrayList();
                try {
                    DtSimpleType[] simpleTypes = this.getDictionaryRoot().getSimpleTypes();
                    int i = 0;
                    while (i < simpleTypes.length) {
                        if (!simpleTypes[i].hasLogicalDictionary()) {
                            this.mSimpleTypes.add(simpleTypes[i]);
                        }
                        ++i;
                    }
                }
                catch (LoadException e) {
                    ServiceCorePlugin.internalError(this.getClass(), "getSimpleTypes", "Failed to load simple types from dictionary root", e, false);
                }
            }
            return this.mSimpleTypes.toArray(new DtSimpleType[this.mSimpleTypes.size()]);
        }
    }

    static class LogicalDictionary
    extends Dictionary {
        private DtLogicalDictionary mLogicalDictionary;

        LogicalDictionary(DtDictionaryRoot dictionaryRoot, DtLogicalDictionary logicalDictionary) {
            super(dictionaryRoot);
            this.mLogicalDictionary = logicalDictionary;
        }

        DtLogicalDictionary getLogicalDictionary() {
            return this.mLogicalDictionary;
        }

        DtGeneralStructure[] getStructures() {
            if (this.mStructures == null) {
                this.mStructures = new ArrayList();
                try {
                    DtGeneralStructure[] structures = this.getDictionaryRoot().getStructures(this.mLogicalDictionary.getPackage());
                    int i = 0;
                    while (i < structures.length) {
                        this.mStructures.add(structures[i]);
                        ++i;
                    }
                }
                catch (LoadException e) {
                    ServiceCorePlugin.internalError(this.getClass(), "getStructures", "Failed to load structures from dictionary root", e, false);
                }
            }
            return this.mStructures.toArray(new DtGeneralStructure[this.mStructures.size()]);
        }

        DtSimpleType[] getSimpleTypes() {
            if (this.mSimpleTypes == null) {
                this.mSimpleTypes = new ArrayList();
                try {
                    DtSimpleType[] simpleTypes = this.getDictionaryRoot().getSimpleTypes(this.mLogicalDictionary.getPackage());
                    int i = 0;
                    while (i < simpleTypes.length) {
                        this.mSimpleTypes.add(simpleTypes[i]);
                        ++i;
                    }
                }
                catch (LoadException e) {
                    ServiceCorePlugin.internalError(this.getClass(), "getSimpleTypes", "Failed to load simple types from dictionary root", e, false);
                }
            }
            return this.mSimpleTypes.toArray(new DtSimpleType[this.mSimpleTypes.size()]);
        }
    }

    static abstract class Dictionary {
        private DtDictionaryRoot mDictionaryRoot;
        protected List mStructures;
        protected List mSimpleTypes;

        Dictionary(DtDictionaryRoot dictionaryRoot) {
            this.mDictionaryRoot = dictionaryRoot;
        }

        DtDictionaryRoot getDictionaryRoot() {
            return this.mDictionaryRoot;
        }

        abstract DtGeneralStructure[] getStructures();

        abstract DtSimpleType[] getSimpleTypes();

        public String toString() {
            return "Dictionary: " + this.mDictionaryRoot.getName();
        }
    }

    public static class DictionaryRoot {
        private DtDictionaryRoot mDictionaryRoot;

        public DictionaryRoot(DtDictionaryRoot dictionaryRoot) {
            this.mDictionaryRoot = dictionaryRoot;
        }

        public DtDictionaryRoot getDictionaryRoot() {
            return this.mDictionaryRoot;
        }

        public String toString() {
            return "Dictionary root: " + this.mDictionaryRoot.getName();
        }
    }
}

