/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.wizards.refactor;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.refactoring.RefactoringItem;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.webdynpro.services.ServicesDC;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardData;
import com.sap.ide.webdynpro.ui.dialog.wizard.refactor.WDRefactorWizardPagePreview;
import com.sap.ide.webdynpro.ui.service.TextPool;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class RenameWizardPagePreview
extends WDRefactorWizardPagePreview {
    private CoreTextPool mCPool = CoreTextPool.getInstance();
    private RenameWizardData mRenameWizardData = null;
    private String AN_ERROR_OCCURRED = this.mCPool.getText(40);

    public RenameWizardPagePreview(RenameWizardData data) {
        this.mRenameWizardData = data;
        this.setPageComplete(true);
        DevelopmentObject developmentObject = this.mRenameWizardData.getObjectToRefactor();
        String type = developmentObject.getDevelopmentObjectEnum().toString();
        String name = type + " '" + data.getObjectToRefactor().getName() + "' ";
        this.setDescription(TextPool.getInstance().getText(301, (Object)name));
    }

    protected void initializeListeners() {
        this.getTableViewer().addCheckStateListener((ICheckStateListener)new TableCheckedListener());
        this.getTableViewer().getTable().addListener(13, (Listener)new RevertCheckListener());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        try {
            if (visible) {
                this.setPageComplete(true);
                this.setErrorMessage(null);
                this.setMessage(null);
                this.mRenameWizardData.setPreviewPageActivated(true);
                IStatus refactorPreparationStatus = ((RenameWizard)this.getWizard()).doRefactorPreparationWithProgres();
                CheckboxTableViewer viewer = this.getTableViewer();
                RefactoringRequest request = this.mRenameWizardData.getRefactoringRequest();
                RefactoringItem[] refactoringItems = request.getAffectedMDOs();
                viewer.setInput((Object)refactoringItems);
                Object[] objects = ((RenameWizard)this.getWizard()).getAdditionalPreviewItems();
                viewer.add(objects);
                viewer.setAllChecked(true);
                int i = 0;
                while (i < refactoringItems.length) {
                    viewer.setChecked((Object)refactoringItems[i], true);
                    if (refactoringItems[i].isRefactoringMandatory()) {
                        viewer.setGrayed((Object)refactoringItems[i], true);
                    }
                    ++i;
                }
                if (refactorPreparationStatus.getCode() == 4) {
                    this.setErrorMessage(this.AN_ERROR_OCCURRED + refactorPreparationStatus.getMessage());
                    this.setPageComplete(false);
                }
            } else {
                this.setPageComplete(true);
                this.setErrorMessage(null);
            }
        }
        catch (Throwable e) {
            ServiceCorePlugin.internalError(((Object)((Object)this)).getClass(), "setVisible", "Exception occured", e, false);
        }
    }

    public IStructuredContentProvider getContentProvider() {
        return ((RenameWizard)this.getWizard()).getContentProvider();
    }

    private class RevertCheckListener
    implements Listener {
        private RevertCheckListener() {
        }

        public void handleEvent(Event event) {
            RefactoringItem refItem;
            TableItem tableItem;
            Object data;
            if (event.detail == 32 && event.item instanceof TableItem && (data = (tableItem = (TableItem)event.item).getData()) instanceof RefactoringItem && (refItem = (RefactoringItem)data).isRefactoringMandatory()) {
                tableItem.setChecked(true);
            }
        }
    }

    private class TableCheckedListener
    implements ICheckStateListener {
        private TableCheckedListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object object = event.getElement();
            if (object instanceof RefactoringItem) {
                RefactoringItem item = (RefactoringItem)object;
                if (!event.getChecked()) {
                    if (!item.isRefactoringMandatory()) {
                        item.setExcluded(true);
                    }
                } else {
                    item.setExcluded(false);
                }
            } else if (object instanceof ServicesDC.EntityPair) {
                ServicesDC.EntityPair entityPair = (ServicesDC.EntityPair)object;
                if (!event.getChecked()) {
                    entityPair.setExcluded(true);
                    RenameWizardPagePreview.this.setErrorMessage(null);
                    RenameWizardPagePreview.this.setPageComplete(true);
                    IWizardPage[] pages = ((RenameWizard)RenameWizardPagePreview.this.getWizard()).getPages();
                    int i = 0;
                    while (i < pages.length) {
                        ((WizardPage)pages[i]).setErrorMessage(null);
                        ((WizardPage)pages[i]).setMessage(null);
                        ((WizardPage)pages[i]).setPageComplete(true);
                        ++i;
                    }
                    DevelopmentObject developmentObject = RenameWizardPagePreview.this.mRenameWizardData.getObjectToRefactor();
                    String type = developmentObject.getDevelopmentObjectEnum().toString();
                    RenameWizardPagePreview.this.setMessage(RenameWizardPagePreview.this.mCPool.getText(317, type), 2);
                } else {
                    entityPair.setExcluded(false);
                    Object[] objects = ((RenameWizard)RenameWizardPagePreview.this.getWizard()).getAdditionalPreviewItems();
                    boolean excludedAvailable = false;
                    int i = 0;
                    while (i < objects.length) {
                        ServicesDC.EntityPair pair;
                        if (objects[i] instanceof ServicesDC.EntityPair && (pair = (ServicesDC.EntityPair)objects[i]).isExcluded()) {
                            excludedAvailable = true;
                            break;
                        }
                        ++i;
                    }
                    if (!excludedAvailable) {
                        RenameWizardPagePreview.this.setMessage(null);
                    }
                }
            }
        }
    }
}

