/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.wizards.refactor;

import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardData;
import com.sap.ide.webdynpro.ui.dialog.wizard.refactor.IRefactorWizardData;
import com.sap.ide.webdynpro.ui.dialog.wizard.refactor.WDRefactorWizardPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

public class RenameWizardPage
extends WDRefactorWizardPage {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private RenameWizardData mRenameWizardData = null;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public RenameWizardPage(RenameWizardData data) {
        this.mRenameWizardData = data;
        DevelopmentObject developmentObject = this.mRenameWizardData.getObjectToRefactor();
        String type = developmentObject.getDevelopmentObjectEnum().toString();
        String name = type + " '" + data.getObjectToRefactor().getName() + "' ";
        this.setDescription(mCPool.getText(415, name));
    }

    protected void initializeListeners() {
        this.getNameField().addModifyListener((ModifyListener)new NameModifyListener());
        this.getPackageField().addModifyListener((ModifyListener)new PackageModifyListener());
        this.getBrowsePackageButton().addSelectionListener((SelectionListener)new BrowsePackageButtonListener());
        this.getSourcePathListField().addSelectionListener((SelectionListener)new SourceSelectionListener());
    }

    protected void initializeFields() {
        DevelopmentObject developmentObject = this.mRenameWizardData.getObjectToRefactor();
        if (developmentObject == null) {
            return;
        }
        String preselectedName = developmentObject.getName();
        if (this.mRenameWizardData.getName() != null && this.mRenameWizardData.getName().length() > 0) {
            preselectedName = this.mRenameWizardData.getName();
        }
        this.getNameField().setText(preselectedName);
        this.getNameField().setSelection(0, preselectedName.length() + 8);
        this.mRenameWizardData.setName(preselectedName);
        if (developmentObject.isMDO()) {
            MainDevelopmentObject mdo = (MainDevelopmentObject)developmentObject;
            String preselectedPackage = mdo.getPackage();
            if (this.mRenameWizardData.getPackage() != null && this.mRenameWizardData.getPackage().length() > 0) {
                preselectedPackage = this.mRenameWizardData.getPackage();
            }
            this.getPackageField().setText(preselectedPackage);
            this.mRenameWizardData.setPackage(preselectedPackage);
            IPackageFragmentRoot mdoSourceRoot = ServicesEclipse.getMDOSourceRoot((MainDevelopmentObject)mdo);
            IPackageFragmentRoot[] roots = this.mRenameWizardData.getAllValidRoots();
            int preselectionIndex = 0;
            if (roots != null) {
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].equals(mdoSourceRoot)) {
                        preselectionIndex = i;
                    }
                    ++i;
                }
                this.getSourcePathListField().setSelection(preselectionIndex);
                this.mRenameWizardData.setSelectedRoot(roots[preselectionIndex]);
            }
        }
        if (this.mRenameWizardData.isPresetting()) {
            this.setPageComplete(this.isValidName() && this.isValidPackage() && this.isValidSourceFolder());
        } else {
            this.setPageComplete(false);
        }
    }

    public void handlePageCompletion() {
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
        }
        ((RenameWizard)this.getWizard()).setPagesOK();
        this.mRenameWizardData.setName(this.getNameField().getText());
        if (this.mRenameWizardData.getObjectToRefactor().isMDO()) {
            this.mRenameWizardData.setPackage(this.getPackageField().getText());
            this.mRenameWizardData.setSelectedRoot(this.mRenameWizardData.getTemporaryRoot());
        }
    }

    public boolean isValidName() {
        String error;
        this.mDeleteNameMessage = true;
        String nameInput = this.getNameField().getText();
        if (nameInput.equals(this.getWizardData().getObjectToRefactor().getName())) {
            return true;
        }
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mCPool.getText(3, nameInput));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        if (this.getWizardData().getObjectToRefactor().isMDO()) {
            nameInput = CheckServices.checkFirstCharacter(this.getNameField());
            char c = nameInput.charAt(0);
            if (!Character.isUpperCase(c)) {
                this.setErrorMessage(mCPool.getText(17, nameInput));
                return false;
            }
        } else if (nameInput.equalsIgnoreCase(this.getWizardData().getObjectToRefactor().getName())) {
            return true;
        }
        if ((error = ((RenameWizard)this.getWizard()).verifyDevelopmentobjectName(nameInput, this.getPackageField().getText())) == null) {
            return true;
        }
        this.setErrorMessage(error);
        return false;
    }

    private boolean isValidPackage() {
        this.mDeletePackageMessage = true;
        if (!this.getWizardData().getObjectToRefactor().isMDO()) {
            return true;
        }
        String packageInput = CheckServices.convertToLowerCase(this.getPackageField());
        IStatus validatedStatus = CheckServices.isValidPackage(packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidSourceFolder() {
        if (!this.getWizardData().getObjectToRefactor().isMDO()) {
            return true;
        }
        if (this.getSourcePathListField().getItemCount() <= 0) {
            this.setErrorMessage(mCPool.getText(18));
            return false;
        }
        return true;
    }

    public IRefactorWizardData getWizardData() {
        return this.mRenameWizardData;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mRenameWizardData.setPreviewPageActivated(false);
        }
    }

    protected String getWarningMessage() {
        return ((RenameWizard)this.getWizard()).getWarningMessage();
    }

    class BrowsePackageButtonListener
    extends SelectionAdapter {
        BrowsePackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot sourceRoot = RenameWizardPage.this.mRenameWizardData.getTemporaryRoot();
            String packageName = RenameWizardPage.this.mRenameWizardData.getPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = com.sap.ide.metamodel.core.services.ServicesEclipse.getPackageInSourceRoot((String)packageName, (IPackageFragmentRoot)sourceRoot);
            }
            if ((packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)RenameWizardPage.this.getShell())) != null) {
                RenameWizardPage.this.getPackageField().setText(packageFragment.getElementName());
            }
            if (RenameWizardPage.this.isValidPackage() && RenameWizardPage.this.isValidName() && RenameWizardPage.this.isValidSourceFolder()) {
                RenameWizardPage.this.handlePageCompletion();
            } else {
                RenameWizardPage.this.setPageComplete(false);
            }
        }
    }

    class SourceSelectionListener
    implements SelectionListener {
        SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = RenameWizardPage.this.getSourcePathListField().getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot[] allRoots = RenameWizardPage.this.mRenameWizardData.getAllValidRoots();
                IPackageFragmentRoot selectedRoot = allRoots[selectionIndex];
                RenameWizardPage.this.mRenameWizardData.setTemporaryRoot(selectedRoot);
                if (RenameWizardPage.this.isValidSourceFolder() && RenameWizardPage.this.isValidName() && RenameWizardPage.this.isValidPackage()) {
                    RenameWizardPage.this.handlePageCompletion();
                } else {
                    RenameWizardPage.this.setPageComplete(false);
                }
            }
        }
    }

    class PackageModifyListener
    implements ModifyListener {
        PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (RenameWizardPage.this.isValidPackage() && RenameWizardPage.this.isValidName() && RenameWizardPage.this.isValidSourceFolder()) {
                RenameWizardPage.this.handlePageCompletion();
            } else {
                RenameWizardPage.this.setPageComplete(false);
            }
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (RenameWizardPage.this.isValidName() && RenameWizardPage.this.isValidPackage() && RenameWizardPage.this.isValidSourceFolder()) {
                RenameWizardPage.this.handlePageCompletion();
            } else {
                RenameWizardPage.this.setPageComplete(false);
            }
        }
    }
}

