/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.wizards.refactor;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.webdynpro.services.GenerationPathManager;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.ui.dialog.wizard.refactor.IRefactorWizardData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class RenameWizardData
implements IRefactorWizardData {
    private String mRefactoredName = "";
    private String mRefactoredPackage = "";
    private IPackageFragmentRoot[] mAllValidRoots = null;
    private IPackageFragmentRoot mSelectedRoot = null;
    private SourcePathIdentifier mSelectedSourcePathId = null;
    private IPackageFragmentRoot mTemporaryRoot = null;
    private SourcePathIdentifier mTemporarySourcePathId = null;
    private boolean mIsMinSelected = false;
    private boolean mIsMaxSelected = false;
    private boolean mIsChooseSelected = false;
    private String mScope = null;
    private boolean mPreviewPageActivated = false;
    private boolean mShowPackageSection = true;
    private boolean mIsPresetting = false;
    private boolean mShowWarningSection = false;
    private DevelopmentObject mDevelopmentObject = null;
    private RefactoringRequest mRefactoringRequest = null;

    public RenameWizardData(DevelopmentObject developmentObject) {
        this.mDevelopmentObject = developmentObject;
        this.initializeData();
    }

    private void initializeData() {
        if (this.mDevelopmentObject == null) {
            return;
        }
        String sourceText = "";
        IProject eclipseProject = com.sap.ide.metamodel.core.services.ServicesEclipse.getEclipseProject((DevelopmentObject)this.mDevelopmentObject);
        IPackageFragmentRoot[] allValidRoots = GenerationPathManager.getValidSourceRoots((IProject)eclipseProject);
        this.setAllValidRoots(allValidRoots);
        IPackageFragmentRoot componentSourceRoot = null;
        if (this.mDevelopmentObject.isMDO()) {
            MainDevelopmentObject mdo = (MainDevelopmentObject)this.mDevelopmentObject;
            componentSourceRoot = ServicesEclipse.getMDOSourceRoot((MainDevelopmentObject)mdo);
            this.setSelectedRoot(componentSourceRoot);
            this.setTemporaryRoot(componentSourceRoot);
            this.setPackage(mdo.getPackage());
        }
        this.setName(this.mDevelopmentObject.getName());
        this.setScope(IRefactorWizardData.TOOL);
    }

    public DevelopmentObject getObjectToRefactor() {
        return this.mDevelopmentObject;
    }

    public String getName() {
        return this.mRefactoredName;
    }

    public void setName(String name) {
        this.mRefactoredName = name;
    }

    public String getPackage() {
        return this.mRefactoredPackage;
    }

    public void setPackage(String viewPackage) {
        this.mRefactoredPackage = viewPackage.toLowerCase();
    }

    public void setAllValidRoots(IPackageFragmentRoot[] allValidRoots) {
        this.mAllValidRoots = allValidRoots;
    }

    public IPackageFragmentRoot[] getAllValidRoots() {
        return this.mAllValidRoots;
    }

    public void setSelectedRoot(IPackageFragmentRoot selectedRoot) {
        if (selectedRoot == null) {
            return;
        }
        this.mSelectedRoot = selectedRoot;
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mDevelopmentObject.getMetamodel().getName());
        IPath sourcePath = manager.makePathAbsolute(this.mSelectedRoot.getPath());
        this.mSelectedSourcePathId = manager.getSourcePathIdentifier(sourcePath);
    }

    public IPackageFragmentRoot getSelectedRoot() {
        return this.mSelectedRoot;
    }

    public SourcePathIdentifier getSelectedSourcePathIdentifier() {
        return this.mSelectedSourcePathId;
    }

    public void setTemporaryRoot(IPackageFragmentRoot temporaryRoot) {
        this.mTemporaryRoot = temporaryRoot;
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mDevelopmentObject.getMetamodel().getName());
        IPath sourcePath = manager.makePathAbsolute(this.mTemporaryRoot.getPath());
        this.mTemporarySourcePathId = manager.getSourcePathIdentifier(sourcePath);
    }

    public IPackageFragmentRoot getTemporaryRoot() {
        return this.mTemporaryRoot;
    }

    public SourcePathIdentifier getTemporarySourcePathIdentifier() {
        return this.mTemporarySourcePathId;
    }

    public void setScope(String scope) {
        this.mScope = scope;
    }

    public String getScope() {
        return this.mScope;
    }

    public void setRefactoringRequest(RefactoringRequest request) {
        this.mRefactoringRequest = request;
    }

    public RefactoringRequest getRefactoringRequest() {
        return this.mRefactoringRequest;
    }

    public void setPreviewPageActivated(boolean activated) {
        this.mPreviewPageActivated = activated;
    }

    public boolean isPreviewPageActivated() {
        return this.mPreviewPageActivated;
    }

    public void setIsPresetting(boolean isPresetting) {
        this.mIsPresetting = isPresetting;
    }

    public boolean isPresetting() {
        return this.mIsPresetting;
    }

    public IProject getEclipseProject() {
        return com.sap.ide.metamodel.core.services.ServicesEclipse.getEclipseProject((DevelopmentObject)this.mDevelopmentObject);
    }

    public void setShowPackageSection(boolean showPackageSection) {
        this.mShowPackageSection = showPackageSection;
    }

    public boolean showPackageSection() {
        return this.mShowPackageSection;
    }

    public void setShowWarningSection(boolean showWarningSection) {
        this.mShowWarningSection = showWarningSection;
    }

    public boolean showWarningSection() {
        return this.mShowWarningSection;
    }
}

