/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.wizards.refactor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.RefactoringException;
import com.sap.ide.metamodel.general.refactoring.MDORefactoringTask;
import com.sap.ide.metamodel.general.refactoring.RefactoringItem;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.general.refactoring.RefactoringTask;
import com.sap.ide.metamodel.webdynpro.repository.RepositoryUtilities;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameDefaultContentProvider;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardData;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardPage;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardPagePreview;
import com.sap.ide.webdynpro.ui.dialog.wizard.refactor.WDRefactorWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class RenameWizard
extends WDRefactorWizard {
    private CoreTextPool mCPool = CoreTextPool.getInstance();
    private String PLUGIN_ID = ServiceCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
    private String AN_ERROR_OCCURRED = this.mCPool.getText(40);
    private String TOO_LONG = this.mCPool.getText(36);
    private String REFACTORING = this.mCPool.getText(313);
    private String CHECKING = this.mCPool.getText(315);
    private String CLEANING = this.mCPool.getText(314);
    private String COMPUTING = this.mCPool.getText(316);
    private RenameWizardData mRenameWizardData = null;
    private RenameWizardPage mRenameWizardPage = null;
    private RenameWizardPagePreview mRenameWizardPagePreview = null;
    private IStatus refactorPreprationResult = null;

    public RenameWizard(DevelopmentObject developmentObject) {
        this.mRenameWizardData = new RenameWizardData(developmentObject);
        this.createAndStoreRefactoringRequest(developmentObject, this.mRenameWizardData);
        this.handleWizardUI(developmentObject, this.mRenameWizardData);
        this.mRenameWizardData.setIsPresetting(false);
        this.setNeedsProgressMonitor(true);
    }

    public RenameWizard(DevelopmentObject developmentObject, String newName) {
        this.mRenameWizardData = new RenameWizardData(developmentObject);
        this.createAndStoreRefactoringRequest(developmentObject, this.mRenameWizardData);
        this.handleWizardUI(developmentObject, this.mRenameWizardData);
        this.handlePreselection(newName, null);
        this.setNeedsProgressMonitor(true);
    }

    public RenameWizard(DevelopmentObject developmentObject, String newName, String newPackage) {
        this.mRenameWizardData = new RenameWizardData(developmentObject);
        this.createAndStoreRefactoringRequest(developmentObject, this.mRenameWizardData);
        this.handleWizardUI(developmentObject, this.mRenameWizardData);
        this.handlePreselection(newName, newPackage);
        this.setNeedsProgressMonitor(true);
    }

    public RenameWizardData getWizardData() {
        return this.mRenameWizardData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        ProgressMonitorDialog dialog = this.createAndOpenProgresMonitor();
        IStatus statusBefore = this.doAdditionalTasksBeforeRefactoring(dialog);
        if (statusBefore.getSeverity() != 0) {
            return this.doErrorHandling(dialog, statusBefore);
        }
        dialog.getProgressMonitor().beginTask(this.CLEANING, -1);
        this.deleteImplementation();
        try {
            try {
                IStatus status;
                dialog.getProgressMonitor().setTaskName(this.REFACTORING);
                if (!this.getWizardData().isPreviewPageActivated() && (status = this.doRefactorPreparation()).getSeverity() != 0) {
                    boolean bl = this.doErrorHandling(dialog, status);
                    Object var15_8 = null;
                    dialog.close();
                    return bl;
                }
                dialog.getProgressMonitor().setTaskName(this.CHECKING);
                RefactoringRequest request = this.getWizardData().getRefactoringRequest();
                RefactoringItem[] refItems = request.getAffectedMDOs();
                ArrayList<MainDevelopmentObject> mdoList = new ArrayList<MainDevelopmentObject>();
                int i = 0;
                while (i < refItems.length) {
                    if (!refItems[i].isExcluded()) {
                        mdoList.add(refItems[i].getMDO());
                    }
                    ++i;
                }
                MainDevelopmentObject[] mdos = mdoList.toArray(new MainDevelopmentObject[0]);
                if (!RepositoryUtilities.checkWriteability((MainDevelopmentObject[])mdos, (boolean)true)) {
                    boolean bl = this.doErrorHandling(dialog, (IStatus)new Status(4, this.PLUGIN_ID, 4, "Rename failed: objects are readonly", null));
                    Object var15_9 = null;
                    dialog.close();
                    return bl;
                }
                RefactoringTask[] tasks = request.getRefactoringTasks();
                int i2 = 0;
                while (i2 < tasks.length) {
                    if (tasks[i2].isConflicting()) {
                        boolean bl = this.doErrorHandling(dialog, (IStatus)new Status(4, this.PLUGIN_ID, 4, this.mCPool.getText(30), null));
                        Object var15_10 = null;
                        dialog.close();
                        return bl;
                    }
                    ++i2;
                }
                this.doAdditionalTasksInMidOfRefactoring(dialog);
                try {
                    try {
                        request.execute();
                    }
                    catch (RefactoringException e) {
                        ServiceCorePlugin.internalError(((Object)((Object)this)).getClass(), "performFinish", "Refactoring failed", e, false);
                        boolean bl = this.doErrorHandling(dialog, (IStatus)new Status(4, this.PLUGIN_ID, 4, "Refactoring failed", (Throwable)e));
                        Object var13_25 = null;
                        this.generateImplementation(dialog);
                        this.organizeImports(dialog);
                        Object var15_11 = null;
                        dialog.close();
                        return bl;
                    }
                    Object var13_24 = null;
                    this.generateImplementation(dialog);
                    this.organizeImports(dialog);
                }
                catch (Throwable throwable) {
                    Object var13_26 = null;
                    this.generateImplementation(dialog);
                    this.organizeImports(dialog);
                    throw throwable;
                }
                this.doAdditionalTasksAfterRefactoring(dialog);
                Metamodel metamodel = this.getWizardData().getObjectToRefactor().getRoot().getMetamodel();
                MetamodelManager manager = MetamodelManager.getMetamodelManager((String)metamodel.getName());
                manager.refreshTSModel();
                dialog.getProgressMonitor().done();
                dialog.close();
                boolean bl = true;
                Object var15_12 = null;
                dialog.close();
                return bl;
            }
            catch (Throwable e) {
                ServiceCorePlugin.internalError(((Object)((Object)this)).getClass(), "performFinish", "Exception occured", e, false);
                boolean bl = false;
                Object var15_13 = null;
                dialog.close();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            dialog.close();
            throw throwable;
        }
    }

    public void addPages() {
        this.mRenameWizardPage = new RenameWizardPage(this.getWizardData());
        this.mRenameWizardPagePreview = new RenameWizardPagePreview(this.getWizardData());
        this.addPage((IWizardPage)this.mRenameWizardPage);
        this.addPage((IWizardPage)this.mRenameWizardPagePreview);
    }

    private ProgressMonitorDialog createAndOpenProgresMonitor() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        dialog.open();
        return dialog;
    }

    private boolean doErrorHandling(ProgressMonitorDialog dialog, IStatus statusBefore) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            ((WizardPage)pages[i]).setErrorMessage(statusBefore.getMessage());
            ((WizardPage)pages[i]).setPageComplete(false);
            ++i;
        }
        dialog.getProgressMonitor().done();
        dialog.close();
        return false;
    }

    protected void setPagesOK() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            ((WizardPage)pages[i]).setErrorMessage(null);
            ((WizardPage)pages[i]).setPageComplete(true);
            ++i;
        }
    }

    private void createAndStoreRefactoringRequest(DevelopmentObject developmentObject, RenameWizardData renameWizardData) {
        Metamodel metamodel = developmentObject.getRoot().getMetamodel();
        RefactoringRequest request = metamodel.createRefactoringRequest();
        renameWizardData.setRefactoringRequest(request);
    }

    private void handleWizardUI(DevelopmentObject developmentObject, RenameWizardData renameWizardData) {
        if (developmentObject.isMDO()) {
            renameWizardData.setShowPackageSection(true);
        } else {
            renameWizardData.setShowPackageSection(false);
        }
        if (this.showWarningSection()) {
            renameWizardData.setShowWarningSection(true);
        } else {
            renameWizardData.setShowWarningSection(false);
        }
    }

    protected boolean showWarningSection() {
        return false;
    }

    protected String getWarningMessage() {
        return "";
    }

    private void handlePreselection(String newName, String newPackage) {
        if (newName != null) {
            this.mRenameWizardData.setName(newName);
            this.mRenameWizardData.setIsPresetting(true);
        } else {
            this.mRenameWizardData.setName("");
            this.mRenameWizardData.setIsPresetting(false);
        }
        if (newPackage != null) {
            this.mRenameWizardData.setPackage(newPackage);
            this.mRenameWizardData.setIsPresetting(true);
        } else {
            this.mRenameWizardData.setPackage("");
            this.mRenameWizardData.setIsPresetting(false);
        }
    }

    protected IStatus doRefactorPreparation() {
        DevelopmentObject developmentObject = this.mRenameWizardData.getObjectToRefactor();
        String newPackage = null;
        String newName = this.mRenameWizardData.getName();
        SourcePathIdentifier identifier = null;
        RefactoringRequest request = this.mRenameWizardData.getRefactoringRequest();
        if (developmentObject.isMDO()) {
            newPackage = this.mRenameWizardData.getPackage();
            IPackageFragmentRoot packageFragmentRoot = this.mRenameWizardData.getSelectedRoot();
            MetamodelManager manager = MetamodelManager.getMetamodelManager((String)developmentObject.getRoot().getMetamodel().getName());
            IPath sourcePath = manager.makePathAbsolute(packageFragmentRoot.getPath());
            identifier = manager.getSourcePathIdentifier(sourcePath);
            MDORefactoringTask task = (MDORefactoringTask)request.createRefactoringTask(developmentObject);
            task.setNewSourcePathIdentifier(identifier);
            try {
                task.setNewName(newName);
                task.setNewPackage(newPackage);
            }
            catch (RuntimeException e) {
                return new Status(4, this.PLUGIN_ID, 4, this.TOO_LONG, (Throwable)e);
            }
        } else {
            RefactoringTask task = request.createRefactoringTask(developmentObject);
            task.setNewName(newName);
        }
        IStatus status = this.doSpecialRefactoringPreparation(request, developmentObject, newName, newPackage, identifier);
        request.maximizeRefactoringScope();
        this.setToolDefinedScope(request, developmentObject);
        return status;
    }

    public IStatus doRefactorPreparationWithProgres() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(RenameWizard.this.COMPUTING, -1);
                RenameWizard.this.refactorPreprationResult = RenameWizard.this.doRefactorPreparation();
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            ServiceCorePlugin.internalError(((Object)((Object)this)).getClass(), "doRefactorPreparationWithProgres", "Exception occured", e, false);
        }
        catch (InvocationTargetException e) {
            ServiceCorePlugin.internalError(((Object)((Object)this)).getClass(), "doRefactorPreparationWithProgres", "Exception occured", e, false);
        }
        return this.refactorPreprationResult;
    }

    private void deleteImplementation() {
    }

    protected void deleteImplementation(DevelopmentObject developmentObject) {
    }

    private void organizeImports(ProgressMonitorDialog dialog) {
        DevelopmentObject developmentObject = this.getWizardData().getObjectToRefactor();
        this.organizeImports(developmentObject, dialog);
    }

    protected void organizeImports(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
    }

    private void generateImplementation(ProgressMonitorDialog dialog) {
    }

    protected void generateImplementation(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
    }

    protected void setToolDefinedScope(RefactoringRequest request, DevelopmentObject developmentObject) {
    }

    protected IStatus doSpecialRefactoringPreparation(RefactoringRequest request, DevelopmentObject developmentObject, String newName, String newPackage, SourcePathIdentifier newIdentifier) {
        return new Status(0, this.PLUGIN_ID, 0, "OK", null);
    }

    private IStatus doAdditionalTasksBeforeRefactoring(ProgressMonitorDialog dialog) {
        DevelopmentObject developmentObject = this.getWizardData().getObjectToRefactor();
        return this.doAdditionalTasksBeforeRefactoring(developmentObject, dialog);
    }

    protected IStatus doAdditionalTasksBeforeRefactoring(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        String PLUGIN_ID = ServiceCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
        return new Status(0, PLUGIN_ID, -1, "", null);
    }

    private void doAdditionalTasksInMidOfRefactoring(ProgressMonitorDialog dialog) {
        DevelopmentObject developmentObject = this.getWizardData().getObjectToRefactor();
        this.doAdditionalTasksInMidOfRefactoring(developmentObject, dialog);
    }

    protected void doAdditionalTasksInMidOfRefactoring(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
    }

    private void doAdditionalTasksAfterRefactoring(ProgressMonitorDialog dialog) {
        DevelopmentObject developmentObject = this.getWizardData().getObjectToRefactor();
        this.doAdditionalTasksAfterRefactoring(developmentObject, dialog);
    }

    protected void doAdditionalTasksAfterRefactoring(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
    }

    protected Object[] getAdditionalPreviewItems() {
        return new Object[0];
    }

    protected IStructuredContentProvider getContentProvider() {
        return new RenameDefaultContentProvider();
    }

    protected abstract String verifyDevelopmentobjectName(String var1, String var2);
}

