/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.wizards.refactor;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.services.ServicesDC;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardData;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;

public abstract class RenamePartOfPPObjectWizard
extends RenameWizard {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private String mOldMDOName = null;
    private String mOldMDOPackage = null;
    private ServicesDC.EntityPair[] mEntityPairs;

    public RenamePartOfPPObjectWizard(MainDevelopmentObject mdo) {
        super((DevelopmentObject)mdo);
        this.mOldMDOName = mdo.getName();
        this.mOldMDOPackage = mdo.getPackage();
        this.initializePreviewObjects(mdo);
    }

    public RenamePartOfPPObjectWizard(MainDevelopmentObject mdo, String newName, String newPackage) {
        super((DevelopmentObject)mdo, newName, newPackage);
        this.mOldMDOName = mdo.getName();
        this.mOldMDOPackage = mdo.getPackage();
        this.initializePreviewObjects(mdo);
    }

    private void initializePreviewObjects(MainDevelopmentObject mdo) {
        this.mEntityPairs = ServicesDC.getCorrespondingEntityPairs((String)this.mOldMDOName, (String)this.mOldMDOPackage, (MainDevelopmentObject)mdo);
    }

    private boolean isInPublicPart() {
        RenameWizardData mRenameWizardData = this.getWizardData();
        DevelopmentObject developmentObject = mRenameWizardData.getObjectToRefactor();
        if (developmentObject instanceof MainDevelopmentObject) {
            ServicesDC.EntityHandler entityHandler = ServicesDC.isMDOInPublicPart((MainDevelopmentObject)((MainDevelopmentObject)developmentObject));
            return entityHandler.isInPublicPart();
        }
        return false;
    }

    protected IStatus doAdditionalTasksBeforeRefactoring(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        String PLUGIN_ID = ServiceCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
        if (!(developmentObject instanceof MainDevelopmentObject)) {
            return new Status(4, PLUGIN_ID, -1, "Wrong type in RenamePartOfPPObjectWizard", null);
        }
        dialog.getProgressMonitor().setTaskName(CoreTextPool.getInstance().getText(218));
        return ServicesDC.checkoutPublicParts((ServicesDC.EntityPair[])this.mEntityPairs, (MainDevelopmentObject)((MainDevelopmentObject)developmentObject));
    }

    protected void doAdditionalTasksAfterRefactoring(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        if (!(developmentObject instanceof MainDevelopmentObject)) {
            return;
        }
        dialog.getProgressMonitor().setTaskName(CoreTextPool.getInstance().getText(217));
        ServicesDC.renameEntities((ServicesDC.EntityPair[])this.mEntityPairs, (MainDevelopmentObject)((MainDevelopmentObject)developmentObject));
    }

    protected Object[] getAdditionalPreviewItems() {
        return this.mEntityPairs;
    }

    protected boolean showWarningSection() {
        return this.isInPublicPart();
    }

    protected String getWarningMessage() {
        return mCPool.getText(318);
    }

    protected abstract String verifyDevelopmentobjectName(String var1, String var2);
}

