/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.ui;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.service.core.ui.DevelopmentObjectService;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DevelopmentObjectTreeDialog
extends Dialog {
    private static final int LIST_WIDTH = 400;
    private static final int LIST_HEIGHT = 300;
    private DevelopmentObject[] mDevelopmentObjects = null;
    private TreeViewer mTree;
    private Button mOkButton;
    private String mTitle;
    private String mMessage = null;

    public DevelopmentObjectTreeDialog(Shell parentShell, DevelopmentObject[] developmentObjects, String title) {
        super(parentShell);
        this.mDevelopmentObjects = developmentObjects;
        this.mTitle = title;
    }

    public void setMessageText(String message) {
        this.mMessage = message;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.mOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        GridData spec;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        if (this.mMessage != null) {
            Text messageArea = new Text(composite, 72);
            messageArea.setText(this.mMessage);
            spec = new GridData(1808);
            spec.widthHint = 400;
            messageArea.setLayoutData((Object)spec);
        }
        this.mTree = new TreeViewer(composite, 2820);
        this.mTree.setLabelProvider((IBaseLabelProvider)new DevelopmentObjectLabelProvider());
        this.mTree.setContentProvider((IContentProvider)new DevelopmentObjectContentProvider());
        this.mTree.setSorter((ViewerSorter)new DevelopmentObjectSorter());
        this.mTree.setInput((Object)this.mDevelopmentObjects);
        Control ctrl = this.mTree.getControl();
        spec = new GridData(1808);
        spec.widthHint = 400;
        spec.heightHint = 300;
        ctrl.setLayoutData((Object)spec);
        ctrl.setFocus();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.mTitle);
    }

    private class DevelopmentObjectLabelProvider
    extends LabelProvider {
        private DevelopmentObjectLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof Class) {
                text = DevelopmentObjectService.getDevelopmentClassObjectDisplayName((Class)element);
            } else if (element instanceof DevelopmentObject) {
                text = ((DevelopmentObject)element).getName();
            }
            return text;
        }
    }

    private class DevelopmentObjectContentProvider
    implements ITreeContentProvider {
        private DevelopmentObjectContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = new Object[]{};
            if (parentElement instanceof DevelopmentObject[]) {
                DevelopmentObject[] developmentObjects = (DevelopmentObject[])parentElement;
                ArrayList list = new ArrayList();
                int i = 0;
                while (i < developmentObjects.length) {
                    if (!list.contains(developmentObjects[i].getClass())) {
                        list.add(developmentObjects[i].getClass());
                    }
                    ++i;
                }
                children = new Object[list.size()];
                children = list.toArray(children);
            } else if (parentElement instanceof Class) {
                Class clazz = (Class)parentElement;
                ArrayList<DevelopmentObject> list = new ArrayList<DevelopmentObject>();
                int i = 0;
                while (i < DevelopmentObjectTreeDialog.this.mDevelopmentObjects.length) {
                    if (clazz.equals(DevelopmentObjectTreeDialog.this.mDevelopmentObjects[i].getClass())) {
                        list.add(DevelopmentObjectTreeDialog.this.mDevelopmentObjects[i]);
                    }
                    ++i;
                }
                children = new Object[list.size()];
                children = list.toArray(children);
            }
            return children;
        }

        public Object getParent(Object element) {
            Class<?> parent = null;
            if (element instanceof DevelopmentObject[]) {
                parent = element.getClass();
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            boolean children = false;
            if (element instanceof DevelopmentObject[]) {
                children = true;
            } else if (element instanceof Class) {
                children = true;
            }
            return children;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DevelopmentObjectSorter
    extends ViewerSorter {
        private DevelopmentObjectSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return super.compare(viewer, e1, e2);
        }
    }
}

