/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.properties;

import com.sap.ide.webdynpro.service.core.properties.ITextCallback;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextButtonCellEditor
extends DialogCellEditor {
    protected Text text;
    protected String[] mEnums = null;
    protected ModifyListener modifyListener;
    protected ITextCallback mCallback;
    protected String mType;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    public TextButtonCellEditor(Composite parent, String type, String[] enums, ITextCallback callback) {
        this.mCallback = callback;
        this.mEnums = enums;
        this.mType = type;
        this.setStyle(0);
        this.create(parent);
    }

    public TextButtonCellEditor(Composite parent, String type, ITextCallback callback) {
        super(parent);
        this.mCallback = callback;
        this.mEnums = null;
    }

    protected void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    protected void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    protected void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 0);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.text = new Text(cell, 16384);
        this.text.setToolTipText(this.mType);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                TextButtonCellEditor.super.keyReleaseOccured(e);
                if (TextButtonCellEditor.this.getControl() == null || TextButtonCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                TextButtonCellEditor.this.checkSelection();
                TextButtonCellEditor.this.checkDeleteable();
                TextButtonCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TextButtonCellEditor.this.checkSelection();
                TextButtonCellEditor.this.checkDeleteable();
                TextButtonCellEditor.this.checkSelectable();
            }
        });
        this.text.setFont(cell.getFont());
        this.text.setBackground(cell.getBackground());
        this.text.addModifyListener(this.getModifyListener());
        return this.text;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        return this.mCallback.callbackText(cellEditorWindow);
    }

    protected void updateContents(Object value) {
        if (value != null) {
            String string = (String)value;
            this.text.setText(string);
        } else {
            this.text.setText("");
        }
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetValue(Object value) {
        this.text.removeModifyListener(this.getModifyListener());
        if (this.mEnums != null && value instanceof Integer) {
            this.text.setText(this.mEnums[(Integer)value]);
        } else {
            this.text.setText((String)value);
        }
        this.text.addModifyListener(this.getModifyListener());
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextButtonCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.text.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            // empty if block
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }
}

