/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.properties;

import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.properties.IResetCallback;
import com.sap.ide.webdynpro.service.core.properties.ITextCallback;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResetTextButtonCellEditor
extends DialogCellEditor {
    protected Text text;
    protected Button mButton = null;
    protected ModifyListener modifyListener;
    protected ITextCallback mCallback;
    protected IResetCallback mResetCallback;
    protected String mType;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    public ResetTextButtonCellEditor(Composite parent, String type, ITextCallback callback, IResetCallback resetCallback) {
        this.mCallback = callback;
        this.mResetCallback = resetCallback;
        this.mType = type;
        this.setStyle(0);
        this.create(parent);
    }

    protected void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    protected void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    protected void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 0);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        Composite comp = new Composite(cell, 0);
        GridData gridData = new GridData(1808);
        comp.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        comp.setLayout((Layout)gridLayout);
        this.text = new Text(comp, 16384);
        this.text.setToolTipText(this.mType);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ResetTextButtonCellEditor.super.keyReleaseOccured(e);
                if (ResetTextButtonCellEditor.this.getControl() == null || ResetTextButtonCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                ResetTextButtonCellEditor.this.checkSelection();
                ResetTextButtonCellEditor.this.checkDeleteable();
                ResetTextButtonCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ResetTextButtonCellEditor.this.checkSelection();
                ResetTextButtonCellEditor.this.checkDeleteable();
                ResetTextButtonCellEditor.this.checkSelectable();
            }
        });
        this.text.setFont(cell.getFont());
        this.text.setBackground(cell.getBackground());
        this.text.addModifyListener(this.getModifyListener());
        GridData gridData1 = new GridData(1808);
        gridData1.verticalAlignment = 128;
        this.text.setLayoutData((Object)gridData1);
        this.mButton = new Button(comp, 0);
        this.mButton.setText(CoreTextPool.getInstance().getText(165));
        this.mButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResetTextButtonCellEditor.this.mResetCallback.callbackText(null);
                ResetTextButtonCellEditor.this.mResetCallback.setDependent(true);
                ResetTextButtonCellEditor.this.doSetValue("<>");
            }
        });
        GridData gridData2 = new GridData(1040);
        gridData2.horizontalAlignment = 128;
        this.mButton.setLayoutData((Object)gridData2);
        return comp;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        return this.mCallback.callbackText(cellEditorWindow);
    }

    protected void updateContents(Object value) {
        if (value != null) {
            String string = (String)value;
            this.text.setText(string);
        } else {
            this.text.setText("");
        }
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetValue(Object value) {
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText((String)value);
        this.text.addModifyListener(this.getModifyListener());
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ResetTextButtonCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.text.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            // empty if block
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }
}

