/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.properties;

import com.sap.ide.webdynpro.service.core.properties.IComboCallback;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ComboButtonCellEditor
extends DialogCellEditor {
    private String[] items;
    private int selection;
    private CCombo comboBox;
    private Text text;
    private ModifyListener modifyListener;
    private IComboCallback callback;
    protected String mType;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    public ComboButtonCellEditor(Composite parent, String[] items, String type, IComboCallback callback) {
        this.items = items;
        this.selection = 0;
        this.callback = callback;
        this.mType = type;
        this.setStyle(0);
        this.create(parent);
        this.populateComboBoxItems();
    }

    protected Object doGetValue() {
        return new Integer(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        layoutData.minimumWidth = Math.max(30, layoutData.minimumWidth);
        return layoutData;
    }

    protected void doSetValue(Object value) {
        if (value instanceof Integer) {
            this.selection = (Integer)value;
            if (!this.comboBox.isDisposed()) {
                this.comboBox.select(this.selection);
            }
        }
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        return this.callback.callbackCombo(cellEditorWindow);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 0);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.comboBox = new CCombo(cell, 12);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.setToolTipText(this.mType);
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ComboButtonCellEditor.super.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ComboButtonCellEditor.this.selection = ComboButtonCellEditor.this.comboBox.getSelectionIndex();
                Object newValue = ComboButtonCellEditor.this.doGetValue();
                boolean newValidState = ComboButtonCellEditor.super.isCorrect(newValue);
                if (newValidState) {
                    ComboButtonCellEditor.this.doSetValue(newValue);
                } else {
                    ComboButtonCellEditor.super.setErrorMessage(MessageFormat.format(ComboButtonCellEditor.this.getErrorMessage(), ComboButtonCellEditor.this.items[ComboButtonCellEditor.this.selection]));
                }
                ComboButtonCellEditor.super.fireApplyEditorValue();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }
}

