/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.paste;

import com.sap.ide.generationfwk.eclipse.progressmonitor.StatusLineProgressMonitor;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.clipboard.PasteProcess;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.IncompleteRefactoringInfoException;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.repository.RepositoryUtilities;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteLog;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.PasteException;
import com.sap.ide.webdynpro.service.core.paste.PasteLog;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;

public abstract class PasteManager
implements IPasteManager {
    protected static final ClipboardObject[] EMPTY_CLIPBOARD_OBJECTS_ARRAY = new ClipboardObject[0];
    protected static final DevelopmentObject[] EMPTY_DEVELOPMENT_OBJECTS_ARRAY = new DevelopmentObject[0];
    protected static final MainDevelopmentObject[] EMPTY_MDO_ARRAY = new MainDevelopmentObject[0];
    private Map mHandlersForObjectType = this.createHandlers(this.getValidExtensions(ServiceCorePlugin.getDefault()));
    private IPasteLog mLog;

    public void paste(MetamodelClipboard clipboard, MetamodelObject newParent) {
    }

    public MetamodelClipboard getClipboard() {
        return Metamodel.getClipboard();
    }

    public ClipboardObject[] getRootObjects() {
        return EMPTY_CLIPBOARD_OBJECTS_ARRAY;
    }

    public SourcePathIdentifier getSourcePathIdentifier() {
        return null;
    }

    public void setSourcePathIdentifier(SourcePathIdentifier sourcePathIdentifier) {
    }

    public IPasteHandler getPasteHandler(ClipboardObject clipboardObject) {
        return this.getPasteHandler(clipboardObject.getType());
    }

    public IPasteHandler getPasteHandler(DevelopmentObject developmentObject) {
        String objectTypeName = this.getObjectTypeName(developmentObject);
        return this.getPasteHandler(WebDynproDevelopmentObjectEnum.valueOf((String)objectTypeName));
    }

    public IPasteHandler getPasteHandler(DevelopmentObjectEnum type) {
        Iterator iter = this.mHandlersForObjectType.keySet().iterator();
        while (iter.hasNext()) {
            DevelopmentObjectEnum enumType = (DevelopmentObjectEnum)iter.next();
            if (enumType != type) continue;
            return (IPasteHandler)this.mHandlersForObjectType.get(enumType);
        }
        return null;
    }

    public void addToClipboardObjectsHistory(ClipboardObject clipboardObject) {
    }

    public ClipboardObject[] getClipboardObjectsHistory() {
        return EMPTY_CLIPBOARD_OBJECTS_ARRAY;
    }

    public IProgressMonitor getSharedMonitor() {
        return StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)false);
    }

    public void openSharedMonitor() {
    }

    public void closeSharedMonitor() {
    }

    public IPasteLog getLog() {
        if (this.mLog == null) {
            this.mLog = new PasteLog();
        }
        return this.mLog;
    }

    public boolean isSourceMetamodelValid(Metamodel metamodel) {
        return metamodel != null && metamodel.isValid();
    }

    public void displayPasteException(PasteException e) {
        UIHelper.displayErrorMessage(CoreTextPool.getInstance().getText(414), e.getMessage());
    }

    public boolean displayPasteExceptionAsWarning(PasteException e) {
        MessageDialog dialog = UIHelper.createMessageDialogToDecide(CoreTextPool.getInstance().getText(418), e.getMessage(), 4, 0);
        return dialog.open() == 0;
    }

    private DevelopmentObjectEnum mapExtensionTypeToClipboardObjectType(String extensionType) {
        if (extensionType.equalsIgnoreCase("Context")) {
            return WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE;
        }
        return WebDynproDevelopmentObjectEnum.valueOf((String)extensionType);
    }

    private List getValidExtensions(Plugin plugin) {
        Vector<IConfigurationElement> extensions = new Vector<IConfigurationElement>();
        IExtensionPoint extensionPoint = plugin.getDescriptor().getExtensionPoint("pasteHandler");
        if (extensionPoint == null) {
            return extensions;
        }
        IExtension[] lExtensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < lExtensions.length) {
            IConfigurationElement[] configurationElements = lExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                if (configurationElements[j].getAttribute("class") != null && configurationElements[j].getAttribute("type") != null) {
                    extensions.add(configurationElements[j]);
                }
                ++j;
            }
            ++i;
        }
        return extensions;
    }

    private Map createHandlers(List extensions) {
        Hashtable<DevelopmentObjectEnum, Object> validHandlers = new Hashtable<DevelopmentObjectEnum, Object>();
        Iterator iter = extensions.iterator();
        while (iter.hasNext()) {
            IConfigurationElement confElement = (IConfigurationElement)iter.next();
            if (confElement == null) continue;
            try {
                Object instance = confElement.createExecutableExtension("class");
                if (instance instanceof IPasteHandler) {
                    String objectType = confElement.getAttribute("type");
                    DevelopmentObjectEnum type = this.mapExtensionTypeToClipboardObjectType(objectType);
                    if (type != null) {
                        validHandlers.put(type, instance);
                        if (!ServiceCorePlugin.isPasteHandlerLogEnabled()) continue;
                        ServiceCorePlugin.logInfoMessage("Created a paste handler for " + type + ": " + instance);
                        continue;
                    }
                    ServiceCorePlugin.internalError(this.getClass(), "createHandlers(List)", "Not a valid type value in registered paste handler: " + type + ". Will be ignored.", null, true);
                    continue;
                }
                ServiceCorePlugin.internalError(this.getClass(), "createHandlers(List)", CoreTextPool.getInstance().getText(29, "com.sap.ide.webdynpro.services.core.IPasteHandler"), null, true);
            }
            catch (CoreException e) {
                ServiceCorePlugin.internalError(this.getClass(), "createHandlers(List)", "Could not create paste handler extension", e, true);
            }
        }
        return validHandlers;
    }

    protected boolean checkAffectedMDOs(Set mdos) {
        return RepositoryUtilities.checkWriteability((MainDevelopmentObject[])mdos.toArray(new MainDevelopmentObject[mdos.size()]), (boolean)false);
    }

    protected int computeScope(MetamodelClipboard clipboard, MetamodelObject newParent) {
        boolean isCrossComp = false;
        boolean isCrossProject = MetamodelServices.isCrossProjectPaste(newParent, clipboard);
        if (newParent instanceof DevelopmentObject) {
            isCrossComp = MetamodelServices.isCrossComponentPaste((DevelopmentObject)newParent, clipboard);
            if (isCrossComp) {
                if (isCrossProject) {
                    return 3;
                }
                return 2;
            }
        } else if (newParent instanceof Root && isCrossProject) {
            return 3;
        }
        return 1;
    }

    protected DevelopmentObject[] pasteExecute(PasteProcess pasteProcess) {
        try {
            return pasteProcess.execute();
        }
        catch (CreateException e) {
            ServicesUI.internalError(this.getClass(), (String)"pasteExecute", (String)"Failed to create new objects", (Throwable)e, (Plugin)ServiceCorePlugin.getDefault(), (boolean)false);
            return EMPTY_DEVELOPMENT_OBJECTS_ARRAY;
        }
        catch (IncompleteRefactoringInfoException e) {
            ServicesUI.internalError(this.getClass(), (String)"pasteExecute", (String)"refactoring info not complete", (Throwable)e, (Plugin)ServiceCorePlugin.getDefault(), (boolean)false);
            return EMPTY_DEVELOPMENT_OBJECTS_ARRAY;
        }
    }

    protected Metamodel getNewMetamodel(MetamodelObject newParent) {
        return this.getNewRoot(newParent).getMetamodel();
    }

    protected Root getNewRoot(MetamodelObject newParent) {
        if (newParent instanceof DevelopmentObject) {
            DevelopmentObject newParentDO = (DevelopmentObject)newParent;
            return newParentDO.getRoot();
        }
        if (newParent instanceof Root) {
            return (Root)newParent;
        }
        return null;
    }

    protected String getNewLanguage(MetamodelObject newParent) {
        String newLanguage = null;
        Metamodel newMetamodel = this.getNewMetamodel(newParent);
        if (newMetamodel != null) {
            newLanguage = newMetamodel.getLanguage();
        }
        return newLanguage;
    }

    private String getObjectTypeName(DevelopmentObject object) {
        String lTypeName = object.getClass().getName();
        lTypeName = lTypeName.substring(0, lTypeName.indexOf("Proxy"));
        lTypeName = lTypeName.substring(lTypeName.lastIndexOf(46) + 1);
        return lTypeName;
    }
}

