/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.paste;

import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.sap.ide.webdynpro.service.core.paste.IPasteLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PasteLog
implements IPasteLog {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String TAB = "\t";
    private static final String EMPTY_STRING = "";
    private static final int SEVERITY_UNKNOWN = -1;
    private List mEntries = new ArrayList();
    private String mText = null;
    private int mHighestSeverity = -1;
    private boolean mChangedText = false;

    public void addEntry(int severity, String message, boolean writeErrorLogEntry) {
        this.addEntry(severity, message, null, writeErrorLogEntry);
    }

    public void addEntry(Throwable t, String message, boolean writeErrorLogEntry) {
        this.addEntry(4, message, t, writeErrorLogEntry);
    }

    public boolean isEmpty() {
        return this.mEntries.isEmpty();
    }

    public void clear() {
        this.mEntries.clear();
        this.mChangedText = false;
        this.mHighestSeverity = -1;
        this.mText = null;
    }

    public int getHighestSeverity() {
        return this.mHighestSeverity;
    }

    public String getText() {
        if (this.mChangedText) {
            StringBuffer buf = new StringBuffer();
            Iterator iter = this.mEntries.iterator();
            while (iter.hasNext()) {
                IStatus entry = (IStatus)iter.next();
                this.printEntryHeader(buf, entry.getSeverity());
                buf.append(entry.getMessage());
                if (!iter.hasNext()) continue;
                buf.append(LINE_SEPARATOR + LINE_SEPARATOR);
            }
            this.mText = buf.toString();
            this.mChangedText = false;
        }
        return this.mText == null ? EMPTY_STRING : this.mText;
    }

    private void addEntry(int severity, String message, Throwable t, boolean writeErrorLogEntry) {
        LogEntry entry = new LogEntry(severity, message, t);
        this.mEntries.add(entry);
        if (severity > this.mHighestSeverity) {
            this.mHighestSeverity = severity;
        }
        this.mChangedText = true;
        if (writeErrorLogEntry) {
            this.writeErrorLogEntry((IStatus)entry);
        }
    }

    private void printEntryHeader(StringBuffer buf, int severity) {
        CoreTextPool textPool = CoreTextPool.getInstance();
        switch (severity) {
            case 4: {
                buf.append(textPool.getText(425));
                break;
            }
            case 2: {
                buf.append(textPool.getText(426));
                break;
            }
            case 1: {
                buf.append(textPool.getText(427));
                break;
            }
            default: {
                return;
            }
        }
        buf.append(LINE_SEPARATOR);
        buf.append(TAB);
    }

    private void writeErrorLogEntry(IStatus entry) {
        int severity = entry.getSeverity();
        switch (severity) {
            case 4: {
                ServiceCorePlugin.internalError(this.getClass(), EMPTY_STRING, entry.getMessage(), entry.getException(), true);
                break;
            }
            case 2: {
                ServiceCorePlugin.internalWarning(this.getClass(), EMPTY_STRING, entry.getMessage(), entry.getException());
                break;
            }
            case 1: {
                ServiceCorePlugin.logInfoMessage(entry.getMessage());
                break;
            }
        }
    }

    private static class LogEntry
    extends Status {
        private static final String PLUGIN_ID = ServiceCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();

        LogEntry(int severity, String message, Throwable t) {
            super(severity, PLUGIN_ID, 0, message, t);
        }
    }
}

