/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.paste;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public abstract class PasteHandler
implements IPasteHandler,
IExecutableExtension {
    protected static final MainDevelopmentObject[] EMPTY_MDO_ARRAY = new MainDevelopmentObject[0];
    protected static final DevelopmentObject[] EMPTY_DEVELOPMENT_OBJECT_ARRAY = new DevelopmentObject[0];
    private IConfigurationElement mConfigElement;

    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newParent instanceof DevelopmentObject) {
            return new MainDevelopmentObject[]{((DevelopmentObject)newParent).getMDO()};
        }
        return EMPTY_MDO_ARRAY;
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
    }

    public abstract DevelopmentObjectEnum getType();

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.mConfigElement = config;
    }

    protected String getProjectName(MetamodelObject metamodelObject) {
        if (metamodelObject instanceof DevelopmentObject) {
            return ((DevelopmentObject)metamodelObject).getRoot().getMetamodel().getName();
        }
        if (metamodelObject instanceof Root) {
            return ((Root)metamodelObject).getMetamodel().getName();
        }
        return null;
    }

    protected MetamodelManager getMetamodelManager(MetamodelObject newParent) {
        String projectName = this.getProjectName(newParent);
        if (projectName != null) {
            return MetamodelManager.getMetamodelManager((String)projectName);
        }
        return null;
    }

    protected void setPasteProcessSourcePathIdentifier(IPasteManager pasteManager, IPackageFragmentRoot packageFragmentRoot, MetamodelObject newParent) {
        MetamodelManager manager = this.getMetamodelManager(newParent);
        if (manager != null) {
            IPath sourcePath = manager.makePathAbsolute(packageFragmentRoot.getPath());
            SourcePathIdentifier identifier = manager.getSourcePathIdentifier(sourcePath);
            pasteManager.setSourcePathIdentifier(identifier);
        }
    }

    protected Metamodel getNewMetamodel(MetamodelObject newParent) {
        return this.getNewRoot(newParent).getMetamodel();
    }

    protected Root getNewRoot(MetamodelObject newParent) {
        if (newParent instanceof Root) {
            return (Root)newParent;
        }
        if (newParent instanceof DevelopmentObject) {
            return ((DevelopmentObject)newParent).getRoot();
        }
        return null;
    }

    protected boolean isSourceRootListEnabled(SourcePathIdentifier pasteProcessSourcePathIdentifier, MetamodelObject newParent) {
        return pasteProcessSourcePathIdentifier == null;
    }

    protected String getPreselectedPackage(ClipboardObject currentObject, MetamodelObject newParent) {
        return this.getPreselectedPackage(currentObject, newParent, null);
    }

    protected String getPreselectedPackage(ClipboardObject currentObject, MetamodelObject newParent, DevelopmentObject originalObject) {
        String preselectedPackage = null;
        if (currentObject != null) {
            preselectedPackage = currentObject.getNewPackage();
            if (currentObject.getParent() != null) {
                preselectedPackage = currentObject.getParent().getNewPackage();
            } else if (newParent instanceof MainDevelopmentObject) {
                preselectedPackage = ((MainDevelopmentObject)newParent).getPackage();
            } else if (newParent instanceof Root && originalObject != null) {
                preselectedPackage = originalObject.getMDO().getPackage();
            }
        }
        return preselectedPackage;
    }

    protected void addToClipboardObjectsHistory(ClipboardObject[] clipboardObjects, IPasteManager pasteManager) {
        this.addToClipboardObjectsHistory(clipboardObjects, pasteManager, false, true);
    }

    protected void addToClipboardObjectsHistory(ClipboardObject[] clipboardObjects, IPasteManager pasteManager, boolean addChildrenToo, boolean onlyAddMDOs) {
        if (clipboardObjects != null && pasteManager != null) {
            int i = 0;
            while (i < clipboardObjects.length) {
                ClipboardObject object = clipboardObjects[i];
                if ((!onlyAddMDOs || onlyAddMDOs && object.isMDO()) && !object.getExcluded()) {
                    pasteManager.addToClipboardObjectsHistory(object);
                    if (addChildrenToo) {
                        this.addToClipboardObjectsHistory(object.getChildren(), pasteManager, true, onlyAddMDOs);
                    }
                }
                ++i;
            }
        }
    }

    protected DevelopmentObject convertOldToNewReference(Metamodel newMetamodel, DevelopmentObject oldElement) {
        if (newMetamodel != null && newMetamodel.isValid() && oldElement != null) {
            return newMetamodel.getObjectFromKey(oldElement.getKey());
        }
        return null;
    }

    protected String getTypeName() {
        if (this.mConfigElement == null) {
            return null;
        }
        return this.mConfigElement.getAttribute("type");
    }
}

