/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.paste;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.clipboard.PasteProcess;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.LanguageConflictException;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteMapper;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteResult;
import com.sap.ide.webdynpro.service.core.paste.OriginalObjectNotExistingException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.PasteLogDialog;
import com.sap.ide.webdynpro.service.core.paste.PasteManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class MDOPasteManager
extends PasteManager {
    private MetamodelClipboard mClipboard;
    private ClipboardObject[] mRootObjects = PasteManager.EMPTY_CLIPBOARD_OBJECTS_ARRAY;
    private PasteProcess mPasteProcess;
    private MDOPasteMapper mMapper;
    private Set mClipboardObjectsHistory = new HashSet();
    private MDOPasteResult mPasteResult = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paste(MetamodelClipboard clipboard, MetamodelObject newParent) {
        super.paste(clipboard, newParent);
        this.mClipboard = clipboard;
        CoreTextPool pool = CoreTextPool.getInstance();
        DevelopmentObject[] newObjects = new DevelopmentObject[]{};
        HashSet<MainDevelopmentObject> affectedMDOs = new HashSet<MainDevelopmentObject>();
        int scope = this.computeScope(clipboard, newParent);
        if (!clipboard.isPasteAllowed(newParent)) {
            ServiceCorePlugin.internalError(this.getClass(), "paste(MetamodelClipboard, MetamodelObject)", "Clipboard.isPasteAllowed() returned false. Operation is aborted.", null, false);
            this.buildResult(false, null);
            return;
        }
        this.mPasteProcess = clipboard.initiatePaste(newParent);
        this.mRootObjects = this.mPasteProcess.getClipboardContent();
        if (!this.isSourceMetamodelValid(clipboard.getSourceMetamodel())) {
            UIHelper.displayErrorMessage(pool.getText(414), pool.getText(46));
            this.buildResult(false, null);
            return;
        }
        if (!ProjectService.checkMetamodelLanguage((Metamodel)this.getNewMetamodel(newParent))) {
            UIHelper.displayErrorMessage(pool.getText(414), pool.getText(47));
            this.buildResult(false, null);
            return;
        }
        String newLanguage = this.getNewLanguage(newParent);
        MainDevelopmentObject languageConflictingObject = this.checkForLanguageConflicts(clipboard, this.mRootObjects, newLanguage, scope);
        if (languageConflictingObject != null && !this.displayPasteExceptionAsWarning(new LanguageConflictException(languageConflictingObject, newLanguage))) {
            this.buildResult(false, null);
            return;
        }
        try {
            IPasteHandler handler;
            int i = 0;
            while (i < this.mRootObjects.length) {
                ClipboardObject object = this.mRootObjects[i];
                handler = this.getPasteHandler(object);
                if (handler != null) {
                    try {
                        ClipboardObject[] relevantObjects = MDOPasteManager.computeRelevantObjects(this.mClipboard, this.mRootObjects, i);
                        if (relevantObjects != null && relevantObjects.length > 0) {
                            MainDevelopmentObject[] mdos = PasteManager.EMPTY_MDO_ARRAY;
                            mdos = handler.getAffectedMDOs(relevantObjects, newParent, scope, this);
                            affectedMDOs.addAll(Arrays.asList(mdos));
                        }
                    }
                    catch (PasteHandlerException e) {
                        this.displayPasteException(e);
                        this.buildResult(false, null);
                        Object var19_19 = null;
                        this.closeSharedMonitor();
                        return;
                    }
                    catch (Throwable t) {
                        ServiceCorePlugin.internalError(this.getClass(), "paste(MetamodelClipboard, MetamodelObject)", "Collect affected MDOs: error caused by paste handler", t, false);
                        this.buildResult(false, null);
                        Object var19_20 = null;
                        this.closeSharedMonitor();
                        return;
                    }
                }
                ++i;
            }
            if (!this.checkAffectedMDOs(affectedMDOs)) {
                this.buildResult(false, null);
                Object var19_21 = null;
                this.closeSharedMonitor();
                return;
            }
            int i2 = 0;
            while (i2 < this.mRootObjects.length) {
                ClipboardObject object = this.mRootObjects[i2];
                handler = this.getPasteHandler(object);
                if (handler != null) {
                    try {
                        ClipboardObject[] relevantObjects = MDOPasteManager.computeRelevantObjects(this.mClipboard, this.mRootObjects, i2);
                        if (relevantObjects != null && relevantObjects.length > 0) {
                            boolean cancelled;
                            boolean bl = cancelled = !handler.refactorBeforeExecution(relevantObjects, newParent, scope, this);
                            if (cancelled) {
                                this.buildResult(false, null);
                                Object var19_22 = null;
                                this.closeSharedMonitor();
                                return;
                            }
                        }
                    }
                    catch (PasteHandlerException e) {
                        this.displayPasteException(e);
                        this.buildResult(false, null);
                        Object var19_23 = null;
                        this.closeSharedMonitor();
                        return;
                    }
                    catch (Throwable t) {
                        ServiceCorePlugin.internalError(this.getClass(), "paste(MetamodelClipboard, MetamodelObject)", "Before execution: error caused by paste handler", t, false);
                        this.buildResult(false, null);
                        Object var19_24 = null;
                        this.closeSharedMonitor();
                        return;
                    }
                }
                ++i2;
            }
            boolean wasAutoNotifyEnabled = this.getNewRoot(newParent).isAutoNotifyEnabled();
            this.getNewRoot(newParent).disableAutoNotify();
            try {
                newObjects = this.pasteExecute(this.mPasteProcess);
                Object var16_30 = null;
                if (wasAutoNotifyEnabled) {
                    this.getNewRoot(newParent).enableAutoNotify();
                }
            }
            catch (Throwable throwable) {
                Object var16_31 = null;
                if (wasAutoNotifyEnabled) {
                    this.getNewRoot(newParent).enableAutoNotify();
                }
                throw throwable;
            }
            if (newObjects == null || newObjects.length == 0) {
                this.buildResult(false, null);
                Object var19_25 = null;
                this.closeSharedMonitor();
                return;
            }
            int i3 = 0;
            while (i3 < newObjects.length) {
                DevelopmentObject object = newObjects[i3];
                handler = this.getPasteHandler(object);
                if (handler != null) {
                    try {
                        DevelopmentObject[] relevantObjects = MDOPasteManager.computeRelevantObjects(this.mClipboard, newObjects, i3);
                        if (relevantObjects != null && relevantObjects.length > 0) {
                            handler.refactorAfterExecution(relevantObjects, newParent, scope, this);
                        }
                    }
                    catch (Throwable t) {
                        ServiceCorePlugin.internalError(this.getClass(), "paste(MetamodelClipboard, MetamodelObject)", "After execution: error caused by paste handler", t, false);
                    }
                }
                ++i3;
            }
            if (!this.getLog().isEmpty()) {
                new PasteLogDialog(this.getLog()).open();
            }
            Object var19_26 = null;
            this.closeSharedMonitor();
        }
        catch (Throwable throwable) {
            Object var19_27 = null;
            this.closeSharedMonitor();
            throw throwable;
        }
        this.buildResult(true, newObjects);
    }

    public MDOPasteResult getPasteResult() {
        return this.mPasteResult;
    }

    public static ClipboardObject[] computeRelevantObjects(MetamodelClipboard clipboard, ClipboardObject[] rootObjects, int index) throws OriginalObjectNotExistingException {
        Hashtable<DevelopmentObject, ClipboardObject> clObjToDevObj = new Hashtable<DevelopmentObject, ClipboardObject>();
        ArrayList<DevelopmentObject> originalObjects = new ArrayList<DevelopmentObject>();
        ArrayList relevantClipboardObjects = new ArrayList();
        int i = 0;
        while (i < rootObjects.length) {
            ClipboardObject clipboardObject = rootObjects[i];
            DevelopmentObject originalObject = clipboard.getSourceMetamodel().getObjectFromKey(clipboardObject.getOriginalKey());
            if (originalObject == null) {
                throw new OriginalObjectNotExistingException(clipboardObject);
            }
            originalObjects.add(originalObject);
            clObjToDevObj.put(originalObject, clipboardObject);
            Iterator iter = clipboardObject.iterator();
            while (iter.hasNext()) {
                ClipboardObject child = (ClipboardObject)iter.next();
                DevelopmentObject originalChildObject = clipboard.getSourceMetamodel().getObjectFromKey(child.getOriginalKey());
                if (originalChildObject != null) {
                    clObjToDevObj.put(originalChildObject, child);
                    continue;
                }
                throw new OriginalObjectNotExistingException(child);
            }
            ++i;
        }
        DevelopmentObject[] relevantDevObjects = MDOPasteManager.computeRelevantObjects(clipboard, originalObjects.toArray(new DevelopmentObject[originalObjects.size()]), index);
        int i2 = 0;
        while (i2 < relevantDevObjects.length) {
            relevantClipboardObjects.add(clObjToDevObj.get(relevantDevObjects[i2]));
            ++i2;
        }
        return relevantClipboardObjects.toArray(new ClipboardObject[relevantClipboardObjects.size()]);
    }

    public static DevelopmentObject[] computeRelevantObjects(MetamodelClipboard clipboard, DevelopmentObject[] rootObjects, int index) {
        if (rootObjects == null || rootObjects.length <= index) {
            return PasteManager.EMPTY_DEVELOPMENT_OBJECTS_ARRAY;
        }
        if (rootObjects[index] instanceof View) {
            View v = (View)rootObjects[index];
            Controller vc = v.getViewController();
            int i = 0;
            while (i < rootObjects.length) {
                if (rootObjects[i].equals(vc)) {
                    return new DevelopmentObject[]{v, vc};
                }
                ++i;
            }
        } else {
            if (rootObjects[index] instanceof Controller && ((Controller)rootObjects[index]).getType().equals(ControllerTypeEnum.VIEW)) {
                return PasteManager.EMPTY_DEVELOPMENT_OBJECTS_ARRAY;
            }
            if (rootObjects[index] instanceof Window) {
                Window w = (Window)rootObjects[index];
                InterfaceView iv = w.getInterfaceView();
                Controller ivc = iv.getViewController();
                return new DevelopmentObject[]{w, iv, ivc};
            }
            if (rootObjects[index] instanceof InterfaceView) {
                InterfaceView iv = (InterfaceView)rootObjects[index];
                Controller ivc = iv.getViewController();
                int i = 0;
                while (i < rootObjects.length) {
                    if (rootObjects[i].equals(ivc)) {
                        return new DevelopmentObject[]{iv, ivc};
                    }
                    ++i;
                }
            } else if (rootObjects[index] instanceof Controller && ((Controller)rootObjects[index]).getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
                return PasteManager.EMPTY_DEVELOPMENT_OBJECTS_ARRAY;
            }
        }
        return new DevelopmentObject[]{rootObjects[index]};
    }

    public MetamodelClipboard getClipboard() {
        return this.mClipboard;
    }

    public ClipboardObject[] getRootObjects() {
        return this.mRootObjects;
    }

    public SourcePathIdentifier getSourcePathIdentifier() {
        return this.mPasteProcess.getSourcePathIdentifier();
    }

    public void setSourcePathIdentifier(SourcePathIdentifier sourcePathIdentifier) {
        if (sourcePathIdentifier != null) {
            this.mPasteProcess.setSourcePathIdentifier(sourcePathIdentifier);
        }
    }

    public void addToClipboardObjectsHistory(ClipboardObject clipboardObject) {
        if (clipboardObject != null) {
            this.mClipboardObjectsHistory.add(clipboardObject);
        }
    }

    public ClipboardObject[] getClipboardObjectsHistory() {
        return this.mClipboardObjectsHistory.toArray(new ClipboardObject[this.mClipboardObjectsHistory.size()]);
    }

    public void storeMapping(MainDevelopmentObject oldMDO, String newName, String newPackage, IPackageFragmentRoot newRoot) {
        if (newName != null && newPackage != null && newRoot != null) {
            this.getMDOMapper().storeMapping(newName, newRoot, newPackage, oldMDO.getKey());
        }
    }

    public MainDevelopmentObject getOldMDO(MainDevelopmentObject newMDO) {
        return this.getMDOMapper().getOldMDO(newMDO);
    }

    private MainDevelopmentObject checkForLanguageConflicts(MetamodelClipboard clipboard, ClipboardObject[] rootObjects, String newLanguage, int scope) {
        if (scope == 3) {
            int i = 0;
            while (i < rootObjects.length) {
                MainDevelopmentObject originalMdo;
                String originalLanguage;
                ClipboardObject clipboardObject = rootObjects[i];
                DevelopmentObject originalObject = clipboard.getSourceMetamodel().getObjectFromKey(clipboardObject.getOriginalKey());
                if (originalObject != null && originalObject.isMDO() && !newLanguage.equals(originalLanguage = (originalMdo = (MainDevelopmentObject)originalObject).getMasterLanguage())) {
                    return originalMdo;
                }
                MainDevelopmentObject conflictingObject = this.checkForLanguageConflicts(clipboard, clipboardObject.getChildren(), newLanguage, scope);
                if (conflictingObject != null) {
                    return conflictingObject;
                }
                ++i;
            }
        }
        return null;
    }

    private MDOPasteMapper getMDOMapper() {
        if (this.mMapper == null) {
            this.mMapper = new MDOPasteMapper(this.getClipboard().getSourceMetamodel());
        }
        return this.mMapper;
    }

    private void buildResult(boolean succeeded, DevelopmentObject[] newObjects) {
        ArrayList<DevelopmentObject> mdoList = new ArrayList<DevelopmentObject>();
        if (newObjects != null) {
            int i = 0;
            while (i < newObjects.length) {
                DevelopmentObject object = newObjects[i];
                MetamodelIterator iter = object.iterator();
                while (iter.hasNext()) {
                    DevelopmentObject child = iter.next();
                    if (!child.isMDO()) continue;
                    mdoList.add(child);
                }
                ++i;
            }
        }
        MainDevelopmentObject[] mdos = mdoList.toArray(new MainDevelopmentObject[mdoList.size()]);
        this.mPasteResult = new MDOPasteResult(succeeded, mdos);
    }
}

