/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.model;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectFilter;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class ModelSelectionInput
implements IStructuredContentProvider,
ILabelProvider {
    private DevelopmentObjectFilter mFilter = null;

    public ModelSelectionInput(DevelopmentObjectFilter filter) {
        this.mFilter = filter;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof WebDynproRoot) {
            Model[] models = null;
            try {
                models = ((WebDynproRoot)inputElement).getModels();
            }
            catch (LoadException e) {
                ServiceCorePlugin.internalError(this.getClass(), "getElements(Object)", e.getMessage(), e, false);
            }
            Arrays.sort(models, new ModelComparator());
            ArrayList<Model> list = new ArrayList<Model>();
            int i = 0;
            while (i < models.length) {
                if (this.mFilter.isValidObject((DevelopmentObject)models[i])) {
                    list.add(models[i]);
                }
                ++i;
            }
            return list.toArray(new Model[list.size()]);
        }
        return null;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof Model) {
            return ((Model)element).getName();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private class ModelComparator
    implements Comparator {
        private ModelComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Model)o1).getName().compareTo(((Model)o2).getName());
        }
    }
}

