/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core.check.out;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.CheckResultEntry;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TaskListManager {
    public static final String CHECK_MARKER_ID = "com.sap.ide.webdynpro.service.core.checkMarker";
    public static final String MARKER_ATTRIBUTE_MDOBJECT = "mdobject";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager;

    private TaskListManager() {
    }

    public static void showCheckResults(CheckResult checkResult) {
        TaskListManager.deleteRootMarkers();
        ArrayList lCheckedMainDevObjects = checkResult.getCheckedMDOs();
        int i = 0;
        while (i < lCheckedMainDevObjects.size()) {
            TaskListManager.deleteMarkers((MainDevelopmentObject)lCheckedMainDevObjects.get(i));
            ++i;
        }
        ArrayList lCheckResultEntries = checkResult.getEntries();
        int i2 = 0;
        while (i2 < lCheckResultEntries.size()) {
            TaskListManager.createMarker((CheckResultEntry)lCheckResultEntries.get(i2));
            ++i2;
        }
    }

    private static void createMarker(CheckResultEntry checkResultEntry) {
        DevelopmentObject lDevObject = checkResultEntry.getDevelopmentObject();
        MainDevelopmentObject lMainDevObject = null;
        if (lDevObject != null) {
            lMainDevObject = lDevObject.getMDO();
        } else {
            ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager == null ? (class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager = TaskListManager.class$("com.sap.ide.webdynpro.service.core.check.out.TaskListManager")) : class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager, "createMarker()", "Creation of check marker failed. Message: " + checkResultEntry.getMessage(), null, true);
        }
        int lMarkerSeverity = -1;
        switch (checkResultEntry.getKind()) {
            case 0: {
                lMarkerSeverity = 2;
                break;
            }
            case 1: {
                lMarkerSeverity = 1;
                break;
            }
            case 2: {
                lMarkerSeverity = 0;
                break;
            }
            default: {
                lMarkerSeverity = 2;
            }
        }
        String lMarkerText = "";
        if (checkResultEntry.getHideDevelopmentObjectProperties()) {
            lMarkerText = checkResultEntry.getMessage();
        } else {
            String lMetaClassName = lDevObject.getMetaClass().getName();
            lMetaClassName = lMetaClassName.substring(lMetaClassName.lastIndexOf(46) + 1);
            lMarkerText = checkResultEntry.getPropertyName() == null || checkResultEntry.getPropertyName().length() == 0 ? lMarkerText + lMetaClassName + " " + lDevObject.getName() + ": " + checkResultEntry.getMessage() : lMarkerText + lMetaClassName + " " + lDevObject.getName() + " [" + checkResultEntry.getPropertyName() + "]: " + checkResultEntry.getMessage();
        }
        if (checkResultEntry.getRepairHint() != null && checkResultEntry.getRepairHint().length() > 0) {
            lMarkerText = lMarkerText + " (Hint: " + checkResultEntry.getRepairHint() + ")";
        }
        try {
            IMarker lMarker = TaskListManager.mdoToResource(lMainDevObject).createMarker(CHECK_MARKER_ID);
            if (lMarker == null) {
                return;
            }
            lMarker.setAttribute("message", (Object)lMarkerText);
            lMarker.setAttribute("severity", lMarkerSeverity);
            lMarker.setAttribute("location", (Object)"");
            lMarker.setAttribute(MARKER_ATTRIBUTE_MDOBJECT, (Object)lMainDevObject.getKey().toString());
        }
        catch (CoreException ex) {
            ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager == null ? (class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager = TaskListManager.class$("com.sap.ide.webdynpro.service.core.check.out.TaskListManager")) : class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager, "createMarker()", "Creation of check marker failed", ex, true);
        }
    }

    private static void deleteMarkers(MainDevelopmentObject mainDevObject) {
        try {
            TaskListManager.mdoToResource(mainDevObject).deleteMarkers(CHECK_MARKER_ID, false, 0);
        }
        catch (Exception ex) {
            ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager == null ? (class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager = TaskListManager.class$("com.sap.ide.webdynpro.service.core.check.out.TaskListManager")) : class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager, "deleteMarkers()", "Deletion of check marker for " + mainDevObject.getName() + " failed", ex, true);
        }
    }

    private static void deleteRootMarkers() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().deleteMarkers(CHECK_MARKER_ID, false, 0);
        }
        catch (Exception ex) {
            ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager == null ? (class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager = TaskListManager.class$("com.sap.ide.webdynpro.service.core.check.out.TaskListManager")) : class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager, "deleteRootMarkers()", "Deletion of check marker for workspace root failed", ex, true);
        }
    }

    private static IResource mdoToResource(MainDevelopmentObject mainDevObject) {
        IFile lResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(mainDevObject.getAbsolutePath()));
        if (lResource == null || !lResource.exists()) {
            lResource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return lResource;
    }

    public static final boolean hasMarkers() {
        try {
            IMarker[] lMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers(CHECK_MARKER_ID, false, 2);
            if (lMarkers.length > 0) {
                return true;
            }
        }
        catch (Exception ex) {
            ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager == null ? (class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager = TaskListManager.class$("com.sap.ide.webdynpro.service.core.check.out.TaskListManager")) : class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager, "hasMarkers()", "Existence check of markers failed", ex, true);
        }
        return false;
    }

    public static final boolean hasMarkers(IResource resource) {
        if (resource == null) {
            return false;
        }
        try {
            IMarker[] lMarkers = resource.findMarkers(CHECK_MARKER_ID, false, 0);
            if (lMarkers.length > 0) {
                return true;
            }
        }
        catch (Exception ex) {
            ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager == null ? (class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager = TaskListManager.class$("com.sap.ide.webdynpro.service.core.check.out.TaskListManager")) : class$com$sap$ide$webdynpro$service$core$check$out$TaskListManager, "hasMarkers()", "Existence check of markers failed", ex, true);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

