/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core;

import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.wizards.typeselection.TypeSelectionDialog;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class UIHelper {
    private static final String PLUGIN_ID = "com.sap.ide.webdynpro.service.core";
    private static final CoreTextPool mTextPool = CoreTextPool.getInstance();

    public static boolean askUserToDelete(String objectName, String objectType) {
        MessageDialog dialog = UIHelper.createMessageDialogToDecide(mTextPool.getText(400, objectType), mTextPool.getText(401, objectType, objectName), 3, 0);
        return dialog.open() == 0;
    }

    public static int askUserToDeleteAll(String objectName, String objectType) {
        MessageDialog dialog = UIHelper.createMessageDialogToDecideYesAllNo(mTextPool.getText(400, objectType), mTextPool.getText(401, objectType, objectName), 3, 0);
        return dialog.open();
    }

    public static boolean askUserToDeleteObjects() {
        MessageDialog dialog = UIHelper.createMessageDialogToDecide(mTextPool.getText(413), mTextPool.getText(412), 3, 0);
        return dialog.open() == 0;
    }

    public static boolean askUserToDeleteNumberOfObjects(int numberOfObjects) {
        MessageDialog dialog = UIHelper.createMessageDialogToDecide(mTextPool.getText(413), mTextPool.getText(416, Integer.toString(numberOfObjects)), 3, 0);
        return dialog.open() == 0;
    }

    public static boolean askUserToRepair(String objectName, String objectType, String repairInfo) {
        MessageDialog dialog = UIHelper.createMessageDialogToDecide(mTextPool.getText(402, objectType), mTextPool.getText(403, objectType, objectName) + "\n" + repairInfo, 3, 0);
        return dialog.open() == 0;
    }

    public static void informUser(String title, String message) {
        MessageDialog dialog = UIHelper.createMessageDialogToConfirm(title, message, 2);
        dialog.open();
    }

    public static MessageDialog createMessageDialogToDecide(String dialogTitle, String dialogMessage, int dialogImageType, int defaultButtonIndex) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        return ServicesUI.createMessageDialog((String)dialogTitle, (String)dialogMessage, (String[])buttons, (int)dialogImageType, (Image)SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_WEBDYNPRO), (int)defaultButtonIndex);
    }

    public static MessageDialog createMessageDialogToDecideYesAllNo(String dialogTitle, String dialogMessage, int dialogImageType, int defaultButtonIndex) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, mTextPool.getText(164), IDialogConstants.NO_LABEL};
        return ServicesUI.createMessageDialog((String)dialogTitle, (String)dialogMessage, (String[])buttons, (int)dialogImageType, (Image)SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_WEBDYNPRO), (int)defaultButtonIndex);
    }

    private static MessageDialog createMessageDialogToConfirm(String dialogTitle, String dialogMessage, int dialogImageType) {
        String[] buttons = new String[]{IDialogConstants.OK_LABEL};
        return ServicesUI.createMessageDialog((String)dialogTitle, (String)dialogMessage, (String[])buttons, (int)dialogImageType, (Image)SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_WEBDYNPRO), (int)0);
    }

    public static void displayErrorMessage(String title, String message) {
        UIHelper.displayStatusMessage(title, message, 4);
    }

    public static void displayErrorMessage(String message) {
        UIHelper.displayErrorMessage(mTextPool.getText(0), message);
    }

    public static boolean displayWarningMessage(String title, String message) {
        return UIHelper.displayStatusMessage(title, message, 2);
    }

    public static boolean displayStatusMessage(String title, String message, int type) {
        Status status;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ErrorDialog dialog = new ErrorDialog(shell, title, null, (IStatus)(status = new Status(type, PLUGIN_ID, 0, message, (Throwable)new Exception())), type);
        return dialog.open() == 0;
    }

    public static MetamodelServices.CompoundType selectType(DtDictionaryRoot dictionaryRoot, DevelopmentObject initialType) {
        TypeSelectionDialog dialog;
        MetamodelServices.CompoundType returnValue = null;
        if (dictionaryRoot != null && (dialog = new TypeSelectionDialog(dictionaryRoot, initialType)).open() == 0) {
            returnValue = dialog.isSimpleTypeSelection() ? new MetamodelServices.CompoundType(dialog.getSimpleType()) : new MetamodelServices.CompoundType(dialog.getQualifiedJavaNativeTypeName());
        }
        return returnValue;
    }

    private static boolean containsJavaElement(ArrayList list, IJavaElement element) {
        Iterator iterator = ((AbstractList)list).iterator();
        boolean result = false;
        while (iterator.hasNext()) {
            IJavaElement existingElement = (IJavaElement)iterator.next();
            if (!element.getElementName().equals(existingElement.getElementName())) continue;
            return true;
        }
        return false;
    }

    private static class PackageSelectionValidator
    implements ISelectionStatusValidator {
        private PackageSelectionValidator() {
        }

        public IStatus validate(Object[] selection) {
            int severity = 0;
            String message = "";
            int i = 0;
            while (i < selection.length) {
                PackageFragment fragment;
                if (selection[i] instanceof PackageFragment && (fragment = (PackageFragment)selection[i]).getElementName().endsWith(".wdp")) {
                    severity = 4;
                    message = mTextPool.getText(38, fragment.getElementName());
                    break;
                }
                ++i;
            }
            return new Status(severity, UIHelper.PLUGIN_ID, 0, message, null);
        }
    }
}

