/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core;

import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MessageDialogWithCheckBoxes
extends MessageDialog {
    private String[] mQuestions = null;
    private boolean[] mQuestionsDefaultValues = null;
    private Button[] mButtons = null;
    private boolean[] mAnswers = null;

    public MessageDialogWithCheckBoxes(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String[] questions, boolean[] questionsDefaultValues) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.mQuestions = questions;
        this.mQuestionsDefaultValues = questionsDefaultValues;
        this.mButtons = new Button[this.mQuestions.length];
        this.mAnswers = new boolean[this.mQuestions.length];
        int i = 0;
        while (i < this.mAnswers.length) {
            this.mAnswers[i] = this.mQuestionsDefaultValues[i];
            ++i;
        }
    }

    protected Control createCustomArea(Composite parent) {
        IGridLayoutPane pane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        CheckBoxSelectionListener listener = new CheckBoxSelectionListener();
        int i = 0;
        while (i < this.mQuestions.length) {
            IGridLayoutData gd = pane.createGridLayoutData(4, 1, true, false);
            this.mButtons[i] = pane.addCheckBox(this.mQuestions[i], false, gd);
            this.mButtons[i].setSelection(this.mQuestionsDefaultValues[i]);
            this.mButtons[i].addSelectionListener((SelectionListener)listener);
            ++i;
        }
        return super.createCustomArea(parent);
    }

    public boolean[] getAnswers() {
        return this.mAnswers;
    }

    private class CheckBoxSelectionListener
    implements SelectionListener {
        private CheckBoxSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                Button button = (Button)e.widget;
                int i = 0;
                while (i < MessageDialogWithCheckBoxes.this.mButtons.length) {
                    if (button.equals(MessageDialogWithCheckBoxes.this.mButtons[i])) {
                        ((MessageDialogWithCheckBoxes)MessageDialogWithCheckBoxes.this).mAnswers[i] = MessageDialogWithCheckBoxes.this.mButtons[i].getSelection();
                        return;
                    }
                    ++i;
                }
            }
        }
    }
}

