/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.IllegalNamingException;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.swt.widgets.Text;

public class CheckServices {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();

    private CheckServices() {
    }

    public static final boolean isValidIdentifier(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_') {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final boolean isValidIdentifier(String s, String alsoValid) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_') {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c) || alsoValid.indexOf(c) != -1)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String isSourcePathValid(IPackageFragmentRoot root) {
        if (root == null) {
            return mCoreTextPool.getText(28);
        }
        return null;
    }

    public static boolean isValidMDO(MainDevelopmentObject mdo) {
        if (mdo == null) {
            return false;
        }
        DevelopmentObject parentObject = mdo.getParent();
        return parentObject.getRoot().getMetamodel().objectExists(mdo.getPackage(), mdo.getName(), mdo.getKey().getMDOType());
    }

    public static IStatus isValidPackage(String packageName) {
        String pluginID = ServiceCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
        IStatus javaStatus = JavaConventions.validatePackageName((String)packageName);
        if (!javaStatus.isOK()) {
            return javaStatus;
        }
        try {
            Metamodel.getNamingService().checkMainDevelopmentObjectPackage(packageName);
        }
        catch (IllegalNamingException e) {
            return new Status(4, pluginID, -1, e.getMessage(), (Throwable)e);
        }
        if (packageName.indexOf(" ") != -1) {
            return new Status(4, pluginID, -1, mCoreTextPool.getText(32), null);
        }
        if (packageName.length() >= 60) {
            return new Status(2, ServiceCorePlugin.getDefault().getDescriptor().getUniqueIdentifier(), 2, TextPool.getInstance().getText(445), null);
        }
        return new Status(0, pluginID, 0, "", null);
    }

    public static IStatus isValidSourcePath(IPackageFragmentRoot packageFragmentRoot) {
        String pluginID = ServiceCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
        if (packageFragmentRoot == null) {
            return new Status(4, pluginID, -1, mCoreTextPool.getText(28), null);
        }
        if (!packageFragmentRoot.exists()) {
            return new Status(4, pluginID, -1, mCoreTextPool.getText(42), null);
        }
        return new Status(0, pluginID, 0, "", null);
    }

    public static String checkFirstCharacter(Text textField) {
        char firstChar;
        String nameInput = textField.getText();
        if (textField.getCaretPosition() == 1 && !Character.isUpperCase(firstChar = nameInput.charAt(0))) {
            char upperChar = Character.toUpperCase(firstChar);
            char[] chars = nameInput.toCharArray();
            chars[0] = upperChar;
            nameInput = new String(chars);
            textField.setText(nameInput);
            textField.setSelection(1, 1);
        }
        return nameInput;
    }

    public static String convertToLowerCase(Text textField) {
        String packageInput = textField.getText();
        boolean upperCaseExists = false;
        char[] chars = packageInput.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Character.isUpperCase(chars[i])) {
                upperCaseExists = true;
                break;
            }
            ++i;
        }
        if (!upperCaseExists) {
            return packageInput;
        }
        if (packageInput.length() > 0 && textField.getCaretPosition() == packageInput.length()) {
            packageInput = packageInput.toLowerCase();
            textField.setText(packageInput);
            textField.setSelection(packageInput.length(), packageInput.length());
        }
        return packageInput;
    }

    public static IStatus isValidMDOPath(Metamodel metamodel, MDOEnum mDOEnum, String mdoName, String mdoPackage, SourcePathIdentifier identifier) {
        String pluginID = ServiceCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
        try {
            boolean valid = Metamodel.getNamingService().isValidMainDevelopmentObjectPath(metamodel, mdoName, mdoPackage, mDOEnum, identifier);
            if (!valid) {
                String pathInvalid = mCoreTextPool.getText(43);
                return new Status(4, pluginID, 4, pathInvalid, null);
            }
        }
        catch (IllegalNamingException e) {
            String exception = mCoreTextPool.getText(44);
            return new Status(4, pluginID, 4, exception, (Throwable)e);
        }
        return new Status(0, pluginID, 0, "", null);
    }
}

