/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.core;

import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class BrowseHelper {
    private static final CoreTextPool mTextPool = CoreTextPool.getInstance();
    public static final String EXTENSION_COMPONENT = ".wdcomponent";
    private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$core$BrowseHelper;

    public static File[] getAllWebDynproComponentFilesInWorkspace() {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            files = BrowseHelper.getAllWebDynproComponentFilesInProject(projects[i]);
            int j = 0;
            while (j < files.length) {
                list.add(files[j]);
                ++j;
            }
            ++i;
        }
        files = new File[list.size()];
        return list.toArray(files);
    }

    public static File[] getAllWebDynproComponentFilesInProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return BrowseHelper.getAllWebDynproComponentFilesInProject(project);
    }

    public static File[] getAllWebDynproComponentFilesInProject(IProject project) {
        IProjectNature nature = null;
        IJavaProject javaProject = null;
        try {
            nature = project.getNature(JAVA_NATURE);
            if (nature instanceof IJavaProject) {
                javaProject = (IJavaProject)nature;
            }
        }
        catch (CoreException e) {
            ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$BrowseHelper == null ? (class$com$sap$ide$webdynpro$service$core$BrowseHelper = BrowseHelper.class$("com.sap.ide.webdynpro.service.core.BrowseHelper")) : class$com$sap$ide$webdynpro$service$core$BrowseHelper, "getAllWebDynproComponentFilesInProject(IProject)", e.getMessage(), e, true);
            return new File[0];
        }
        IClasspathEntry[] classpaths = null;
        try {
            classpaths = javaProject.getResolvedClasspath(false);
        }
        catch (JavaModelException e) {
            ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$BrowseHelper == null ? (class$com$sap$ide$webdynpro$service$core$BrowseHelper = BrowseHelper.class$("com.sap.ide.webdynpro.service.core.BrowseHelper")) : class$com$sap$ide$webdynpro$service$core$BrowseHelper, "getAllWebDynproComponentFilesInProject(IProject)", e.getMessage(), e, true);
            return new File[0];
        }
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < classpaths.length) {
            String folderName;
            File folder;
            if (classpaths[i].getEntryKind() == 3 && !(folder = new File(folderName = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString() + classpaths[i].getPath().toString())).isFile()) {
                BrowseHelper.addAllWebDynproComponentFilesInFolder(folder, list);
            }
            ++i;
        }
        File[] files = new File[list.size()];
        return list.toArray(files);
    }

    public static String getOutputLocation(IProject project) throws CoreException {
        IProjectNature nature = project.getNature(JAVA_NATURE);
        if (nature instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)nature;
            IPath outputLocation = javaProject.getOutputLocation();
            if (outputLocation.segmentCount() > 0) {
                outputLocation = outputLocation.removeFirstSegments(1);
            }
            if ((outputLocation = project.getFolder(outputLocation).getLocation()) != null && outputLocation.toFile().exists()) {
                return outputLocation.toOSString();
            }
        }
        return null;
    }

    public static IFolder getPrimarySrcFolder(IProject project) {
        IFolder folder = project.getFolder("src");
        return folder;
    }

    private static void addAllWebDynproComponentFilesInFolder(File folder, ArrayList list) {
        File[] children = folder.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isFile() && children[i].getName().endsWith(EXTENSION_COMPONENT)) {
                    list.add(children[i]);
                } else if (children[i].isDirectory()) {
                    BrowseHelper.addAllWebDynproComponentFilesInFolder(children[i], list);
                }
                ++i;
            }
        }
    }

    public static String getPackageName(IResource resource, IJavaProject lJavaProject) throws JavaModelException {
        IPackageFragment lPackageFragment = lJavaProject.findPackageFragment(resource.getParent().getFullPath());
        if (lPackageFragment == null) {
            return "";
        }
        String lPackage = lPackageFragment.getElementName();
        if (lPackage == null) {
            return "";
        }
        return lPackage;
    }

    public static void ensureFolderExists(IResource resource) {
        if (resource instanceof IFile) {
            resource = resource.getParent();
        }
        if (resource.exists()) {
            return;
        }
        BrowseHelper.ensureFolderExists((IResource)resource.getParent());
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                ServiceCorePlugin.internalError(class$com$sap$ide$webdynpro$service$core$BrowseHelper == null ? (class$com$sap$ide$webdynpro$service$core$BrowseHelper = BrowseHelper.class$("com.sap.ide.webdynpro.service.core.BrowseHelper")) : class$com$sap$ide$webdynpro$service$core$BrowseHelper, "ensureFolderExists(IResource)", e.getMessage(), e, false);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

