/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg.tools.java.client;

import com.sap.util.monitor.grmg.tools.runtime.RuntimeArguments;
import com.sap.util.monitor.grmg.tools.xml.DocumentNavigator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Document;
import sun.misc.BASE64Encoder;

public class URLConnector {
    static Properties props = new Properties();
    static /* synthetic */ Class class$java$net$HttpURLConnection;

    public static void main(String[] args) {
        int j = 0;
        boolean getFlag = false;
        String user = "x";
        String password = "x";
        String protocol = "http";
        String fullurl = "";
        int count = 0;
        RuntimeArguments rta = new RuntimeArguments(args);
        try {
            String type;
            String iViewName;
            String servletName;
            String port;
            String server;
            String xmlfile = rta.getProperty("file");
            if (xmlfile == null) {
                xmlfile = "grmgRequest.xml";
            }
            if ((server = rta.getProperty("server")) == null) {
                server = "10.20.18.95";
            }
            if ((fullurl = rta.getProperty("fullurl")) == null) {
                fullurl = "http://localhost";
            }
            if (rta.getProperty("ssl") != null) {
                protocol = "https";
            }
            if ((port = rta.getProperty("port")) == null) {
                port = "8090";
            }
            if ((servletName = rta.getProperty("servlet")) == null) {
                servletName = "ScenarioServlet";
            }
            if ((iViewName = rta.getProperty("iview")) == null) {
                iViewName = "TestParProject";
            }
            if (rta.containsPureArgument("get")) {
                getFlag = true;
            }
            String servlet = (type = rta.getProperty("type")) == null ? ((user = rta.getProperty("user")) != null && (password = rta.getProperty("password")) != null ? "irj/servlet/prt/portal/prtroot/" + iViewName + "?j_user=" + user + "&j_password=" + password + "&login_submit=off" : "heartbeat/servlet/" + servletName) : "irj/servlet/prt/portal/prtroot/" + iViewName + "." + type;
            String userPassword = user + ":" + password;
            String encodedUser = new BASE64Encoder().encode(userPassword.getBytes());
            URL ur = !getFlag && fullurl.equals("http://localhost") ? new URL(protocol + "://" + server + ":" + port + "/" + servlet) : new URL(fullurl);
            URLConnection hurlconn = ur.openConnection();
            if (hurlconn instanceof HttpURLConnection) {
                ((HttpURLConnection)hurlconn).setDoOutput(true);
                ((HttpURLConnection)hurlconn).setDoInput(true);
                ((HttpURLConnection)hurlconn).setRequestProperty("Content-Type", "text/html");
                ((HttpURLConnection)hurlconn).setRequestProperty("Authorization", "Basic " + encodedUser);
                System.out.print("Start getting connection (" + (getFlag ? "GET " : "POST ") + "request)\n");
                if (getFlag) {
                    ((HttpURLConnection)hurlconn).setRequestMethod("GET");
                } else {
                    ((HttpURLConnection)hurlconn).setRequestMethod("POST");
                    File file = new File(xmlfile);
                    System.out.println("to " + ur);
                    System.out.println("\nRequest containing file " + file + " :\n");
                    FileInputStream fis = new FileInputStream(file.getAbsolutePath());
                    while (fis.read() != -1) {
                        ++j;
                    }
                    fis.close();
                    fis = new FileInputStream(file.getAbsolutePath());
                    byte[] barray = new byte[j];
                    fis.read(barray);
                    fis.close();
                    OutputStream out = hurlconn.getOutputStream();
                    int i = 0;
                    while (i < barray.length) {
                        System.out.print((char)barray[i]);
                        out.write(barray[i]);
                        ++i;
                    }
                    out.close();
                }
                System.out.println("\nwaiting for HTTP response ...\n");
                try {
                    int t;
                    System.out.println("Response data:\n");
                    if (System.getProperty("java.version").startsWith("1.4")) {
                        Method getHeaderFields = (class$java$net$HttpURLConnection == null ? (class$java$net$HttpURLConnection = URLConnector.class$("java.net.HttpURLConnection")) : class$java$net$HttpURLConnection).getMethod("getHeaderFields", null);
                        Map headers = (Map)getHeaderFields.invoke((Object)((HttpURLConnection)hurlconn), null);
                        Set keys = headers.keySet();
                        Iterator itkeys = keys.iterator();
                        while (itkeys.hasNext()) {
                            Object keyloc = itkeys.next();
                            System.out.println((Object)(keyloc != null ? "Header: " + keyloc + " | Value: " + headers.get(keyloc) : headers.get(keyloc)));
                        }
                    } else if (System.getProperty("java.version").startsWith("1.3")) {
                        int i = 0;
                        while (i < 100) {
                            String hfieldkey;
                            String hfield = ((URLConnection)((HttpURLConnection)hurlconn)).getHeaderField(i);
                            if (hfield != null | (hfieldkey = ((URLConnection)((HttpURLConnection)hurlconn)).getHeaderFieldKey(i)) != null) {
                                System.out.println(hfieldkey != null ? "Header: " + hfieldkey + " | Value: " + hfield : hfield);
                            }
                            ++i;
                        }
                    }
                    System.out.println("\nContent-Encoding: " + hurlconn.getContentEncoding());
                    System.out.println("URL: " + ur.toString().trim() + "\n");
                    System.out.println("Content of response:\n");
                    InputStream is = hurlconn.getInputStream();
                    while ((t = is.read()) != -1) {
                        System.out.print((char)t);
                        ++count;
                    }
                }
                catch (Exception e) {
                    System.out.println("\nTransmission error: \n");
                    e.printStackTrace();
                }
            }
            System.out.println("\n\nEnd of monitoring. Response content size: " + URLConnector.getSizeAndUnit(count, 3));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printOut(String strg, ByteArrayOutputStream out) {
        byte[] barray = strg.getBytes();
        int i = 0;
        while (i < barray.length) {
            out.write(barray[i]);
            ++i;
        }
    }

    public void printOut(char chr, ByteArrayOutputStream out) {
        out.write(chr);
    }

    public void printlnOut(String strg, ByteArrayOutputStream out) {
        String strgnl = strg + "\n";
        this.printOut(strgnl, out);
    }

    public ByteArrayOutputStream getResponseData(Document scenarioDoc, String fullurl) {
        String userPwd = "";
        String encodedUser = "";
        boolean baseEncoding = false;
        int count = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if ((fullurl = fullurl.trim()).startsWith("http://")) {
            try {
                userPwd = fullurl.substring(7).substring(0, fullurl.substring(7).indexOf(64));
                baseEncoding = true;
            }
            catch (Exception e) {
                userPwd = "";
            }
        }
        if (fullurl.startsWith("https://")) {
            try {
                userPwd = fullurl.substring(8).substring(0, fullurl.substring(8).indexOf(64));
                baseEncoding = true;
            }
            catch (Exception e) {
                userPwd = "";
            }
        }
        if (baseEncoding && !userPwd.equals("")) {
            if (userPwd.indexOf(58) == -1 || userPwd.indexOf(58) == userPwd.length() - 1 || userPwd.indexOf(58) == 0) {
                this.printlnOut("Syntax error: " + userPwd, bout);
                this.printlnOut("<user>:<password> expected in tag scenstarturl!", bout);
                return bout;
            }
            encodedUser = new BASE64Encoder().encode(userPwd.getBytes());
        }
        try {
            URL ur = new URL(fullurl);
            URLConnection hurlconn = ur.openConnection();
            if (hurlconn instanceof HttpURLConnection) {
                int t;
                ((HttpURLConnection)hurlconn).setDoOutput(true);
                ((HttpURLConnection)hurlconn).setDoInput(true);
                ((HttpURLConnection)hurlconn).setRequestProperty("Content-Type", "text/html");
                if (baseEncoding && !userPwd.equals("")) {
                    ((HttpURLConnection)hurlconn).setRequestProperty("Authorization", "Basic " + encodedUser);
                }
                ((HttpURLConnection)hurlconn).setRequestMethod("POST");
                this.printlnOut("Start getting connection (POST request) to", bout);
                this.printlnOut(ur.toString(), bout);
                if (baseEncoding && !userPwd.equals("")) {
                    this.printlnOut("using basic authentication for " + userPwd, bout);
                }
                DocumentNavigator docnav = new DocumentNavigator(scenarioDoc);
                ByteArrayOutputStream docBOs = docnav.getDocumentAsOutputStream();
                OutputStream out = hurlconn.getOutputStream();
                docBOs.writeTo(out);
                out.close();
                this.printlnOut("\nResponse data:\n", bout);
                if (System.getProperty("java.version").startsWith("1.4")) {
                    Method getHeaderFields = (class$java$net$HttpURLConnection == null ? (class$java$net$HttpURLConnection = URLConnector.class$("java.net.HttpURLConnection")) : class$java$net$HttpURLConnection).getMethod("getHeaderFields", null);
                    Map headers = (Map)getHeaderFields.invoke((Object)((HttpURLConnection)hurlconn), null);
                    Set keys = headers.keySet();
                    Iterator itkeys = keys.iterator();
                    while (itkeys.hasNext()) {
                        Object keyloc = itkeys.next();
                        String header1 = keyloc != null ? "Header: " + keyloc + " | Value: " + headers.get(keyloc).toString() : headers.get(keyloc).toString();
                        this.printlnOut(header1, bout);
                    }
                } else if (System.getProperty("java.version").startsWith("1.3")) {
                    int i = 0;
                    while (i < 100) {
                        String hfieldkey;
                        String hfield = ((URLConnection)((HttpURLConnection)hurlconn)).getHeaderField(i);
                        if (hfield != null | (hfieldkey = ((URLConnection)((HttpURLConnection)hurlconn)).getHeaderFieldKey(i)) != null) {
                            String header2 = hfieldkey != null ? "Header: " + hfieldkey + " | Value: " + hfield : hfield;
                            this.printlnOut(header2, bout);
                        }
                        ++i;
                    }
                }
                this.printlnOut("\nContent-Encoding: " + hurlconn.getContentEncoding(), bout);
                this.printlnOut("URL: " + ur.toString() + "\n", bout);
                this.printlnOut("Content of response:\n", bout);
                InputStream is = hurlconn.getInputStream();
                while ((t = is.read()) != -1) {
                    this.printOut((char)t, bout);
                    ++count;
                }
            }
            this.printlnOut("\n\nEnd of monitoring. GRMG response content size: " + URLConnector.getSizeAndUnit(count, 3), bout);
        }
        catch (MalformedURLException e) {
            this.printlnOut("ERROR: MalformedURLException " + e.toString(), bout);
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            this.printlnOut("ERROR: ProtocolException " + e.toString(), bout);
            e.printStackTrace();
        }
        catch (IOException e) {
            this.printlnOut("ERROR: IOException " + e.toString(), bout);
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            this.printlnOut("ERROR: NoSuchMethodException " + e.toString(), bout);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            this.printlnOut("ERROR: InvocationTargetException " + e.toString(), bout);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            this.printlnOut("ERROR: IllegalAccessException " + e.toString(), bout);
            e.printStackTrace();
        }
        return bout;
    }

    static void setProperties(String[] arg) {
        int j = 0;
        while (j < arg.length) {
            props.setProperty(arg[j].substring(0, arg[j].indexOf(61)), arg[j].substring(arg[j].indexOf(61) + 1));
            ++j;
        }
    }

    public static String getSizeAndUnit(int size, int digits) {
        String unit = "";
        int helpcount = 0;
        String countString = "";
        double unitcount = 0.0;
        int digitpower = (int)Math.pow(10.0, digits);
        if (size < 1024) {
            countString = new Integer(size).toString();
            unit = size == 1 ? " byte" : " bytes";
        } else if (size < 0x100000) {
            unitcount = (double)size / 1024.0;
            helpcount = (int)((double)digitpower * unitcount);
            unitcount = (double)helpcount / (double)digitpower;
            countString = new Double(unitcount).toString();
            unit = " kB";
        } else if (size < 0x40000000) {
            unitcount = (double)size / 1048576.0;
            helpcount = (int)((double)digitpower * unitcount);
            unitcount = (double)helpcount / (double)digitpower;
            countString = new Double(unitcount).toString();
            unit = " MB";
        } else {
            unitcount = (double)size / 1.073741824E9;
            helpcount = (int)((double)digitpower * unitcount);
            unitcount = (double)helpcount / (double)digitpower;
            countString = new Double(unitcount).toString();
            unit = " GB";
        }
        return countString + unit;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

