/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg;

import com.sap.util.monitor.grmg.GrmgCustomizing;
import com.sap.util.monitor.grmg.GrmgCustomizingXmlGenerator;
import com.sap.util.monitor.grmg.GrmgScenario;
import com.sap.util.monitor.grmg.GrmgText;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GrmgXMLFile {
    private Document m_document;
    private String lineEnd = System.getProperty("line.separator");

    public GrmgXMLFile() throws ParserConfigurationException, SAXException {
        GrmgCustomizing cust = new GrmgCustomizing();
        cust.setGrmgRunsFlag(true);
        GrmgScenario scen = new GrmgScenario();
        scen.setName("Default");
        scen.setVersion("1");
        scen.setInstance("1");
        scen.setStartUrl("http://localhost");
        GrmgText text = new GrmgText();
        text.setLanguage("E");
        text.setDescription("default scenario");
        scen.setText(text);
        cust.addScenario(scen);
        this.m_document = GrmgCustomizingXmlGenerator.buildDocument(cust);
    }

    public GrmgXMLFile(File baseFile) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.m_document = builder.parse(baseFile);
    }

    public GrmgXMLFile(Document document) {
        this.m_document = document;
    }

    public GrmgXMLFile(InputStream instream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.m_document = builder.parse(instream);
    }

    public void addComponents(InputStream instream) throws ParserConfigurationException, IOException, SAXException {
        this.addComponents(instream, null);
    }

    public void addComponents(InputStream instream, String scenName) throws ParserConfigurationException, IOException, SAXException {
        Element scenNode = null;
        Element baseElementDoc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document extdocument = builder.parse(instream);
        if (scenName != null) {
            NodeList scenList = this.m_document.getElementsByTagName("scenario");
            int k = 0;
            while (k < scenList.getLength()) {
                if (scenList.item(k).getChildNodes().item(1).getFirstChild().getNodeValue().equals(scenName)) {
                    scenNode = (Element)scenList.item(k);
                    break;
                }
                ++k;
            }
            if (scenNode != null) {
                baseElementDoc = (Element)scenNode.getElementsByTagName("components").item(0);
            }
        } else {
            baseElementDoc = (Element)this.m_document.getElementsByTagName("components").item(0);
        }
        NodeList nextdoclst = extdocument.getElementsByTagName("component");
        int j = 0;
        while (j < nextdoclst.getLength()) {
            if (baseElementDoc != null) {
                Element childElementExt = (Element)nextdoclst.item(j);
                Element childImpDoc = (Element)this.m_document.importNode(childElementExt, true);
                baseElementDoc.appendChild(childImpDoc);
            }
            ++j;
        }
    }

    public void addComponent(Element component, String scenName) throws ParserConfigurationException, IOException, SAXException {
        Element scenNode = null;
        Element baseElement = null;
        if (scenName != null) {
            NodeList scenList = this.m_document.getElementsByTagName("scenario");
            int k = 0;
            while (k < scenList.getLength()) {
                if (scenList.item(k).getChildNodes().item(1).getFirstChild().getNodeValue().equals(scenName)) {
                    scenNode = (Element)scenList.item(k);
                    break;
                }
                ++k;
            }
            if (scenNode != null) {
                baseElement = (Element)scenNode.getElementsByTagName("components").item(0);
            }
        } else {
            baseElement = (Element)this.m_document.getElementsByTagName("components").item(0);
        }
        if (component.getNodeName().equalsIgnoreCase("component") && baseElement != null) {
            Element childImpDoc = (Element)this.m_document.importNode(component, true);
            baseElement.appendChild(childImpDoc);
        }
    }

    public void addComponent(Element component) throws ParserConfigurationException, IOException, SAXException {
        this.addComponent(component, null);
    }

    public void addUniqueComponent(Element component, String scenName) throws ParserConfigurationException, IOException, SAXException {
        NodeList allBaseComponents = this.getComponentNodes(scenName);
        NodeList compNameNodes = component.getElementsByTagName("compname");
        if (compNameNodes.getLength() != 1) {
            return;
        }
        String nameOfComponent = compNameNodes.item(0).getFirstChild().getNodeValue();
        if (allBaseComponents.getLength() == 0) {
            this.addComponent(component, scenName);
            return;
        }
        int j = 0;
        if (j < allBaseComponents.getLength()) {
            NodeList allCompNameNodes = ((Element)allBaseComponents.item(j)).getElementsByTagName("compname");
            if (allCompNameNodes.getLength() != 1 || allCompNameNodes.item(0).getFirstChild().getNodeValue().equals(nameOfComponent)) {
                return;
            }
            this.addComponent(component, scenName);
            return;
        }
    }

    public void addUniqueComponent(Element component) throws ParserConfigurationException, IOException, SAXException {
        this.addUniqueComponent(component, null);
    }

    public NodeList getComponentNodes() {
        return this.getComponentNodes(null);
    }

    public NodeList getComponentNodes(String scenName) {
        Element scenNode = null;
        if (scenName != null) {
            NodeList scenList = this.m_document.getElementsByTagName("scenario");
            int k = 0;
            while (k < scenList.getLength()) {
                if (scenList.item(k).getChildNodes().item(1).getFirstChild().getNodeValue().equals(scenName)) {
                    scenNode = (Element)scenList.item(k);
                    break;
                }
                ++k;
            }
            if (scenNode != null) {
                return scenNode.getElementsByTagName("components");
            }
            return null;
        }
        return this.m_document.getElementsByTagName("components");
    }

    public Document getDocument() {
        return this.m_document;
    }

    public InputStream getDocumentAsStream() {
        ByteArrayOutputStream output = this.getDocumentAsOutputStream();
        PipedOutputStream pout = new PipedOutputStream();
        try {
            output.writeTo(pout);
            PipedInputStream pin = new PipedInputStream(pout);
            return pin;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ByteArrayOutputStream getDocumentAsOutputStream() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.m_document);
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            this.println(output, tce.getMessage());
        }
        catch (TransformerException te) {
            this.println(output, te.getMessage());
        }
        return output;
    }

    public void createCustomizingFile(File custFile) {
        ByteArrayOutputStream output = this.getDocumentAsOutputStream();
        try {
            output.writeTo(new FileOutputStream(custFile));
            output.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void println(ByteArrayOutputStream output, String line) {
        output.write(line.getBytes(), 0, line.length());
        output.write(this.lineEnd.getBytes(), 0, this.lineEnd.length());
    }

    public void setScenarioName(String scenOldName, String scenNewName) {
        boolean test = false;
        NodeList allScens = this.m_document.getElementsByTagName("scenname");
        int j = 0;
        while (j < allScens.getLength()) {
            test = scenOldName == null ? true : allScens.item(j).getFirstChild().getNodeValue().equals(scenOldName);
            if (test) {
                allScens.item(j).getFirstChild().setNodeValue(scenNewName);
                this.m_document.importNode(allScens.item(j), true);
            }
            ++j;
        }
    }

    public void setScenarioName(String scenName) {
        this.setScenarioName(null, scenName);
    }

    public void setScenarioVersion(String scenName, String scenversion) {
        boolean test = false;
        NodeList allScenVersions = this.m_document.getElementsByTagName("scenversion");
        int j = 0;
        while (j < allScenVersions.getLength()) {
            test = scenName == null ? true : this.getNodeByName(allScenVersions.item(j).getParentNode().getChildNodes(), "scenname").getFirstChild().getNodeValue().equals(scenName);
            if (test) {
                allScenVersions.item(j).getFirstChild().setNodeValue(scenversion);
                this.m_document.importNode(allScenVersions.item(j), true);
            }
            ++j;
        }
    }

    public void setScenarioVersion(String scenversion) {
        this.setScenarioVersion(null, scenversion);
    }

    public void setScenarioInstance(String scenName, String sceninst) {
        boolean test = false;
        NodeList allScenInsts = this.m_document.getElementsByTagName("sceninst");
        int j = 0;
        while (j < allScenInsts.getLength()) {
            test = scenName == null ? true : this.getNodeByName(allScenInsts.item(j).getParentNode().getChildNodes(), "scenname").getFirstChild().getNodeValue().equals(scenName);
            if (test) {
                allScenInsts.item(j).getFirstChild().setNodeValue(sceninst);
                this.m_document.importNode(allScenInsts.item(j), true);
            }
            ++j;
        }
    }

    public void setScenarioInstance(String sceninst) {
        this.setScenarioInstance(null, sceninst);
    }

    public void setScenarioStartUrl(String scenName, String scenstarturl) {
        boolean test = false;
        NodeList allScenUrls = this.m_document.getElementsByTagName("scenstarturl");
        int j = 0;
        while (j < allScenUrls.getLength()) {
            test = scenName == null ? true : this.getNodeByName(allScenUrls.item(j).getParentNode().getChildNodes(), "scenname").getFirstChild().getNodeValue().equals(scenName);
            if (test) {
                allScenUrls.item(j).getFirstChild().setNodeValue(scenstarturl);
                this.m_document.importNode(allScenUrls.item(j), true);
            }
            ++j;
        }
    }

    public void setScenarioStartUrl(String scenstarturl) {
        this.setScenarioStartUrl(null, scenstarturl);
    }

    public void setScenarioStartMode(String scenName, String scenstartmod) {
        boolean test = false;
        NodeList allScenMods = this.m_document.getElementsByTagName("scenstartmod");
        int j = 0;
        while (j < allScenMods.getLength()) {
            test = scenName == null ? true : this.getNodeByName(allScenMods.item(j).getParentNode().getChildNodes(), "scenname").getFirstChild().getNodeValue().equals(scenName);
            if (test) {
                allScenMods.item(j).getFirstChild().setNodeValue(scenstartmod);
                this.m_document.importNode(allScenMods.item(j), true);
            }
            ++j;
        }
    }

    public void setScenarioStartMode(String scenstartmod) {
        this.setScenarioStartMode(null, scenstartmod);
    }

    private Node getNodeByName(NodeList nlist, String nodename) {
        int j = 0;
        while (j < nlist.getLength()) {
            if (nlist.item(j).getNodeName().equals(nodename)) {
                return nlist.item(j);
            }
            ++j;
        }
        return null;
    }
}

