/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg;

import com.sap.util.monitor.grmg.GrmgRequestException;
import com.sap.util.monitor.grmg.GrmgScenario;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GrmgResponse {
    private GrmgScenario gs;
    private ByteArrayOutputStream output;
    private boolean isCompatibilityMode = false;
    private String lineEnd = System.getProperty("line.separator");

    public GrmgScenario getScenario() {
        return this.gs;
    }

    public GrmgResponse() {
        this.output = new ByteArrayOutputStream();
        this.gs = new GrmgScenario();
    }

    public GrmgResponse(GrmgScenario gs) {
        this.output = new ByteArrayOutputStream();
        this.gs = gs;
    }

    public ByteArrayOutputStream getOutput() {
        if (!this.isCompatibilityMode) {
            return this.getOutputWithDom();
        }
        return this.getOutputWithStringConcatenation();
    }

    public void setCompatibilityMode(boolean isCompatible) {
        this.isCompatibilityMode = isCompatible;
    }

    public boolean getCompatibilityMode() {
        return this.isCompatibilityMode;
    }

    private ByteArrayOutputStream getOutputWithDom() {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.getResponseAsDom());
            StreamResult result = new StreamResult(this.output);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            this.println(tce.getMessage());
        }
        catch (TransformerException te) {
            this.println(te.getMessage());
        }
        catch (GrmgRequestException e) {
            this.println(e.getMessage());
        }
        return this.output;
    }

    private ByteArrayOutputStream getOutputWithStringConcatenation() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.println("<scenario>");
        this.println("<scenname>");
        this.println(this.gs.getName());
        this.println("</scenname>");
        this.println("<sceninst>");
        this.println(this.gs.getInstance());
        this.println("</sceninst>");
        this.println("<scenversion>");
        this.println(this.gs.getVersion());
        this.println("</scenversion>");
        if (this.gs.getNumberOfComponents() > 0) {
            int i = 0;
            while (i < this.gs.getNumberOfComponents()) {
                this.println("<component>");
                this.println("<compname>" + this.gs.getComponent(i).getName() + "</compname>");
                this.println("<compversion>" + this.gs.getComponent(i).getVersion() + "</compversion>");
                this.println("<comphost>" + this.gs.getComponent(i).getHost() + "</comphost>");
                this.println("<compinst>" + this.gs.getComponent(i).getInst() + "</compinst>");
                this.println("<messages>");
                int j = 0;
                while (j < this.gs.getComponent(i).getNumberOfMessages()) {
                    this.println("<message>");
                    String[] st = this.gs.getComponent(i).getMessage(j).getMessageParameters();
                    if (st != null) {
                        this.println("<messalert>" + st[0] + "</messalert>");
                        this.println("<messseverity>" + st[1] + "</messseverity>");
                        this.println("<messarea>" + st[2] + "</messarea>");
                        this.println("<messnumber>" + st[3] + "</messnumber>");
                        this.println("<messparam1>" + st[4] + "</messparam1>");
                        this.println("<messparam2>" + st[5] + "</messparam2>");
                        this.println("<messparam3>" + st[6] + "</messparam3>");
                        this.println("<messparam4>" + st[7] + "</messparam4>");
                        this.println("<messtext>" + st[8] + "</messtext>");
                    }
                    this.println("</message>");
                    ++j;
                }
                this.println("</messages>");
                this.println("</component>");
                ++i;
            }
        }
        this.println("</scenario>");
        return this.output;
    }

    private void println(String s) {
        this.output.write(s.getBytes(), 0, s.length());
        this.output.write(this.lineEnd.getBytes(), 0, this.lineEnd.length());
    }

    Document getResponseAsDom() throws GrmgRequestException {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new GrmgRequestException("Parser Configuration Exception while creating Output");
        }
        Element scenario = document.createElement("scenario");
        document.appendChild(scenario);
        Element scenario_name = document.createElement("scenname");
        scenario.appendChild(scenario_name);
        scenario_name.appendChild(document.createTextNode(this.gs.getName()));
        Element scenario_instance = document.createElement("sceninst");
        scenario.appendChild(scenario_instance);
        scenario_instance.appendChild(document.createTextNode(this.gs.getInstance()));
        Element scenario_version = document.createElement("scenversion");
        scenario.appendChild(scenario_version);
        scenario_version.appendChild(document.createTextNode(this.gs.getVersion()));
        if (this.gs.getNumberOfComponents() > 0) {
            int i = 0;
            while (i < this.gs.getNumberOfComponents()) {
                Element component = document.createElement("component");
                scenario.appendChild(component);
                Element component_name = document.createElement("compname");
                component.appendChild(component_name);
                component_name.appendChild(document.createTextNode(this.gs.getComponent(i).getName()));
                Element component_version = document.createElement("compversion");
                component.appendChild(component_version);
                component_version.appendChild(document.createTextNode(this.gs.getComponent(i).getVersion()));
                Element component_host = document.createElement("comphost");
                component.appendChild(component_host);
                component_host.appendChild(document.createTextNode(this.gs.getComponent(i).getHost()));
                Element component_instance = document.createElement("compinst");
                component.appendChild(component_instance);
                component_instance.appendChild(document.createTextNode(this.gs.getComponent(i).getInst()));
                Element messages = document.createElement("messages");
                component.appendChild(messages);
                int j = 0;
                while (j < this.gs.getComponent(i).getNumberOfMessages()) {
                    Element message = document.createElement("message");
                    messages.appendChild(message);
                    Element message_alert = document.createElement("messalert");
                    message.appendChild(message_alert);
                    message_alert.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageAlert()));
                    Element message_severity = document.createElement("messseverity");
                    message.appendChild(message_severity);
                    message_severity.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageSeverity()));
                    Element message_area = document.createElement("messarea");
                    message.appendChild(message_area);
                    message_area.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageArea()));
                    Element message_id = document.createElement("messnumber");
                    message.appendChild(message_id);
                    message_id.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageId()));
                    Element message_parameter1 = document.createElement("messparam1");
                    message.appendChild(message_parameter1);
                    message_parameter1.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageParameter1()));
                    Element message_parameter2 = document.createElement("messparam2");
                    message.appendChild(message_parameter2);
                    message_parameter2.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageParameter2()));
                    Element message_parameter3 = document.createElement("messparam3");
                    message.appendChild(message_parameter3);
                    message_parameter3.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageParameter3()));
                    Element message_parameter4 = document.createElement("messparam4");
                    message.appendChild(message_parameter4);
                    message_parameter4.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageParameter4()));
                    Element message_text = document.createElement("messtext");
                    message.appendChild(message_text);
                    message_text.appendChild(document.createTextNode(this.gs.getComponent(i).getMessage(j).getMessageText()));
                    ++j;
                }
                ++i;
            }
        }
        return document;
    }
}

