/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg;

import com.sap.util.monitor.grmg.GrmgComponent;
import com.sap.util.monitor.grmg.GrmgCustomizing;
import com.sap.util.monitor.grmg.GrmgProperty;
import com.sap.util.monitor.grmg.GrmgScenario;
import com.sap.util.monitor.grmg.GrmgText;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GrmgCustomizingXmlGenerator {
    public static final String DEFAULT_OUTPUT_DIRECTORY = "../../grmg";
    public static final String DEFAULT_FILE_NAME = "grmg-customizing.xml";
    public static final String X_SIGN_STRING = "X";
    public static final String EMPTY_STRING = "";
    public static final String SPACE_STRING = " ";

    public static Document createCustomizingXml(GrmgCustomizing customizingDescriptor) {
        return GrmgCustomizingXmlGenerator.createCustomizingXml(DEFAULT_OUTPUT_DIRECTORY, DEFAULT_FILE_NAME, customizingDescriptor);
    }

    public static Document createCustomizingXml(String outputDirectory, String fileName, GrmgCustomizing customizingDescriptor) {
        try {
            Document doc = GrmgCustomizingXmlGenerator.buildDocument(customizingDescriptor);
            File dir = new File(outputDirectory);
            dir.mkdirs();
            File file = new File(dir, fileName);
            FileOutputStream output = new FileOutputStream(file);
            GrmgCustomizingXmlGenerator.printDocument(doc, output);
            output.flush();
            output.close();
            return doc;
        }
        catch (Exception exc) {
            return null;
        }
    }

    protected static Document buildDocument(GrmgCustomizing customizingDescriptor) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element mainNode = doc.createElement("customizing");
        Element controlElement = doc.createElement("control");
        GrmgCustomizingXmlGenerator.buildLeafTag(doc, controlElement, "grmgruns", customizingDescriptor.isGrmgRunsFlag() ? X_SIGN_STRING : EMPTY_STRING);
        GrmgCustomizingXmlGenerator.buildLeafTag(doc, controlElement, "runlog", customizingDescriptor.isRunLogFlag() ? X_SIGN_STRING : SPACE_STRING);
        GrmgCustomizingXmlGenerator.buildLeafTag(doc, controlElement, "errorlog", customizingDescriptor.isErrorLogFlag() ? X_SIGN_STRING : SPACE_STRING);
        mainNode.appendChild(controlElement);
        ArrayList grmgScenarios = customizingDescriptor.getScenarios();
        Element scenariosElement = doc.createElement("scenarios");
        int i = 0;
        while (i < grmgScenarios.size()) {
            GrmgScenario scenario = (GrmgScenario)grmgScenarios.get(i);
            Element scenarioElement = doc.createElement("scenario");
            GrmgCustomizingXmlGenerator.buildLeafTag(doc, scenarioElement, "scenname", scenario.getName());
            GrmgCustomizingXmlGenerator.buildLeafTag(doc, scenarioElement, "scenversion", scenario.getVersion());
            GrmgCustomizingXmlGenerator.buildLeafTag(doc, scenarioElement, "sceninst", scenario.getInstance());
            GrmgCustomizingXmlGenerator.buildLeafTag(doc, scenarioElement, "scentype", scenario.getType());
            GrmgCustomizingXmlGenerator.buildLeafTag(doc, scenarioElement, "scenstarturl", scenario.getStartUrl());
            GrmgCustomizingXmlGenerator.buildLeafTag(doc, scenarioElement, "scenstartmode", scenario.getStartMode());
            GrmgText scenarioText = scenario.getText();
            Element scenarioTextsElement = doc.createElement("scentexts");
            if (scenarioText != null) {
                Element scenarioTextElement = doc.createElement("scentext");
                GrmgCustomizingXmlGenerator.buildLeafTag(doc, scenarioTextElement, "scenlangu", scenarioText.getLanguage());
                GrmgCustomizingXmlGenerator.buildLeafTag(doc, scenarioTextElement, "scendesc", scenarioText.getDescription());
                scenarioTextsElement.appendChild(scenarioTextElement);
            }
            scenarioElement.appendChild(scenarioTextsElement);
            ArrayList components = scenario.getComponents();
            Element componentsElement = doc.createElement("components");
            int t = 0;
            while (t < components.size()) {
                GrmgComponent component = (GrmgComponent)components.get(t);
                Element componentElement = doc.createElement("component");
                GrmgCustomizingXmlGenerator.buildLeafTag(doc, componentElement, "compname", component.getName());
                GrmgCustomizingXmlGenerator.buildLeafTag(doc, componentElement, "compversion", component.getVersion());
                GrmgCustomizingXmlGenerator.buildLeafTag(doc, componentElement, "comptype", component.getType());
                GrmgText componentText = component.getText();
                Element componentTextsElement = doc.createElement("comptexts");
                if (componentText != null) {
                    Element componentTextElement = doc.createElement("comptext");
                    GrmgCustomizingXmlGenerator.buildLeafTag(doc, componentTextElement, "complangu", componentText.getLanguage());
                    GrmgCustomizingXmlGenerator.buildLeafTag(doc, componentTextElement, "compdesc", componentText.getDescription());
                    componentTextsElement.appendChild(componentTextElement);
                }
                componentElement.appendChild(componentTextsElement);
                ArrayList properties = component.getProperties();
                Element propertiesElement = doc.createElement("properties");
                int s = 0;
                while (s < properties.size()) {
                    Element propertyElement = doc.createElement("property");
                    GrmgProperty property = (GrmgProperty)properties.get(s);
                    GrmgCustomizingXmlGenerator.buildLeafTag(doc, propertyElement, "propname", property.getName());
                    GrmgCustomizingXmlGenerator.buildLeafTag(doc, propertyElement, "propvallue", property.getValue());
                    propertiesElement.appendChild(propertyElement);
                    ++s;
                }
                componentElement.appendChild(propertiesElement);
                componentsElement.appendChild(componentElement);
                ++t;
            }
            scenarioElement.appendChild(componentsElement);
            scenariosElement.appendChild(scenarioElement);
            ++i;
        }
        mainNode.appendChild(scenariosElement);
        doc.appendChild(mainNode);
        return doc;
    }

    protected static void buildLeafTag(Document doc, Element parentElement, String tagName, String tagValue) {
        Element subElement = doc.createElement(tagName);
        Text text = doc.createTextNode(tagValue);
        subElement.appendChild(text);
        parentElement.appendChild(subElement);
    }

    public static void printDocument(Document doc, OutputStream output) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(output);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, result);
    }

    public static final void main(String[] args) throws Exception {
        GrmgCustomizing c = new GrmgCustomizing();
        c.setGrmgRunsFlag(true);
        GrmgScenario s = new GrmgScenario();
        s.setName("Some Scenario");
        s.setVersion("1");
        s.setInstance("2");
        s.setStartUrl("http://localhost:8080/myBeautifulTest");
        GrmgText text = new GrmgText();
        text.setLanguage("E");
        text.setDescription("the best run businesses run sap");
        s.setText(text);
        GrmgComponent comp = new GrmgComponent();
        comp.setName("Some Component");
        comp.setVersion("1");
        comp.setType("1");
        text = new GrmgText();
        text.setLanguage("D");
        text.setDescription("Deutsch macht Spass");
        comp.setText(text);
        GrmgProperty prop = new GrmgProperty();
        prop.setName("propName");
        prop.setValue("propValue");
        comp.addProperty(prop);
        s.addComponent(comp);
        c.addScenario(s);
        GrmgCustomizingXmlGenerator.printDocument(GrmgCustomizingXmlGenerator.createCustomizingXml(".", "testGRMGCustomizing.xml", c), System.out);
    }
}

