/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg;

import com.sap.util.monitor.grmg.GrmgComponent;
import com.sap.util.monitor.grmg.GrmgRequest;
import com.sap.util.monitor.grmg.GrmgRequestException;
import com.sap.util.monitor.grmg.GrmgResponse;
import com.sap.util.monitor.grmg.GrmgScenario;
import com.sap.util.monitor.grmg.GrmgXMLFile;
import com.sap.util.monitor.grmg.ScenarioDevice;
import com.sap.util.monitor.grmg.ScenarioPanel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.GregorianCalendar;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GRMFactory {
    public static final String GRMG_REQUEST = "grmg_request";
    public static String CONTENT_TYPE = "text/html";
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    private GRMFactory() {
    }

    public static final GrmgRequest createRequestFromInputStream(InputStream is) throws ServletException, IOException, GrmgRequestException {
        return new GrmgRequest(is);
    }

    public static final GrmgRequest createRequestFromHttpRequest(HttpServletRequest req) throws ServletException, IOException, GrmgRequestException {
        return GRMFactory.createRequestFromHttpRequest(req, GRMG_REQUEST);
    }

    public static final GrmgRequest createRequestFromHttpRequest(HttpServletRequest req, String attribName) throws ServletException, IOException, GrmgRequestException {
        GrmgRequest greq = GRMFactory.createRequestFromInputStream((InputStream)req.getInputStream());
        if (req.getSession(true).getAttribute(attribName) == null) {
            req.getSession().setAttribute(attribName, (Object)greq);
        }
        return greq;
    }

    public static final GrmgRequest createRequestFromFile(String filename) throws ServletException, IOException, GrmgRequestException {
        return new GrmgRequest(filename);
    }

    public static final GrmgRequest createRequestFromFile(File file) throws ServletException, IOException, GrmgRequestException {
        return new GrmgRequest(file.getName());
    }

    public static final GrmgRequest getRequestFromHttpRequest(HttpServletRequest hreq) throws GrmgRequestException, IOException, ServletException {
        return GRMFactory.getRequestFromHttpRequest(hreq, GRMG_REQUEST);
    }

    public static final GrmgRequest getRequestFromHttpRequest(HttpServletRequest hreq, String attribName) throws GrmgRequestException, IOException, ServletException {
        GrmgRequest greq = (GrmgRequest)hreq.getSession(true).getAttribute(attribName);
        if (greq == null) {
            return GRMFactory.createRequestFromHttpRequest(hreq, attribName);
        }
        return greq;
    }

    public static final GrmgRequest getRequestFromSession(HttpSession hss) {
        return GRMFactory.getRequestFromSession(hss, GRMG_REQUEST);
    }

    public static final GrmgRequest getRequestFromSession(HttpSession hss, String attribName) {
        return (GrmgRequest)hss.getAttribute(attribName);
    }

    public static final GrmgScenario getScenarioFromSession(HttpSession hss) {
        return GRMFactory.getRequestFromSession(hss).getScenario();
    }

    public static final GrmgScenario createScenarioFromHttpRequest(HttpServletRequest hreq) throws GrmgRequestException, IOException, ServletException {
        return GRMFactory.createRequestFromHttpRequest(hreq).getScenario();
    }

    public static final GrmgComponent[] getComponentsFromScenario(GrmgScenario gscen) {
        int i = 0;
        if (gscen == null) {
            return null;
        }
        while (gscen.getComponent(i) != null) {
            ++i;
        }
        if (i > 0) {
            GrmgComponent[] allComps = new GrmgComponent[i];
            int j = 0;
            while (j < i) {
                allComps[j] = gscen.getComponent(j);
                ++j;
            }
            return allComps;
        }
        return null;
    }

    public static final void setInitialComponentData(GrmgComponent comp, HttpServletRequest httpreq, String compinst) {
        comp.setHost(httpreq.getScheme() + "://" + httpreq.getServerName() + ":" + httpreq.getServerPort() + httpreq.getContextPath());
        if (compinst == null) {
            compinst = "001";
        }
        comp.setInst(compinst);
        comp.addMessage().setMessageParameters("", "", "", "", "", "", "", "", "initial");
    }

    public static final void testScenario(ScenarioDevice[] scdevarr, HttpServletRequest hreq) {
        String doMethodType = hreq.getMethod();
        if (!doMethodType.equals("POST")) {
            return;
        }
        GrmgRequest greq = null;
        GrmgScenario gscen = null;
        HttpServletRequest ghreq = hreq;
        try {
            greq = GRMFactory.getRequestFromHttpRequest(hreq);
            gscen = greq.getScenario();
            GrmgComponent[] allComps = GRMFactory.getComponentsFromScenario(gscen);
            int i = 0;
            while (i < allComps.length) {
                GRMFactory.setInitialComponentData(allComps[i], hreq, null);
                ++i;
            }
        }
        catch (GrmgRequestException e) {
        }
        catch (IOException e) {
        }
        catch (ServletException e) {
            // empty catch block
        }
        if (scdevarr == null | scdevarr.length == 0) {
            return;
        }
        System.out.println("\n[INFO] Heartbeat Test of Scenario " + gscen.getName());
        System.out.println("[INFO] Time: " + new GregorianCalendar().getTime());
        System.out.println("[INFO] Remote host: " + hreq.getRemoteHost());
        System.out.println("[INFO] URL: " + hreq.getRequestURL());
        int i = 0;
        while (i < scdevarr.length) {
            block14: {
                scdevarr[i].setHttpData(ghreq, null);
                scdevarr[i].setRequest(greq);
                scdevarr[i].setScenario(gscen);
                scdevarr[i].setRequestObject(hreq);
                GrmgComponent scenGenComp = gscen.getComponentByName("ScenSelf");
                try {
                    GRMFactory.testScenario(scdevarr[i], "runScenario", null);
                }
                catch (IllegalAccessException e) {
                    if (scenGenComp != null) {
                        scdevarr[i].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + i + ". scenario. " + e.getMessage());
                    }
                }
                catch (IllegalArgumentException e) {
                    if (scenGenComp != null) {
                        scdevarr[i].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + i + ". scenario. " + e.getMessage());
                    }
                }
                catch (InvocationTargetException e) {
                    if (scenGenComp == null) break block14;
                    scdevarr[i].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + i + ". scenario. " + e.getMessage());
                }
            }
            ++i;
        }
    }

    public static final void testScenario(ScenarioDevice[] scdevarr, HttpServletRequest hreq, HttpServletResponse hres) {
        hres.setContentType(CONTENT_TYPE);
        String doMethodType = hreq.getMethod();
        if (!doMethodType.equalsIgnoreCase("POST")) {
            return;
        }
        GrmgRequest greq = null;
        GrmgScenario gscen = null;
        HttpServletRequest ghreq = hreq;
        HttpServletResponse ghres = hres;
        try {
            greq = GRMFactory.getRequestFromHttpRequest(hreq);
            gscen = greq.getScenario();
            GrmgComponent[] allComps = GRMFactory.getComponentsFromScenario(gscen);
            int i = 0;
            while (i < allComps.length) {
                GRMFactory.setInitialComponentData(allComps[i], hreq, null);
                ++i;
            }
        }
        catch (GrmgRequestException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        if (scdevarr == null | scdevarr.length == 0) {
            return;
        }
        System.out.println("\n[INFO] Heartbeat Test of Scenario " + gscen.getName());
        System.out.println("[INFO] Time: " + new GregorianCalendar().getTime());
        System.out.println("[INFO] Remote host: " + hreq.getRemoteHost());
        System.out.println("[INFO] URL: " + hreq.getRequestURL());
        int i = 0;
        while (i < scdevarr.length) {
            block16: {
                scdevarr[i].setHttpData(ghreq, ghres);
                scdevarr[i].setRequest(greq);
                scdevarr[i].setScenario(gscen);
                scdevarr[i].setRequestObject(hreq);
                scdevarr[i].setResponseObject(hres);
                GrmgComponent scenGenComp = gscen.getComponentByName("ScenSelf");
                try {
                    GRMFactory.testScenario(scdevarr[i], "runScenario", null);
                }
                catch (IllegalAccessException e) {
                    if (scenGenComp != null) {
                        scdevarr[i].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + i + ". scenario. " + e.getMessage());
                    }
                }
                catch (IllegalArgumentException e) {
                    if (scenGenComp != null) {
                        scdevarr[i].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + i + ". scenario. " + e.getMessage());
                    }
                }
                catch (InvocationTargetException e) {
                    if (scenGenComp == null) break block16;
                    scdevarr[i].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + i + ". scenario. " + e.getMessage());
                }
            }
            ++i;
        }
        try {
            GRMFactory.transmitResponse(GRMFactory.createResponse(gscen), hres);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static final void testScenario(ScenarioDevice[] scdevarr, Object hreqobj) {
        Class<?> hreqcls = hreqobj.getClass();
        int j = 0;
        while (j < scdevarr.length) {
            scdevarr[j].setRequestObject(hreqobj);
            ++j;
        }
        if ((class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = GRMFactory.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).isAssignableFrom(hreqcls) || GRMFactory.isRequestObject(hreqobj)) {
            HttpServletRequest hreq = GRMFactory.getHttpRequest(hreqobj);
            GRMFactory.testScenario(scdevarr, hreq);
        } else {
            System.out.println("No match of request or response object.");
        }
    }

    public static final void testScenario(ScenarioDevice[] scdevarr, Object hreqobj, Object hresobj) {
        Class<?> hreqcls = hreqobj.getClass();
        Class<?> hrescls = hresobj.getClass();
        int j = 0;
        while (j < scdevarr.length) {
            scdevarr[j].setRequestObject(hreqobj);
            scdevarr[j].setResponseObject(hresobj);
            ++j;
        }
        if ((class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = GRMFactory.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).isAssignableFrom(hreqcls) && (class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = GRMFactory.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse).isAssignableFrom(hrescls) || GRMFactory.isRequestObject(hreqobj)) {
            HttpServletRequest hreq = GRMFactory.getHttpRequest(hreqobj);
            HttpServletResponse hres = GRMFactory.getHttpResponse(hreqobj, hresobj);
            GRMFactory.testScenario(scdevarr, hreq, hres);
        } else {
            System.out.println("No match of request or response object.");
        }
    }

    public static final void testScenario(ScenarioDevice scdev, HttpServletRequest hreq, HttpServletResponse hres) {
        ScenarioDevice[] scdevarray = new ScenarioDevice[]{scdev};
        GRMFactory.testScenario(scdevarray, hreq, hres);
    }

    public static final void testScenario(ScenarioDevice scdev, HttpServletRequest hreq) {
        ScenarioDevice[] scdevarray = new ScenarioDevice[]{scdev};
        GRMFactory.testScenario(scdevarray, hreq);
    }

    public static final void testScenario(ScenarioDevice scdev, Object hreqobj) {
        ScenarioDevice[] scdevarr = new ScenarioDevice[]{scdev};
        int j = 0;
        while (j < scdevarr.length) {
            scdevarr[j].setRequestObject(hreqobj);
            ++j;
        }
        GRMFactory.testScenario(scdevarr, hreqobj);
    }

    public static final void testScenario(ScenarioDevice scdev, Object hreqobj, Object hresobj) {
        ScenarioDevice[] scdevarr = new ScenarioDevice[]{scdev};
        int j = 0;
        while (j < scdevarr.length) {
            scdevarr[j].setRequestObject(hreqobj);
            scdevarr[j].setResponseObject(hresobj);
            ++j;
        }
        GRMFactory.testScenario(scdevarr, hreqobj, hresobj);
    }

    private static final void testScenario(ScenarioDevice scdev, String methodname, Object[] params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = null;
        boolean match = false;
        Class<?> scdevClass = scdev.getClass();
        Method[] methods = scdevClass.getMethods();
        int j = 0;
        while (j < methods.length) {
            block7: {
                Class<?>[] parms = methods[j].getParameterTypes();
                int arrayLength = params == null ? 0 : params.length;
                if (methods[j].getName().equals(methodname) & parms.length == arrayLength) {
                    int k = 0;
                    while (k < parms.length) {
                        if (parms[k].isAssignableFrom(params[k].getClass())) {
                            if (k == parms.length - 1) {
                                match = true;
                            }
                            ++k;
                            continue;
                        }
                        break block7;
                    }
                    if (match | arrayLength == 0) {
                        method = methods[j];
                        break;
                    }
                }
            }
            ++j;
        }
        if (method != null) {
            System.out.println("[INFO] Method invoked: " + method);
            method.invoke((Object)scdev, params);
        }
    }

    public static final void testScenario(ScenarioDevice scdev, Object[] params) {
        try {
            GRMFactory.testScenario(scdev, "runScenario", params);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static final void testScenario(ScenarioPanel scpan, Object hreqobj) {
        GRMFactory.testScenario(scpan.getScenarioDeviceList(), hreqobj);
    }

    public static final void testScenario(ScenarioPanel scpan, Object hreqobj, Object hresobj) {
        GRMFactory.testScenario(scpan.getScenarioDeviceList(), hreqobj, hresobj);
    }

    public static final Document testScenario(ScenarioDevice[] scdevarray, Document grmgCust) throws GrmgRequestException {
        Document document;
        NodeList allScenarios = grmgCust.getElementsByTagName("scenario");
        if (allScenarios.getLength() > 1 & allScenarios.getLength() == 0) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new GrmgRequestException("Parser Configuration Exception while creating Output");
        }
        document.importNode(allScenarios.item(0), true);
        InputStream docStream = new GrmgXMLFile(document).getDocumentAsStream();
        GrmgRequest greq = new GrmgRequest(docStream);
        int j = 0;
        while (j < scdevarray.length) {
            block10: {
                scdevarray[j].setRequest(greq);
                scdevarray[j].setScenarioByRequest(greq);
                GrmgComponent scenGenComp = scdevarray[j].getScenario().getComponentByName("ScenSelf");
                try {
                    GRMFactory.testScenario(scdevarray[j], "runScenario", null);
                }
                catch (IllegalAccessException e) {
                    if (scenGenComp != null) {
                        scdevarray[j].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + j + ". scenario. " + e.getMessage());
                    }
                }
                catch (IllegalArgumentException e) {
                    if (scenGenComp != null) {
                        scdevarray[j].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + j + ". scenario. " + e.getMessage());
                    }
                }
                catch (InvocationTargetException e) {
                    if (scenGenComp == null) break block10;
                    scdevarray[j].setComponentData(scenGenComp, "ERROR", "010", "RT", "555", "", "", "", "", "General scenario error in " + j + ". scenario. " + e.getMessage());
                }
            }
            ++j;
        }
        return GRMFactory.createResponse(greq.getScenario()).getResponseAsDom();
    }

    public static final Document testScenario(ScenarioPanel scpan, Document grmgCust) throws GrmgRequestException {
        ScenarioDevice[] scdevarray = scpan.getScenarioDeviceList();
        return GRMFactory.testScenario(scdevarray, grmgCust);
    }

    public static final GrmgResponse createResponse(GrmgScenario grsc) {
        return new GrmgResponse(grsc);
    }

    public static final void transmitResponse(GrmgResponse gresp, HttpServletResponse hresp) throws IOException {
        try {
            gresp.getOutput().writeTo((OutputStream)hresp.getOutputStream());
        }
        catch (IllegalStateException e) {
            GRMFactory.transmitResponse(gresp, hresp.getWriter());
        }
    }

    public static final void transmitResponse(GrmgResponse gresp, PrintWriter wrt) throws IOException {
        byte[] barray = gresp.getOutput().toByteArray();
        int k = 0;
        while (k < barray.length) {
            wrt.write(barray[k]);
            ++k;
        }
    }

    private static final boolean isRequestObject(Object reqobj) {
        try {
            Method reqmeth = reqobj.getClass().getMethod("getServletRequest", null);
            if (reqmeth != null & (class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = GRMFactory.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).isAssignableFrom(reqmeth.getReturnType())) {
                return true;
            }
            if ((class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = GRMFactory.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).isAssignableFrom(reqobj.getClass())) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static final HttpServletRequest getHttpRequest(Object reqobj) {
        try {
            if (GRMFactory.isRequestObject(reqobj)) {
                return (HttpServletRequest)reqobj.getClass().getMethod("getServletRequest", null).invoke(reqobj, null);
            }
            if ((class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = GRMFactory.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).isAssignableFrom(reqobj.getClass())) {
                return (HttpServletRequest)reqobj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static final HttpServletResponse getHttpResponse(Object reqobj, Object resobj) {
        try {
            if (GRMFactory.isRequestObject(reqobj)) {
                return (HttpServletResponse)reqobj.getClass().getMethod("getServletResponse", Boolean.TYPE).invoke(reqobj, new Boolean(true));
            }
            if ((class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = GRMFactory.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse).isAssignableFrom(resobj.getClass())) {
                return (HttpServletResponse)resobj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

