/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.generation;

import com.sap.dictionary.designtime.DtDbTableExpanded;
import com.sap.dictionary.designtime.DtDictionaryExpanded;
import com.sap.dictionary.designtime.DtSimpleTypeExpanded;
import com.sap.dictionary.designtime.DtStructureExpanded;
import com.sap.dictionary.tools.generation.dependency.DependencyService;
import com.sap.dictionary.tools.generation.naming.NamingService;
import com.sap.dictionary.tools.generation.util.dc.DevComponentService;
import com.sap.ide.generationfwk.GenerationBase;
import com.sap.ide.generationfwk.naming.NamingGenerationUnitFile;
import com.sap.ide.generationfwk.naming.NamingGenerationUnitJava;
import com.sap.ide.generationfwk.naming.NamingServiceBase;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class Generation
extends GenerationBase {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$dictionary$tools$generation$Generation == null ? (class$com$sap$dictionary$tools$generation$Generation = Generation.class$("com.sap.dictionary.tools.generation.Generation")) : class$com$sap$dictionary$tools$generation$Generation).getName());
    public static final String GENERATION_CONFIGURATION_FILE = "DictionaryGenerationConfiguration.xml";
    public static final String GENERATION_CONFIGURATION_FILE_COMPILED = "DictionaryGenerationConfigurationCompiled.xml";
    public static final String DEFAULT_VENDOR = "sap.com";
    public static final String CONTEXT_ID_CLASS_NAME = "className";
    public static final String CONTEXT_ID_DICTIONARY = "dictionary";
    public static final String CONTEXT_ID_DPENDENCY_SERVICE = "dependencyService";
    public static final String CONTEXT_ID_NAMING_SERVICE = "namingService";
    public static final String CONTEXT_ID_PACKAGE = "package";
    public static final String CONTEXT_ID_LANGUAGE = "language";
    public static final String CONTEXT_ID_DB_TABLE = "dbtable";
    public static final String CONTEXT_ID_SIMPLE_TYPE = "simpleType";
    public static final String CONTEXT_ID_SIMPLE_TYPES = "simpleTypes";
    public static final String CONTEXT_ID_STRUCTURE = "structure";
    public static final String GENERATION_UNIT_ID_ARCHIVE_SDM = "archiveSdmDd";
    public static final String GENERATION_UNIT_ID_DB_TABLE = "dbTable";
    public static final String GENERATION_UNIT_ID_LOGICAL_DICTIONARY = "logicalDictionary";
    public static final String GENERATION_UNIT_ID_PACKAGE_POINTER = "packagePointer";
    public static final String GENERATION_UNIT_ID_SIMPLE_TYPE = "simpleType";
    public static final String GENERATION_UNIT_ID_SIMPLE_TYPE_ENUM_CLASS = "simpleTypeEnumClass";
    public static final String GENERATION_UNIT_ID_SIMPLE_TYPE_SCHEMA = "simpleTypeSchema";
    public static final String GENERATION_UNIT_ID_SIMPLE_TYPE_SCHEMA_DEFAULT = "simpleTypeSchemaDefault";
    public static final String GENERATION_UNIT_ID_SIMPLE_TYPES_DEFAULT_RESOURCE = "simpleTypesDefaultResource";
    public static final String GENERATION_UNIT_ID_SIMPLE_TYPES_RESOURCE = "simpleTypesResource";
    public static final String GENERATION_UNIT_ID_STRUCTURE = "structure";
    private static boolean mErrorIndicator = false;
    private DependencyService mDependencyService = null;
    private NamingService mNamingService = null;
    private String mTargetPath = "";
    private HashMap mValidatedObjectCache = new HashMap();
    static /* synthetic */ Class class$com$sap$dictionary$tools$generation$Generation;

    public Generation(int environment) {
        super(environment);
        this.setErrorIndicator(false);
    }

    public Generation(int environment, String templateConfigurationFile) {
        super(environment, templateConfigurationFile);
        this.setErrorIndicator(false);
    }

    private String doPersistentGenerationForSimpleType(DtSimpleType simpleType, DtSimpleTypeExpanded simpleTypeExpanded, boolean check) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getSimpleTypeNaming(simpleType);
        if (!this.isGenerationForSimpleType((DevelopmentObject)simpleType, lNaming.getAbsoluteFilePath())) {
            return null;
        }
        if (check && !this.validate((DevelopmentObject)simpleType)) {
            return null;
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put("simpleType", simpleTypeExpanded);
        if (this.doPersistentGeneration("simpleType", lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName(lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doTransientGenerationForSimpleTypeXSD(DtSimpleType simpleType, DtSimpleTypeExpanded simpleTypeExpanded, boolean check) {
        if (check && !this.validate((DevelopmentObject)simpleType)) {
            return null;
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put("simpleType", simpleTypeExpanded);
        return this.doTransientGeneration(GENERATION_UNIT_ID_SIMPLE_TYPE_SCHEMA, lGenerationContext, null);
    }

    private String doTransientGenerationForSimpleTypeXSDDefault(DtSimpleType simpleType, DtSimpleTypeExpanded simpleTypeExpanded, boolean check) {
        if (check && !this.validate((DevelopmentObject)simpleType)) {
            return null;
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put("simpleType", simpleTypeExpanded);
        return this.doTransientGeneration(GENERATION_UNIT_ID_SIMPLE_TYPE_SCHEMA_DEFAULT, lGenerationContext, null);
    }

    private String doPersistentGenerationForSimpleTypeEnumClass(DtSimpleType simpleType, DtSimpleTypeExpanded simpleTypeExpanded, boolean check) {
        NamingGenerationUnitJava lNaming = this.getNamingService().getSimpleTypeEnumClassNaming(simpleType);
        if (!this.getDependencyService().getSimpleTypeDependencies(simpleType).isSimpleTypeEnumClassRequired()) {
            return null;
        }
        if (!this.isGenerationForSimpleType((DevelopmentObject)simpleType, lNaming.getAbsoluteFilePath())) {
            return null;
        }
        if (check && !this.validate((DevelopmentObject)simpleType)) {
            return null;
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put("simpleType", simpleTypeExpanded);
        lGenerationContext.put(CONTEXT_ID_PACKAGE, lNaming.getPackage());
        lGenerationContext.put(CONTEXT_ID_CLASS_NAME, lNaming.getClassName());
        if (this.doPersistentGeneration(GENERATION_UNIT_ID_SIMPLE_TYPE_ENUM_CLASS, lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName((NamingGenerationUnitFile)lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doPersistentGenerationForStructure(DtGeneralStructure structure, DtStructureExpanded structureExpanded, boolean check) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getStructureNaming(structure);
        if (!this.isGenerationForStructure((DevelopmentObject)structure, lNaming.getAbsoluteFilePath())) {
            return null;
        }
        if (check && !this.validate((DevelopmentObject)structure)) {
            return null;
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put("structure", structureExpanded);
        if (this.doPersistentGeneration("structure", lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName(lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doPersistentGenerationForPackagePointer(String packageName, boolean check) {
        NamingGenerationUnitJava lNaming = this.getNamingService().getPackagePointerNaming(packageName);
        File lOutputFile = new File(lNaming.getAbsoluteFilePath());
        if (lOutputFile.exists()) {
            return null;
        }
        if (check) {
            // empty if block
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put(CONTEXT_ID_PACKAGE, lNaming.getPackage());
        lGenerationContext.put(CONTEXT_ID_CLASS_NAME, lNaming.getClassName());
        if (this.doPersistentGeneration(GENERATION_UNIT_ID_PACKAGE_POINTER, lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName((NamingGenerationUnitFile)lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doPersistentGenerationForSimpleTypesResource(String packageName, DtSimpleType[] simpleTypes, DtSimpleTypeExpanded[] simpleTypesExpanded, String language, boolean check) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getSimpleTypesResourceNaming(packageName, language);
        boolean lHasChanged = false;
        int i = 0;
        while (i < simpleTypes.length) {
            if (this.isGenerationForSimpleType((DevelopmentObject)simpleTypes[i], lNaming.getAbsoluteFilePath())) {
                lHasChanged = true;
                break;
            }
            ++i;
        }
        if (!lHasChanged) {
            return null;
        }
        if (check) {
            boolean lValidationError = false;
            int i2 = 0;
            while (i2 < simpleTypes.length) {
                if (!this.validate((DevelopmentObject)simpleTypes[i2])) {
                    lValidationError = true;
                }
                ++i2;
            }
            if (lValidationError) {
                return null;
            }
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put(CONTEXT_ID_SIMPLE_TYPES, simpleTypesExpanded);
        lGenerationContext.put(CONTEXT_ID_LANGUAGE, language);
        if (this.doPersistentGeneration(GENERATION_UNIT_ID_SIMPLE_TYPES_RESOURCE, lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName(lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doPersistentGenerationForSimpleTypesDefaultResource(String packageName, DtSimpleType[] simpleTypes, DtSimpleTypeExpanded[] simpleTypesExpanded, boolean check) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getSimpleTypesDefaultResourceNaming(packageName);
        boolean lHasChanged = false;
        int i = 0;
        while (i < simpleTypes.length) {
            if (this.isGenerationForSimpleType((DevelopmentObject)simpleTypes[i], lNaming.getAbsoluteFilePath())) {
                lHasChanged = true;
                break;
            }
            ++i;
        }
        if (!lHasChanged) {
            return null;
        }
        if (check) {
            boolean lValidationError = false;
            int i2 = 0;
            while (i2 < simpleTypes.length) {
                if (!this.validate((DevelopmentObject)simpleTypes[i2])) {
                    lValidationError = true;
                }
                ++i2;
            }
            if (lValidationError) {
                return null;
            }
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put(CONTEXT_ID_SIMPLE_TYPES, simpleTypesExpanded);
        if (this.doPersistentGeneration(GENERATION_UNIT_ID_SIMPLE_TYPES_DEFAULT_RESOURCE, lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName(lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doPersistentGenerationForDbTable(DtDbTable dbTable, DtDbTableExpanded dbTableExpanded, boolean check) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getDbTableNaming(dbTable);
        if (!this.isGeneration((DevelopmentObject)dbTable, lNaming.getAbsoluteFilePath())) {
            return null;
        }
        if (check && !this.validate((DevelopmentObject)dbTable)) {
            return null;
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put(CONTEXT_ID_DB_TABLE, dbTableExpanded);
        if (this.doPersistentGeneration(GENERATION_UNIT_ID_DB_TABLE, lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName(lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doPersistentGenerationForLogicalDictionary(DtLogicalDictionary logicalDictionary, DtDictionaryExpanded logicalDictionaryExpanded, boolean check) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getLogicalDictionaryNaming(logicalDictionary);
        if (!this.isGenerationForLogicalDictionary((DevelopmentObject)logicalDictionary, lNaming.getAbsoluteFilePath())) {
            return null;
        }
        if (check && !this.validate((DevelopmentObject)logicalDictionary)) {
            return null;
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        lGenerationContext.put(CONTEXT_ID_DICTIONARY, logicalDictionaryExpanded);
        if (this.doPersistentGeneration(GENERATION_UNIT_ID_LOGICAL_DICTIONARY, lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName(lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doPersistentGenerationForArchiveSdmDictionary(boolean check) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getArchiveSdmDictionaryNaming();
        if (!this.isGeneration(lNaming.getAbsoluteFilePath())) {
            return null;
        }
        HashMap lGenerationContext = this.getInitialGenerationContext();
        if (this.doPersistentGeneration(GENERATION_UNIT_ID_ARCHIVE_SDM, lGenerationContext, lNaming.getAbsoluteFilePath(), this.getGenerationUnitDisplayName(lNaming))) {
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    protected final String[] generatePersistentSimpleType(DtSimpleType simpleType, boolean check) {
        String[] lOutputFileNames = new String[]{};
        String lOutputFileName = null;
        ArrayList<String> lOutputFileList = new ArrayList<String>();
        DtSimpleTypeExpanded lSimpleTypeExpanded = new DtSimpleTypeExpanded(simpleType, check);
        if (lSimpleTypeExpanded.isExpanded()) {
            lOutputFileName = this.doPersistentGenerationForSimpleType(simpleType, lSimpleTypeExpanded, check);
            if (lOutputFileName != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
            if ((lOutputFileName = this.doPersistentGenerationForSimpleTypeEnumClass(simpleType, lSimpleTypeExpanded, false)) != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
            if ((lOutputFileName = this.doPersistentGenerationForPackagePointer(simpleType.getPackage(), check)) != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
        }
        this.showCheckResult(lSimpleTypeExpanded.getInfoMessages(), lSimpleTypeExpanded.getWarningMessages(), lSimpleTypeExpanded.getErrorMessages());
        lOutputFileNames = new String[lOutputFileList.size()];
        return lOutputFileList.toArray(lOutputFileNames);
    }

    protected final String generateTransientSimpleTypeXSD(DtSimpleType simpleType, boolean check) {
        String lOutputString = null;
        DtSimpleTypeExpanded lSimpleTypeExpanded = new DtSimpleTypeExpanded(simpleType, check);
        if (lSimpleTypeExpanded.isExpanded()) {
            lOutputString = this.doTransientGenerationForSimpleTypeXSD(simpleType, lSimpleTypeExpanded, check);
        }
        this.showCheckResult(lSimpleTypeExpanded.getInfoMessages(), lSimpleTypeExpanded.getWarningMessages(), lSimpleTypeExpanded.getErrorMessages());
        return lOutputString;
    }

    protected final String generateTransientSimpleTypeXSDDefault(DtSimpleType simpleType, boolean check) {
        String lOutputString = null;
        DtSimpleTypeExpanded lSimpleTypeExpanded = new DtSimpleTypeExpanded(simpleType, check);
        if (lSimpleTypeExpanded.isExpanded()) {
            lOutputString = this.doTransientGenerationForSimpleTypeXSDDefault(simpleType, lSimpleTypeExpanded, check);
        }
        this.showCheckResult(lSimpleTypeExpanded.getInfoMessages(), lSimpleTypeExpanded.getWarningMessages(), lSimpleTypeExpanded.getErrorMessages());
        return lOutputString;
    }

    protected final String[] generatePersistentStructure(DtGeneralStructure structure, boolean check) {
        String[] lOutputFileNames = new String[]{};
        String lOutputFileName = null;
        ArrayList<String> lOutputFileList = new ArrayList<String>();
        DtStructureExpanded lStructureExpanded = new DtStructureExpanded((DtStructure)structure, check);
        if (lStructureExpanded.isExpanded()) {
            lOutputFileName = this.doPersistentGenerationForStructure(structure, lStructureExpanded, check);
            if (lOutputFileName != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
            if ((lOutputFileName = this.doPersistentGenerationForPackagePointer(structure.getPackage(), check)) != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
        }
        this.showCheckResult(lStructureExpanded.getInfoMessages(), lStructureExpanded.getWarningMessages(), lStructureExpanded.getErrorMessages());
        lOutputFileNames = new String[lOutputFileList.size()];
        return lOutputFileList.toArray(lOutputFileNames);
    }

    private String doPersistentGenerationForLogicalDictionary(DtLogicalDictionary logicalDictionary, boolean check) {
        String lOutputFileName = null;
        DtDictionaryExpanded lLogicalDictionaryExpanded = new DtDictionaryExpanded(logicalDictionary, check);
        if (lLogicalDictionaryExpanded.isExpanded()) {
            lOutputFileName = this.doPersistentGenerationForLogicalDictionary(logicalDictionary, lLogicalDictionaryExpanded, check);
        }
        this.showCheckResult(lLogicalDictionaryExpanded.getInfoMessages(), lLogicalDictionaryExpanded.getWarningMessages(), lLogicalDictionaryExpanded.getErrorMessages());
        return lOutputFileName;
    }

    private String[] doPersistentGenerationForSimpleTypesResource(String packageName, DtSimpleType[] simpleTypes, String[] languages, boolean check) {
        Vector<DtSimpleTypeExpanded> lSimpleTypesExpandedVector = new Vector<DtSimpleTypeExpanded>();
        Vector<DtSimpleType> lSimpleTypesVector = new Vector<DtSimpleType>();
        DtSimpleTypeExpanded lSimpleTypeExpanded = null;
        int i = 0;
        while (i < simpleTypes.length) {
            lSimpleTypeExpanded = new DtSimpleTypeExpanded(simpleTypes[i], check);
            if (lSimpleTypeExpanded.isExpanded()) {
                lSimpleTypesVector.add(simpleTypes[i]);
                lSimpleTypesExpandedVector.add(lSimpleTypeExpanded);
            } else {
                this.printMessage(3, "Language resource for simple type " + simpleTypes[i].getName() + "could not be created, because it has errors");
            }
            ++i;
        }
        if (lSimpleTypesExpandedVector.size() == 0) {
            return new String[0];
        }
        DtSimpleTypeExpanded[] lSimpleTypesExpanded = new DtSimpleTypeExpanded[lSimpleTypesExpandedVector.size()];
        lSimpleTypesExpanded = lSimpleTypesExpandedVector.toArray(lSimpleTypesExpanded);
        DtSimpleType[] lSimpleTypes = new DtSimpleType[lSimpleTypesVector.size()];
        lSimpleTypes = lSimpleTypesVector.toArray(lSimpleTypes);
        String[] lOutputFileNames = new String[]{};
        String lOutputFileName = null;
        ArrayList<String> lOutputFileList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < languages.length) {
            lOutputFileName = this.doPersistentGenerationForSimpleTypesResource(packageName, lSimpleTypes, lSimpleTypesExpanded, languages[i2], check);
            if (lOutputFileName != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
            ++i2;
        }
        lOutputFileNames = new String[lOutputFileList.size()];
        return lOutputFileList.toArray(lOutputFileNames);
    }

    private String doPersistentGenerationForSimpleTypesDefaultResource(String packageName, DtSimpleType[] simpleTypes, boolean check) {
        Vector<DtSimpleTypeExpanded> lSimpleTypesExpandedVector = new Vector<DtSimpleTypeExpanded>();
        Vector<DtSimpleType> lSimpleTypesVector = new Vector<DtSimpleType>();
        DtSimpleTypeExpanded lSimpleTypeExpanded = null;
        int i = 0;
        while (i < simpleTypes.length) {
            lSimpleTypeExpanded = new DtSimpleTypeExpanded(simpleTypes[i], check);
            if (lSimpleTypeExpanded.isExpanded()) {
                lSimpleTypesVector.add(simpleTypes[i]);
                lSimpleTypesExpandedVector.add(lSimpleTypeExpanded);
            } else {
                this.printMessage(3, "Default language resource for simple type " + simpleTypes[i].getName() + "could not be created, because it has errors");
            }
            ++i;
        }
        if (lSimpleTypesExpandedVector.size() == 0) {
            return null;
        }
        DtSimpleTypeExpanded[] lSimpleTypesExpanded = new DtSimpleTypeExpanded[lSimpleTypesExpandedVector.size()];
        lSimpleTypesExpanded = lSimpleTypesExpandedVector.toArray(lSimpleTypesExpanded);
        DtSimpleType[] lSimpleTypes = new DtSimpleType[lSimpleTypesVector.size()];
        lSimpleTypes = lSimpleTypesVector.toArray(lSimpleTypes);
        return this.doPersistentGenerationForSimpleTypesDefaultResource(packageName, lSimpleTypes, lSimpleTypesExpanded, check);
    }

    protected final String generatePersistentDbTable(DtDbTable dbTable, boolean check) {
        String lOutputString = null;
        DtDbTableExpanded lDbTableExpanded = new DtDbTableExpanded((DtStructure)dbTable, check);
        if (lDbTableExpanded.isExpanded()) {
            lOutputString = this.doPersistentGenerationForDbTable(dbTable, lDbTableExpanded, check);
        }
        this.showCheckResult(lDbTableExpanded.getInfoMessages(), lDbTableExpanded.getWarningMessages(), lDbTableExpanded.getErrorMessages());
        return lOutputString;
    }

    protected final String[] generatePersistentArchive(String archiveName, String vendorName, String dcName, DtLogicalDictionary[] logicalDictionaries, DtSimpleType[] simpleTypes, DtGeneralStructure[] structures, DtDbTable[] dbTables, String[] languages, boolean check) {
        int i;
        int i2;
        if (archiveName == null || archiveName.length() == 0) {
            archiveName = "";
        }
        if (vendorName == null) {
            vendorName = "";
        }
        if (dcName == null) {
            dcName = "";
        }
        if (languages == null) {
            languages = new String[]{};
        }
        if (logicalDictionaries == null) {
            logicalDictionaries = new DtLogicalDictionary[]{};
        }
        if (simpleTypes == null) {
            simpleTypes = new DtSimpleType[]{};
        }
        if (structures == null) {
            structures = new DtGeneralStructure[]{};
        }
        if (dbTables == null) {
            dbTables = new DtDbTable[]{};
        }
        ArrayList<Object> lSourceObjectList = new ArrayList<Object>();
        ArrayList<Object> lArchivObjectList = new ArrayList<Object>();
        lSourceObjectList.clear();
        lArchivObjectList.clear();
        int i3 = 0;
        while (i3 < simpleTypes.length) {
            if (!simpleTypes[i3].originatesInArchive()) {
                lSourceObjectList.add(simpleTypes[i3]);
            } else if (this.getDependencyService().getSimpleTypeDependencies(simpleTypes[i3]).isSimpleTypeToDeploy() && !DevComponentService.originatesInWebDynproArchive((MainDevelopmentObject)simpleTypes[i3])) {
                lArchivObjectList.add(simpleTypes[i3]);
            }
            ++i3;
        }
        simpleTypes = new DtSimpleType[lSourceObjectList.size()];
        simpleTypes = lSourceObjectList.toArray(simpleTypes);
        DtSimpleType[] lSimpleTypesFromArchive = new DtSimpleType[lArchivObjectList.size()];
        lSimpleTypesFromArchive = lArchivObjectList.toArray(lSimpleTypesFromArchive);
        lSourceObjectList.clear();
        lArchivObjectList.clear();
        int i4 = 0;
        while (i4 < structures.length) {
            if (!structures[i4].originatesInArchive()) {
                lSourceObjectList.add(structures[i4]);
            } else if (this.getDependencyService().getStructureDependencies(structures[i4]).isStructureToDeploy() && !DevComponentService.originatesInWebDynproArchive((MainDevelopmentObject)structures[i4])) {
                lArchivObjectList.add(structures[i4]);
            }
            ++i4;
        }
        structures = new DtGeneralStructure[lSourceObjectList.size()];
        structures = lSourceObjectList.toArray(structures);
        DtGeneralStructure[] lStructuresFromArchiv = new DtGeneralStructure[lArchivObjectList.size()];
        lStructuresFromArchiv = lArchivObjectList.toArray(lStructuresFromArchiv);
        String[] lOutputFileNames = new String[]{};
        String lOutputFileName = null;
        ArrayList<String> lOutputFileList = new ArrayList<String>();
        int i5 = 0;
        while (i5 < lSimpleTypesFromArchive.length) {
            lOutputFileNames = this.generatePersistentSimpleType(lSimpleTypesFromArchive[i5], false);
            int x = 0;
            while (x < lOutputFileNames.length) {
                lOutputFileList.add(lOutputFileNames[x]);
                ++x;
            }
            ++i5;
        }
        HashSet<String> lUniquePackages = new HashSet<String>();
        int i6 = 0;
        while (i6 < simpleTypes.length) {
            if (!lUniquePackages.contains(simpleTypes[i6].getPackage())) {
                lUniquePackages.add(simpleTypes[i6].getPackage());
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < lSimpleTypesFromArchive.length) {
            if (!lUniquePackages.contains(lSimpleTypesFromArchive[i7].getPackage())) {
                lUniquePackages.add(lSimpleTypesFromArchive[i7].getPackage());
            }
            ++i7;
        }
        Iterator lIterator = lUniquePackages.iterator();
        String lPackage = null;
        Vector<DtSimpleType> lSimpleTypesForCurrentPackageVector = new Vector<DtSimpleType>();
        DtSimpleType[] lSimpleTypesForCurrentPackage = new DtSimpleType[]{};
        boolean lDetermineLanguages = false;
        if (languages.length == 0) {
            lDetermineLanguages = true;
        }
        while (lIterator.hasNext()) {
            lPackage = (String)lIterator.next();
            lSimpleTypesForCurrentPackageVector.clear();
            i2 = 0;
            while (i2 < simpleTypes.length) {
                if (simpleTypes[i2].getPackage().equals(lPackage)) {
                    lSimpleTypesForCurrentPackageVector.add(simpleTypes[i2]);
                }
                ++i2;
            }
            i = 0;
            while (i < lSimpleTypesFromArchive.length) {
                if (lSimpleTypesFromArchive[i].getPackage().equals(lPackage)) {
                    lSimpleTypesForCurrentPackageVector.add(lSimpleTypesFromArchive[i]);
                }
                ++i;
            }
            lSimpleTypesForCurrentPackage = new DtSimpleType[lSimpleTypesForCurrentPackageVector.size()];
            lOutputFileName = this.doPersistentGenerationForSimpleTypesDefaultResource(lPackage, lSimpleTypesForCurrentPackage = lSimpleTypesForCurrentPackageVector.toArray(lSimpleTypesForCurrentPackage), check);
            if (lOutputFileName != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
            if (lDetermineLanguages) {
                languages = Generation.evaluateAvailableLanguages((MainDevelopmentObject[])lSimpleTypesForCurrentPackage);
            }
            lOutputFileNames = this.doPersistentGenerationForSimpleTypesResource(lPackage, lSimpleTypesForCurrentPackage, languages, check);
            int x = 0;
            while (x < lOutputFileNames.length) {
                lOutputFileList.add(lOutputFileNames[x]);
                ++x;
            }
        }
        i2 = 0;
        while (i2 < lStructuresFromArchiv.length) {
            lOutputFileNames = this.generatePersistentStructure(lStructuresFromArchiv[i2], false);
            int x = 0;
            while (x < lOutputFileNames.length) {
                lOutputFileList.add(lOutputFileNames[x]);
                ++x;
            }
            ++i2;
        }
        i = 0;
        while (i < logicalDictionaries.length) {
            lOutputFileName = this.doPersistentGenerationForLogicalDictionary(logicalDictionaries[i], check);
            if (lOutputFileName != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
            ++i;
        }
        if (this.getEnvironment() != 2 && (lOutputFileName = this.doPersistentGenerationForArchiveSdmDictionary(check)) != null && lOutputFileName.length() > 0) {
            lOutputFileList.add(lOutputFileName);
        }
        lOutputFileNames = new String[lOutputFileList.size()];
        return lOutputFileList.toArray(lOutputFileNames);
    }

    private static String[] evaluateAvailableLanguages(MainDevelopmentObject[] mdos) {
        HashSet<String> lUniqueLanguages = new HashSet<String>();
        String[] lAvailableLanguages = null;
        int i = 0;
        while (i < mdos.length) {
            lAvailableLanguages = mdos[i].getTextPool().getAvailableLanguages();
            int x = 0;
            while (x < lAvailableLanguages.length) {
                if (!lAvailableLanguages[x].equals("") && !lUniqueLanguages.contains(lAvailableLanguages[x])) {
                    lUniqueLanguages.add(lAvailableLanguages[x]);
                }
                ++x;
            }
            ++i;
        }
        lAvailableLanguages = new String[lUniqueLanguages.size()];
        return ((AbstractCollection)lUniqueLanguages).toArray(lAvailableLanguages);
    }

    public void printMessage(int category, String messageText) {
        switch (category) {
            case 1: {
                if (!this.isLogging()) break;
                System.out.println("[Info]    " + messageText);
                break;
            }
            case 3: {
                if (!this.isLogging()) break;
                System.out.println("[Warning] " + messageText);
                break;
            }
            case 2: {
                System.out.println("[Error]   " + messageText);
                this.setErrorIndicator(true);
                break;
            }
            default: {
                if (!this.isLogging()) break;
                System.out.println(messageText);
            }
        }
    }

    protected final void setErrorIndicator(boolean errorIndicator) {
        mErrorIndicator = errorIndicator;
    }

    public static final boolean isErrorIndicator() {
        return mErrorIndicator;
    }

    protected DependencyService getDependencyService() {
        return this.mDependencyService;
    }

    protected void setDependencyService(DependencyService dependencyService) {
        this.mDependencyService = dependencyService;
    }

    protected final NamingService getNamingService() {
        return this.mNamingService;
    }

    private void setNamingService(NamingService namingService) {
        this.mNamingService = namingService;
    }

    protected void setTargetPath(String targetPath) {
        this.mTargetPath = targetPath == null ? "" : NamingServiceBase.getNormalizedFileName((String)targetPath);
        this.setNamingService(new NamingService(this.getTargetPath()));
        this.setDependencyService(new DependencyService(this.getTargetPath()));
    }

    protected String getTargetPath() {
        return this.mTargetPath;
    }

    private HashMap getInitialGenerationContext() {
        HashMap<String, Object> lGenerationContext = new HashMap<String, Object>();
        lGenerationContext.put(CONTEXT_ID_NAMING_SERVICE, (Object)this.getNamingService());
        lGenerationContext.put(CONTEXT_ID_DPENDENCY_SERVICE, this.getDependencyService());
        lGenerationContext.put("JARMInstrumentationLevel", new Integer(this.getJarmLevel()));
        return lGenerationContext;
    }

    protected final boolean isGeneration(DevelopmentObject devObject, String outputFilePath) {
        if (devObject.getMDO().originatesInArchive()) {
            return false;
        }
        if (super.isGeneration(outputFilePath)) {
            return true;
        }
        return this.isGeneration(devObject);
    }

    private boolean isGenerationForSimpleType(DevelopmentObject devObject, String outputFilePath) {
        if (super.isGeneration(outputFilePath)) {
            return true;
        }
        return this.isGeneration(devObject);
    }

    private boolean isGenerationForStructure(DevelopmentObject devObject, String outputFilePath) {
        if (super.isGeneration(outputFilePath)) {
            return true;
        }
        return this.isGeneration(devObject);
    }

    private boolean isGenerationForLogicalDictionary(DevelopmentObject devObject, String outputFilePath) {
        if (super.isGeneration(outputFilePath)) {
            return true;
        }
        return this.isGeneration(devObject);
    }

    protected abstract boolean isGeneration(DevelopmentObject var1);

    private boolean validate(DevelopmentObject devObject) {
        if (this.getValidatedObjectCache().containsKey(devObject.getKey())) {
            return (Boolean)this.getValidatedObjectCache().get(devObject.getKey());
        }
        try {
            devObject.validate();
        }
        catch (Exception ex) {
            String lMetaClassName = devObject.getMetaClass().getName();
            lMetaClassName = lMetaClassName.substring(lMetaClassName.lastIndexOf(46) + 1);
            this.printMessage(2, "Metadata constraint of " + lMetaClassName + " " + devObject.getName() + " is violated: " + ex.getMessage());
            this.getValidatedObjectCache().put(devObject.getKey(), new Boolean(false));
            return false;
        }
        this.getValidatedObjectCache().put(devObject.getKey(), new Boolean(true));
        return true;
    }

    private HashMap getValidatedObjectCache() {
        return this.mValidatedObjectCache;
    }

    private void setValidatedObjectCache(HashMap validatedObjectCache) {
        this.mValidatedObjectCache = validatedObjectCache;
    }

    protected void showCheckResult(ArrayList infoMessages, ArrayList warningMessages, ArrayList errorMessages) {
        if (errorMessages.size() > 0) {
            this.setErrorIndicator(true);
        }
    }

    protected abstract String getGenerationUnitDisplayName(NamingGenerationUnitFile var1);

    protected void deleteOutputFolderContent() {
        block6: {
            if (this.getTargetPath() == null || this.getTargetPath().length() == 0) {
                this.printMessage(2, "Generation output folder is not set");
                return;
            }
            super.deleteOutputFolderContent(this.getTargetPath() + '/' + "datatypes");
            super.deleteOutputFolderContent(this.getTargetPath() + '/' + "dbtables");
            File lTargetPathFile = new File(this.getTargetPath());
            File[] lFileList = lTargetPathFile.listFiles();
            if (lFileList == null) break block6;
            int i = 0;
            while (i < lFileList.length) {
                block8: {
                    block7: {
                        if (!lFileList[i].isDirectory()) break block7;
                        if (lFileList[i].getName().equals("datatypes") || lFileList[i].getName().equals("dbtables")) break block8;
                        super.deleteOutputFolderContent(lFileList[i].getAbsolutePath());
                    }
                    if (!GenerationBase.isOutputFileReadOnly((String)lFileList[i].getAbsolutePath())) {
                        lFileList[i].delete();
                    }
                }
                ++i;
            }
        }
    }

    protected void cleanup() {
        super.cleanup();
        this.setNamingService(null);
        this.setDependencyService(null);
        this.setValidatedObjectCache(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

