/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.common;

import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;

public class ResourceReference
implements Serializable {
    static final long serialVersionUID = -264356129956362625L;
    public static final int SERVLET_AUTHORIZATION = 1;
    public static final int CONTAINER_AUTHORIZATION = 2;
    public static final int APPLICATION_AUTHORIZATION = 3;
    public static final int RESOURCE_SHAREABLE = 0;
    public static final int RESOURCE_UNSHAREABLE = 1;
    private String resourceDescription;
    private String resourceReferenceName;
    private String resourceReferenceType;
    private String resourceLink;
    private int resourceAuthorization = 3;
    private int resourceSharingScope = 0;
    private boolean transactional = true;

    public ResourceReference() {
    }

    public ResourceReference(String name, String type, int auth) {
        this.resourceReferenceName = name;
        this.resourceReferenceType = type;
        this.resourceAuthorization = auth;
    }

    public ResourceReference(String name, String type, int auth, String descr) {
        this.resourceReferenceName = name;
        this.resourceReferenceType = type;
        this.resourceAuthorization = auth;
        this.resourceDescription = descr;
    }

    public ResourceReference(String name, String type, String link, int auth) {
        this.resourceReferenceName = name;
        this.resourceReferenceType = type;
        this.resourceAuthorization = auth;
        this.resourceLink = link;
    }

    public ResourceReference(String name, String type, String link, int auth, String description) {
        this.resourceReferenceName = name;
        this.resourceReferenceType = type;
        this.resourceAuthorization = auth;
        this.resourceLink = link;
        this.resourceDescription = description;
    }

    public String getResourceName() {
        return this.resourceReferenceName;
    }

    public void setResourceName(String name) {
        this.resourceReferenceName = name;
    }

    public String getResourceType() {
        return this.resourceReferenceType;
    }

    public void setResourceType(String type) {
        this.resourceReferenceType = type;
    }

    public String getResourceLink() {
        return this.resourceLink;
    }

    public void setResourceLink(String resourceLink) {
        this.resourceLink = "".equals(resourceLink) ? null : resourceLink;
    }

    public int getResourceAuthorization() {
        return this.resourceAuthorization;
    }

    public void setResourceAuthorization(int auth) {
        if (auth != 3 && auth != 2 && auth != 1) {
            throw new BaseIllegalArgumentException("deploy_2005");
        }
        this.resourceAuthorization = auth;
    }

    public int getResourceSharingScope() {
        return this.resourceSharingScope;
    }

    public void setResourceSharingScope(int resShar) {
        if (resShar != 0 && resShar != 1) {
            throw new BaseIllegalArgumentException("deploy_2006");
        }
        this.resourceSharingScope = resShar;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String descr) {
        this.resourceDescription = descr;
    }

    public Object clone() {
        ResourceReference cloning = new ResourceReference(this.resourceReferenceName, this.resourceReferenceType, this.resourceLink, this.resourceAuthorization, this.resourceDescription);
        cloning.setResourceSharingScope(this.resourceSharingScope);
        cloning.setTransactional(this.transactional);
        return cloning;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ResourceReference) {
            if (this == obj) {
                return true;
            }
            if (this.resourceReferenceName != null ? !this.resourceReferenceName.equals(((ResourceReference)obj).getResourceName()) : ((ResourceReference)obj).getResourceName() != null) {
                return false;
            }
            if (this.resourceReferenceType != null ? !this.resourceReferenceType.equals(((ResourceReference)obj).getResourceType()) : ((ResourceReference)obj).getResourceType() != null) {
                return false;
            }
            if (this.resourceAuthorization != ((ResourceReference)obj).getResourceAuthorization()) {
                return false;
            }
            if (this.resourceSharingScope != ((ResourceReference)obj).getResourceSharingScope()) {
                return false;
            }
            if (this.resourceLink != null ? !this.resourceLink.equals(((ResourceReference)obj).getResourceLink()) : ((ResourceReference)obj).getResourceLink() != null) {
                return false;
            }
            if (this.resourceDescription != null ? !this.resourceDescription.equals(((ResourceReference)obj).getResourceDescription()) : ((ResourceReference)obj).getResourceDescription() != null) {
                return false;
            }
            return this.transactional == ((ResourceReference)obj).isTransactional();
        }
        return false;
    }
}

