/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.common;

import com.sap.engine.services.deploy.ear.common.CloneUtils;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;
import java.lang.reflect.Method;

public class MethodEntry
implements Serializable,
Cloneable {
    static final long serialVersionUID = 3036572546904003124L;
    public static final String REMOTE_INTF = "Remote";
    public static final String REMOTE_HOME_INTF = "Home";
    public static final String LOCAL_INTF = "Local";
    public static final String LOCAL_HOME_INTF = "LocalHome";
    public static final int ALL_METHODS = 1;
    public static final int EQUALS_NAMED_METHODS = 2;
    public static final int SINGLE_METHOD = 3;
    private String methodDescription;
    private String methodName;
    private String methodIntf;
    private String ejbName;
    private String[] params;
    private String[] implExceptions;
    private String[] intfExceptions;
    private String returnType;
    private boolean methodSpecified = false;
    private transient int priority = 1;

    public MethodEntry() {
    }

    public MethodEntry(String name) {
        this.methodName = name;
    }

    public MethodEntry(Method method) {
        if (method != null) {
            Class<?>[] paramClasses = method.getParameterTypes();
            this.params = new String[paramClasses.length];
            int i = 0;
            while (i < paramClasses.length) {
                this.params[i] = paramClasses[i].getName();
                ++i;
            }
            this.methodName = method.getName();
            this.methodSpecified = true;
        } else {
            this.methodName = "Entire EJB";
        }
    }

    public MethodEntry(String ejb_name, String method_intf, Method method, String descrip) {
        this.methodDescription = descrip;
        this.ejbName = ejb_name;
        this.methodIntf = method_intf == null || method_intf.equals("") ? null : method_intf;
        this.methodName = method.getName();
        Class<?>[] par = method.getParameterTypes();
        this.params = new String[par.length];
        int i = 0;
        while (i < this.params.length) {
            this.params[i] = par[i].getName();
            ++i;
        }
        Class<?>[] exc = method.getExceptionTypes();
        this.intfExceptions = new String[exc.length];
        int i2 = 0;
        while (i2 < exc.length) {
            this.intfExceptions[i2] = exc[i2].getName();
            ++i2;
        }
        this.returnType = method.getReturnType().getName();
        if (method != null) {
            this.methodSpecified = true;
        }
    }

    public boolean isMethodSpecified() {
        return this.methodSpecified;
    }

    public void setMethodSpecified(boolean spec) {
        this.methodSpecified = spec;
    }

    public boolean isRelevant(String method_intf, Method method) {
        if (method_intf == null && this.methodIntf != null || method_intf != null && this.methodIntf == null) {
            return false;
        }
        if (this.methodIntf != null && !this.methodIntf.equals(method_intf)) {
            return false;
        }
        if (!this.methodName.equals(method.getName())) {
            return false;
        }
        Class<?>[] mParams = method.getParameterTypes();
        if (this.params.length != mParams.length) {
            return false;
        }
        int i = 0;
        while (i < this.params.length) {
            if (!this.params[i].equals(mParams[i].getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setMethodInterface(String methodIntf) {
        if (methodIntf == null || methodIntf.equals("")) {
            this.methodIntf = null;
        } else if (methodIntf.equals(REMOTE_INTF) || methodIntf.equals(REMOTE_HOME_INTF) || methodIntf.equals(LOCAL_INTF) || methodIntf.equals(LOCAL_HOME_INTF)) {
            this.methodIntf = methodIntf;
        } else {
            throw new BaseIllegalArgumentException("deploy_2004", new String[]{methodIntf});
        }
    }

    public String getMethodInterface() {
        return this.methodIntf;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public String[] getParameters() {
        return this.params;
    }

    public void setParameters(String[] params) {
        this.params = params;
    }

    public String[] getImplExceptions() {
        return this.implExceptions;
    }

    public void setImplExceptions(String[] implExceptions) {
        this.implExceptions = implExceptions;
    }

    public String[] getIntfExceptions() {
        return this.intfExceptions;
    }

    public void setIntfExceptions(String[] intfExceptions) {
        this.intfExceptions = intfExceptions;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getMethodDescription() {
        return this.methodDescription;
    }

    public void setMethodDescription(String methodDescription) {
        this.methodDescription = methodDescription;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean simpleEquals(Object obj) {
        String[] param;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodEntry)) {
            return false;
        }
        MethodEntry entry = (MethodEntry)obj;
        if (this.methodSpecified != entry.methodSpecified) {
            return false;
        }
        if (this.methodName != null) {
            if (entry.getMethodName() == null) return false;
            if (!entry.getMethodName().equals(this.methodName)) {
                return false;
            }
        } else if (entry.getMethodName() != null) {
            return false;
        }
        if (this.methodIntf != null) {
            if (entry.getMethodInterface() == null) return false;
            if (!entry.getMethodInterface().equals(this.methodIntf)) {
                return false;
            }
        } else if (entry.getMethodInterface() != null) {
            return false;
        }
        if ((param = entry.getParameters()) != null) {
            if (this.params == null) return false;
            if (param.length != this.params.length) {
                return false;
            }
            int i = 0;
            while (i < param.length) {
                if (!param[i].equals(this.params[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (this.params == null) return true;
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodEntry)) {
            return false;
        }
        MethodEntry newEntry = (MethodEntry)obj;
        if (!EqualUtils.equalUnOrderedArrays(this.params, newEntry.getParameters())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.implExceptions, newEntry.getImplExceptions())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.intfExceptions, newEntry.getIntfExceptions())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.methodDescription, newEntry.getMethodDescription())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.methodName, newEntry.getMethodName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.methodIntf, newEntry.getMethodInterface())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.ejbName, newEntry.getEjbName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.returnType, newEntry.getReturnType())) {
            return false;
        }
        return this.methodSpecified == newEntry.isMethodSpecified();
    }

    public Object clone() {
        MethodEntry entry = new MethodEntry(this.methodName);
        entry.setParameters(CloneUtils.cloneStringArray(this.params));
        entry.setImplExceptions(CloneUtils.cloneStringArray(this.implExceptions));
        entry.setIntfExceptions(CloneUtils.cloneStringArray(this.intfExceptions));
        entry.setMethodInterface(this.methodIntf == null ? null : new String(this.methodIntf));
        entry.setMethodDescription(this.methodDescription == null ? null : new String(this.methodDescription));
        entry.setMethodName(this.methodName == null ? null : new String(this.methodName));
        entry.setReturnType(this.returnType == null ? null : new String(this.returnType));
        entry.setEjbName(this.ejbName == null ? null : new String(this.ejbName));
        entry.methodSpecified = this.methodSpecified;
        return entry;
    }

    public boolean isCompatible(Method chMethod, String intfName, String beanName) {
        if (!beanName.equals(this.ejbName)) {
            return false;
        }
        String mn = chMethod.getName();
        if (chMethod == null) {
            return false;
        }
        Class<?>[] par2 = chMethod.getParameterTypes();
        if (intfName.equals(this.methodIntf) && chMethod.getName().equals(this.methodName)) {
            if (par2.length != this.params.length) {
                return false;
            }
            int i = 0;
            while (i < par2.length) {
                if (!this.params[i].equals(par2[i].getName())) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        String result = "";
        result = result + "\n methodName = " + this.methodName;
        result = result + "\n methodIntf = " + this.methodIntf;
        result = result + "\n ejbName = " + this.ejbName;
        result = result + "\n returnType = " + this.returnType;
        int i = 0;
        while (i < this.params.length) {
            result = result + "\n      params = " + this.params[i];
            ++i;
        }
        return result;
    }

    public boolean hasLowPriority(MethodEntry entry) {
        return this.priority < entry.priority;
    }

    public boolean hasEqualsPriority(MethodEntry entry) {
        return this.priority == entry.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

