/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.common;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.WebServiceObject;
import java.io.Serializable;
import org.w3c.dom.Document;

public abstract class ArchiveDescriptor
implements Serializable {
    static final long serialVersionUID = -1538034737761240533L;
    protected String description = null;
    protected String displayName = null;
    protected SerializableFile smallIcon = null;
    protected SerializableFile largeIcon = null;
    protected boolean webServiceRelated = false;
    protected WebServiceObject webServiceObject = null;
    public boolean isLoaded;

    public abstract Descriptor getDescriptor(String var1);

    public abstract Descriptor[] getDescriptors();

    public abstract void setDescriptors(Descriptor[] var1);

    public Descriptor[] removeElement(Descriptor[] descriptors, Descriptor el) {
        int index = -1;
        if (descriptors != null && descriptors.length > 0) {
            int j = 0;
            while (j < descriptors.length) {
                if (descriptors[j] != null && descriptors[j].equals(el)) {
                    index = j;
                    break;
                }
                ++j;
            }
            if (index > -1) {
                Descriptor[] descr = new Descriptor[descriptors.length - 1];
                System.arraycopy(descriptors, 0, descr, 0, index);
                System.arraycopy(descriptors, index + 1, descr, index, descriptors.length - 1 - index);
                descriptors = descr;
            }
            return descriptors;
        }
        return null;
    }

    public int containsElement(Descriptor[] descriptors, String elName) {
        int found = -1;
        if (descriptors != null && descriptors.length > 0) {
            int i = 0;
            while (i < descriptors.length) {
                if (descriptors[i] != null && descriptors[i].getName().equals(elName)) {
                    found = i;
                    return found;
                }
                ++i;
            }
        }
        return found;
    }

    public Descriptor[] replaceElement(Descriptor[] descriptors, int index, Descriptor el) {
        if (descriptors != null && descriptors.length > 0 && index >= 0 && index < descriptors.length) {
            descriptors[index] = el;
        }
        return descriptors;
    }

    public Descriptor[] addElement(Descriptor[] descriptors, Descriptor el) {
        int size = 0;
        Descriptor[] newDescriptors = null;
        if (descriptors != null) {
            size = descriptors.length;
            newDescriptors = new Descriptor[size + 1];
            System.arraycopy(descriptors, 0, newDescriptors, 0, descriptors.length);
            newDescriptors[size] = el;
            descriptors = newDescriptors;
        } else {
            descriptors = new Descriptor[]{el};
        }
        return descriptors;
    }

    public void setDisplayName(String archieveName) {
        this.displayName = archieveName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    public SerializableFile getLargeIcon() {
        return this.largeIcon;
    }

    public SerializableFile getSmallIcon() {
        return this.smallIcon;
    }

    public void setLargeIcon(SerializableFile icon) {
        this.largeIcon = icon;
    }

    public void setSmallIcon(SerializableFile icon) {
        this.smallIcon = icon;
    }

    public abstract String saveToFile(String var1);

    public abstract Document getAsDocument();

    public abstract void loadFromDocument(Document var1);

    public abstract void loadFromFile(String var1);

    public abstract Object clone();

    public boolean isWebServiceRelated() {
        return this.webServiceRelated;
    }

    public void setWebServiceRelated(boolean _isWebServiceRelated) {
        this.webServiceRelated = _isWebServiceRelated;
        if (!_isWebServiceRelated) {
            this.webServiceObject = null;
        }
    }

    public void setWebServiceObject(WebServiceObject wso) {
        this.webServiceObject = wso;
    }

    public WebServiceObject getWebServiceObject() {
        return this.webServiceObject;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveDescriptor)) {
            return false;
        }
        ArchiveDescriptor temp = (ArchiveDescriptor)obj;
        if (!EqualUtils.equalObjects(this.description, temp.getDescription())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.displayName, temp.getDisplayName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.smallIcon, temp.getSmallIcon())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.largeIcon, temp.getLargeIcon())) {
            return false;
        }
        if (this.webServiceRelated != temp.isWebServiceRelated()) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.webServiceObject, temp.getWebServiceObject())) {
            return false;
        }
        return this.isLoaded == temp.isLoaded;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }
}

