/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.container;

import com.sap.engine.services.deploy.container.ContainerResourceAccessor;
import com.sap.exception.BaseExceptionInfo;
import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class WarningException
extends RemoteException
implements IBaseException {
    private BaseExceptionInfo exceptionInfo = null;
    String[] res = null;
    String[] warnings = null;

    public WarningException() {
        this("deploy_0000");
    }

    public WarningException(String s) {
        LocalizableTextFormatter formater = new LocalizableTextFormatter(ContainerResourceAccessor.getResourceAccessor(), s);
        this.exceptionInfo = new BaseExceptionInfo(ContainerResourceAccessor.category, 400, ContainerResourceAccessor.location, (LocalizableText)formater, (Throwable)this, null);
    }

    public WarningException(String s, Object[] params) {
        LocalizableTextFormatter formater = new LocalizableTextFormatter(ContainerResourceAccessor.getResourceAccessor(), s, params);
        this.exceptionInfo = new BaseExceptionInfo(ContainerResourceAccessor.category, 400, ContainerResourceAccessor.location, (LocalizableText)formater, (Throwable)this, null);
    }

    public WarningException(String s, Exception e) {
        LocalizableTextFormatter formater = new LocalizableTextFormatter(ContainerResourceAccessor.getResourceAccessor(), s);
        this.exceptionInfo = new BaseExceptionInfo(ContainerResourceAccessor.category, 400, ContainerResourceAccessor.location, (LocalizableText)formater, (Throwable)this, (Throwable)e);
    }

    public WarningException(String s, Object[] params, Exception e) {
        LocalizableTextFormatter formater = new LocalizableTextFormatter(ContainerResourceAccessor.getResourceAccessor(), s, params);
        this.exceptionInfo = new BaseExceptionInfo(ContainerResourceAccessor.category, 400, ContainerResourceAccessor.location, (LocalizableText)formater, (Throwable)this, (Throwable)e);
    }

    public WarningException(String s, Object[] params, Throwable t) {
        LocalizableTextFormatter formater = new LocalizableTextFormatter(ContainerResourceAccessor.getResourceAccessor(), s, params);
        this.exceptionInfo = new BaseExceptionInfo(ContainerResourceAccessor.category, 400, ContainerResourceAccessor.location, (LocalizableText)formater, (Throwable)this, t);
    }

    public WarningException(LocalizableTextFormatter textFormater, Throwable t) {
        this.exceptionInfo = new BaseExceptionInfo(ContainerResourceAccessor.category, 400, ContainerResourceAccessor.location, (LocalizableText)textFormater, (Throwable)this, t);
    }

    public WarningException(LocalizableTextFormatter textFormater) {
        this.exceptionInfo = new BaseExceptionInfo(ContainerResourceAccessor.category, 400, ContainerResourceAccessor.location, (LocalizableText)textFormater, (Throwable)this, null);
    }

    public WarningException(LocalizableTextFormatter textFormater, Throwable t, Category category, int severity, Location location) {
        this.exceptionInfo = new BaseExceptionInfo(category, severity, location, (LocalizableText)textFormater, (Throwable)this, t);
    }

    public WarningException(LocalizableTextFormatter textFormater, Category category, int severity, Location location) {
        this.exceptionInfo = new BaseExceptionInfo(category, severity, location, (LocalizableText)textFormater, (Throwable)this, null);
    }

    public void addWarning(String newWarning) {
        if (newWarning == null) {
            return;
        }
        if (this.warnings == null) {
            this.warnings = new String[1];
            this.warnings[0] = newWarning;
        } else {
            String[] newRes = new String[this.warnings.length + 1];
            System.arraycopy(this.warnings, 0, newRes, 0, this.warnings.length);
            newRes[this.warnings.length] = newWarning;
            this.warnings = newRes;
        }
    }

    public void setWarning(String[] newWarning) {
        if (newWarning != null) {
            Vector<String> res = new Vector<String>();
            int i = 0;
            while (i < newWarning.length) {
                if (newWarning[i] != null && !newWarning[i].trim().equals("") && !newWarning[i].trim().equals("null")) {
                    res.add(newWarning[i]);
                }
                ++i;
            }
            if (res.size() > 0) {
                this.warnings = new String[res.size()];
                res.copyInto(this.warnings);
                return;
            }
        }
        this.warnings = null;
    }

    public void setWarnings(Vector newWarnings) {
        if (newWarnings != null && newWarnings.size() > 0) {
            this.warnings = new String[newWarnings.size()];
            newWarnings.toArray(this.warnings);
        }
    }

    public String[] getWarnings() {
        return this.warnings;
    }

    public void setResult(String[] res1) {
        this.res = res1;
    }

    public String[] getResult() {
        return this.res;
    }

    public String toString() {
        String res = this.getLocalizedMessage();
        if (res == null || res.trim().equals("null")) {
            res = "";
        }
        if (this.warnings != null) {
            int i = 0;
            while (i < this.warnings.length) {
                if (this.warnings[i] != null && !this.warnings[i].trim().equals("") && !this.warnings[i].trim().equals("null")) {
                    res = res + "\n" + this.warnings[i];
                }
                ++i;
            }
        }
        return res;
    }

    public Throwable initCause(Throwable cause) {
        if (this.exceptionInfo != null) {
            return this.exceptionInfo.initCause(cause);
        }
        return null;
    }

    public Throwable getCause() {
        return this.exceptionInfo.getCause();
    }

    public LocalizableText getLocalizableMessage() {
        return this.exceptionInfo.getLocalizableMessage();
    }

    public String getLocalizedMessage() {
        return this.exceptionInfo.getLocalizedMessage();
    }

    public String getLocalizedMessage(Locale loc) {
        return this.exceptionInfo.getLocalizedMessage(loc);
    }

    public String getLocalizedMessage(TimeZone timeZone) {
        return this.exceptionInfo.getLocalizedMessage(timeZone);
    }

    public String getLocalizedMessage(Locale loc, TimeZone timeZone) {
        return this.exceptionInfo.getLocalizedMessage(loc, timeZone);
    }

    public String getNestedLocalizedMessage() {
        return this.exceptionInfo.getNestedLocalizedMessage();
    }

    public String getNestedLocalizedMessage(Locale loc) {
        return this.exceptionInfo.getNestedLocalizedMessage(loc);
    }

    public String getNestedLocalizedMessage(TimeZone timeZone) {
        return this.exceptionInfo.getNestedLocalizedMessage(timeZone);
    }

    public String getNestedLocalizedMessage(Locale loc, TimeZone timeZone) {
        return this.exceptionInfo.getNestedLocalizedMessage(loc, timeZone);
    }

    public void finallyLocalize() {
        this.exceptionInfo.finallyLocalize();
    }

    public void finallyLocalize(Locale loc) {
        this.exceptionInfo.finallyLocalize(loc);
    }

    public void finallyLocalize(TimeZone timeZone) {
        this.exceptionInfo.finallyLocalize(timeZone);
    }

    public void finallyLocalize(Locale loc, TimeZone timeZone) {
        this.exceptionInfo.finallyLocalize(loc, timeZone);
    }

    public String getSystemStackTraceString() {
        StringWriter s = new StringWriter();
        super.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public String getStackTraceString() {
        return this.exceptionInfo.getStackTraceString();
    }

    public String getNestedStackTraceString() {
        return this.exceptionInfo.getNestedStackTraceString();
    }

    public void printStackTrace() {
        this.exceptionInfo.printStackTrace();
    }

    public void printStackTrace(PrintStream s) {
        this.exceptionInfo.printStackTrace(s);
    }

    public void printStackTrace(PrintWriter s) {
        this.exceptionInfo.printStackTrace(s);
    }

    public void setLogSettings(Category cat, int severity, Location loc) {
        this.exceptionInfo.setLogSettings(cat, severity, loc);
    }

    public void log() {
        this.exceptionInfo.log();
    }
}

