/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.container;

import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import java.io.Serializable;

public class ExportInfo
implements Serializable {
    static final long serialVersionUID = -6200086283330628239L;
    public static final byte EJB = 1;
    public static final byte WEB = 2;
    public static final byte CLIENT = 3;
    private String componentName = null;
    private byte type = 0;
    private EnvironmentEntry[] env = null;
    private ResourceReference[] refs = null;
    private EJBeanReference[] ejbs = null;
    private SecurityRoles[] roles = null;
    private ContextParam[] params = null;
    private String dbPoolName = null;

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String compName) {
        this.componentName = compName;
    }

    public EJBeanReference[] getEJBeanReferences() {
        return this.ejbs;
    }

    public void setEJBeanReferences(EJBeanReference[] ejbRefs) {
        this.ejbs = ejbRefs;
    }

    public EnvironmentEntry[] getEnvironmentEntries() {
        return this.env;
    }

    public void setEnvironmentEntries(EnvironmentEntry[] envEntries) {
        this.env = envEntries;
    }

    public ContextParam[] getContextParams() {
        return this.params;
    }

    public void setContextParams(ContextParam[] contParams) {
        this.params = contParams;
    }

    public ResourceReference[] getResourceReferences() {
        return this.refs;
    }

    public void setResourceReferences(ResourceReference[] resRefs) {
        this.refs = resRefs;
    }

    public SecurityRoles[] getSecurityRoles() {
        return this.roles;
    }

    public void setSecurityRoles(SecurityRoles[] secRoles) {
        this.roles = secRoles;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getDBPoolName() {
        return this.dbPoolName;
    }

    public void setDBPoolName(String dbPoolName) {
        this.dbPoolName = dbPoolName;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ExportInfo)) {
            return false;
        }
        ExportInfo temp = (ExportInfo)obj;
        if (!this.compareStrings(this.componentName, temp.componentName)) {
            return false;
        }
        if (this.type != temp.type) {
            return false;
        }
        if (!this.compareEjbRefs(this.ejbs, temp.ejbs)) {
            return false;
        }
        if (!this.compareResRefs(this.refs, temp.refs)) {
            return false;
        }
        if (!this.compareArrays(this.env, temp.env)) {
            return false;
        }
        if (!this.compareRoles(this.roles, temp.roles)) {
            return false;
        }
        if (!this.compareArrays(this.params, temp.params)) {
            return false;
        }
        return this.compareStrings(this.dbPoolName, temp.dbPoolName);
    }

    private boolean compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private boolean compareArrays(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        if (array1.length == 0) {
            return true;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != null || array2[i] != null) {
                if (array1[i] == null || array2[i] == null) {
                    return false;
                }
                if (array1[i] instanceof EnvironmentEntry) {
                    EnvironmentEntry entry2;
                    EnvironmentEntry entry1 = (EnvironmentEntry)array1[i];
                    if (array2[i] instanceof EnvironmentEntry && !entry1.equals(entry2 = (EnvironmentEntry)array2[i])) {
                        return false;
                    }
                }
                if (array1[i] instanceof ContextParam) {
                    ContextParam param2;
                    ContextParam param1 = (ContextParam)array1[i];
                    if (array2[i] instanceof ContextParam && !param1.equals(param2 = (ContextParam)array2[i])) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean compareEjbRefs(EJBeanReference[] ejbs1, EJBeanReference[] ejbs2) {
        if (ejbs1 == null && ejbs2 == null) {
            return true;
        }
        if (ejbs1 == null || ejbs2 == null) {
            return false;
        }
        if (ejbs1.length != ejbs2.length) {
            return false;
        }
        if (ejbs1.length == 0) {
            return true;
        }
        int i = 0;
        while (i < ejbs1.length) {
            if (ejbs1[i] != null || ejbs2[i] != null) {
                if (ejbs1[i] == null || ejbs2[i] == null) {
                    return false;
                }
                EJBeanReference ejb1 = ejbs1[i];
                EJBeanReference ejb2 = ejbs2[i];
                if (ejb1.getReferenceName() != null ? !ejb1.getReferenceName().equals(ejb2.getReferenceName()) : ejb2.getReferenceName() != null) {
                    return false;
                }
                if (ejb1.getReferenceDescription() != null ? !ejb1.getReferenceDescription().equals(ejb2.getReferenceDescription()) : ejb2.getReferenceDescription() != null) {
                    return false;
                }
                if (ejb1.getReferenceJndiLink() != null ? !ejb1.getReferenceJndiLink().equals(ejb2.getReferenceJndiLink()) : ejb2.getReferenceJndiLink() != null) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean compareResRefs(ResourceReference[] res1, ResourceReference[] res2) {
        if (res1 == null && res2 == null) {
            return true;
        }
        if (res1 == null || res2 == null) {
            return false;
        }
        if (res1.length != res2.length) {
            return false;
        }
        if (res1.length == 0) {
            return true;
        }
        int i = 0;
        while (i < res1.length) {
            if (res1[i] != null || res2[i] != null) {
                if (res1[i] == null || res2[i] == null) {
                    return false;
                }
                ResourceReference ref1 = res1[i];
                ResourceReference ref2 = res2[i];
                if (ref1.getResourceName() != null ? !ref1.getResourceName().equals(ref2.getResourceName()) : ref2.getResourceName() != null) {
                    return false;
                }
                if (ref1.getResourceDescription() != null ? !ref1.getResourceDescription().equals(ref2.getResourceDescription()) : ref2.getResourceDescription() != null) {
                    return false;
                }
                if (ref1.getResourceLink() != null ? !ref1.getResourceLink().equals(ref2.getResourceLink()) : ref2.getResourceLink() != null) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean compareRoles(SecurityRoles[] roles1, SecurityRoles[] roles2) {
        if (roles1 == null && roles2 == null) {
            return true;
        }
        if (roles1 == null || roles2 == null) {
            return false;
        }
        if (roles1.length != roles2.length) {
            return false;
        }
        if (roles1.length == 0) {
            return true;
        }
        int i = 0;
        while (i < roles1.length) {
            if (roles1[i] != null || roles2[i] != null) {
                if (roles1[i] == null || roles2[i] == null) {
                    return false;
                }
                SecurityRoles role1 = roles1[i];
                SecurityRoles role2 = roles2[i];
                if (role1.getRoleName() != null ? !role1.getRoleName().equals(role2.getRoleName()) : role2.getRoleName() != null) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

