/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.XmlLogger;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.core.ant.AntSecurityManager;
import org.eclipse.ant.internal.core.ant.InputHandlerSetter;
import org.eclipse.ant.internal.core.ant.InternalAntMessages;
import org.eclipse.ant.internal.core.ant.InternalProject;
import org.eclipse.ant.internal.core.ant.ProgressBuildListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class InternalAntRunner {
    protected IProgressMonitor monitor;
    protected List buildListeners;
    protected String buildFileLocation;
    protected Vector targets;
    protected Map userProperties;
    protected Project currentProject;
    protected String defaultTarget;
    protected BuildLogger buildLogger = null;
    protected String antVersion = null;
    protected String antVersionNumber = null;
    protected int messageOutputLevel = 2;
    protected boolean emacsMode = false;
    protected boolean projectHelp = false;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    protected String loggerClassname = null;
    protected String[] extraArguments = null;
    protected boolean scriptExecuted = false;
    protected List propertyFiles = new ArrayList();
    private String inputHandlerClassname = null;
    private String buildAntHome = null;
    private static final String PROPERTY_ECLIPSE_RUNNING = "eclipse.running";
    static /* synthetic */ Class class$0;

    public void addBuildListeners(List classNames) {
        if (this.buildListeners == null) {
            this.buildListeners = new ArrayList(classNames.size());
        }
        this.buildListeners.addAll(classNames);
    }

    public void addBuildLogger(String className) {
        this.loggerClassname = className;
    }

    public void addUserProperties(Map properties) {
        if (this.userProperties == null) {
            this.userProperties = new HashMap(properties.size());
        }
        this.userProperties.putAll(properties);
    }

    public void addPropertyFiles(String[] propertyFiles) {
        this.propertyFiles.addAll(Arrays.asList(propertyFiles));
    }

    private void addBuildListeners(Project project) {
        String className = null;
        try {
            BuildLogger logger = this.createLogger();
            if (logger != null) {
                project.addBuildListener((BuildListener)logger);
            }
            if (this.buildListeners != null) {
                Iterator iterator = this.buildListeners.iterator();
                while (iterator.hasNext()) {
                    className = (String)iterator.next();
                    Class<?> listener = Class.forName(className);
                    project.addBuildListener((BuildListener)listener.newInstance());
                }
            }
        }
        catch (ClassCastException e) {
            String message = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.{0}_which_was_specified_to_be_a_build_listener_is_not_an_instance_of_org.apache.tools.ant.BuildListener._1"), className);
            this.logMessage(null, message, 0);
            throw new BuildException(message, (Throwable)e);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void setProperties(Project project) {
        project.setUserProperty(PROPERTY_ECLIPSE_RUNNING, "true");
        project.setUserProperty("ant.file", this.getBuildFileLocation());
        project.setUserProperty("ant.version", Main.getAntVersion());
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        Property[] properties = prefs.getCustomProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                Property property = properties[i];
                project.setUserProperty(property.getName(), property.getValue());
                ++i;
            }
        }
        if (this.userProperties == null) {
            return;
        }
        Iterator iterator = this.userProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            project.setUserProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setTasks(Project project) {
        List tasks = AntCorePlugin.getPlugin().getPreferences().getTasks();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            try {
                Class<?> taskClass = Class.forName(task.getClassName());
                if (this.isVersionCompatible("1.5")) {
                    try {
                        project.checkTaskClass(taskClass);
                    }
                    catch (BuildException e) {
                        Status status = new Status(4, "org.eclipse.ant.core", 1, MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Error_setting_Ant_task"), task.getTaskName()), (Throwable)e);
                        AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                        continue;
                    }
                }
                project.addTaskDefinition(task.getTaskName(), taskClass);
            }
            catch (ClassNotFoundException e) {
                Status status = new Status(4, "org.eclipse.ant.core", 1, MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Class_{0}_not_found_for_task_{1}_1"), task.getClassName(), task.getTaskName()), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
    }

    private void setTypes(Project project) {
        List types = AntCorePlugin.getPlugin().getPreferences().getTypes();
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            try {
                Class<?> typeClass = Class.forName(type.getClassName());
                project.addDataTypeDefinition(type.getTypeName(), typeClass);
            }
            catch (ClassNotFoundException e) {
                Status status = new Status(4, "org.eclipse.ant.core", 1, MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Class_{0}_not_found_for_type_{1}_2"), type.getClassName(), type.getTypeName()), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
    }

    private void parseBuildFile(Project project) {
        File buildFile = new File(this.getBuildFileLocation());
        if (!buildFile.exists()) {
            throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Buildfile__{0}_does_not_exist_!_1"), buildFile.getAbsolutePath()));
        }
        if (!buildFile.isFile()) {
            throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Buildfile__{0}_is_not_a_file_1"), buildFile.getAbsolutePath()));
        }
        ProjectHelper.configureProject((Project)project, (File)buildFile);
    }

    public List getTargets() {
        Object antProject = this.isVersionCompatible("1.6") ? new Project() : new InternalProject();
        antProject.init();
        this.setTypes((Project)antProject);
        this.processProperties(this.getArrayList(this.extraArguments));
        this.setProperties((Project)antProject);
        this.parseBuildFile((Project)antProject);
        this.defaultTarget = antProject.getDefaultTarget();
        Enumeration targets = antProject.getTargets().elements();
        ArrayList<Object> infos = new ArrayList<Object>();
        infos.add(antProject.getName());
        infos.add(antProject.getDescription());
        boolean defaultFound = false;
        while (targets.hasMoreElements()) {
            Target target = (Target)targets.nextElement();
            String name = target.getName();
            if (name.length() == 0) continue;
            ArrayList<Object> info = new ArrayList<Object>(4);
            info.add(name);
            if (target.getName().equals(this.defaultTarget)) {
                defaultFound = true;
            }
            info.add(target.getDescription());
            ArrayList dependencies = new ArrayList();
            Enumeration enumeration = target.getDependencies();
            while (enumeration.hasMoreElements()) {
                dependencies.add(enumeration.nextElement());
            }
            String[] dependencyArray = new String[dependencies.size()];
            dependencies.toArray(dependencyArray);
            info.add(dependencyArray);
            infos.add(info);
        }
        if (!defaultFound) {
            throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Default_target_{0}{1}{2}_does_not_exist_in_this_project_1"), "'", this.defaultTarget, "'"));
        }
        return infos;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void run() {
        this.run(this.getArrayList(this.extraArguments));
    }

    private void printArguments(Project project) {
        if (this.messageOutputLevel != 4 && this.messageOutputLevel != 3) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.extraArguments.length) {
            sb.append(this.extraArguments[i]);
            sb.append(' ');
            ++i;
        }
        project.log(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Arguments__{0}_2"), sb.toString().trim()));
    }

    private void createMonitorBuildListener(Project project) {
        if (this.monitor == null) {
            return;
        }
        AbstractList chosenTargets = this.targets;
        if (chosenTargets == null || chosenTargets.isEmpty()) {
            chosenTargets = new ArrayList(1);
            String defltTarget = project.getDefaultTarget();
            if (defltTarget != null) {
                chosenTargets.add(defltTarget);
            }
        }
        project.addBuildListener((BuildListener)new ProgressBuildListener(project, chosenTargets, this.monitor));
    }

    private void printTargets(Project project) {
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        ArrayList<String> topNames = new ArrayList<String>();
        ArrayList<String> topDescriptions = new ArrayList<String>();
        ArrayList<String> subNames = new ArrayList<String>();
        while (ptargets.hasMoreElements()) {
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                subNames.add(targetName);
                continue;
            }
            topNames.add(targetName);
            topDescriptions.add(targetDescription);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        Collections.sort(subNames);
        Collections.sort(topNames);
        Collections.sort(topDescriptions);
        String defaultTarget = project.getDefaultTarget();
        if (defaultTarget != null && !"".equals(defaultTarget)) {
            ArrayList<String> defaultName = new ArrayList<String>(1);
            ArrayList defaultDesc = null;
            defaultName.add(defaultTarget);
            int indexOfDefDesc = topNames.indexOf(defaultTarget);
            if (indexOfDefDesc >= 0) {
                defaultDesc = new ArrayList(1);
                defaultDesc.add(topDescriptions.get(indexOfDefDesc));
            }
            this.printTargets(project, defaultName, defaultDesc, InternalAntMessages.getString("InternalAntRunner.Default_target__3"), maxLength);
        }
        this.printTargets(project, topNames, topDescriptions, InternalAntMessages.getString("InternalAntRunner.Main_targets__4"), maxLength);
        this.printTargets(project, subNames, null, InternalAntMessages.getString("InternalAntRunner.Subtargets__5"), 0);
    }

    private void printTargets(Project project, List names, List descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() < maxlen) {
            spaces = String.valueOf(spaces) + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(String.valueOf(heading) + lSep + lSep);
        int i = 0;
        while (i < names.size()) {
            msg.append(' ');
            msg.append(names.get(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.get(i)).length() + 2));
                msg.append(descriptions.get(i));
            }
            msg.append(lSep);
            ++i;
        }
        this.logMessage(project, msg.toString(), 2);
    }

    public void run(Object argArray) throws Exception {
        this.run(this.getArrayList((String[])argArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(List argList) {
        SecurityManager originalSM;
        PrintStream originalOut;
        PrintStream originalErr;
        Throwable error;
        block42: {
            block41: {
                block40: {
                    block39: {
                        this.setCurrentProject(new Project());
                        error = null;
                        originalErr = System.err;
                        originalOut = System.out;
                        originalSM = System.getSecurityManager();
                        this.setJavaClassPath();
                        this.scriptExecuted = true;
                        this.processAntHome(false);
                        try {
                            try {
                                if (argList != null && argList.remove("-projecthelp")) {
                                    this.projectHelp = true;
                                }
                                this.getCurrentProject().init();
                                if (argList != null) {
                                    this.scriptExecuted = this.preprocessCommandLine(argList);
                                    if (!this.scriptExecuted) {
                                        Object var7_6 = null;
                                        break block39;
                                    }
                                }
                                this.addBuildListeners(this.getCurrentProject());
                                this.processProperties(argList);
                                this.setProperties(this.getCurrentProject());
                                this.addInputHandler(this.getCurrentProject());
                                System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(this.getCurrentProject(), false)));
                                System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(this.getCurrentProject(), true)));
                                if (!this.projectHelp) {
                                    this.fireBuildStarted(this.getCurrentProject());
                                }
                                if (argList != null && !argList.isEmpty()) {
                                    try {
                                        this.scriptExecuted = this.processCommandLine(argList);
                                    }
                                    catch (BuildException e) {
                                        this.scriptExecuted = false;
                                        throw e;
                                    }
                                }
                                if (!this.scriptExecuted) {
                                    break block40;
                                }
                                this.getCurrentProject().log(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Build_file__{0}_1"), this.getBuildFileLocation()));
                                this.setTasks(this.getCurrentProject());
                                this.setTypes(this.getCurrentProject());
                                this.parseBuildFile(this.getCurrentProject());
                                this.validateDefaultTarget();
                                this.createMonitorBuildListener(this.getCurrentProject());
                                if (this.projectHelp) {
                                    this.printHelp(this.getCurrentProject());
                                    this.scriptExecuted = false;
                                    break block41;
                                }
                                if (this.extraArguments != null) {
                                    this.printArguments(this.getCurrentProject());
                                }
                                System.setSecurityManager(new AntSecurityManager(originalSM));
                                if (this.targets != null && !this.targets.isEmpty()) {
                                    this.getCurrentProject().executeTargets(this.targets);
                                    break block42;
                                } else {
                                    this.getCurrentProject().executeTarget(this.getCurrentProject().getDefaultTarget());
                                }
                                break block42;
                            }
                            catch (OperationCanceledException e) {
                                this.scriptExecuted = false;
                                this.logMessage(this.getCurrentProject(), e.getMessage(), 2);
                                throw e;
                            }
                            catch (AntSecurityException antSecurityException) {
                                break block42;
                            }
                            catch (RuntimeException e) {
                                error = e;
                                throw e;
                            }
                            catch (Error e) {
                                error = e;
                                throw e;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            System.setErr(originalErr);
                            System.setOut(originalOut);
                            if (System.getSecurityManager() instanceof AntSecurityManager) {
                                System.setSecurityManager(originalSM);
                            }
                            if (!this.projectHelp) {
                                this.fireBuildFinished(this.getCurrentProject(), error);
                            }
                            if (this.err != originalErr) {
                                this.err.close();
                            }
                            if (this.out != originalOut) {
                                this.out.close();
                            }
                            this.processAntHome(true);
                            throw throwable;
                        }
                    }
                    System.setErr(originalErr);
                    System.setOut(originalOut);
                    if (System.getSecurityManager() instanceof AntSecurityManager) {
                        System.setSecurityManager(originalSM);
                    }
                    if (!this.projectHelp) {
                        this.fireBuildFinished(this.getCurrentProject(), error);
                    }
                    if (this.err != originalErr) {
                        this.err.close();
                    }
                    if (this.out != originalOut) {
                        this.out.close();
                    }
                    this.processAntHome(true);
                    return;
                }
                Object var7_7 = null;
                System.setErr(originalErr);
                System.setOut(originalOut);
                if (System.getSecurityManager() instanceof AntSecurityManager) {
                    System.setSecurityManager(originalSM);
                }
                if (!this.projectHelp) {
                    this.fireBuildFinished(this.getCurrentProject(), error);
                }
                if (this.err != originalErr) {
                    this.err.close();
                }
                if (this.out != originalOut) {
                    this.out.close();
                }
                this.processAntHome(true);
                return;
            }
            Object var7_8 = null;
            System.setErr(originalErr);
            System.setOut(originalOut);
            if (System.getSecurityManager() instanceof AntSecurityManager) {
                System.setSecurityManager(originalSM);
            }
            if (!this.projectHelp) {
                this.fireBuildFinished(this.getCurrentProject(), error);
            }
            if (this.err != originalErr) {
                this.err.close();
            }
            if (this.out != originalOut) {
                this.out.close();
            }
            this.processAntHome(true);
            return;
        }
        Object var7_10 = null;
        System.setErr(originalErr);
        System.setOut(originalOut);
        if (System.getSecurityManager() instanceof AntSecurityManager) {
            System.setSecurityManager(originalSM);
        }
        if (!this.projectHelp) {
            this.fireBuildFinished(this.getCurrentProject(), error);
        }
        if (this.err != originalErr) {
            this.err.close();
        }
        if (this.out != originalOut) {
            this.out.close();
        }
        this.processAntHome(true);
    }

    private void processAntHome(boolean finished) {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        String antHome = prefs.getAntHome();
        if (this.buildAntHome != null && !finished) {
            antHome = this.buildAntHome;
        }
        if (antHome == null || antHome.length() == 0) {
            ((Hashtable)System.getProperties()).remove("ant.home");
        } else {
            System.setProperty("ant.home", antHome);
        }
    }

    public void setAntHome(String antHome) {
        this.buildAntHome = antHome;
    }

    private void validateDefaultTarget() {
        this.defaultTarget = this.getCurrentProject().getDefaultTarget();
        Enumeration targets = this.getCurrentProject().getTargets().elements();
        boolean defaultFound = false;
        while (targets.hasMoreElements()) {
            Target target = (Target)targets.nextElement();
            if (!target.getName().equals(this.defaultTarget)) continue;
            defaultFound = true;
            break;
        }
        if (!defaultFound) {
            throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Default_target_{0}{1}{2}_does_not_exist_in_this_project_1"), "'", this.defaultTarget, "'"));
        }
    }

    private BuildLogger createLogger() {
        if (this.loggerClassname == null) {
            this.buildLogger = new DefaultLogger();
        } else if (!"".equals(this.loggerClassname)) {
            try {
                this.buildLogger = (BuildLogger)Class.forName(this.loggerClassname).newInstance();
            }
            catch (ClassCastException e) {
                String message = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.{0}_which_was_specified_to_perform_logging_is_not_an_instance_of_org.apache.tools.ant.BuildLogger._2"), this.loggerClassname);
                this.logMessage(null, message, 0);
                throw new BuildException(message, (Throwable)e);
            }
            catch (Exception e) {
                String message = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Unable_to_instantiate_logger__{0}_6"), this.loggerClassname);
                this.logMessage(null, message, 0);
                throw new BuildException(message, (Throwable)e);
            }
        }
        if (this.buildLogger != null) {
            this.buildLogger.setMessageOutputLevel(this.messageOutputLevel);
            this.buildLogger.setOutputPrintStream(this.out);
            this.buildLogger.setErrorPrintStream(this.err);
            this.buildLogger.setEmacsMode(this.emacsMode);
        }
        return this.buildLogger;
    }

    private void fireBuildStarted(Project project) {
        BuildEvent event = new BuildEvent(project);
        Iterator iterator = ((AbstractList)project.getBuildListeners()).iterator();
        while (iterator.hasNext()) {
            BuildListener listener = (BuildListener)iterator.next();
            listener.buildStarted(event);
        }
    }

    private void fireBuildFinished(Project project, Throwable error) {
        BuildEvent event = new BuildEvent(project);
        if (this.usingXmlLogger()) {
            String fileName = project.getProperty("XmlLogger.file");
            if (fileName == null) {
                fileName = "log.xml";
            }
            String realPath = new Path(this.getBuildFileLocation()).toFile().getAbsolutePath();
            Path path = new Path(realPath);
            path = path.removeLastSegments(1);
            path = path.addTrailingSeparator();
            path = path.append(fileName);
            project.setProperty("XmlLogger.file", path.toOSString());
        }
        if (error == null && this.scriptExecuted) {
            this.logMessage(project, InternalAntMessages.getString("InternalAntRunner.BUILD_SUCCESSFUL_1"), 2);
        } else {
            event.setException(error);
        }
        Iterator iterator = ((AbstractList)project.getBuildListeners()).iterator();
        while (iterator.hasNext()) {
            BuildListener listener = (BuildListener)iterator.next();
            listener.buildFinished(event);
        }
    }

    private boolean usingXmlLogger() {
        if (this.buildLogger instanceof XmlLogger) {
            return true;
        }
        if (this.buildListeners != null) {
            Enumeration e = this.getCurrentProject().getBuildListeners().elements();
            while (e.hasMoreElements()) {
                BuildListener element = (BuildListener)e.nextElement();
                if (!(element instanceof XmlLogger)) continue;
                return true;
            }
        }
        return false;
    }

    private void logMessage(Project project, String message, int priority) {
        if (project != null) {
            project.log(message, priority);
        } else if (this.buildListeners != null) {
            project = new Project();
            BuildEvent event = new BuildEvent(project);
            event.setMessage(message, priority);
            Iterator iterator = this.buildListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    BuildListener listener = (BuildListener)iterator.next();
                    listener.messageLogged(event);
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    public void setBuildFileLocation(String buildFileLocation) {
        this.buildFileLocation = buildFileLocation;
        if (this.getCurrentProject() != null) {
            this.getCurrentProject().setUserProperty("ant.file", buildFileLocation);
        }
    }

    public void setInputHandler(String inputHandlerClassname) {
        this.inputHandlerClassname = inputHandlerClassname;
    }

    private String getBuildFileLocation() {
        if (this.buildFileLocation == null) {
            this.buildFileLocation = new File("build.xml").getAbsolutePath();
        }
        return this.buildFileLocation;
    }

    public void setMessageOutputLevel(int level) {
        this.messageOutputLevel = level;
        if (this.buildLogger != null) {
            this.buildLogger.setMessageOutputLevel(level);
        }
    }

    public void setArguments(String[] args) {
        this.extraArguments = args;
    }

    public void setExecutionTargets(String[] executionTargets) {
        this.targets = new Vector(executionTargets.length);
        int i = 0;
        while (i < executionTargets.length) {
            this.targets.add(executionTargets[i]);
            ++i;
        }
    }

    private String getAntVersionNumber() throws BuildException {
        if (this.antVersionNumber == null) {
            try {
                String versionNumber;
                Properties props = new Properties();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.tools.ant.Main");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream in = clazz.getResourceAsStream("/org/apache/tools/ant/version.txt");
                props.load(in);
                in.close();
                this.antVersionNumber = versionNumber = props.getProperty("VERSION");
            }
            catch (IOException ioe) {
                throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Could_not_load_the_version_information._{0}_9"), ioe.getMessage()));
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.Could_not_load_the_version_information._10"));
            }
        }
        return this.antVersionNumber;
    }

    private boolean isVersionCompatible(String comparison) {
        String version = this.getAntVersionNumber();
        return version.compareTo(comparison) >= 0;
    }

    private boolean preprocessCommandLine(List commands) {
        String[] args = this.getArgument(commands, "-listener");
        while (args != null) {
            if (args.length == 0) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_classname_when_using_the_-listener_argument_1"));
            }
            if (this.buildListeners == null) {
                this.buildListeners = new ArrayList(1);
            }
            this.buildListeners.add(args[0]);
            args = this.getArgument(commands, "-listener");
        }
        args = this.getArgument(commands, "-logger");
        if (args != null) {
            if (args.length == 0) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_classname_when_using_the_-logger_argument_2"));
            }
            this.loggerClassname = args[0];
        }
        if ((args = this.getArgument(commands, "-logger")) != null) {
            throw new BuildException(InternalAntMessages.getString("InternalAntRunner.Only_one_logger_class_may_be_specified_1"));
        }
        args = this.getArgument(commands, "-inputhandler");
        if (args != null) {
            if (!this.isVersionCompatible("1.5")) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.Specifying_an_InputHandler_is_an_Ant_1.5.*_feature._Please_update_your_Ant_classpath_to_include_an_Ant_version_greater_than_this._2"));
            }
            if (args.length == 0) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_classname_when_using_the_-inputhandler_argument_1"));
            }
            this.inputHandlerClassname = args[0];
        }
        if ((args = this.getArgument(commands, "-inputhandler")) != null) {
            throw new BuildException(InternalAntMessages.getString("InternalAntRunner.Only_one_input_handler_class_may_be_specified._2"));
        }
        return true;
    }

    private boolean processCommandLine(List commands) {
        if (commands.remove("-help")) {
            this.printUsage();
            return false;
        }
        if (commands.remove("-version")) {
            this.printVersion();
            return false;
        }
        if (commands.remove("-verbose") || commands.remove("-v")) {
            this.printVersion();
            this.setMessageOutputLevel(3);
        }
        if (commands.remove("-debug")) {
            this.printVersion();
            this.setMessageOutputLevel(4);
        }
        if (commands.remove("-quiet") || commands.remove("-q")) {
            this.setMessageOutputLevel(1);
        }
        if (commands.remove("-emacs")) {
            this.emacsMode = true;
            if (this.buildLogger != null) {
                this.buildLogger.setEmacsMode(true);
            }
        }
        if (commands.remove("-diagnostics")) {
            if (!this.isVersionCompatible("1.5")) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.The_diagnositics_options_is_an_Ant_1.5.*_feature._Please_update_your_Ant_classpath_to_include_an_Ant_version_greater_than_this._4"));
            }
            try {
                Diagnostics.doReport((PrintStream)System.out);
            }
            catch (NullPointerException nullPointerException) {
                this.logMessage(this.getCurrentProject(), InternalAntMessages.getString("InternalAntRunner.ANT_HOME_must_be_set_to_use_Ant_diagnostics_2"), 0);
            }
            return false;
        }
        String[] args = this.getArgument(commands, "-logfile");
        if (args == null) {
            args = this.getArgument(commands, "-l");
        }
        if (args != null) {
            if (args.length == 0) {
                String message = InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_log_file_when_using_the_-log_argument_3");
                this.logMessage(this.currentProject, message, 0);
                throw new BuildException(message);
            }
            try {
                this.createLogFile(args[0]);
            }
            catch (IOException iOException) {
                this.logMessage(this.getCurrentProject(), MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Could_not_write_to_the_specified_log_file__{0}._Make_sure_the_path_exists_and_you_have_write_permissions._2"), args[0]), 0);
                return false;
            }
        }
        if ((args = this.getArgument(commands, "-buildfile")) == null && (args = this.getArgument(commands, "-file")) == null) {
            args = this.getArgument(commands, "-f");
        }
        if (args != null) {
            if (args.length == 0) {
                String message = InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_buildfile_when_using_the_-buildfile_argument_4");
                this.logMessage(this.currentProject, message, 0);
                throw new BuildException(message);
            }
            this.setBuildFileLocation(args[0]);
        }
        if ((args = this.getArgument(commands, "-find")) != null) {
            this.logMessage(this.currentProject, InternalAntMessages.getString("InternalAntRunner.-find_not_supported"), 0);
            return false;
        }
        return commands == null || commands.isEmpty() || this.processTargets(commands);
    }

    private boolean processTargets(List commands) {
        if (this.targets == null) {
            this.targets = new Vector(commands.size());
        }
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            if (!arg.startsWith("-")) {
                this.targets.add(arg);
                continue;
            }
            this.logMessage(this.getCurrentProject(), MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Unknown_argument__{0}_2"), arg), 0);
            this.printUsage();
            return false;
        }
        return true;
    }

    private void createLogFile(String fileName) throws FileNotFoundException, IOException {
        File logFile = this.getFileRelativeToBaseDir(fileName);
        this.err = this.out = new PrintStream(new FileOutputStream(logFile));
        this.logMessage(this.getCurrentProject(), MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Using_{0}_file_as_build_log._1"), logFile.getCanonicalPath()), 2);
        if (this.buildLogger != null) {
            this.buildLogger.setErrorPrintStream(this.err);
            this.buildLogger.setOutputPrintStream(this.out);
        }
    }

    private File getFileRelativeToBaseDir(String fileName) {
        Path path = new Path(fileName);
        if (!path.isAbsolute()) {
            String base = this.getCurrentProject().getUserProperty("basedir");
            if (base != null) {
                File baseDir = new File(base);
                if (baseDir != null) {
                    path = new Path(baseDir.getAbsolutePath());
                }
            } else {
                path = new Path(this.getBuildFileLocation());
                path = path.removeLastSegments(1);
            }
            path = path.addTrailingSeparator();
            path = path.append(fileName);
        }
        return path.toFile();
    }

    private void processProperties(List commands) {
        String[] args = this.getArgument(commands, "-propertyfile");
        while (args != null) {
            if (!this.isVersionCompatible("1.5")) {
                this.logMessage(this.currentProject, InternalAntMessages.getString("InternalAntRunner.Specifying_property_files_is_a_Ant_1.5.*_feature._Please_update_your_Ant_classpath._6"), 0);
                break;
            }
            if (args.length == 0) {
                String message = InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_property_filename_when_using_the_-propertyfile_argument_3");
                this.logMessage(this.currentProject, message, 0);
                throw new BuildException(message);
            }
            this.propertyFiles.add(args[0]);
            args = this.getArgument(commands, "-propertyfile");
        }
        String[] globalPropertyFiles = AntCorePlugin.getPlugin().getPreferences().getCustomPropertyFiles();
        if (globalPropertyFiles.length > 0) {
            if (this.propertyFiles == null) {
                this.propertyFiles = new ArrayList(globalPropertyFiles.length);
            }
            this.propertyFiles.addAll(Arrays.asList(globalPropertyFiles));
        }
        if (this.propertyFiles != null && !this.propertyFiles.isEmpty()) {
            this.loadPropertyFiles();
        }
        if (commands == null) {
            return;
        }
        args = commands.toArray(new String[commands.size()]);
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-D")) {
                String name = arg.substring(2, arg.length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else if (i < args.length - 1) {
                    value = args[++i];
                }
                if (this.userProperties == null) {
                    this.userProperties = new HashMap();
                }
                this.userProperties.put(name, value);
                commands.remove(args[i]);
            }
            ++i;
        }
    }

    private void printHelp(Project project) {
        if (project.getDescription() != null) {
            this.logMessage(project, project.getDescription(), 2);
        }
        this.printTargets(project);
    }

    private void printVersion() {
        this.logMessage(this.getCurrentProject(), Main.getAntVersion(), 2);
    }

    private void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [");
        msg.append(InternalAntMessages.getString("InternalAntRunner.options_13"));
        msg.append("] [");
        msg.append(InternalAntMessages.getString("InternalAntRunner.target_15"));
        msg.append(" [");
        msg.append(InternalAntMessages.getString("InternalAntRunner.target_15"));
        msg.append("2 [");
        msg.append(InternalAntMessages.getString("InternalAntRunner.target_15"));
        msg.append("3] ...]]");
        msg.append(lSep);
        msg.append(InternalAntMessages.getString("InternalAntRunner.Options___21"));
        msg.append(lSep);
        msg.append("\t-help\t\t\t\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_this_message_23"));
        msg.append(lSep);
        msg.append("\t-projecthelp\t\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_project_help_information_25"));
        msg.append(lSep);
        msg.append("\t-version\t\t\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_the_version_information_and_exit_27"));
        msg.append(lSep);
        msg.append("\t-diagnostics\t\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_information_that_might_be_helpful_to_12"));
        msg.append(lSep);
        msg.append(InternalAntMessages.getString("InternalAntRunner._t_t_t_t_t_t_t_t_t_t_tdiagnose_or_report_problems._13"));
        msg.append(lSep);
        msg.append("\t-quiet, -q\t\t\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.be_extra_quiet_29"));
        msg.append(lSep);
        msg.append("\t-verbose, -v\t\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.be_extra_verbose_31"));
        msg.append(lSep);
        msg.append("\t-debug\t\t\t\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_debugging_information_33"));
        msg.append(lSep);
        msg.append("\t-emacs\t\t\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.produce_logging_information_without_adornments_35"));
        msg.append(lSep);
        msg.append("\t-logfile\t<file>\t\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.use_given_file_for_log_37"));
        msg.append(lSep);
        msg.append("\t\t-l\t\t<file>");
        msg.append(InternalAntMessages.getString("InternalAntRunner._t_t_t_t_t_t_t_t_____15"));
        msg.append(lSep);
        msg.append("\t-logger <classname>\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.the_class_which_is_to_perform_logging_39"));
        msg.append(lSep);
        msg.append("\t-listener <classname>\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.add_an_instance_of_class_as_a_project_listener_41"));
        msg.append(lSep);
        msg.append("\t-buildfile\t<file>\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.use_given_buildfile_43"));
        msg.append(lSep);
        msg.append("\t\t-file\t\t<file>");
        msg.append(InternalAntMessages.getString("InternalAntRunner._t_t_t_t_t_t_t_____1"));
        msg.append(lSep);
        msg.append("\t\t-f\t\t\t<file>");
        msg.append(InternalAntMessages.getString("InternalAntRunner._t_t_t_t_t_t_t_____1"));
        msg.append(lSep);
        msg.append("\t-D<property>=<value>\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.use_value_for_given_property_45"));
        msg.append(lSep);
        msg.append("\t-propertyfile <name>\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.load_all_properties_from_file_with_-D_19"));
        msg.append(lSep);
        msg.append(InternalAntMessages.getString("InternalAntRunner._t_t_t_t_t_t_t_t_t_t_tproperties_taking_precedence_20"));
        msg.append(lSep);
        msg.append("\t-inputhandler <class>\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.the_class_which_will_handle_input_requests_22"));
        msg.append(lSep);
        this.logMessage(this.getCurrentProject(), msg.toString(), 2);
    }

    private String[] getArgument(List commands, String param) {
        if (commands == null) {
            return null;
        }
        int index = commands.indexOf(param);
        if (index == -1) {
            return null;
        }
        commands.remove(index);
        if (index == commands.size()) {
            return new String[0];
        }
        String[] args = new String[1];
        String command = (String)commands.get(index);
        if (command.startsWith("-")) {
            return new String[0];
        }
        args[0] = command;
        commands.remove(index);
        return args;
    }

    private ArrayList getArrayList(String[] args) {
        if (args == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(args.length);
        int i = 0;
        while (i < args.length) {
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private Project getCurrentProject() {
        return this.currentProject;
    }

    private void setCurrentProject(Project currentProject) {
        this.currentProject = currentProject;
    }

    public String getBuildExceptionErrorMessage(Throwable t) {
        if (t instanceof BuildException) {
            return t.toString();
        }
        return null;
    }

    private void loadPropertyFiles() {
        Iterator itr = this.propertyFiles.iterator();
        while (itr.hasNext()) {
            Object var8_9;
            String filename = (String)itr.next();
            File file = this.getFileRelativeToBaseDir(filename);
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    props.load(fis);
                }
                catch (IOException e) {
                    String msg = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Could_not_load_property_file_{0}__{1}_4"), filename, e.getMessage());
                    this.logMessage(this.getCurrentProject(), msg, 0);
                }
            }
            catch (Throwable throwable) {
                var8_9 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            var8_9 = null;
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (this.userProperties == null) {
                this.userProperties = new HashMap();
            }
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (this.userProperties.get(name) != null) continue;
                this.userProperties.put(name, props.getProperty(name));
            }
        }
    }

    private void addInputHandler(Project project) {
        if (!this.isVersionCompatible("1.5")) {
            return;
        }
        InputHandlerSetter setter = new InputHandlerSetter();
        setter.setInputHandler(project, this.inputHandlerClassname);
    }

    private void setJavaClassPath() {
        org.apache.tools.ant.types.Path systemClasspath;
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        URL[] antClasspath = prefs.getAntURLs();
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < antClasspath.length) {
            block3: {
                URL url = antClasspath[i];
                Path path = null;
                try {
                    path = new Path(Platform.asLocalURL((URL)url).getFile());
                }
                catch (IOException iOException) {
                    break block3;
                }
                buff.append(path.toOSString());
                buff.append("; ");
            }
            ++i;
        }
        org.apache.tools.ant.types.Path.systemClasspath = systemClasspath = new org.apache.tools.ant.types.Path(null, buff.substring(0, buff.length() - 2));
    }
}

