/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.localstore.FileSystemStore;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;

class ResourceTree
implements IResourceTree {
    private MultiStatus status;
    private int updateFlags;
    private boolean isValid = true;

    public ResourceTree(MultiStatus status, int updateFlags) {
        this.status = status;
        this.updateFlags = updateFlags;
    }

    void makeInvalid() {
        this.isValid = false;
    }

    public void addToLocalHistory(IFile file) {
        Assert.isLegal(this.isValid);
        if (!file.exists()) {
            return;
        }
        IPath path = file.getLocation();
        if (path == null || !path.toFile().exists()) {
            return;
        }
        long lastModified = this.internalComputeTimestamp(path.toOSString());
        ((Resource)((Object)file)).getLocalManager().getHistoryStore().addState(file.getFullPath(), path, lastModified, false);
    }

    private void copyLocalHistory(IResource source, IResource destination) {
        ((Resource)destination).getLocalManager().getHistoryStore().copyHistory(source.getFullPath(), destination.getFullPath());
    }

    public void movedFile(IFile source, IFile destination) {
        ResourceStatus status;
        String message;
        Assert.isLegal(this.isValid);
        if (!source.exists()) {
            return;
        }
        if (destination.exists()) {
            String message2 = Policy.bind("resources.mustNotExist", destination.getFullPath().toString());
            ResourceStatus status2 = new ResourceStatus(4, destination.getFullPath(), message2);
            this.failed(status2);
        }
        PropertyManager propertyManager = ((Resource)((Object)source)).getPropertyManager();
        try {
            propertyManager.copy(source, destination, 0);
            propertyManager.deleteProperties(source, 0);
        }
        catch (CoreException e) {
            String message3 = Policy.bind("resources.errorPropertiesMove", source.getFullPath().toString(), destination.getFullPath().toString());
            ResourceStatus status3 = new ResourceStatus(4, source.getFullPath(), message3, e);
            this.failed(status3);
        }
        Workspace workspace = (Workspace)source.getWorkspace();
        try {
            workspace.move((Resource)((Object)source), destination.getFullPath(), 0, this.updateFlags, false);
        }
        catch (CoreException e) {
            message = Policy.bind("resources.errorMoving", source.getFullPath().toString(), destination.getFullPath().toString());
            status = new ResourceStatus(4, source.getFullPath(), message, e);
            this.failed(status);
        }
        try {
            workspace.getMarkerManager().moved(source, destination, 0);
        }
        catch (CoreException e) {
            message = Policy.bind("resources.errorMarkersDelete", source.getFullPath().toString());
            status = new ResourceStatus(4, source.getFullPath(), message, e);
            this.failed(status);
        }
        this.copyLocalHistory(source, destination);
    }

    public void movedFolderSubtree(IFolder source, IFolder destination) {
        ResourceStatus status;
        String message;
        Assert.isLegal(this.isValid);
        if (!source.exists()) {
            return;
        }
        if (destination.exists()) {
            String message2 = Policy.bind("resources.mustNotExist", destination.getFullPath().toString());
            ResourceStatus status2 = new ResourceStatus(4, destination.getFullPath(), message2);
            this.failed(status2);
            return;
        }
        int depth = 2;
        PropertyManager propertyManager = ((Resource)((Object)source)).getPropertyManager();
        try {
            propertyManager.copy(source, destination, depth);
            propertyManager.deleteProperties(source, depth);
        }
        catch (CoreException e) {
            String message3 = Policy.bind("resources.errorPropertiesMove", source.getFullPath().toString(), destination.getFullPath().toString());
            ResourceStatus status3 = new ResourceStatus(4, source.getFullPath(), message3, e);
            this.failed(status3);
        }
        Workspace workspace = (Workspace)source.getWorkspace();
        try {
            workspace.move((Resource)((Object)source), destination.getFullPath(), depth, this.updateFlags, false);
        }
        catch (CoreException e) {
            message = Policy.bind("resources.errorMoving", source.getFullPath().toString(), destination.getFullPath().toString());
            status = new ResourceStatus(4, source.getFullPath(), message, e);
            this.failed(status);
        }
        try {
            workspace.getMarkerManager().moved(source, destination, depth);
        }
        catch (CoreException e) {
            message = Policy.bind("resources.errorMarkersDelete", source.getFullPath().toString());
            status = new ResourceStatus(4, source.getFullPath(), message, e);
            this.failed(status);
        }
        this.copyLocalHistory(source, destination);
    }

    public boolean movedProjectSubtree(IProject project, IProjectDescription destDescription) {
        ResourceStatus status;
        String message;
        ResourceStatus status2;
        String message2;
        Assert.isLegal(this.isValid);
        if (!project.exists()) {
            return true;
        }
        Project source = (Project)project;
        Project destination = (Project)source.getWorkspace().getRoot().getProject(destDescription.getName());
        ProjectDescription srcDescription = source.internalGetDescription();
        Workspace workspace = (Workspace)source.getWorkspace();
        int depth = 2;
        if (this.isNameChange(source, destDescription)) {
            if (destination.exists()) {
                String message3 = Policy.bind("resources.mustNotExist", destination.getFullPath().toString());
                ResourceStatus status3 = new ResourceStatus(4, destination.getFullPath(), message3);
                this.failed(status3);
                return false;
            }
            try {
                source.getPropertyManager().closePropertyStore(source);
            }
            catch (CoreException e) {
                message2 = Policy.bind("properties.couldNotClose", source.getFullPath().toString());
                status2 = new ResourceStatus(4, source.getFullPath(), message2, e);
                this.failed(status2);
            }
            java.io.File oldMetaArea = workspace.getMetaArea().locationFor(source).toFile();
            java.io.File newMetaArea = workspace.getMetaArea().locationFor(destination).toFile();
            try {
                source.getLocalManager().getStore().move(oldMetaArea, newMetaArea, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                message = Policy.bind("resources.moveMeta", oldMetaArea.toString(), newMetaArea.toString());
                status = new ResourceStatus(568, destination.getFullPath(), message, e);
                this.failed(status);
            }
            try {
                workspace.move(source, destination.getFullPath(), depth, this.updateFlags, true);
            }
            catch (CoreException e) {
                message = Policy.bind("resources.errorMoving", source.getFullPath().toString(), destination.getFullPath().toString());
                status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
            }
            ProjectInfo info = (ProjectInfo)destination.getResourceInfo(false, true);
            info.clearNatures();
            info.setBuilders(null);
            try {
                workspace.getMarkerManager().moved(source, destination, depth);
            }
            catch (CoreException e) {
                String message4 = Policy.bind("resources.errorMarkersMove", source.getFullPath().toString(), destination.getFullPath().toString());
                ResourceStatus status4 = new ResourceStatus(4, source.getFullPath(), message4, e);
                this.failed(status4);
            }
            this.copyLocalHistory(source, destination);
        }
        try {
            ((ProjectDescription)destDescription).setLinkDescriptions(destination.internalGetDescription().getLinks());
            destination.internalSetDescription(destDescription, true);
            destination.writeDescription(1);
        }
        catch (CoreException e) {
            message2 = Policy.bind("resources.projectDesc");
            status2 = new ResourceStatus(4, destination.getFullPath(), message2, e);
            this.failed(status2);
        }
        IPath srcLocation = srcDescription.getLocation();
        IPath destLocation = destDescription.getLocation();
        if (srcLocation == null && destLocation != null || srcLocation != null && !srcLocation.equals((Object)destLocation)) {
            try {
                workspace.getMetaArea().writeLocation(destination);
            }
            catch (CoreException e) {
                this.failed(e.getStatus());
            }
        }
        try {
            destination.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            message = Policy.bind("resources.errorRefresh", destination.getFullPath().toString());
            status = new ResourceStatus(4, destination.getFullPath(), message, e);
            this.failed(status);
            return false;
        }
        return true;
    }

    protected IStatus getStatus() {
        return this.status;
    }

    public long getTimestamp(IFile file) {
        Assert.isLegal(this.isValid);
        if (!file.exists()) {
            return 0L;
        }
        ResourceInfo info = ((File)file).getResourceInfo(false, false);
        return info == null ? 0L : info.getLocalSyncInfo();
    }

    public void deletedFile(IFile file) {
        Assert.isLegal(this.isValid);
        if (!file.exists()) {
            return;
        }
        try {
            ((Resource)((Object)file)).deleteResource(true, null);
        }
        catch (CoreException e) {
            String message = Policy.bind("resources.errorDeleting", file.getFullPath().toString());
            ResourceStatus status = new ResourceStatus(4, file.getFullPath(), message, e);
            this.failed(status);
        }
    }

    public void deletedFolder(IFolder folder) {
        Assert.isLegal(this.isValid);
        if (!folder.exists()) {
            return;
        }
        try {
            ((Resource)((Object)folder)).deleteResource(true, null);
        }
        catch (CoreException e) {
            String message = Policy.bind("resources.errorDeleting", folder.getFullPath().toString());
            ResourceStatus status = new ResourceStatus(4, folder.getFullPath(), message, e);
            this.failed(status);
        }
    }

    public void deletedProject(IProject target) {
        ResourceStatus status;
        String message;
        Assert.isLegal(this.isValid);
        if (!target.exists()) {
            return;
        }
        Project project = (Project)target;
        Workspace workspace = (Workspace)project.getWorkspace();
        try {
            project.deleteResource(false, null);
        }
        catch (CoreException e) {
            message = Policy.bind("resources.errorDeleting", project.getFullPath().toString());
            status = new ResourceStatus(4, project.getFullPath(), message, e);
            this.failed(status);
        }
        try {
            workspace.getMetaArea().delete(project);
        }
        catch (CoreException e) {
            message = Policy.bind("resources.deleteMeta", project.getFullPath().toString());
            status = new ResourceStatus(569, project.getFullPath(), message, e);
            this.failed(status);
        }
        try {
            project.clearHistory(null);
        }
        catch (CoreException e) {
            message = Policy.bind("history.problemsRemoving", project.getFullPath().toString());
            status = new ResourceStatus(273, project.getFullPath(), message, e);
            this.failed(status);
        }
    }

    public void failed(IStatus reason) {
        Assert.isLegal(this.isValid);
        this.status.add(reason);
    }

    private boolean isNameChange(IProject project, IProjectDescription description) {
        return !project.getName().equals(description.getName());
    }

    private boolean isContentChange(IProject project, IProjectDescription destinationDescription) {
        ProjectDescription sourceDescription = ((Project)project).internalGetDescription();
        if (sourceDescription.getLocation() == null || destinationDescription.getLocation() == null) {
            return true;
        }
        return !sourceDescription.getLocation().equals((Object)destinationDescription.getLocation());
    }

    private boolean isCaseChange(IProject project, IProjectDescription description) {
        return !project.getName().equals(description.getName()) && project.getName().equalsIgnoreCase(description.getName());
    }

    public boolean isSynchronized(IResource resource, int depth) {
        return ((Resource)resource).getLocalManager().isSynchronized(resource, depth);
    }

    public long computeTimestamp(IFile file) {
        Assert.isLegal(this.isValid);
        if (!file.getProject().exists()) {
            return 0L;
        }
        return this.internalComputeTimestamp(file.getLocation().toOSString());
    }

    protected long internalComputeTimestamp(String location) {
        return CoreFileSystemLibrary.getLastModified(location);
    }

    public void standardDeleteFile(IFile file, int updateFlags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        this.internalDeleteFile(file, updateFlags, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalDeleteFile(IFile file, int updateFlags, IProgressMonitor monitor) {
        block13: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    boolean inSync;
                                    boolean force;
                                    String message = Policy.bind("resources.deleting", file.getFullPath().toString());
                                    monitor.beginTask(message, Policy.totalWork);
                                    if (!file.exists()) {
                                        Object var10_5 = null;
                                        break block8;
                                    }
                                    if (file.isLinked()) {
                                        this.deletedFile(file);
                                        break block9;
                                    }
                                    java.io.File fileOnDisk = file.getLocation().toFile();
                                    if (!fileOnDisk.exists()) {
                                        this.deletedFile(file);
                                        break block10;
                                    }
                                    boolean keepHistory = (updateFlags & 2) != 0;
                                    boolean bl = force = (updateFlags & 1) != 0;
                                    if (keepHistory) {
                                        this.addToLocalHistory(file);
                                    }
                                    monitor.worked(Policy.totalWork / 4);
                                    if (!force && !(inSync = this.isSynchronized(file, 0)) && file.getLocation().toFile().exists()) {
                                        message = Policy.bind("localstore.resourceIsOutOfSync", file.getFullPath().toString());
                                        ResourceStatus status = new ResourceStatus(274, file.getFullPath(), message);
                                        this.failed(status);
                                        break block11;
                                    }
                                    monitor.worked(Policy.totalWork / 4);
                                    boolean success = fileOnDisk.delete();
                                    monitor.worked(Policy.totalWork / 4);
                                    if (success) {
                                        this.deletedFile(file);
                                        break block12;
                                    }
                                    message = Policy.bind("resources.couldnotDelete", file.getLocation().toOSString());
                                    ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message);
                                    this.failed(status);
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var10_11 = null;
                                    monitor.done();
                                    throw throwable;
                                }
                            }
                            monitor.done();
                            return true;
                        }
                        Object var10_6 = null;
                        monitor.done();
                        return true;
                    }
                    Object var10_7 = null;
                    monitor.done();
                    return true;
                }
                Object var10_8 = null;
                monitor.done();
                return false;
            }
            Object var10_9 = null;
            monitor.done();
            return true;
        }
        Object var10_10 = null;
        monitor.done();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardDeleteFolder(IFolder folder, int updateFlags, IProgressMonitor monitor) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            Assert.isLegal(this.isValid);
                            try {
                                boolean success;
                                boolean keepHistory;
                                boolean force;
                                String message = Policy.bind("resources.deleting", folder.getFullPath().toString());
                                monitor.beginTask(message, Policy.totalWork);
                                if (!folder.exists()) {
                                    Object var11_5 = null;
                                    break block12;
                                }
                                if (folder.isLinked()) {
                                    this.deletedFolder(folder);
                                    break block13;
                                }
                                java.io.File folderOnDisk = folder.getLocation().toFile();
                                if (!folderOnDisk.exists()) {
                                    this.deletedFolder(folder);
                                    break block14;
                                }
                                boolean bl = force = (updateFlags & 1) != 0;
                                if (!force && !this.isSynchronized(folder, 2)) {
                                    this.internalDeleteFolder(folder, updateFlags, monitor);
                                    break block15;
                                }
                                boolean bl2 = keepHistory = (updateFlags & 2) != 0;
                                if (keepHistory) {
                                    this.addToLocalHistory(folder, 2);
                                }
                                try {
                                    FileSystemResourceManager localManager = ((Folder)folder).getLocalManager();
                                    localManager.delete(folder, force, true, false, monitor);
                                    java.io.File folderLocation = folder.getLocation().toFile();
                                    success = Workspace.clear(folderLocation);
                                }
                                catch (CoreException ce) {
                                    message = Policy.bind("localstore.couldnotDelete", folder.getFullPath().toString());
                                    MultiStatus status = new MultiStatus("org.eclipse.core.resources", 273, message, (Throwable)ce);
                                    if (ce.getStatus() != null) {
                                        status.merge(ce.getStatus());
                                    }
                                    this.failed((IStatus)status);
                                    Object var11_9 = null;
                                    monitor.done();
                                    return;
                                }
                                if (success) {
                                    this.deletedFolder(folder);
                                    break block16;
                                } else {
                                    message = Policy.bind("resources.couldnotDelete", folder.getLocation().toOSString());
                                    ResourceStatus status = new ResourceStatus(273, folder.getFullPath(), message);
                                    this.failed(status);
                                }
                                break block16;
                            }
                            catch (Throwable throwable) {
                                Object var11_10 = null;
                                monitor.done();
                                throw throwable;
                            }
                        }
                        monitor.done();
                        return;
                    }
                    Object var11_6 = null;
                    monitor.done();
                    return;
                }
                Object var11_7 = null;
                monitor.done();
                return;
            }
            Object var11_8 = null;
            monitor.done();
            return;
        }
        Object var11_11 = null;
        monitor.done();
    }

    private void addToLocalHistory(IResource root, int depth) {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1) {
                    ResourceTree.this.addToLocalHistory((IFile)resource);
                }
                return true;
            }
        };
        try {
            root.accept(visitor, depth, false);
        }
        catch (CoreException coreException) {}
    }

    private boolean internalDeleteFolder(IFolder folder, int updateFlags, IProgressMonitor monitor) {
        IResource[] members = null;
        try {
            members = folder.members(2);
        }
        catch (CoreException e) {
            String message = Policy.bind("resources.errorMembers", folder.getFullPath().toString());
            ResourceStatus status = new ResourceStatus(4, folder.getFullPath(), message, e);
            this.failed(status);
            return false;
        }
        boolean deletedChildren = true;
        int i = 0;
        while (i < members.length) {
            IResource child = members[i];
            switch (child.getType()) {
                case 1: {
                    deletedChildren &= this.internalDeleteFile((IFile)child, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork / members.length));
                    break;
                }
                case 2: {
                    deletedChildren &= this.internalDeleteFolder((IFolder)child, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork / members.length));
                }
            }
            ++i;
        }
        if (!deletedChildren) {
            return false;
        }
        java.io.File folderOnDisk = folder.getLocation().toFile();
        boolean success = folderOnDisk.delete();
        if (!success && !folderOnDisk.exists()) {
            success = true;
        }
        if (success) {
            this.deletedFolder(folder);
            return true;
        }
        String message = Policy.bind("resources.couldnotDelete", folder.getLocation().toOSString());
        ResourceStatus status = new ResourceStatus(273, folder.getFullPath(), message);
        this.failed(status);
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardDeleteProject(IProject project, int updateFlags, IProgressMonitor monitor) {
        block16: {
            block15: {
                block14: {
                    Assert.isLegal(this.isValid);
                    try {
                        message = Policy.bind("resources.deleting", project.getFullPath().toString());
                        monitor.beginTask(message, Policy.totalWork);
                        if (!project.exists()) {
                            var14_5 = null;
                            break block14;
                        }
                        v0 = alwaysDeleteContent = (updateFlags & 4) != 0;
                        force = alwaysDeleteContent != false ? true : (updateFlags & 1) != 0;
                        neverDeleteContent = (updateFlags & 8) != 0;
                        success = true;
                        if (alwaysDeleteContent || project.isOpen() && !neverDeleteContent) {
                            if (!force && !this.isSynchronized(project, 2)) {
                                success = this.internalDeleteProject(project, updateFlags, monitor);
                                if (success) {
                                    this.deletedProject(project);
                                    break block15;
                                } else {
                                    message = Policy.bind("resources.couldnotDelete", project.getLocation().toOSString());
                                    status = new ResourceStatus(273, project.getFullPath(), message);
                                    this.failed(status);
                                }
                                break block15;
                            }
                            description = ((Project)project).internalGetDescription();
                            defaultLocation = description == null || description.getLocation() == null;
                            projectLocation = project.getLocation().toFile();
                            if (project.isOpen()) {
                                try {
                                    localManager = ((Project)project).getLocalManager();
                                    localManager.delete(project, force, false, false, Policy.subMonitorFor(monitor, Policy.totalWork * 3 / 4));
                                    if (!defaultLocation) ** GOTO lbl47
                                    success = Workspace.clear(projectLocation);
                                }
                                catch (CoreException ce) {
                                    message = Policy.bind("localstore.couldnotDelete", project.getFullPath().toString());
                                    status = new MultiStatus("org.eclipse.core.resources", 273, message, (Throwable)ce);
                                    if (ce.getStatus() != null) {
                                        status.merge(ce.getStatus());
                                    }
                                    this.failed((IStatus)status);
                                    var14_7 = null;
                                    monitor.done();
                                    return;
                                }
                            } else {
                                success = defaultLocation != false ? Workspace.clear(projectLocation) : Workspace.clearChildren(projectLocation);
                                monitor.worked(Policy.totalWork * 3 / 4);
                            }
                        }
lbl47:
                        // 5 sources

                        if (success) {
                            this.deletedProject(project);
                            break block16;
                        } else {
                            message = Policy.bind("localstore.couldnotDelete", project.getFullPath().toString());
                            status = new ResourceStatus(273, project.getFullPath(), message);
                            this.failed(status);
                        }
                        break block16;
                    }
                    catch (Throwable var15_21) {
                        var14_8 = null;
                        monitor.done();
                        throw var15_21;
                    }
                }
                monitor.done();
                return;
            }
            var14_6 = null;
            monitor.done();
            return;
        }
        var14_9 = null;
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void moveProjectContent(IProject source, IProjectDescription destDescription, int updateFlags, IProgressMonitor monitor) throws CoreException {
        block13: {
            block12: {
                try {
                    String message = Policy.bind("resources.moving", source.getFullPath().toString());
                    monitor.beginTask(message, 10);
                    IProjectDescription srcDescription = source.getDescription();
                    if (srcDescription.getLocation() != null && srcDescription.getLocation().equals((Object)destDescription)) {
                        Object var15_7 = null;
                        break block12;
                    }
                    IPath srcLocation = source.getLocation();
                    IPath destLocation = destDescription.getLocation();
                    if (destLocation == null) {
                        destLocation = Platform.getLocation().append(destDescription.getName());
                    }
                    java.io.File destinationFile = destLocation.toFile();
                    try {
                        this.moveInFileSystem(srcLocation.toFile(), destinationFile, updateFlags, monitor);
                    }
                    catch (CoreException ce) {
                        boolean failedDeletingSource;
                        boolean bl = failedDeletingSource = ce instanceof ResourceException && ce.getStatus().getCode() == 273 && destinationFile.exists();
                        if (!failedDeletingSource) {
                            throw ce;
                        }
                        this.failed(ce.getStatus());
                    }
                    monitor.worked(9);
                    if ((updateFlags & 0x20) == 0) {
                        IResource[] children = source.members();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i].isLinked()) {
                                message = Policy.bind("resources.moving", children[i].getFullPath().toString());
                                monitor.subTask(message);
                                java.io.File sourceFile = children[i].getLocation().toFile();
                                java.io.File destFile = destLocation.append(children[i].getName()).toFile();
                                try {
                                    this.moveInFileSystem(sourceFile, destFile, updateFlags, Policy.monitorFor(null));
                                }
                                catch (CoreException ce) {
                                    this.failed(ce.getStatus());
                                }
                            }
                            ++i;
                        }
                    }
                    monitor.worked(1);
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var15_8 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var15_9 = null;
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardMoveFile(IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        block11: {
            block9: {
                block8: {
                    Assert.isLegal(this.isValid);
                    try {
                        block10: {
                            boolean isDeep;
                            String message = Policy.bind("resources.moving", source.getFullPath().toString());
                            monitor.subTask(message);
                            if (!source.exists()) throw new IllegalArgumentException();
                            if (destination.exists()) throw new IllegalArgumentException();
                            if (!destination.getParent().isAccessible()) {
                                throw new IllegalArgumentException();
                            }
                            boolean force = (updateFlags & 1) != 0;
                            boolean keepHistory = (updateFlags & 2) != 0;
                            boolean bl = isDeep = (updateFlags & 0x20) == 0;
                            if (!force && !this.isSynchronized(source, 2)) {
                                message = Policy.bind("localstore.resourceIsOutOfSync", source.getFullPath().toString());
                                ResourceStatus status = new ResourceStatus(274, source.getFullPath(), message);
                                this.failed(status);
                                Object var13_11 = null;
                                break block8;
                            }
                            monitor.worked(Policy.totalWork / 4);
                            if (keepHistory) {
                                this.addToLocalHistory(source);
                            }
                            monitor.worked(Policy.totalWork / 4);
                            if (!isDeep && source.isLinked()) {
                                this.movedFile(source, destination);
                                break block9;
                            }
                            java.io.File sourceFile = source.getLocation().toFile();
                            java.io.File destFile = destination.getLocation().toFile();
                            try {
                                this.moveInFileSystem(sourceFile, destFile, updateFlags, monitor);
                            }
                            catch (CoreException e) {
                                boolean failedDeletingSource;
                                this.failed(e.getStatus());
                                boolean bl2 = failedDeletingSource = e instanceof ResourceException && e.getStatus().getCode() == 273 && destFile.exists();
                                if (failedDeletingSource) break block10;
                                Object var13_13 = null;
                                monitor.done();
                                return;
                            }
                        }
                        this.movedFile(source, destination);
                        this.updateMovedFileTimestamp(destination, this.computeTimestamp(destination));
                        monitor.worked(Policy.totalWork / 4);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return;
            }
            Object var13_12 = null;
            monitor.done();
            return;
        }
        Object var13_14 = null;
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardMoveFolder(IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        block13: {
            block11: {
                block10: {
                    Assert.isLegal(this.isValid);
                    try {
                        java.io.File destinationFile;
                        boolean isDeep;
                        String message;
                        block12: {
                            boolean keepHistory;
                            boolean force;
                            message = Policy.bind("resources.moving", source.getFullPath().toString());
                            monitor.subTask(message);
                            if (!source.exists()) throw new IllegalArgumentException();
                            if (destination.exists()) throw new IllegalArgumentException();
                            if (!destination.getParent().isAccessible()) {
                                throw new IllegalArgumentException();
                            }
                            boolean bl = force = (updateFlags & 1) != 0;
                            if (!force && !this.isSynchronized(source, 2)) {
                                message = Policy.bind("localstore.resourceIsOutOfSync", source.getFullPath().toString());
                                ResourceStatus status = new ResourceStatus(4, source.getFullPath(), message);
                                this.failed(status);
                                Object var13_9 = null;
                                break block10;
                            }
                            boolean bl2 = keepHistory = (updateFlags & 2) != 0;
                            if (keepHistory) {
                                this.addToLocalHistory(source, 2);
                            }
                            boolean bl3 = isDeep = (updateFlags & 0x20) == 0;
                            if (!isDeep && source.isLinked()) {
                                this.movedFolderSubtree(source, destination);
                                break block11;
                            }
                            java.io.File sourceFile = source.getLocation().toFile();
                            destinationFile = destination.getLocation().toFile();
                            try {
                                this.moveInFileSystem(sourceFile, destinationFile, updateFlags, monitor);
                            }
                            catch (CoreException e) {
                                boolean failedDeletingSource;
                                this.failed(e.getStatus());
                                boolean bl4 = failedDeletingSource = e instanceof ResourceException && e.getStatus().getCode() == 273 && destinationFile.exists();
                                if (failedDeletingSource) break block12;
                                Object var13_11 = null;
                                monitor.done();
                                return;
                            }
                        }
                        boolean success = destinationFile.exists();
                        if (success) {
                            this.movedFolderSubtree(source, destination);
                            this.updateTimestamps(destination, isDeep);
                            break block13;
                        } else {
                            message = Policy.bind("localstore.couldNotCreateFolder", destination.getLocation().toOSString());
                            ResourceStatus status = new ResourceStatus(272, destination.getFullPath(), message);
                            this.failed(status);
                        }
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var13_12 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return;
            }
            Object var13_10 = null;
            monitor.done();
            return;
        }
        Object var13_13 = null;
        monitor.done();
    }

    private void updateTimestamps(IResource root, final boolean isDeep) {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                boolean isLinked = resource.isLinked();
                if (isLinked && !isDeep) {
                    return false;
                }
                if (resource.getType() == 1) {
                    IFile file = (IFile)resource;
                    ResourceTree.this.updateMovedFileTimestamp(file, ResourceTree.this.computeTimestamp(file));
                } else if (isLinked) {
                    ResourceInfo info = ((Resource)resource).getResourceInfo(false, true);
                    info.clear(65536);
                }
                return true;
            }
        };
        try {
            root.accept(visitor, 2, 2);
        }
        catch (CoreException coreException) {}
    }

    private boolean internalDeleteProject(IProject project, int updateFlags, IProgressMonitor monitor) {
        boolean success;
        IResource[] members = null;
        try {
            members = project.members(2);
        }
        catch (CoreException e) {
            String message = Policy.bind("resources.errorMembers", project.getFullPath().toString());
            ResourceStatus status = new ResourceStatus(4, project.getFullPath(), message, e);
            this.failed(status);
            return false;
        }
        boolean deletedChildren = true;
        int i = 0;
        while (i < members.length) {
            IResource child = members[i];
            switch (child.getType()) {
                case 1: {
                    if (child.getName().equals(".project")) break;
                    deletedChildren &= this.internalDeleteFile((IFile)child, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork / members.length));
                    break;
                }
                case 2: {
                    deletedChildren &= this.internalDeleteFolder((IFolder)child, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork / members.length));
                }
            }
            ++i;
        }
        if (deletedChildren) {
            IResource file = project.findMember(".project");
            if (file != null) {
                if (file.getType() != 1) {
                    String message = Policy.bind("resources.couldnotDelete", file.getFullPath().toString());
                    ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message);
                    this.failed(status);
                    return false;
                }
                boolean deletedProjectFile = this.internalDeleteFile((IFile)file, updateFlags, Policy.monitorFor(null));
                if (!deletedProjectFile) {
                    String message = Policy.bind("resources.couldnotDelete", file.getFullPath().toString());
                    ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message);
                    this.failed(status);
                    return false;
                }
            }
        } else {
            return false;
        }
        java.io.File root = project.getLocation().toFile();
        ProjectDescription description = ((Project)project).internalGetDescription();
        if (description == null || description.getLocation() == null) {
            success = root.delete();
            if (!success && !root.exists()) {
                success = true;
            }
        } else {
            String[] children = root.list();
            boolean bl = success = children == null || children.length == 0;
        }
        if (success) {
            this.deletedProject(project);
            return true;
        }
        String message = Policy.bind("resources.couldnotDelete", project.getLocation().toOSString());
        ResourceStatus status = new ResourceStatus(273, project.getFullPath(), message);
        this.failed(status);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void standardMoveProject(IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        block9: {
            block8: {
                block7: {
                    Assert.isLegal(this.isValid);
                    try {
                        boolean force;
                        String message = Policy.bind("resources.moving", source.getFullPath().toString());
                        monitor.beginTask(message, Policy.totalWork);
                        if (!source.isAccessible()) {
                            throw new IllegalArgumentException();
                        }
                        if (!this.isContentChange(source, description)) {
                            this.movedProjectSubtree(source, description);
                            Object var9_6 = null;
                            break block7;
                        }
                        boolean bl = force = (updateFlags & 1) != 0;
                        if (!force && !this.isSynchronized(source, 2)) {
                            message = Policy.bind("localstore.resourceIsOutOfSync", source.getFullPath().toString());
                            ResourceStatus status = new ResourceStatus(274, source.getFullPath(), message);
                            this.failed(status);
                            break block8;
                        }
                        try {
                            this.moveProjectContent(source, description, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork * 3 / 4));
                        }
                        catch (CoreException e) {
                            message = Policy.bind("localstore.couldNotMove", source.getFullPath().toString());
                            ResourceStatus status = new ResourceStatus(4, source.getFullPath(), message, e);
                            this.failed(status);
                            Object var9_8 = null;
                            monitor.done();
                            return;
                        }
                        this.movedProjectSubtree(source, description);
                        monitor.worked(Policy.totalWork * 1 / 8);
                        boolean isDeep = (updateFlags & 0x20) == 0;
                        this.updateTimestamps(source.getWorkspace().getRoot().getProject(description.getName()), isDeep);
                        monitor.worked(Policy.totalWork * 1 / 8);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return;
            }
            Object var9_7 = null;
            monitor.done();
            return;
        }
        Object var9_10 = null;
        monitor.done();
    }

    private void moveLinkedChildren(IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
    }

    private void moveInFileSystem(java.io.File source, java.io.File destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal(this.isValid);
        FileSystemStore store = ((Resource)((Object)ResourcesPlugin.getWorkspace().getRoot())).getLocalManager().getStore();
        boolean force = (updateFlags & 1) != 0;
        store.move(source, destination, force, monitor);
    }

    public void updateMovedFileTimestamp(IFile file, long timestamp) {
        Assert.isLegal(this.isValid);
        if (!file.exists()) {
            return;
        }
        ResourceInfo info = ((Resource)((Object)file)).getResourceInfo(false, true);
        ((Resource)((Object)file)).getLocalManager().updateLocalSync(info, timestamp);
        info.clear(65536);
    }
}

