/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.watson.IElementComparator;

public class ResourceComparator
implements IElementComparator,
ICoreConstants {
    boolean notification;
    protected static ResourceComparator markerSingleton;
    protected static ResourceComparator noMarkerSingleton;

    private ResourceComparator(boolean notification) {
        this.notification = notification;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        int result = 0;
        if (o1 == null) {
            return ((ResourceInfo)o2).isSet(8) ? 8 : 1;
        }
        if (o2 == null) {
            return ((ResourceInfo)o1).isSet(8) ? 16 : 2;
        }
        if (!(o1 instanceof ResourceInfo) || !(o2 instanceof ResourceInfo)) {
            return 0;
        }
        ResourceInfo oldElement = (ResourceInfo)o1;
        ResourceInfo newElement = (ResourceInfo)o2;
        if (!oldElement.isSet(8) && newElement.isSet(8)) {
            return 2;
        }
        if (oldElement.isSet(8) && !newElement.isSet(8)) {
            return 1;
        }
        if (!this.compareOpen(oldElement, newElement)) {
            result |= 0x4000;
        }
        if (!this.compareContents(oldElement, newElement)) {
            result = oldElement.getType() == 4 ? (result |= 0x80000) : (result |= 0x100);
        }
        if (!this.compareType(oldElement, newElement)) {
            result |= 0x8000;
        }
        if (!this.compareNodeIDs(oldElement, newElement)) {
            result |= 0x40000;
            if (oldElement.getType() == 1 && newElement.getType() == 1) {
                result |= 0x100;
            }
        }
        if (this.notification && !this.compareSync(oldElement, newElement)) {
            result |= 0x10000;
        }
        if (this.notification && !this.compareMarkers(oldElement, newElement)) {
            result |= 0x20000;
        }
        return result == 0 ? 0 : result | 4;
    }

    private boolean compareContents(ResourceInfo oldElement, ResourceInfo newElement) {
        return oldElement.getContentId() == newElement.getContentId();
    }

    private boolean compareMarkers(ResourceInfo oldElement, ResourceInfo newElement) {
        boolean bothNull;
        boolean bl = bothNull = oldElement.getMarkers() == null && newElement.getMarkers() == null;
        return bothNull || oldElement.getMarkerGenerationCount() == newElement.getMarkerGenerationCount();
    }

    private boolean compareNodeIDs(ResourceInfo oldElement, ResourceInfo newElement) {
        return oldElement.getNodeId() == newElement.getNodeId();
    }

    private boolean compareOpen(ResourceInfo oldElement, ResourceInfo newElement) {
        return oldElement.isSet(1) == newElement.isSet(1);
    }

    private boolean compareSync(ResourceInfo oldElement, ResourceInfo newElement) {
        return oldElement.getSyncInfoGenerationCount() == newElement.getSyncInfoGenerationCount();
    }

    private boolean compareType(ResourceInfo oldElement, ResourceInfo newElement) {
        return oldElement.getType() == newElement.getType();
    }

    public static ResourceComparator getComparator() {
        return ResourceComparator.getComparator(false);
    }

    public static ResourceComparator getComparator(boolean includeMarkerDeltas) {
        if (includeMarkerDeltas) {
            if (markerSingleton == null) {
                markerSingleton = new ResourceComparator(includeMarkerDeltas);
            }
            return markerSingleton;
        }
        if (noMarkerSingleton == null) {
            noMarkerSingleton = new ResourceComparator(includeMarkerDeltas);
        }
        return noMarkerSingleton;
    }
}

