/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.ptn.attachments.utils;

import com.sap.caf.ui.ptn.newattachment.def.wdp.IExternalNewAttachmentCI;
import com.sap.caf.ui.utils.cafproperties.CAFPropertyReader;
import com.sap.caf.ui.utils.cool.CAFServiceFactory;
import com.sap.caf.ui.utils.cool.CoolUtils;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDMessage;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FileUploadHelper {
    private static Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$ptn$attachments$utils$FileUploadHelper == null ? (class$com$sap$caf$ui$ptn$attachments$utils$FileUploadHelper = FileUploadHelper.class$("com.sap.caf.ui.ptn.attachments.utils.FileUploadHelper")) : class$com$sap$caf$ui$ptn$attachments$utils$FileUploadHelper));
    public static final String DOC_SRV = "sap.com/caf.core/DocumentService";
    public static final String DOC_CONTENT_SRV = "sap.com/caf.core/DocContent";
    public static final String FIND_BY_RID_QUERY = "findByRid";
    public static final String ATTR_NAME_DOCUMENT_ID = "documentId";
    public static final String ATTR_NAME_PARENT_FOLDER = "parentFolder";
    public static final String ATTR_NAME_TITLE = "title";
    public static final String ATTR_NAME_LINK = "link";
    public static final String ATTR_NAME_KEY = "key";
    public static final String QUERY_UPLOAD_DOCUMENT = "uploadDocument";
    public static final String QUERY_UPLOAD_EXT_LINK = "uploadExtLink";
    public static final String QUERY_ADD_RELATED_OBJECT_RID = "addRelatedObjectRid";
    private IAspectRow m_ObjectRow;
    private Map m_UploadedDocs = new HashMap();
    private String m_DocumentRelation;
    private String m_BOName;
    private boolean m_Relation01;
    private String m_PortalBaseUrl;
    private IWDMessageManager m_MsgMgr;
    private IWDMessage msgAttachNotAdded;
    private IWDMessage msgAttachAdded;
    static /* synthetic */ Class class$com$sap$caf$ui$ptn$attachments$utils$FileUploadHelper;

    public FileUploadHelper(String documentRelation, String boName, boolean relation01, IWDMessageManager msgMgr, IWDMessage msgAttachAdded, IWDMessage msgAttachNotAdded) {
        this.m_DocumentRelation = documentRelation;
        this.m_MsgMgr = msgMgr;
        this.m_BOName = boName;
        this.m_Relation01 = relation01;
        this.msgAttachAdded = msgAttachAdded;
        this.msgAttachNotAdded = msgAttachNotAdded;
    }

    public IAspectRow onUpload(IExternalNewAttachmentCI newAttachCI, String mode, IAspectRow objectRow) {
        IAspectRow result = null;
        if (objectRow == null || newAttachCI == null) {
            return result;
        }
        boolean bUploaded = true;
        this.m_ObjectRow = objectRow;
        AttachmentInfo attachInfo = new AttachmentInfo(null, mode, null);
        if (mode.equalsIgnoreCase("url")) {
            attachInfo.m_title = newAttachCI.getName();
            String path = newAttachCI.getPath();
            result = this.addAttachment_Url(attachInfo.m_title, path);
        } else if (mode.equalsIgnoreCase("loc")) {
            attachInfo.m_title = newAttachCI.getPath();
            AttachmentInfo.access$102(attachInfo, newAttachCI.getLocalFileData());
            result = this.addAttachment_LF(attachInfo.m_title);
        } else if (mode.equalsIgnoreCase("kmr")) {
            attachInfo.m_title = newAttachCI.getName();
            String path = newAttachCI.getPath();
            result = this.addAttachment_KM(attachInfo.m_title, path);
        } else if (mode.equalsIgnoreCase("")) {
            bUploaded = false;
        }
        if (bUploaded) {
            this.m_UploadedDocs.put(attachInfo.m_title, attachInfo);
            if (result != null) {
                this.m_MsgMgr.reportMessage(this.msgAttachAdded, null, false);
            } else {
                this.m_MsgMgr.reportMessage(this.msgAttachNotAdded, null, false);
            }
        }
        return result;
    }

    private IAspectRow addAttachment_LF(String filePath) {
        IAspectRow docRow = null;
        try {
            IAspect attachAspect = this.m_ObjectRow.getRelatedAspect(this.m_DocumentRelation);
            if (this.m_Relation01) {
                attachAspect.clear();
            }
            docRow = attachAspect.createAspectRow();
            docRow.setAttributeValue(ATTR_NAME_TITLE, (Object)filePath);
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
            docRow = null;
        }
        return docRow;
    }

    private IAspectRow addAttachment_KM(String attachName, String kmPath) {
        IAspectRow result = null;
        try {
            IAspect attachAspect = this.m_ObjectRow.getRelatedAspect(this.m_DocumentRelation);
            if (this.m_Relation01) {
                attachAspect.clear();
            }
            IServiceModule docServiceModule = this.getServiceFacade().getServiceModule(DOC_SRV);
            IQuery query = docServiceModule.createQuery(FIND_BY_RID_QUERY);
            query.getInputParameterStructure().setAttributeValue(0, (Object)kmPath);
            query.execute();
            Collection docs = query.getResult();
            if (docs.size() > 0) {
                IAspectRow docRow = (IAspectRow)docs.iterator().next();
                this.m_ObjectRow.addRelatedModelObject(this.m_DocumentRelation, (ICMIModelClass)docRow);
                result = docRow;
            }
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
        }
        return result;
    }

    private IAspectRow addAttachment_Url(String attachName, String attachUrl) {
        IAspectRow docRow = null;
        try {
            IAspect attachAspect = this.m_ObjectRow.getRelatedAspect(this.m_DocumentRelation);
            if (this.m_Relation01) {
                attachAspect.clear();
            }
            docRow = attachAspect.createAspectRow(this.m_ObjectRow.getKey());
            docRow.setAttributeValue(ATTR_NAME_TITLE, (Object)attachName);
            docRow.setAttributeValue(ATTR_NAME_LINK, (Object)attachUrl);
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
            docRow = null;
        }
        return docRow;
    }

    public boolean saveChanges() throws Exception {
        if (!this.isDirty()) {
            return true;
        }
        boolean result = true;
        IAspect objectAspect = this.m_ObjectRow.getAspect();
        IAspect docAspect = this.m_ObjectRow.getRelatedAspect(this.m_DocumentRelation);
        objectAspect.sendChanges();
        IServiceFacade facade = this.getServiceFacade();
        result &= facade.save();
        result &= !CoolUtils.reportCoolMessages((IServiceFacade)facade, (IWDMessageManager)this.m_MsgMgr, (boolean)false, (boolean)false);
        IServiceModule docContentServiceModule = this.getServiceFacade().getServiceModule(DOC_CONTENT_SRV);
        for (int i = 0; i < docAspect.size(); ++i) {
            String queryName;
            IAspectRow row = docAspect.getAspectRow(i);
            AttachmentInfo attachInfo = (AttachmentInfo)this.m_UploadedDocs.get(row.getAttributeValue(ATTR_NAME_TITLE));
            if (attachInfo == null) continue;
            String docKey = (String)row.getAttributeValue(ATTR_NAME_KEY);
            if (attachInfo.m_mode.equalsIgnoreCase("loc")) {
                queryName = QUERY_UPLOAD_DOCUMENT;
                IQuery query = docContentServiceModule.createQuery(queryName);
                query.getInputParameterStructure().setAttributeValue(0, (Object)docKey);
                query.getInputParameterStructure().setAttributeValue(1, (Object)attachInfo.m_data);
                query.execute();
            } else if (attachInfo.m_mode.equalsIgnoreCase("url")) {
                String attachUrl = (String)row.getAttributeValue(ATTR_NAME_LINK);
                queryName = QUERY_UPLOAD_EXT_LINK;
                IQuery query = docContentServiceModule.createQuery(queryName);
                query.getInputParameterStructure().setAttributeValue(0, (Object)docKey);
                query.getInputParameterStructure().setAttributeValue(1, (Object)attachUrl);
                query.execute();
            }
            String objectKey = this.m_ObjectRow.getKey().toString();
            if (objectKey.startsWith("[") && objectKey.endsWith("]")) {
                objectKey = objectKey.substring(1, objectKey.length() - 1);
            }
            queryName = QUERY_ADD_RELATED_OBJECT_RID;
            IQuery relQuery = docContentServiceModule.createQuery(queryName);
            relQuery.getInputParameterStructure().setAttributeValue(0, (Object)docKey);
            relQuery.getInputParameterStructure().setAttributeValue(1, (Object)this.m_BOName);
            relQuery.getInputParameterStructure().setAttributeValue(2, (Object)objectKey);
            relQuery.execute();
            result &= !CoolUtils.reportCoolMessages((IServiceFacade)facade, (IWDMessageManager)this.m_MsgMgr, (boolean)false, (boolean)false);
        }
        facade.save();
        if (result &= !CoolUtils.reportCoolMessages((IServiceFacade)facade, (IWDMessageManager)this.m_MsgMgr, (boolean)false, (boolean)false)) {
            this.m_UploadedDocs.clear();
        }
        return result;
    }

    public void cancelChanges() {
        this.m_UploadedDocs.clear();
    }

    public boolean isDirty() {
        return !this.m_UploadedDocs.isEmpty();
    }

    private IServiceFacade getServiceFacade() throws Exception {
        return CAFServiceFactory.getServiceFacade();
    }

    public String getDocUrl(IAspectRow docRow) throws Exception {
        String docUrl = null;
        if (docRow != null) {
            StringBuffer sb = new StringBuffer(docRow.getAttributeAsString(ATTR_NAME_PARENT_FOLDER));
            sb.append('/').append(docRow.getAttributeAsString(ATTR_NAME_DOCUMENT_ID));
            String docRid = sb.toString();
            docUrl = FileUploadHelper.makeDocUrl(this.getPortalBaseDocURL(), docRid);
        }
        return docUrl;
    }

    public String getPortalBaseDocURL() throws Exception {
        if (this.m_PortalBaseUrl == null) {
            this.m_PortalBaseUrl = CAFPropertyReader.substituteKMUrlParams((String)CAFPropertyReader.getCAFProperty((String)"KM_PREVIEW_URL"));
        }
        return this.m_PortalBaseUrl;
    }

    public static String makeDocUrl(String url, String rId) {
        String result;
        int iEndCh;
        String kmAddress = url;
        if (kmAddress == null) {
            kmAddress = "";
        }
        if (rId != null && rId.length() > 0 && rId.charAt(0) == '/') {
            for (iEndCh = kmAddress.length(); iEndCh > 0 && kmAddress.charAt(iEndCh - 1) == '/'; --iEndCh) {
            }
        }
        if ((result = kmAddress.substring(0, iEndCh) + rId).indexOf(63) == -1) {
            result = result + "?dummy";
        }
        return result;
    }

    public static String getRIDParentFolder(String rid) {
        String result = null;
        String ridToken = "/";
        int index = rid.lastIndexOf(ridToken);
        if (index > -1) {
            result = rid.substring(0, index);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AttachmentInfo
    implements Comparable {
        private String m_mode;
        private String m_title;
        private byte[] m_data;

        public AttachmentInfo() {
        }

        public AttachmentInfo(String title, String mode, byte[] data) {
            this.m_title = title;
            this.m_mode = mode;
            this.m_data = data;
        }

        public int compareTo(Object o) {
            if (o != null) {
                if (o instanceof AttachmentInfo) {
                    throw new ClassCastException("Object should be of type AttachmentInfo: " + o);
                }
                AttachmentInfo info2 = (AttachmentInfo)o;
                return this.m_title != null ? this.m_title.compareTo(info2.m_title) : (info2.m_title != null ? 1 : 0);
            }
            return 1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        static /* synthetic */ byte[] access$102(AttachmentInfo x0, byte[] x1) {
            x0.m_data = x1;
            return x1;
        }
    }

    public static class POPUP_MODES {
        public static final String LOCAL_FILE = "loc";
        public static final String KM_REFERENCE = "kmr";
        public static final String URL = "url";
        public static final String CANCEL = "";
    }
}

