/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.wizard;

import com.togethersoft.selena.xmi.wizard.ExportPage;
import com.togethersoft.selena.xmi.wizard.PackageTree$1;
import com.togethersoft.selena.xmi.wizard.TreeContentProvider;
import com.togethersoft.selena.xmi.wizard.TreeLabelProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.ui.IElementWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class PackageTree
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object myRoot;
    private Object selectedModel = null;
    private CheckboxTreeViewer myTreeViewer;
    private ITreeContentProvider myTreeContentProvider;
    private ILabelProvider myTreeLabelProvider;
    private List myListeners = new ArrayList();
    private ExportPage myPage;
    static Class class$org$eclipse$jdt$core$IJavaElement;

    public PackageTree(Composite composite, ExportPage exportPage) {
        Tree tree = new Tree(composite, 2080);
        this.myRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.myTreeContentProvider = new TreeContentProvider();
        this.myTreeLabelProvider = new TreeLabelProvider();
        this.myTreeViewer = new CheckboxTreeViewer(tree);
        this.myTreeViewer.setUseHashlookup(true);
        this.myTreeViewer.setContentProvider((IContentProvider)this.myTreeContentProvider);
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)this.myTreeLabelProvider);
        this.myTreeViewer.addTreeListener((ITreeViewerListener)this);
        this.myTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.myTreeViewer.setInput(this.myRoot);
        this.myPage = exportPage;
    }

    public void doSelectionOld(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty()) {
            IElementWrapper iElementWrapper = (IElementWrapper)iStructuredSelection.getFirstElement();
            IJavaElement iJavaElement = (IJavaElement)Platform.getAdapterManager().getAdapter((Object)iElementWrapper.getOriginalElement(), class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = PackageTree.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
            if (iJavaElement != null) {
                this.myTreeViewer.setSelection((ISelection)new StructuredSelection((Object)iJavaElement));
                this.myTreeViewer.setChecked((Object)iJavaElement, true);
                this.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.myTreeViewer, (Object)iJavaElement, true));
            }
        }
    }

    public void doSelection(IStructuredSelection iStructuredSelection) {
        IElementWrapper iElementWrapper;
        Element element;
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (element = (iElementWrapper = (IElementWrapper)iStructuredSelection.getFirstElement()).getOriginalElement()) != null) {
            Model model = element.getModel();
            this.myTreeViewer.setSelection((ISelection)new StructuredSelection((Object)model));
            this.myTreeViewer.setChecked((Object)model, true);
            this.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.myTreeViewer, (Object)model, true));
        }
    }

    public List getExportedPackages() {
        Model model = this.getSelectedModel();
        if (model == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        this.recursivePackageScan(model, arrayList);
        return arrayList;
    }

    private void recursivePackageScan(Object object, List list) {
        if (!this.myTreeContentProvider.hasChildren(object)) {
            return;
        }
        Object[] objectArray = this.myTreeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (this.myTreeViewer.getChecked(objectArray[n])) {
                list.add(objectArray[n]);
                this.recursivePackageScan(objectArray[n], list);
            }
            ++n;
        }
    }

    public Tree getTree() {
        return this.myTreeViewer.getTree();
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.myListeners.add(iCheckStateListener);
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        Object object = checkStateChangedEvent.getElement();
        boolean bl = checkStateChangedEvent.getChecked();
        if (this.myTreeViewer.getGrayed(object)) {
            this.myTreeViewer.setGrayed(object, false);
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new PackageTree$1(this, object, bl, checkStateChangedEvent));
    }

    public Model getSelectedModel() {
        return (Model)this.selectedModel;
    }

    private void updateState(Object object) {
        boolean bl = this.myTreeViewer.getChecked(object);
        boolean bl2 = this.myTreeViewer.getGrayed(object);
        int n = 0;
        if (bl && !bl2) {
            n = 1;
        } else if (!bl && !bl2) {
            n = -1;
        }
        int n2 = this.getChildrenState(object);
        if (n2 == n) {
            return;
        }
        if (n2 == 1) {
            this.myTreeViewer.setChecked(object, true);
            this.myTreeViewer.setGrayed(object, false);
        } else if (n2 == -1) {
            this.myTreeViewer.setChecked(object, false);
            this.myTreeViewer.setGrayed(object, false);
        } else {
            this.myTreeViewer.setChecked(object, true);
            this.myTreeViewer.setGrayed(object, true);
        }
        Object object2 = this.myTreeContentProvider.getParent(object);
        if (object2 == null) {
            if (this.myTreeViewer.getChecked(object)) {
                if (this.selectedModel != null && !bl) {
                    this.myTreeViewer.setChecked(this.selectedModel, false);
                    this.myTreeViewer.setGrayed(this.selectedModel, false);
                    this.recursiveCheckChildren(this.selectedModel, false);
                }
                this.selectedModel = object;
            } else {
                this.selectedModel = null;
            }
            this.myPage.setFileNameByModel((Model)this.selectedModel);
            return;
        }
        this.updateState(object2);
    }

    private int getChildrenState(Object object) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.myTreeContentProvider.hasChildren(object)) {
            Object[] objectArray = this.myTreeContentProvider.getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                if (this.myTreeViewer.getChecked(object2)) {
                    if (!this.myTreeViewer.getGrayed(object2)) {
                        bl = true;
                    }
                } else {
                    bl2 = true;
                }
                ++n;
            }
        }
        if (bl && !bl2) {
            return 1;
        }
        if (!bl && bl2) {
            return -1;
        }
        return 0;
    }

    private void recursiveCheckChildren(Object object, boolean bl) {
        if (this.myTreeContentProvider.hasChildren(object)) {
            Object[] objectArray = this.myTreeContentProvider.getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                this.myTreeViewer.setChecked(object2, bl);
                this.recursiveCheckChildren(object2, bl);
                ++n;
            }
        }
    }

    private void notifyCheckStateChangeListeners(CheckStateChangedEvent checkStateChangedEvent) {
        Iterator iterator = this.myListeners.iterator();
        while (iterator.hasNext()) {
            ((ICheckStateListener)iterator.next()).checkStateChanged(checkStateChangedEvent);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ITreeContentProvider access$000(PackageTree packageTree) {
        return packageTree.myTreeContentProvider;
    }

    static Object access$100(PackageTree packageTree) {
        return packageTree.selectedModel;
    }

    static CheckboxTreeViewer access$200(PackageTree packageTree) {
        return packageTree.myTreeViewer;
    }

    static void access$300(PackageTree packageTree, Object object, boolean bl) {
        packageTree.recursiveCheckChildren(object, bl);
    }

    static Object access$102(PackageTree packageTree, Object object) {
        packageTree.selectedModel = object;
        return packageTree.selectedModel;
    }

    static ExportPage access$400(PackageTree packageTree) {
        return packageTree.myPage;
    }

    static void access$500(PackageTree packageTree, Object object) {
        packageTree.updateState(object);
    }

    static void access$600(PackageTree packageTree, CheckStateChangedEvent checkStateChangedEvent) {
        packageTree.notifyCheckStateChangeListeners(checkStateChangedEvent);
    }
}

