/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.wizard;

import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InfiniteProgressMonitorHelper;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import com.togethersoft.selena.xmi.wizard.AbstractXMIWizard;
import com.togethersoft.selena.xmi.wizard.ImportPage;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class ImportWizard
extends AbstractXMIWizard {
    private static final String IMPORT_COMPLETED = XMIInterchangeMessages.getString("Import_from_{0}_completed_7");
    private static final String IMPORT_CANCELED = XMIInterchangeMessages.getString("Import_from_{0}_canceled_8");
    private static final String IMPORT_ERROR = XMIInterchangeMessages.getString("Errors_occured_while_exporting_model_9");

    public ImportWizard() {
        super(XMIInterchangeMessages.getString("XMIImportWizard.windowTitle"), "xmiimport_big.gif");
        this.setDialogSetingsKey("XMIImportWizard");
    }

    public void addPages() {
        if (this.isFeatureAvailable()) {
            super.addPages();
            this.addPage((IWizardPage)new ImportPage(this.data, this.getValidSelection()));
        }
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            iProgressMonitor.beginTask("import", InfiniteProgressMonitorHelper.getTotalWork());
            File file = new File(this.data.getXMLFileName());
            FileOutputStream fileOutputStream = null;
            if (Diagnostic.isDeveloperEnvironment()) {
                fileOutputStream = new FileOutputStream(this.data.getLogFile());
            }
            XMI11Import.doImport(file, iProgressMonitor, fileOutputStream);
            iProgressMonitor.done();
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            Diagnostic.printError(exception);
        }
    }

    public String getCompletedMessage() {
        return MessageFormat.format(IMPORT_COMPLETED, this.data.getModel().getPropertyValue("$name"));
    }

    public String getCanceledMessage() {
        return MessageFormat.format(IMPORT_CANCELED, this.data.getModel().getPropertyValue("$name"));
    }

    public String getErrorMessage() {
        return IMPORT_ERROR;
    }

    public String getDialogTitle() {
        return XMIInterchangeMessages.getString("XMI_Import_6");
    }
}

