/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.wizard;

import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import com.togethersoft.selena.xmi.wizard.IXMIWizardPage;
import com.togethersoft.selena.xmi.wizard.ImportPage$1;
import com.togethersoft.selena.xmi.wizard.ImportPage$2;
import com.togethersoft.selena.xmi.wizard.ImportPage$3;
import com.togethersoft.selena.xmi.wizard.ImportPage$TableContentProvider;
import com.togethersoft.selena.xmi.wizard.ImportPage$TableLabelProvider;
import com.togethersoft.selena.xmi.wizard.XMIWizardData;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.ui.IElementWrapper;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportPage
extends WizardPage
implements IXMIWizardPage {
    private CheckboxTableViewer tableViewer;
    private Object selectedItem;
    private static final String NAME = "xmiImportWizardPage";
    private static final String STORE_IMPORT_FILE = "xmiImportWizardPage.IMPORT_FILE";
    private static final String STORE_HISTORY = "xmiImportWizardPage.HISTORY";
    private static final String FILE_DOESNT_EXIST = XMIInterchangeMessages.getString("File_{0}_does_not_exist.");
    private XMIWizardData myData;
    private IStructuredSelection mySelection;
    private Model selectedModel;
    private Combo myFile;
    private ArrayList myModels;

    public ImportPage(XMIWizardData xMIWizardData, IStructuredSelection iStructuredSelection) {
        super(NAME);
        this.myData = xMIWizardData;
        this.mySelection = iStructuredSelection;
        this.setTitle(XMIInterchangeMessages.getString("XMIImportWizardPage.title"));
        this.setDescription(XMIInterchangeMessages.getString("XMIImportWizardPage.description"));
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Control control = this.createSourceFilePane(composite2);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)gridData);
        Control control2 = this.createProjectList(composite2);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        control2.setLayoutData((Object)gridData);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"com.togethersoft.togetherxj.nonuml.xmi_import_help");
        this.myFile.setFocus();
        this.restoreDialogSettings();
    }

    public boolean canFinish() {
        String string = this.myFile.getText().trim();
        File file = new File(string);
        if (file.exists()) {
            return true;
        }
        String string2 = MessageFormat.format(FILE_DOESNT_EXIST, string);
        new MessageDialog(null, XMIInterchangeMessages.getString("Confirmation_3"), null, string2, 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
        return false;
    }

    public void finish() {
        this.myData.setModel(this.getSelectedModel());
        this.myData.setXMLFileName(this.myFile.getText().trim());
        this.saveDialogSettings();
    }

    public boolean isPageComplete() {
        if (this.selectedModel == null) {
            this.setErrorMessage(XMIInterchangeMessages.getString("No_selected_project._3"));
            return false;
        }
        String string = this.myFile.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage(XMIInterchangeMessages.getString("Source_file_not_selected._4"));
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.setErrorMessage(XMIInterchangeMessages.getString("Source_file_not_exists"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void saveDialogSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String string = this.myData.getXMIType();
            String string2 = this.myData.getXMLFileName();
            iDialogSettings.put(STORE_IMPORT_FILE, string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < this.myFile.getItemCount()) {
                arrayList.add(this.myFile.getItem(n));
                ++n;
            }
            String string3 = this.myFile.getText().trim();
            if (!arrayList.contains(string3)) {
                arrayList.add(0, string3);
            }
            iDialogSettings.put(STORE_HISTORY, arrayList.toArray(new String[0]));
        }
    }

    public void restoreDialogSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        String string = "";
        String[] stringArray = null;
        if (iDialogSettings != null) {
            String string2 = iDialogSettings.get(STORE_IMPORT_FILE);
            if (string2 != null && string2.length() != 0) {
                string = string2;
            }
            stringArray = iDialogSettings.getArray(STORE_HISTORY);
        }
        if (stringArray != null) {
            this.myFile.setItems(stringArray);
        }
        this.myFile.setText(string);
    }

    private Model getSelectedModel() {
        return this.selectedModel;
    }

    private void updatePageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    private Control createSourceFilePane(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText(XMIInterchangeMessages.getString("Select_source_.xmi_file._6"));
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.myFile = new Combo(composite2, 4);
        this.myFile.addModifyListener((ModifyListener)new ImportPage$1(this));
        gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        gridData.grabExcessHorizontalSpace = true;
        this.myFile.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        button.setText(XMIInterchangeMessages.getString("XMIExportWizardPage.filename.button"));
        button.setLayoutData((Object)new GridData(256));
        button.addSelectionListener((SelectionListener)new ImportPage$2(this));
        return composite2;
    }

    private void browse() {
        FileDialog fileDialog = new FileDialog(this.getContainer().getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.xml;*.xmi", "*.xml", "*.xmi", "*.*"});
        String string = this.myData.getXMLFileName();
        fileDialog.setFileName(string);
        String string2 = fileDialog.open();
        if (string2 != null) {
            this.myFile.setText(string2);
        }
    }

    private Control createProjectList(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite2, 0);
        label.setText(XMIInterchangeMessages.getString("Select_destination_project._8"));
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        Table table = new Table(composite2, 2048);
        gridData = new GridData(1808);
        gridData.horizontalIndent = 5;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new ImportPage$3(this, table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new ImportPage$TableContentProvider(this, null));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ImportPage$TableLabelProvider(this, null));
        this.tableViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (this.mySelection != null && !this.mySelection.isEmpty()) {
            IElementWrapper iElementWrapper = (IElementWrapper)this.mySelection.getFirstElement();
            this.selectedModel = iElementWrapper.getOriginalElement().getModel();
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedModel));
        }
        return composite2;
    }

    static void access$000(ImportPage importPage) {
        importPage.updatePageComplete();
    }

    static void access$100(ImportPage importPage) {
        importPage.browse();
    }

    static CheckboxTableViewer access$200(ImportPage importPage) {
        return importPage.tableViewer;
    }

    static Model access$302(ImportPage importPage, Model model) {
        importPage.selectedModel = model;
        return importPage.selectedModel;
    }
}

