/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.wizard;

import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import com.togethersoft.selena.xmi.wizard.AbstractXMIWizard;
import com.togethersoft.selena.xmi.wizard.ExportPage;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class ExportWizard
extends AbstractXMIWizard {
    private static final String EXPORT_COMPLETED = XMIInterchangeMessages.getString("Export_to_{0}_completed_7");
    private static final String EXPORT_COMPLETED_WARNINGS = XMIInterchangeMessages.getString("Export_to_{0}_completed_warnings");
    private static final String EXPORT_CANCELED = XMIInterchangeMessages.getString("Export_to_{0}_canceled_8");
    private static final String EXPORT_ERROR = XMIInterchangeMessages.getString("Errors_occured_while_exporting_model_9");

    public ExportWizard() {
        super(XMIInterchangeMessages.getString("XMIExportWizard.windowTitle"), "xmiexport_big.gif");
        this.setDialogSetingsKey("XMIExportWizard");
    }

    public void addPages() {
        if (this.isFeatureAvailable()) {
            super.addPages();
            this.addPage((IWizardPage)new ExportPage(this.data, this.getValidSelection()));
        }
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            iProgressMonitor.beginTask("export", InterchangeUtils.getWizardData().getExportedPackagesCount());
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = false;
            if ("XMI_11_Unisys".equals(this.data.getXMIType())) {
                bl2 = false;
            } else if ("XMI_11_Unisys_TCC".equals(this.data.getXMIType())) {
                bl2 = false;
                bl3 = true;
            } else if ("XMI_11_UML_14".equals(this.data.getXMIType())) {
                bl = false;
                bl2 = false;
            }
            FileOutputStream fileOutputStream = null;
            if (Diagnostic.isDeveloperEnvironment()) {
                fileOutputStream = new FileOutputStream(this.data.getLogFile());
            }
            XMI11Export.export(new FileOutputStream(new File(this.data.getXMLFileName())), bl, bl2, bl3, iProgressMonitor, fileOutputStream);
            iProgressMonitor.done();
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            System.out.println("Error during export" + exception.toString());
            exception.printStackTrace();
        }
    }

    public String getCompletedMessage() {
        if (XMI11Export.isWarningGenerated()) {
            return MessageFormat.format(EXPORT_COMPLETED_WARNINGS, this.data.getXMLFileName());
        }
        return MessageFormat.format(EXPORT_COMPLETED, this.data.getXMLFileName());
    }

    public String getCanceledMessage() {
        return MessageFormat.format(EXPORT_CANCELED, this.data.getXMLFileName());
    }

    public String getErrorMessage() {
        return EXPORT_ERROR;
    }

    public String getDialogTitle() {
        return XMIInterchangeMessages.getString("XMI_Export_6");
    }
}

