/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.wizard;

import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import com.togethersoft.selena.xmi.wizard.ExportPage$1;
import com.togethersoft.selena.xmi.wizard.ExportPage$2;
import com.togethersoft.selena.xmi.wizard.ExportPage$3;
import com.togethersoft.selena.xmi.wizard.ExportPage$4;
import com.togethersoft.selena.xmi.wizard.IXMIWizardPage;
import com.togethersoft.selena.xmi.wizard.PackageTree;
import com.togethersoft.selena.xmi.wizard.XMIWizardData;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.ModelUinSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExportPage
extends WizardPage
implements IXMIWizardPage,
SelectionListener {
    private static final String NAME = "xmiExportWizardPage";
    private static final String STORE_XMI_TYPE = "xmiExportWizardPage.XMI_TYPE";
    private static final String STORE_EXPORT_SCOPE = "xmiExportWizardPage.EXPORT_SCOPE";
    private static final String STORE_EXPORT_FILE = "xmiExportWizardPage.EXPORT_FILE";
    private static final String STORE_ENCODING = "xmiExportWizardPage.ENCODING";
    private static final String STORE_HISTORY = "xmiExportWizardPage.HISTORY";
    private static final String FILE_EXISTS = XMIInterchangeMessages.getString("File_{0}_already_exists._Overwrite_it__21");
    private PackageTree myPackageTree;
    private XMIWizardData myData;
    private IStructuredSelection mySelection;
    private Button type1;
    private Button type2;
    private Button type3;
    private Button type4;
    private Combo myEncoding;
    private Combo myFileName;
    private ModifyListener myListener;
    private boolean myManualFileName = false;

    public ExportPage(XMIWizardData xMIWizardData, IStructuredSelection iStructuredSelection) {
        super(NAME);
        this.mySelection = iStructuredSelection;
        this.myData = xMIWizardData;
        this.setTitle(XMIInterchangeMessages.getString("XMIExportWizardPage.title"));
        this.setDescription(XMIInterchangeMessages.getString("XMIExportWizardPage.description"));
        this.myListener = new ExportPage$1(this);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Control control = this.createTreeView(composite2);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 200;
        control.setLayoutData((Object)gridData);
        Control control2 = this.createXMITypeGroup(composite2);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        control2.setLayoutData((Object)gridData);
        Control control3 = this.createFileNamePane(composite2);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        control3.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"com.togethersoft.togetherxj.nonuml.xmi_export_help");
        this.myPackageTree.doSelection(this.mySelection);
        this.myPackageTree.getTree().setFocus();
        this.restoreDialogSettings();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.updatePageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public static boolean isUML20Active(Model model) {
        PropertyEnumeration propertyEnumeration = model.properties("$nature");
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            String string = property.getValue();
            if (!"com.togethersoft.togetherxj.uml.uml20.uml20_profile_nature".equals(string)) continue;
            return true;
        }
        return false;
    }

    private String fixFileName(String string) {
        String string2 = string;
        String string3 = string.toUpperCase();
        if (!string3.endsWith(".XML") && !string3.endsWith(".XMI")) {
            string2 = string2 + ".xml";
            this.myFileName.setText(string2);
        }
        return string2;
    }

    public boolean canFinish() {
        String string;
        String string2 = this.fixFileName(this.myFileName.getText().trim());
        File file = new File(string2);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            string = new MessageDialog(null, XMIInterchangeMessages.getString("Confirmation_3"), null, XMIInterchangeMessages.getFormattedString("Confirmation_Create", file.getParent()), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            if (string.open() == 1) {
                return false;
            }
            file2.mkdirs();
        }
        if (file.exists()) {
            string = MessageFormat.format(FILE_EXISTS, string2);
            MessageDialog messageDialog = new MessageDialog(null, XMIInterchangeMessages.getString("Confirmation_3"), null, string, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            if (messageDialog.open() == 1) {
                return false;
            }
        }
        return true;
    }

    public void finish() {
        this.myData.setModel(this.myPackageTree.getSelectedModel());
        this.myData.setXMIType(this.getSelectedType());
        this.myData.setXMLFileName(this.myFileName.getText().trim());
        this.myData.setExportedPackages(this.myPackageTree.getExportedPackages());
        this.myData.setEncoding(this.myEncoding.getText());
        this.saveDialogSettings();
    }

    public boolean isPageComplete() {
        Model model = this.myPackageTree.getSelectedModel();
        if (model == null) {
            this.setErrorMessage(XMIInterchangeMessages.getString("No_selected_project._4"));
            return false;
        }
        if (!model.childEntities().hasMoreElements()) {
            this.setErrorMessage(XMIInterchangeMessages.getString("Project_is_empty."));
            return false;
        }
        if (!(this.type1.getSelection() || this.type2.getSelection() || this.type3.getSelection() || this.type4.getSelection())) {
            this.setErrorMessage(XMIInterchangeMessages.getString("XMIExportWizardPage.error.selectType"));
            return false;
        }
        String string = this.myFileName.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage(XMIInterchangeMessages.getString("XMIExportWizardPage.error.filename"));
            return false;
        }
        File file = new File(string);
        if (File.separator.equals(string.substring(string.length() - 1))) {
            this.setErrorMessage(XMIInterchangeMessages.getString("XMIExportWizardPage.error.filename2"));
            return false;
        }
        if (file.isDirectory()) {
            this.setErrorMessage(XMIInterchangeMessages.getString("XMIExportWizardPage.error.filename3"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void saveDialogSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String string = this.myData.getXMIType();
            String string2 = this.myData.getXMLFileName();
            String string3 = this.myData.getEncoding();
            iDialogSettings.put(STORE_XMI_TYPE, string);
            iDialogSettings.put(STORE_EXPORT_FILE, string2);
            iDialogSettings.put(STORE_ENCODING, string3);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < this.myFileName.getItemCount()) {
                arrayList.add(this.myFileName.getItem(n));
                ++n;
            }
            String string4 = this.myFileName.getText().trim();
            if (!arrayList.contains(string4)) {
                arrayList.add(0, string4);
            }
            iDialogSettings.put(STORE_HISTORY, arrayList.toArray(new String[0]));
        }
    }

    public void restoreDialogSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        String string = "XMI_11_Unisys";
        String string2 = this.myData.getXMLFileName();
        String string3 = this.myData.getEncoding();
        String[] stringArray = null;
        String string4 = this.myFileName.getText();
        if (string4 != null && string4.length() != 0) {
            string2 = string4;
        }
        if (iDialogSettings != null) {
            String string5;
            String string6;
            String string7 = iDialogSettings.get(STORE_XMI_TYPE);
            if (string7 != null && string7.length() != 0) {
                string = string7;
            }
            if ((string6 = iDialogSettings.get(STORE_ENCODING)) != null && string6.length() != 0) {
                string3 = string6;
            }
            if ((string5 = iDialogSettings.get(STORE_EXPORT_FILE)) != null && string5.length() != 0) {
                string2 = string5;
            }
            stringArray = iDialogSettings.getArray(STORE_HISTORY);
        }
        this.type1.setSelection(false);
        this.type2.setSelection(false);
        this.type3.setSelection(false);
        this.type4.setSelection(false);
        if ("XMI_11_Unisys".equals(string)) {
            this.type1.setSelection(true);
        } else if ("XMI_11_Unisys_TCC".equals(string)) {
            this.type2.setSelection(true);
        } else if ("XMI_11_Unisys_Rose".equals(string)) {
            this.type3.setSelection(true);
        } else if ("XMI_11_UML_14".equals(string)) {
            this.type4.setSelection(true);
        }
        this.myFileName.removeModifyListener(this.myListener);
        if (stringArray != null) {
            this.myFileName.setItems(stringArray);
        }
        this.myFileName.setText(string2);
        this.myFileName.addModifyListener(this.myListener);
        this.myEncoding.setText(string3);
    }

    public void setFileNameByModel(Model model) {
        if (!this.myManualFileName) {
            this.myFileName.removeModifyListener(this.myListener);
            if (model != null) {
                IProject iProject;
                String string;
                if (ModelUinSupport.isModelUin((UniqueName)model.getUniqueName()) && (string = ModelUinSupport.getProjectId((UniqueName)model.getUniqueName())) != null && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)) != null && iProject.exists() && iProject.isAccessible()) {
                    String string2 = iProject.getLocation().toOSString();
                    string2 = string2 + File.separator + "out" + File.separator + "xmi" + File.separator;
                    string2 = ExportPage.findAvailableName(string2, model.getPropertyValue("$name"));
                    this.myFileName.setText(string2);
                }
            } else {
                this.myFileName.setText("");
            }
            this.myFileName.addModifyListener(this.myListener);
        }
    }

    private static String findAvailableName(String string, String string2) {
        String string3 = string2;
        if (Diagnostic.isDeveloperEnvironment()) {
            return "c:\\test.xml";
        }
        File file = new File(string);
        if (file != null && file.isDirectory() && file.exists()) {
            File[] fileArray = file.listFiles(new ExportPage$2(string3));
            if (fileArray != null) {
                int n = 0;
                int n2 = 0;
                while (n2 < fileArray.length) {
                    File file2 = fileArray[n2];
                    String string4 = file2.getName();
                    String string5 = string4.substring(string3.length(), string4.length() - 4);
                    int n3 = 0;
                    try {
                        n3 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 0;
                    }
                    if (n < n3) {
                        n = n3;
                    }
                    ++n2;
                }
                string = string + string3 + ++n + ".xml";
            } else {
                string = string + string3 + "1.xml";
            }
        } else {
            string = string + string3 + "1.xml";
        }
        return string;
    }

    private String getSelectedType() {
        if (this.type1.getSelection()) {
            return "XMI_11_Unisys";
        }
        if (this.type2.getSelection()) {
            return "XMI_11_Unisys_TCC";
        }
        if (this.type3.getSelection()) {
            return "XMI_11_Unisys_Rose";
        }
        if (this.type4.getSelection()) {
            return "XMI_11_UML_14";
        }
        return null;
    }

    private Control createTreeView(Composite composite) {
        this.myPackageTree = new PackageTree(composite, this);
        this.myPackageTree.addCheckStateListener(new ExportPage$3(this));
        return this.myPackageTree.getTree();
    }

    private void updatePageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    private Control createXMITypeGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(XMIInterchangeMessages.getString("XMIExportWizardPage.xmitype.label"));
        GridLayout gridLayout = new GridLayout(2, false);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(784));
        this.type1 = new Button((Composite)group, 16400);
        this.type1.setText(XMIInterchangeMessages.getString("XMIExportWizardPage.xmitype1.text"));
        this.type1.addSelectionListener((SelectionListener)this);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.type1.setLayoutData((Object)gridData);
        this.type2 = new Button((Composite)group, 16400);
        this.type2.setText(XMIInterchangeMessages.getString("XMIExportWizardPage.xmitype2.text"));
        this.type2.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.type2.setLayoutData((Object)gridData);
        this.type3 = new Button((Composite)group, 16400);
        this.type3.setText(XMIInterchangeMessages.getString("XMIExportWizardPage.xmitype3.text"));
        this.type3.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.type3.setLayoutData((Object)gridData);
        this.type4 = new Button((Composite)group, 16400);
        this.type4.setText(XMIInterchangeMessages.getString("XMIExportWizardPage.xmitype4.text"));
        this.type4.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.type4.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 0);
        label.setText(XMIInterchangeMessages.getString("XMI_file__15"));
        gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        Combo combo = new Combo((Composite)group, 4);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        combo.setLayoutData((Object)gridData);
        combo.setItems(new String[]{"1.2"});
        combo.setText("1.2");
        combo.setEnabled(false);
        label = new Label((Composite)group, 0);
        label.setText(XMIInterchangeMessages.getString("XMI_file__16"));
        gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        this.myEncoding = new Combo((Composite)group, 12);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        this.myEncoding.setLayoutData((Object)gridData);
        this.myEncoding.setItems(XMIWizardData.getEncodings());
        return group;
    }

    private Control createFileNamePane(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite2, 0);
        label.setText(XMIInterchangeMessages.getString("Select_the_export_destination._13"));
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = 5;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText(XMIInterchangeMessages.getString("XMI_file__14"));
        gridData = new GridData(32);
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.myFileName = new Combo(composite2, 4);
        this.myFileName.addModifyListener(this.myListener);
        gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        gridData.grabExcessHorizontalSpace = true;
        this.myFileName.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        button.setText(XMIInterchangeMessages.getString("XMIExportWizardPage.filename.button"));
        button.setLayoutData((Object)new GridData(256));
        button.addSelectionListener((SelectionListener)new ExportPage$4(this));
        return composite2;
    }

    private void browse() {
        String string;
        FileDialog fileDialog = new FileDialog(this.getContainer().getShell(), 8192);
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.xmi"});
        String string2 = this.myFileName.getText().trim();
        File file = new File(string2);
        File file2 = file.getParentFile();
        while (file2 != null && !file2.exists()) {
            file2 = file2.getParentFile();
        }
        if (file2 != null) {
            string = file2.toString();
            fileDialog.setFilterPath(string);
            string2 = file.getName();
        }
        fileDialog.setFileName(string2);
        string = fileDialog.open();
        if (string != null) {
            this.myFileName.setText(string);
        }
    }

    static boolean access$002(ExportPage exportPage, boolean bl) {
        exportPage.myManualFileName = bl;
        return exportPage.myManualFileName;
    }

    static void access$100(ExportPage exportPage) {
        exportPage.updatePageComplete();
    }

    static void access$200(ExportPage exportPage) {
        exportPage.browse();
    }
}

