/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.wizard;

import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.wizard.AbstractXMIWizard$1;
import com.togethersoft.selena.xmi.wizard.AbstractXMIWizard$2;
import com.togethersoft.selena.xmi.wizard.IXMIWizardPage;
import com.togethersoft.selena.xmi.wizard.XMIPlugin;
import com.togethersoft.selena.xmi.wizard.XMIWizardData;
import com.tssap.selena.license.CommonLicense;
import com.tssap.selena.license.UnaryOperation;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.ui.IElementWrapper;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class AbstractXMIWizard
extends Wizard
implements IExportWizard,
IRunnableWithProgress {
    private static final int MAX_STRING = 60;
    protected XMIWizardData data;
    private boolean featureAvailable = true;
    private IWorkbench fWorkbench;
    private boolean fHasNewDialogSettings;
    private String myDialogSettingsKey;
    private String myWindowTitle;
    private String myIcon;

    public AbstractXMIWizard(String string, String string2) {
        this.myWindowTitle = string;
        this.myIcon = string2;
        this.data = new XMIWizardData();
        InterchangeUtils.setWizardData(this.data);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        AbstractXMIWizard$1 abstractXMIWizard$1 = new AbstractXMIWizard$1(this);
        if (!CommonLicense.isFeatureAvailable((String)"TS", (String)"XJ_VISIBLE", (UnaryOperation)abstractXMIWizard$1)) {
            this.featureAvailable = false;
            CommonLicense.showLimitedMessage((String)"XJ");
            return;
        }
        this.fWorkbench = iWorkbench;
        this.setWindowTitle(this.myWindowTitle);
        this.setNeedsProgressMonitor(true);
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(new URL(XMIPlugin.getInstance().getDescriptor().getInstallURL(), "icons/"), this.myIcon));
            this.setDefaultPageImageDescriptor(imageDescriptor);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.myDialogSettingsKey != null) {
            IDialogSettings iDialogSettings = XMIPlugin.getInstance().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.myDialogSettingsKey);
            if (iDialogSettings2 == null) {
                this.fHasNewDialogSettings = true;
            } else {
                this.fHasNewDialogSettings = false;
                this.setDialogSettings(iDialogSettings2);
            }
        }
    }

    public boolean isFeatureAvailable() {
        return this.featureAvailable;
    }

    public boolean performFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = 0;
        while (n < iWizardPageArray.length) {
            if (iWizardPageArray[n] instanceof IXMIWizardPage && !((IXMIWizardPage)iWizardPageArray[n]).canFinish()) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.getPageCount()) {
            IWizardPage iWizardPage = iWizardPageArray[n2];
            if (iWizardPage instanceof IXMIWizardPage) {
                ((IXMIWizardPage)iWizardPage).finish();
            }
            ++n2;
        }
        boolean bl = this.doFinish();
        if (this.fHasNewDialogSettings && this.myDialogSettingsKey != null) {
            IDialogSettings iDialogSettings = XMIPlugin.getInstance().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.myDialogSettingsKey);
            iDialogSettings2 = iDialogSettings.addNewSection(this.myDialogSettingsKey);
            this.setDialogSettings(iDialogSettings2);
        }
        return bl;
    }

    public void setDialogSetingsKey(String string) {
        this.myDialogSettingsKey = string;
    }

    protected IStructuredSelection getValidSelection() {
        ISelection iSelection = XMIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            ArrayList arrayList = new ArrayList(iStructuredSelection.size());
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof IElementWrapper)) continue;
                arrayList.add(e);
            }
            return new StructuredSelection(arrayList);
        }
        return StructuredSelection.EMPTY;
    }

    public boolean doFinish() {
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InterruptedException interruptedException) {
            bl = true;
            if (interruptedException.getLocalizedMessage() != null) {
                string = interruptedException.getLocalizedMessage();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            bl2 = true;
        }
        String string2 = null;
        int n = 2;
        if (bl) {
            string2 = this.getCanceledMessage();
            string2 = string2 + string;
            n = 1;
        } else if (bl2) {
            string2 = this.getErrorMessage();
            n = 1;
        } else {
            string2 = this.getCompletedMessage();
        }
        int n2 = n;
        String string3 = this.fixLongMessage(string2);
        ModelAccess.runCommandLater((Runnable)((Object)new AbstractXMIWizard$2(this, string3, n2)));
        return true;
    }

    private String fixLongMessage(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() > 60) {
                String string4 = string3.substring(0, 20);
                string4 = string4 + "...";
                string3 = string4 = string4 + string3.substring(string3.length() - 40 + 3);
            }
            string2 = string2 + string3 + "\n";
        }
        return string2;
    }

    public abstract String getCompletedMessage();

    public abstract String getCanceledMessage();

    public abstract String getErrorMessage();

    public abstract String getDialogTitle();

    public abstract void run(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;
}

