/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.util.TextUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class XMLWriter
extends OutputStreamWriter {
    private String myOffset = "";

    public XMLWriter(OutputStream outputStream, String string) throws IOException {
        super((OutputStream)new FileOutputStream(((FileOutputStream)outputStream).getFD()), string);
    }

    public void writeAttribute(String string, String string2) throws IOException {
        this.writeAttribute(string, string2, false);
    }

    public void writeAttribute(String string, String string2, boolean bl) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 == null) {
            return;
        }
        if (bl) {
            this.write("\n    ");
            this.write(this.myOffset);
        }
        this.write(" ");
        this.write(string);
        this.write(" = '");
        this.write(XMLWriter.replaceProhibitedCharacters(string2));
        this.write("'");
    }

    public void writeStartTag(String string) throws IOException {
        this.writeStartTag(null, string, false);
    }

    public void writeStartTag(String string, boolean bl) throws IOException {
        this.writeStartTag(null, string, bl);
    }

    public void writeStartTag(String string, String string2) throws IOException {
        this.writeStartTag(string, string2, false);
    }

    public void writeStartTag(String string, String string2, boolean bl) throws IOException {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.write("\n");
        this.write(this.myOffset);
        this.write("<");
        if (string != null && string.length() != 0) {
            this.write(string);
            this.write(":");
        }
        this.write(string2);
        if (bl) {
            this.write(">");
        }
        this.myOffset = this.myOffset + " ";
    }

    public void writeEndTag(String string) throws IOException {
        this.writeEndTag(null, string);
    }

    public void writeEndTag(String string, String string2) throws IOException {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.myOffset = this.myOffset.substring(0, this.myOffset.length() - 1);
        this.write("\n");
        this.write(this.myOffset);
        this.write("</");
        if (string != null && string.length() != 0) {
            this.write(string);
            this.write(":");
        }
        this.write(string2);
        this.write(">");
    }

    public void writeCloseBrasket() throws IOException {
        this.write(">");
    }

    public void writeCloseBrasket(boolean bl) throws IOException {
        if (bl) {
            this.write("/>");
            this.myOffset = this.myOffset.substring(0, this.myOffset.length() - 1);
        } else {
            this.write(">");
        }
    }

    public void writeCDATA(String string) throws IOException {
        if (string == null) {
            return;
        }
        this.write("\n");
        this.write(this.myOffset);
        this.write("\t");
        string = XMLWriter.replaceProhibitedCharacters(string);
        this.write(string);
    }

    public void writeComments(String string) throws IOException {
        this.writeComments(string, true);
    }

    public void writeComments(String string, boolean bl) throws IOException {
        if (bl) {
            this.write("\n");
            this.write(this.myOffset);
        } else {
            this.write("    ");
        }
        this.write("<!--");
        this.write(string);
        this.write("-->");
    }

    private static String replaceProhibitedCharacters(String string) {
        if (string == null) {
            return "";
        }
        string = TextUtil.replace(string, "&", "&amp;");
        string = TextUtil.replace(string, "<", "&lt;");
        string = TextUtil.replace(string, ">", "&gt;");
        string = TextUtil.replace(string, "\"", "&quot;");
        string = TextUtil.replace(string, "'", "&apos;");
        return string;
    }
}

