/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.elements.XMIAction;
import com.togethersoft.selena.xmi.elements.XMIAssociation;
import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMIComment;
import com.togethersoft.selena.xmi.elements.XMIDependency;
import com.togethersoft.selena.xmi.elements.XMIDiagramElement;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIEvent;
import com.togethersoft.selena.xmi.elements.XMIGeneralization;
import com.togethersoft.selena.xmi.elements.XMIMessage;
import com.togethersoft.selena.xmi.elements.XMINotInProjectElement;
import com.togethersoft.selena.xmi.elements.XMIParameter;
import com.togethersoft.selena.xmi.elements.XMIPartition;
import com.togethersoft.selena.xmi.elements.XMIStereotype;
import com.togethersoft.selena.xmi.elements.XMITaggedValue;
import com.togethersoft.selena.xmi.elements.XMITransition;
import com.togethersoft.selena.xmi.handlers.XMIDocumentHandler;
import com.togethersoft.selena.xmi.handlers.XMIErrorHandler;
import com.togethersoft.selena.xmi.handlers.XMLParser;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.Renamer;
import com.togethersoft.selena.xmi.util.XMI11Import$1;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import com.togethersoft.togetherxj.uml.cdl.util.ModelElementUtil;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModelAccess;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelValidator;
import com.tssap.selena.impl.model.elements.EntityTemplateImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.providers.internal.design.MetaclassUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;

public class XMI11Import {
    public static final int REPLACE = 1;
    public static final int RENAME = 2;
    public static final int NONE = 0;
    public static final int ADD_CONTENT = 3;
    public static final int CANCEL_IMPORT = 4;
    private static final String REAL_UIN = "RealUIN";
    private static int ourPass = 0;
    private static boolean ourReturnTemplate;
    private static long ourReferenceTime;
    private static Hashtable ourEmptyReferences;
    private static XMLParser ourParser;
    private static int ourReplacementType;
    private static Hashtable ourPackages;
    private static Hashtable ourParameters;
    private static Hashtable ourTransitions;
    private static Hashtable ourPartitions;
    private static Hashtable ourOperations;
    private static Hashtable ourConstructors;
    private static Vector ourMovedElements;
    private static int ourOperationCounter;
    private static IProgressMonitor ourProgress;
    private static Hashtable ourGeneralizations;
    private static Hashtable ourNotInProjectElements;
    private static Hashtable ourEvents;
    private static Hashtable ourDependencies;
    private static Hashtable ourDatatypes;
    private static Hashtable ourXmiElements;
    private static Hashtable ourMessages;
    private static ArrayList ourMessageReferences;
    private static Hashtable ourBases;
    private static Hashtable ourTaggedValues;
    private static Hashtable ourReferences;
    private static Hashtable ourAttributeTypes;
    private static int ourIdCounter;
    private static Hashtable ourAssociations;
    private static Hashtable ourActions;
    private static Vector ourNoteLinks;
    private static Hashtable ourElements;
    private static Hashtable ourElementIDs;
    private static Hashtable ourStereotypeSeeks;
    private static Hashtable ourStereotypes;
    private static Hashtable ourStereotypesById;
    private static XMITransition ourCurrentTransition;
    private static Vector ourStereotypesID;
    private static Vector ourStereotypesType;
    private static Hashtable ourUINReferences;
    private static boolean ourNeedJavaNature;
    private static boolean ourSkipJavaElements;
    private static String ourExporter;
    private static String ourExporterVersion;
    private static ArrayList ourCreatedElements;
    private static Hashtable ourExtendsImplements;

    public static void setPass(int n) {
        ourPass = n;
    }

    public static int getPass() {
        return ourPass;
    }

    public static void addReferenceTime(long l) {
        ourReferenceTime += l;
    }

    public static void doImport(File file, IProgressMonitor iProgressMonitor, OutputStream outputStream) throws XMIException, InterruptedException {
        Date date;
        Diagnostic.init(outputStream);
        Diagnostic.print("Starting import");
        ourReferenceTime = 0L;
        Date date2 = date = new Date();
        long l = 0L;
        Diagnostic.printTimeLog("\nStart import at " + date + "\n");
        InterchangeUtils.initConstantsConverter(false);
        ourProgress = iProgressMonitor;
        Object var7_6 = null;
        Model model = InterchangeUtils.getWizardData().getModel();
        ourNeedJavaNature = false;
        ourUINReferences = null;
        ourCurrentTransition = null;
        ourStereotypesID = new Vector();
        ourStereotypesType = new Vector();
        ourIdCounter = 1;
        ourOperationCounter = 0;
        ourReplacementType = 0;
        ourPackages = new Hashtable();
        ourElements = new Hashtable();
        ourElementIDs = new Hashtable();
        ourReferences = new Hashtable();
        ourDatatypes = new Hashtable();
        ourStereotypes = new Hashtable();
        ourStereotypesById = new Hashtable();
        ourStereotypeSeeks = new Hashtable();
        ourOperations = new Hashtable();
        ourConstructors = new Hashtable();
        ourParameters = new Hashtable();
        ourAttributeTypes = new Hashtable();
        ourGeneralizations = new Hashtable();
        ourAssociations = new Hashtable();
        ourBases = new Hashtable();
        ourMessages = new Hashtable();
        ourMessageReferences = new ArrayList();
        ourActions = new Hashtable();
        ourTransitions = new Hashtable();
        ourDependencies = new Hashtable();
        ourEvents = new Hashtable();
        ourPartitions = new Hashtable();
        ourTaggedValues = new Hashtable();
        ourNoteLinks = new Vector();
        ourXmiElements = new Hashtable();
        ourNotInProjectElements = new Hashtable();
        ourEmptyReferences = new Hashtable();
        ourSkipJavaElements = false;
        XMITaggedValue.initTables();
        ourReturnTemplate = true;
        Entity entity = model.createEntityTemplate((Entity)model);
        String string = model.getPropertyValue("$metaclass");
        entity.setPropertyValue("$metaclass", string);
        ourParser = new XMLParser();
        XMIDocumentHandler xMIDocumentHandler = new XMIDocumentHandler(entity);
        xMIDocumentHandler.setErrorHandler(new XMIErrorHandler());
        ourParser.setErrorHandler(new XMIErrorHandler());
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Diagnostic.print("\n\nStarting parser Pass 1");
        ourPass = 1;
        ourParser.parse(fileInputStream, xMIDocumentHandler);
        XMI11Import.createParameters();
        XMI11Import.setAttributeTypes();
        XMI11Import.setOperationNames();
        XMI11Import.setConstructors();
        XMI11Import.processPartitions();
        XMI11Import.createGeneralizations();
        XMI11Import.createAssociations();
        XMI11Import.setBases();
        XMI11Import.createMessages();
        XMI11Import.createTransitions();
        XMI11Import.createDependencies();
        XMI11Import.setStereotypes();
        XMI11Import.setStereotypes2();
        XMI11Import.setTaggedValues(1);
        if (ourNeedJavaNature) {
            if (!ModelElementUtil.hasJavaNature((Element)model)) {
                Diagnostic.print("Need to add Java nature");
                ourSkipJavaElements = true;
            } else {
                Diagnostic.print("Java nature exists");
            }
        } else {
            Diagnostic.print("Java nature unnecessary");
        }
        ourReturnTemplate = false;
        l = new Date().getTime() - date2.getTime();
        Diagnostic.printTimeLog("1st pass: " + l + " ms");
        date2 = new Date();
        XMI11Import.createRealModel(entity, (Entity)model, 1);
        l = new Date().getTime() - date2.getTime();
        Diagnostic.printTimeLog("createEntities(nodes): " + l + " ms");
        date2 = new Date();
        XMI11Import.createRealModel(entity, (Entity)model, 2);
        l = new Date().getTime() - date2.getTime();
        Diagnostic.printTimeLog("createEntities(links): " + l + " ms");
        date2 = new Date();
        XMI11Import.setRealUINReferences();
        Diagnostic.print("\n\nStarting parser Pass 2");
        xMIDocumentHandler = new XMIDocumentHandler((Entity)model);
        xMIDocumentHandler.setErrorHandler(new XMIErrorHandler());
        ourPass = 2;
        try {
            ((InputStream)fileInputStream).close();
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ourParser.parse(fileInputStream, xMIDocumentHandler);
        XMI11Import.setEmptyReferences();
        XMI11Import.setTaggedValues(2);
        XMI11Import.setMessagesSequenceNumber();
        XMI11Import.createNoteLinks();
        l = new Date().getTime() - date2.getTime();
        Diagnostic.printTimeLog("2nd pass: " + l + " ms" + "(create references: " + ourReferenceTime + " ms)");
        date2 = new Date();
        l = new Date().getTime() - date.getTime();
        Diagnostic.printTimeLog("Total: " + l + " ms");
        date2 = new Date();
        Diagnostic.finish();
        if (ourSkipJavaElements) {
            MessageDialog messageDialog = new MessageDialog(null, XMIInterchangeMessages.getString("JavaNatureTitlte"), null, XMIInterchangeMessages.getFormattedString("JavaNatureMessage", model.getPropertyValue("$name")), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            messageDialog.open();
        }
        ourUINReferences = null;
        ourPackages = null;
        ourElements = null;
        ourElementIDs = null;
        ourReferences = null;
        ourOperations = null;
        ourConstructors = null;
        ourDatatypes = null;
        ourStereotypes = null;
        ourStereotypesById = null;
        ourStereotypeSeeks = null;
        ourParameters = null;
        ourAttributeTypes = null;
        ourGeneralizations = null;
        ourAssociations = null;
        ourBases = null;
        ourMessages = null;
        ourMessageReferences = null;
        ourActions = null;
        ourTransitions = null;
        ourDependencies = null;
        ourTaggedValues = null;
        ourEvents = null;
        ourPartitions = null;
        ourNoteLinks = null;
        ourXmiElements = null;
        ourNotInProjectElements = null;
        ourOperationCounter = 0;
        ourCurrentTransition = null;
        ourStereotypesID = null;
        ourStereotypesType = null;
        ourEmptyReferences = null;
        ourProgress.done();
    }

    private static boolean isLink(String string) {
        boolean bl = MetaclassUtil.isLink((String)string);
        bl = bl || "Message Link".equals(string);
        return bl;
    }

    public static void addExtendsImplements(Entity entity, String string, String string2) {
        ArrayList<Object[]> arrayList;
        if (ourExtendsImplements == null) {
            ourExtendsImplements = new Hashtable();
        }
        if ((arrayList = (ArrayList<Object[]>)ourExtendsImplements.get(entity)) == null) {
            arrayList = new ArrayList<Object[]>();
        }
        arrayList.add(new Object[]{string, string2});
        ourExtendsImplements.put(entity, arrayList);
    }

    private static void setExtendsImplements(Entity entity, Entity entity2) {
        ArrayList arrayList;
        if (ourExtendsImplements != null && (arrayList = (ArrayList)ourExtendsImplements.get(entity2)) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                Object[] objectArray = (Object[])arrayList.get(n);
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                Entity entity3 = XMI11Import.getElement(string2);
                if (entity3 != null) {
                    String string3 = entity3.getPropertyValue("$fullName");
                    if ("$implements".equals(string)) {
                        Diagnostic.print(entity.getPropertyValue("$fullName") + " IMPLEMENTS " + string3);
                    } else {
                        Diagnostic.print(entity.getPropertyValue("$fullName") + " EXTENDS " + string3);
                    }
                    if (entity.canAddProperty(string, string3)) {
                        entity.addProperty(string, string3);
                    } else {
                        Diagnostic.print("Can not add property EXTENDS/IMPLEMENTS");
                    }
                }
                ++n;
            }
        }
    }

    private static Entity findAssociationLink(String string, Entity entity) {
        Entity entity2 = null;
        if ("Association Link".equals(string)) {
            String string2 = entity.getPropertyValue("associationAttribute");
            if (string2 != null && string2.length() != 0) {
                Entity entity3 = XMI11Import.getElement(string2);
                if (entity3 != null) {
                    String string3 = entity3.getPropertyValue("$refAssociationLink");
                    if (string3 != null && string3.length() != 0) {
                        Entity entity4 = (Entity)entity.getModel().findElement(ModelAccess.createUniqueName((String)string3));
                        if (entity4 != null) {
                            entity2 = entity4;
                            Diagnostic.print("Found Association link " + entity4.getPropertyValue("$name"));
                        } else {
                            Diagnostic.print("%%% Incorrect   Association link !!!");
                        }
                    } else {
                        Diagnostic.print("%%% Incorrect   Association link !!!");
                    }
                } else {
                    Diagnostic.print("### Incorrect   Association link !!!");
                }
            } else {
                Diagnostic.print("*** Incorrect   Association link !!!");
            }
        }
        return entity2;
    }

    private static void createRealModel(Entity entity, Entity entity2, int n) throws InterruptedException {
        boolean bl = false;
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity3 = entityEnumeration.next();
            if (Boolean.TRUE.toString().equals(entity3.getPropertyValue("deleted"))) continue;
            String string = entity3.getPropertyValue("$metaclass");
            if (XMI11Import.skipJavaElements() && ("Class".equals(string) || "Interface".equals(string)) || n == 1 && XMI11Import.isLink(string)) continue;
            Diagnostic.print("Pass " + n + ". Try to create '" + string + "' : " + entity3.getPropertyValue("$name") + " in '" + entity2.getPropertyValue("$metaclass") + "' : " + entity2.getPropertyValue("$name"));
            boolean bl2 = false;
            if (n == 2 && !XMI11Import.isLink(string)) {
                bl2 = true;
            } else {
                if (n == 2 && XMI11Import.isLink(string)) {
                    XMI11Import.replaceParticipants(string, entity3);
                }
                bl2 = entity2.canCreateChildEntity(string, entity3);
            }
            if (bl2) {
                Entity entity4 = null;
                if (n == 2 && !XMI11Import.isLink(string)) {
                    entity4 = XMI11Import.realEntity(entity3);
                    Diagnostic.print("Already created on 1st pass " + entity4);
                    if ("Class".equals(string) || "Interface".equals(string)) {
                        XMI11Import.setExtendsImplements(entity4, entity3);
                    }
                } else {
                    if (bl) {
                        Diagnostic.print(">>> creating...");
                        XMIElementImpl.showProperties(entity3);
                    }
                    Enumeration enumeration = XMI11Import.storeProperties(entity3).elements();
                    Renamer.renamePackageIfExists(entity2, string, entity3);
                    Entity entity5 = XMI11Import.findAssociationLink(string, entity3);
                    entity4 = entity5 != null ? entity5 : entity2.createChildEntity(string, entity3);
                    if (entity4 != null && !(entity4 instanceof EntityTemplateImpl)) {
                        entity3.setPropertyValue(REAL_UIN, entity4.getUniqueName().toString());
                        if (bl) {
                            Diagnostic.print(">>> 2");
                            XMIElementImpl.showProperties(entity4);
                        }
                        XMI11Import.updateProperties(entity4, enumeration, bl);
                        if (bl) {
                            Diagnostic.print(">>> 3");
                            XMIElementImpl.showProperties(entity4);
                        }
                    } else {
                        Diagnostic.print("<<**** canCreate returns TRUE, but Create returns NULL  ****>>");
                    }
                }
                if (entity4 == null || entity4 instanceof EntityTemplateImpl) continue;
                XMI11Import.createRealModel(entity3, entity4, n);
                continue;
            }
            Diagnostic.print("child: " + entity3.getPropertyValue("$name") + " can't be created");
        }
    }

    public static void setRealUINReferences() {
        if (ourUINReferences != null) {
            Enumeration enumeration = ourUINReferences.keys();
            while (enumeration.hasMoreElements()) {
                Entity entity = (Entity)enumeration.nextElement();
                Object[] objectArray = (Object[])ourUINReferences.get(entity);
                Entity entity2 = (Entity)objectArray[0];
                String string = (String)objectArray[1];
                Entity entity3 = XMI11Import.realEntity(entity);
                UniqueName uniqueName = entity3.getUniqueName();
                if (uniqueName == null) continue;
                XMI11Import.realEntity(entity2).setPropertyValue(string, uniqueName.toString());
            }
        }
    }

    public static void storeUINReferences(Entity entity, Object[] objectArray) {
        if (ourUINReferences == null) {
            ourUINReferences = new Hashtable();
        }
        ourUINReferences.put(entity, objectArray);
    }

    private static void replaceParticipants(String string, Entity entity) {
        StringEnumeration stringEnumeration = entity.participantRoles();
        while (stringEnumeration.hasMoreElements()) {
            Entity entity2;
            Element element;
            String string2 = stringEnumeration.next();
            Hashtable<Element, Entity> hashtable = new Hashtable<Element, Entity>();
            ElementEnumeration elementEnumeration = entity.participants(string2);
            while (elementEnumeration.hasMoreElements()) {
                element = elementEnumeration.next();
                entity2 = XMI11Import.realEntity((Entity)element);
                hashtable.put(element, entity2);
            }
            element = hashtable.keys();
            while (element.hasMoreElements()) {
                entity2 = (Element)element.nextElement();
                Element element2 = (Element)hashtable.get(entity2);
                entity.setParticipant(string2, (Element)entity2, element2);
            }
            hashtable = null;
        }
    }

    public static void updateProperties(Entity entity, Enumeration enumeration, boolean bl) {
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            String string = property.getName();
            String string2 = property.getValue();
            if (bl) {
                Diagnostic.print(">>> NAME " + string);
            }
            if (!entity.hasProperty(string)) {
                if (bl) {
                    Diagnostic.print(">>> NOT FOUND");
                }
                if (entity.canSetPropertyValue(string, string2)) {
                    if (bl) {
                        Diagnostic.print(">>> TRY TO SET " + string + " to " + string2);
                    }
                    entity.setPropertyValue(string, string2);
                    if (!bl) continue;
                    Diagnostic.print(">>> SET " + string + " to " + string2);
                    continue;
                }
                if (!bl) continue;
                Diagnostic.print(">>> CAN'T SET");
                continue;
            }
            if (entity.hasPropertyValue(string, string2)) continue;
            if (entity.canAddProperty(string, string2)) {
                if (bl) {
                    Diagnostic.print(">>> TRY TO ADD " + string + " to " + string2);
                }
                entity.addProperty(string, string2);
                if (!bl) continue;
                Diagnostic.print(">>> ADD " + string + " to " + string2);
                continue;
            }
            if (bl) {
                Diagnostic.print(">>> TRY TO ADD - FAIL, TRY TO SET");
            }
            if (entity.canSetPropertyValue(string, string2)) {
                entity.setPropertyValue(string, string2);
                if (!bl) continue;
                Diagnostic.print(">>> SET " + string + " to " + string2);
                continue;
            }
            if (!bl) continue;
            Diagnostic.print(">>> CAN'T SET");
        }
    }

    public static Vector storeProperties(Entity entity) {
        Vector<Property> vector = new Vector<Property>();
        PropertyEnumeration propertyEnumeration = entity.properties();
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            vector.add(property);
        }
        return vector;
    }

    public static void addElement(String string, Entity entity) {
        if (entity == null) {
            return;
        }
        ourElements.put(string, entity);
        ourElementIDs.put(entity, string);
    }

    public static Entity realEntity(Entity entity) {
        String string;
        Entity entity2 = entity;
        if (entity != null && (string = entity.getPropertyValue(REAL_UIN)) != null) {
            UniqueName uniqueName = ModelAccess.createUniqueName((String)string);
            Model model = InterchangeUtils.getWizardData().getModel();
            entity2 = (Entity)model.findElement(uniqueName);
        }
        return entity2;
    }

    public static Entity getElement(String string) {
        if (ourElements == null || string == null) {
            return null;
        }
        return XMI11Import.realEntity((Entity)ourElements.get(string));
    }

    public static String getElementID(Object object) {
        if (ourElementIDs == null || object == null) {
            return null;
        }
        return (String)ourElementIDs.get(object);
    }

    public static void replaceElement(Object object, Object object2) {
        String string;
        if (object2 != null && (string = XMI11Import.getElementID(object)) != null) {
            ourElementIDs.remove(object);
            ourElementIDs.put(object2, string);
            ourElements.remove(string);
            ourElements.put(string, object2);
        }
    }

    public static void addStereotypeSeeks(String string, String string2) {
        Diagnostic.print("Adding stereotype request " + string + " : " + string2);
        ourStereotypeSeeks.put(string, string2);
    }

    public static String getNamespace(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String getLocalName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String getUMLNamespace() {
        return "UML";
    }

    public static void addStereotype(String string, XMIStereotype xMIStereotype) {
        Diagnostic.print("Adding stereotype " + string + " : " + xMIStereotype.getName());
        ourStereotypes.put(string, xMIStereotype);
        ourStereotypesID.add(string);
        ourStereotypesType.add(xMIStereotype);
    }

    public static void addStereotypeById(String string, XMIStereotype xMIStereotype) {
        Diagnostic.print("Adding stereotype by ID " + string + " : " + xMIStereotype.getName());
        ourStereotypesById.put(string, xMIStereotype);
    }

    public static void addNoteLink(XMIComment xMIComment, String string) {
        ourNoteLinks.add(new Object[]{xMIComment, string});
    }

    public static void addAction(String string, XMIAction xMIAction) {
        ourActions.put(string, xMIAction);
    }

    public static void addAssociation(String string, XMIAssociation xMIAssociation) {
        Diagnostic.print("Adding association, id = " + string);
        ourAssociations.put(string, xMIAssociation);
    }

    public static String getTemporaryID() {
        return "temporaryID" + ++ourIdCounter;
    }

    public static XMIStereotype getStereotype(String string) {
        if (ourStereotypes == null || string == null) {
            return null;
        }
        return (XMIStereotype)ourStereotypes.get(string);
    }

    public static Enumeration getStereotypes(String string) {
        if (ourStereotypesID == null || ourStereotypesType == null || string == null) {
            return null;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < ourStereotypesID.size()) {
            if (string.equals((String)ourStereotypesID.get(n))) {
                vector.add(ourStereotypesType.get(n));
            }
            ++n;
        }
        return vector.elements();
    }

    public static XMIStereotype getStereotypeById(String string) {
        if (ourStereotypesById == null || string == null) {
            return null;
        }
        return (XMIStereotype)ourStereotypesById.get(string);
    }

    public static void removeStereotype(String string) {
        if (ourStereotypes == null) {
            return;
        }
        ourStereotypes.remove(string);
    }

    public static void addAttributeType(Entity entity, String string) {
        ourAttributeTypes.put(entity, string);
    }

    public static void addDependency(String string, XMIDependency xMIDependency) {
        ourDependencies.put(string, xMIDependency);
    }

    public static XMIDependency getDependency(String string) {
        if (ourDependencies == null) {
            return null;
        }
        return (XMIDependency)ourDependencies.get(string);
    }

    public static void removeStereotypeById(String string) {
        if (ourStereotypes == null) {
            return;
        }
        ourStereotypesById.remove(string);
    }

    public static XMIAction getAction(String string) {
        if (ourActions == null || string == null) {
            return null;
        }
        return (XMIAction)ourActions.get(string);
    }

    public static Hashtable getActions() {
        return ourActions;
    }

    public static boolean isElementAlreadyCreated(Reference reference) {
        boolean bl = false;
        if (reference != null) {
            Entity entity = reference.getEntity();
            if (ourCreatedElements == null) {
                ourCreatedElements = new ArrayList();
            }
            if (!ourCreatedElements.contains(entity)) {
                ourCreatedElements.add(entity);
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public static void addReference(String string, Reference reference) {
        if (reference == null || string == null) {
            return;
        }
        ourReferences.put(string, reference);
    }

    public static void addTaggedValue(String string, XMITaggedValue xMITaggedValue) {
        ourTaggedValues.put(string, xMITaggedValue);
    }

    public static void addBase(XMIClassifierRole xMIClassifierRole, String string) {
        ourBases.put(xMIClassifierRole, string);
    }

    public static void addMessage(String string, XMIMessage xMIMessage) {
        ourMessages.put(string, xMIMessage);
    }

    public static void addMessageReference(Reference reference, String string) {
        if (reference == null || string == null || !string.startsWith("Message")) {
            return;
        }
        int n = string.lastIndexOf("SQN=");
        if (n > -1) {
            String string2 = string.substring(n + 4);
            if ((n = string2.lastIndexOf(",")) > 0) {
                string2 = string2.substring(0, n).trim();
            }
            Diagnostic.print("add SequenceNumber for " + reference.getEntity().getPropertyValue("$name") + " to " + string2);
            ourMessageReferences.add(new Object[]{reference, string2});
        }
    }

    private static void validate(ReferenceCollection referenceCollection) {
        Diagnostic.print("Validate: " + referenceCollection);
        if (referenceCollection != null) {
            Diagnostic.print("Name: " + referenceCollection.getPropertyValue("$name"));
            SequenceModelAccess.invalidateAllModels();
            SequenceModel sequenceModel = SequenceModelAccess.getModel((ReferenceCollection)referenceCollection);
            SequenceModelValidator sequenceModelValidator = new SequenceModelValidator(sequenceModel);
            sequenceModelValidator.validateSendingInstants();
            sequenceModelValidator.recountProcessingDuration();
        }
    }

    private static void setMessagesSequenceNumber() {
        if (ourMessageReferences != null) {
            Object object;
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = ourMessageReferences.toArray();
            Arrays.sort(objectArray3, new XMI11Import$1());
            Hashtable<Object[], Integer> hashtable = new Hashtable<Object[], Integer>();
            Hashtable<Object, Integer> hashtable2 = new Hashtable<Object, Integer>();
            int n = 0;
            while (n < objectArray3.length) {
                Object[] objectArray4 = (Object[])objectArray3[n];
                objectArray2 = (Object[])objectArray4[0];
                objectArray = (Object[])objectArray2.getParent();
                if (hashtable.containsKey(objectArray)) {
                    object = (Integer)hashtable.get(objectArray);
                    int n2 = (Integer)object + 1;
                    hashtable.put(objectArray, new Integer(n2));
                } else {
                    hashtable.put(objectArray, new Integer(1));
                    hashtable2.put(objectArray, new Integer(0));
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < objectArray3.length) {
                objectArray2 = (Object[])objectArray3[n3];
                objectArray = (Reference)objectArray2[0];
                object = objectArray.getEntity();
                ReferenceCollection referenceCollection = (ReferenceCollection)objectArray.getParent();
                int n4 = (Integer)hashtable.get(referenceCollection);
                int n5 = (Integer)hashtable2.get(referenceCollection) + 1;
                hashtable2.put(referenceCollection, new Integer(n5));
                double d = (double)n5 / (double)n4;
                if (object.canSetPropertyValue("normalizedIndex", Double.toString(d))) {
                    object.setPropertyValue("normalizedIndex", Double.toString(d));
                    Diagnostic.print("Set Normalized Index for " + object.getPropertyValue("$name") + " to " + Double.toString(d));
                }
                ++n3;
            }
            int n6 = 0;
            while (n6 < objectArray3.length) {
                objectArray = (Object[])objectArray3[n6];
                object = (Reference)objectArray[0];
                String string = (String)objectArray[1];
                object.setPropertyValue("sequenceNumber", string);
                Diagnostic.print("Set SequenceNumber for " + object.getEntity().getPropertyValue("$name") + " to " + string);
                ++n6;
            }
        }
    }

    public static void addXMIElement(String string, XMIElement xMIElement) {
        ourXmiElements.put(string, xMIElement);
    }

    public static void addDatatype(String string, String string2) {
        Diagnostic.print("Adding datatype " + string + " " + string2);
        ourDatatypes.put(string, string2);
    }

    public static String getDatatype(String string) {
        if (ourDatatypes == null || string == null) {
            return null;
        }
        return (String)ourDatatypes.get(string);
    }

    public static void addEvent(String string, XMIEvent xMIEvent) {
        ourEvents.put(string, xMIEvent);
    }

    public static XMINotInProjectElement getNotInProjectElement(String string) {
        if (ourXmiElements == null || string == null) {
            return null;
        }
        return (XMINotInProjectElement)ourNotInProjectElements.get(string);
    }

    public static void addGeneralization(String string, XMIGeneralization xMIGeneralization) {
        Diagnostic.print("Adding generalization, id = " + string + "; " + xMIGeneralization);
        ourGeneralizations.put(string, xMIGeneralization);
    }

    public static void addOperation(Entity entity, String string) {
        ourOperations.put(entity, string);
    }

    public static void addConstructor(Entity entity, String string) {
        ourConstructors.put(entity, string);
    }

    public static void addParameter(XMIParameter xMIParameter, Entity entity) {
        ourParameters.put(xMIParameter, entity);
    }

    public static XMIAssociation getAssociation(String string) {
        if (ourAssociations == null || string == null) {
            return null;
        }
        return (XMIAssociation)ourAssociations.get(string);
    }

    public static XMIGeneralization getGeneralization(String string) {
        if (ourGeneralizations == null || string == null) {
            return null;
        }
        return (XMIGeneralization)ourGeneralizations.get(string);
    }

    public static XMITransition getTransition(String string) {
        if (ourTransitions == null || string == null) {
            return null;
        }
        return (XMITransition)ourTransitions.get(string);
    }

    public static Enumeration getTransitions() {
        if (ourTransitions == null) {
            return null;
        }
        return ourTransitions.elements();
    }

    public static void addTransition(String string, XMITransition xMITransition) {
        ourTransitions.put(string, xMITransition);
        ourCurrentTransition = xMITransition;
    }

    public static XMITransition getCurrentTransition() {
        return ourCurrentTransition;
    }

    public static void addPartition(String string, XMIPartition xMIPartition) {
        ourPartitions.put(string, xMIPartition);
    }

    public static void addNotInProjectElement(String string, XMINotInProjectElement xMINotInProjectElement) {
        ourNotInProjectElements.put(string, xMINotInProjectElement);
    }

    public static XMIElement getXMIElement(String string) {
        if (ourXmiElements == null || string == null) {
            return null;
        }
        return (XMIElement)ourXmiElements.get(string);
    }

    public static String getNotInProjectElementName(String string) {
        if (ourXmiElements == null || string == null) {
            return null;
        }
        XMINotInProjectElement xMINotInProjectElement = (XMINotInProjectElement)ourNotInProjectElements.get(string);
        if (xMINotInProjectElement != null) {
            return xMINotInProjectElement.getElementName();
        }
        return null;
    }

    public static Reference getReference(String string) {
        if (ourReferences == null || string == null) {
            return null;
        }
        return (Reference)ourReferences.get(string);
    }

    public static XMIEvent getEvent(String string) {
        if (ourEvents == null || string == null) {
            return null;
        }
        return (XMIEvent)ourEvents.get(string);
    }

    public static XMIMessage getMessage(String string) {
        if (ourMessages == null || string == null) {
            return null;
        }
        return (XMIMessage)ourMessages.get(string);
    }

    public static String getTemporaryOperationName() {
        return "operation" + ++ourOperationCounter;
    }

    public static Entity getDefaultReferenceCollection(Entity entity) {
        String string = entity.getPropertyValue("DiagramUIN");
        UniqueName uniqueName = ModelAccess.createUniqueName((String)string);
        return entity.getModel().findEntity(uniqueName);
    }

    public static Entity createRwiDiagram(Entity entity, String string) {
        Diagnostic.print("New XMI11import.createRwiDiagram() " + string);
        ReferenceCollection referenceCollection = null;
        if (entity.canCreateChildReferenceCollection(string, null)) {
            referenceCollection = entity.createChildReferenceCollection(string, null);
        }
        return referenceCollection;
    }

    public static void setOperationNames() {
        Diagnostic.print("Setting operationNames");
        Enumeration enumeration = ourOperations.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string;
                Entity entity = (Entity)enumeration.nextElement();
                if (entity.isDeleted() || !entity.canSetPropertyValue("$name", string = (String)ourOperations.get(entity))) continue;
                entity.setPropertyValue("$name", string);
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
            }
        }
    }

    public static void setConstructors() {
        Diagnostic.print("Setting constructors");
        Enumeration enumeration = ourConstructors.keys();
        while (enumeration.hasMoreElements()) {
            try {
                Entity entity = (Entity)enumeration.nextElement();
                if (entity.canSetPropertyValue("$constructor", "true")) {
                    entity.setPropertyValue("$constructor", "true");
                    continue;
                }
                if (entity.canSetPropertyValue("constructor", "true")) {
                    entity.setPropertyValue("constructor", "true");
                    continue;
                }
                throw new XMIException("xmi.import.error.cannot.create", "constructor");
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
            }
        }
    }

    private static void createParameters() {
        Diagnostic.print("Creating parameters, there are " + ourParameters.size() + " parameteres");
        Enumeration enumeration = ourParameters.keys();
        while (enumeration.hasMoreElements()) {
            try {
                XMIParameter xMIParameter = (XMIParameter)enumeration.nextElement();
                Diagnostic.print("Creating parameter " + xMIParameter.getId());
                xMIParameter.setDataType();
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
            }
        }
    }

    private static void setAttributeTypes() {
        Diagnostic.print("Setting Attribute Types");
        Enumeration enumeration = ourAttributeTypes.keys();
        while (enumeration.hasMoreElements()) {
            try {
                Entity entity = (Entity)enumeration.nextElement();
                String string = (String)ourAttributeTypes.get(entity);
                String string2 = XMI11Import.getDatatype(string);
                Diagnostic.print("Setting type " + string2 + " to attribute " + entity.getPropertyValue("$name"));
                if (entity.canSetPropertyValue("$type", string2)) {
                    Diagnostic.print("Setting...");
                    entity.setPropertyValue("$type", string2);
                    continue;
                }
                Diagnostic.print("Failed...");
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
            }
        }
    }

    private static void createGeneralizations() {
        Diagnostic.print("Creating generalization links");
        Enumeration enumeration = ourGeneralizations.elements();
        while (enumeration.hasMoreElements()) {
            try {
                XMIGeneralization xMIGeneralization = (XMIGeneralization)enumeration.nextElement();
                Diagnostic.print("Creating generalization " + xMIGeneralization.getId());
                xMIGeneralization.createRwiElement();
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
        }
    }

    private static void createAssociations() {
        Diagnostic.print("Creating association links");
        Enumeration enumeration = ourAssociations.elements();
        while (enumeration.hasMoreElements()) {
            try {
                XMIAssociation xMIAssociation = (XMIAssociation)enumeration.nextElement();
                Diagnostic.print("Creating associaiton " + xMIAssociation.toString());
                xMIAssociation.createRwiElement();
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
        }
    }

    private static void createMessages() {
        Diagnostic.print("Creating messages");
        Enumeration enumeration = ourMessages.elements();
        while (enumeration.hasMoreElements()) {
            try {
                XMIMessage xMIMessage = (XMIMessage)enumeration.nextElement();
                Diagnostic.print("Creating message ");
                xMIMessage.createRwiElement();
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
        }
    }

    private static void createTransitions() {
        Diagnostic.print("Creating transitions");
        Enumeration enumeration = ourTransitions.elements();
        while (enumeration.hasMoreElements()) {
            try {
                XMITransition xMITransition = (XMITransition)enumeration.nextElement();
                Diagnostic.print("Creating transition ");
                xMITransition.createRwiElement();
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
        }
    }

    private static void createDependencies() {
        Diagnostic.print("Creating dependencies");
        Enumeration enumeration = ourDependencies.elements();
        while (enumeration.hasMoreElements()) {
            try {
                XMIDependency xMIDependency = (XMIDependency)enumeration.nextElement();
                Diagnostic.print("Creating dependency " + xMIDependency.getId());
                xMIDependency.createRwiElement();
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
        }
    }

    private static void setBases() {
        Diagnostic.print("Setting bases");
        Enumeration enumeration = ourBases.keys();
        while (enumeration.hasMoreElements()) {
            try {
                XMIClassifierRole xMIClassifierRole = (XMIClassifierRole)enumeration.nextElement();
                String string = (String)ourBases.get(xMIClassifierRole);
                Diagnostic.print("Setting base " + string);
                Entity entity = XMI11Import.getElement(string);
                xMIClassifierRole.setBase(entity);
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
                new XMIErrorHandler().error(new XMIException("xmi.import.error.unknown1" + exception.getMessage()));
            }
        }
    }

    public static void setStereotypes() {
        Diagnostic.print("Setting stereotypes");
        Enumeration enumeration = ourStereotypes.keys();
        while (enumeration.hasMoreElements()) {
            try {
                Object object;
                String string = (String)enumeration.nextElement();
                Entity entity = XMI11Import.getElement(string);
                if (entity == null) {
                    object = XMI11Import.getDependency(string);
                    if (object != null) {
                        entity = ((XMIElementImpl)object).getRwiElement();
                        Diagnostic.print("Setting stereotype for dependency " + string);
                    } else {
                        XMITransition xMITransition = XMI11Import.getTransition(string);
                        if (xMITransition != null) {
                            entity = xMITransition.getRwiElement();
                            Diagnostic.print("Setting stereotype for transition " + string);
                        } else {
                            XMIGeneralization xMIGeneralization = XMI11Import.getGeneralization(string);
                            if (xMIGeneralization != null) {
                                entity = xMIGeneralization.getRwiElement();
                                Diagnostic.print("Setting stereotype for generalization " + string);
                            }
                        }
                    }
                }
                object = XMI11Import.getStereotypes(string);
                while (object.hasMoreElements()) {
                    XMIStereotype xMIStereotype = (XMIStereotype)object.nextElement();
                    if (xMIStereotype == null || entity == null) continue;
                    Diagnostic.print("Setting stereotype " + xMIStereotype.getName() + " to " + entity.getPropertyValue("$name"));
                    xMIStereotype.setStereotype(entity);
                    XMI11Import.addElement(string, entity);
                }
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
                new XMIErrorHandler().error(new XMIException("xmi.import.error.unknown1", exception.getMessage()));
            }
        }
    }

    private static void setStereotypes2() {
        Enumeration enumeration = ourStereotypeSeeks.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string;
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)ourStereotypeSeeks.get(string2);
                XMIStereotype xMIStereotype = XMI11Import.getStereotypeById(string3);
                Entity entity = XMI11Import.getElement(string2);
                if (xMIStereotype == null || entity == null || (string = entity.getPropertyValue("@stereotype")) != null && string.length() != 0) continue;
                Diagnostic.print("Setting stereotype " + xMIStereotype.getName() + " to " + entity.getPropertyValue("$name"));
                xMIStereotype.setStereotype(entity);
                XMI11Import.addElement(string2, entity);
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
                new XMIErrorHandler().error(new XMIException("xmi.import.error.unknown1", exception.getMessage()));
            }
        }
    }

    private static void setTaggedValues(int n) {
        Object object;
        Diagnostic.print("Setting taggedValues");
        Enumeration enumeration = ourTaggedValues.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                XMITaggedValue xMITaggedValue = (XMITaggedValue)ourTaggedValues.get(string);
                String string2 = xMITaggedValue.getReference();
                Entity entity = XMI11Import.getElement(string2);
                if (entity == null) {
                    object = XMI11Import.getTransition(string2);
                    if (object != null) {
                        entity = ((XMIElementImpl)object).getRwiElement();
                    } else {
                        Reference reference = XMI11Import.getReference(string2);
                        if (reference != null) {
                            entity = reference;
                        } else {
                            XMIAssociation xMIAssociation = XMI11Import.getAssociation(string2);
                            if (xMIAssociation != null) {
                                entity = xMIAssociation.getRwiElement();
                            } else {
                                XMIDependency xMIDependency = XMI11Import.getDependency(string2);
                                if (xMIDependency != null) {
                                    entity = xMIDependency.getRwiElement();
                                }
                            }
                        }
                    }
                }
                Diagnostic.print("Setting tagged Value " + string2);
                if (entity == null) {
                    Diagnostic.print("Can't set value - element is null");
                    continue;
                }
                if ("showReturnArrow".equals(xMITaggedValue.getTag()) && n == 1) {
                    Diagnostic.print("Don't set value - return link");
                    continue;
                }
                if ("branchingAnchorUid".equals(xMITaggedValue.getTag()) && n == 1) {
                    Diagnostic.print("Don't set value - branching message");
                    continue;
                }
                xMITaggedValue.setTaggedValue((Element)entity);
                vector.add(string);
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
                new XMIErrorHandler().error(new XMIException("xmi.import.error.unknown1", exception.getMessage()));
            }
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (String)vector.get(n2);
            ourTaggedValues.remove(object);
            ++n2;
        }
    }

    public static void processPartitions() {
        Diagnostic.print("Setting Partitions");
        Enumeration enumeration = ourPartitions.elements();
        while (enumeration.hasMoreElements()) {
            try {
                XMIPartition xMIPartition = (XMIPartition)enumeration.nextElement();
                xMIPartition.assignChildren();
            }
            catch (XMIException xMIException) {
                new XMIErrorHandler().error(xMIException);
                Diagnostic.printError(xMIException);
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
                new XMIErrorHandler().error(new XMIException("xmi.import.error.unknown1", exception.getMessage()));
            }
        }
    }

    private static void createNoteLinks() {
        Diagnostic.print("Creating Note Links");
        Enumeration enumeration = ourNoteLinks.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Object[] objectArray = (Object[])enumeration.nextElement();
                XMIComment xMIComment = (XMIComment)objectArray[0];
                String string = (String)objectArray[1];
                Entity entity = XMI11Import.getElement(string);
                Diagnostic.print("Creating Note Entity to " + string + "(" + (entity == null ? "null" : entity.getPropertyValue("$name")) + ")");
                if (entity == null) continue;
                Entity entity2 = XMI11Import.getElement(xMIComment.getId());
                Entity entity3 = entity2.getModel().createEntityTemplate();
                entity3.setParticipant("Supplier", null, (Element)entity);
                entity3.setParticipant("Client", null, (Element)entity2);
                if (entity2 == null || !entity2.canCreateChildEntity("Note Link", entity3)) continue;
                entity2.createChildEntity("Note Link", entity3);
            }
            catch (Exception exception) {
                Diagnostic.printError(exception);
                new XMIErrorHandler().error(new XMIException("xmi.import.error.unknown1", exception.getMessage()));
            }
        }
    }

    public static void addDiagramSetFor(Entity entity) {
        if (ourMovedElements == null || entity == null) {
            return;
        }
        ourMovedElements.addElement(entity);
    }

    public static boolean isDiagramSet(Entity entity) {
        if (ourMovedElements == null || entity == null) {
            return false;
        }
        return ourMovedElements.contains(entity);
    }

    public static IProgressMonitor getProgressMonitor() {
        return ourProgress;
    }

    public static void setReplacementType(int n) {
        ourReplacementType = 1 == n || 2 == n ? n : 0;
    }

    public static int getReplacementType() {
        return ourReplacementType;
    }

    public static Entity changeMetaclass(Entity entity, String string) {
        entity.setPropertyValue("$metaclass", string);
        return entity;
    }

    public static void needJavaNature() {
        ourNeedJavaNature = true;
    }

    public static boolean skipJavaElements() {
        return ourSkipJavaElements;
    }

    public static void setExporterName(String string) {
        ourExporter = string;
    }

    public static void setExporterVersion(String string) {
        ourExporterVersion = string;
    }

    public static String getExporterName() {
        return ourExporter;
    }

    public static String getExporterVersion() {
        return ourExporterVersion;
    }

    public static boolean isRoseCompatible() {
        boolean bl = false;
        if ("Together".equals(XMI11Import.getExporterName()) && "6.1.01".equals(XMI11Import.getExporterVersion())) {
            bl = true;
        }
        return bl;
    }

    public static void addEmptyReference(XMIDiagramElement xMIDiagramElement, String string) {
        if (xMIDiagramElement == null || string == null || string.length() == 0) {
            return;
        }
        ourEmptyReferences.put(xMIDiagramElement, string);
    }

    public static void setEmptyReferences() throws XMIException {
        Enumeration enumeration = ourEmptyReferences.keys();
        while (enumeration.hasMoreElements()) {
            XMIDiagramElement xMIDiagramElement = (XMIDiagramElement)enumeration.nextElement();
            String string = (String)ourEmptyReferences.get(xMIDiagramElement);
            xMIDiagramElement.setDiagram(string, 2);
        }
    }

    static {
        ourReferenceTime = 0L;
        ourUINReferences = null;
    }
}

