/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.elements.XMIAction;
import com.togethersoft.selena.xmi.elements.XMIAssociation;
import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMICollaboration;
import com.togethersoft.selena.xmi.elements.XMIDependency;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.elements.XMIEvent;
import com.togethersoft.selena.xmi.elements.XMIMessage;
import com.togethersoft.selena.xmi.elements.XMINotInProjectElement;
import com.togethersoft.selena.xmi.elements.XMIPackage;
import com.togethersoft.selena.xmi.elements.XMIPartition;
import com.togethersoft.selena.xmi.elements.XMISignal;
import com.togethersoft.selena.xmi.elements.XMIState;
import com.togethersoft.selena.xmi.elements.XMIStateMachine;
import com.togethersoft.selena.xmi.elements.XMIStereotype;
import com.togethersoft.selena.xmi.elements.XMITaggedValue;
import com.togethersoft.selena.xmi.elements.XMITransition;
import com.togethersoft.selena.xmi.util.DataTypeCollector;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.IDManager;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMIElementCollector;
import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.togethersoft.selena.xmi.wizard.ExportPage;
import com.togethersoft.selena.xmi.wizard.XMIWizardData;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;

public class XMI11Export {
    public static final String EXPORTER_NAME = "Together";
    public static final String EXPORTER_VERSION = "6.1";
    public static final String EXPORTER_VERSION_FOR_ROSE = "6.1.01";
    public static final String XMI_VERSION = "1.2";
    private static boolean ourUnisysExtension;
    private static boolean ourRoseSpecific;
    private static boolean ourTCCSpecific;
    private static boolean ourProcessSubpackages;
    private static IDManager ourElementIDManager;
    private static IDManager ourModelIDManager;
    private static IDManager ourDiagramElementIDManager;
    private static XMIElementCollector ourAssociations;
    private static XMIElementCollector ourDependencies;
    private static Vector ourDiagrams;
    private static Hashtable ourDummyClasses;
    private static XMIElementCollector ourStereotypeCollector;
    private static XMLWriter ourWriter;
    private static Entity ourScopePackage;
    private static Entity ourScopeDiagram;
    private static DataTypeCollector ourDataTypeCollector;
    private static XMIElementCollector ourEventCollector;
    private static XMIElementCollector ourSignalCollector;
    private static XMIElementCollector ourUseCaseDiagramCollector;
    private static XMIElementCollector ourTaggedValueCollector;
    private static Hashtable ourExportedElements;
    private static Hashtable ourOutOfScopeElements;
    private static String ourMainModelID;
    private static Vector ourDiagramTypes;
    private static Vector ourExportedDiagrams;
    private static Hashtable ourIncompatibleElements;
    private static Stack ourStateMachineStack;
    private static Stack ourCollaborationStack;
    private static boolean ourWarningsGenerated;

    public static void export(OutputStream outputStream, boolean bl, boolean bl2, boolean bl3, IProgressMonitor iProgressMonitor, OutputStream outputStream2) throws Exception {
        try {
            Diagnostic.init(outputStream2);
            Diagnostic.print("Starting export");
            InterchangeUtils.initConstantsConverter(true);
            ourUnisysExtension = bl;
            ourRoseSpecific = bl2;
            ourTCCSpecific = bl3;
            ourWarningsGenerated = false;
            ourProcessSubpackages = true;
            ourElementIDManager = new IDManager("S");
            ourModelIDManager = new IDManager("G");
            ourDiagramElementIDManager = new IDManager("XX");
            ourAssociations = new XMIElementCollector();
            ourDependencies = new XMIElementCollector();
            ourDiagrams = new Vector();
            ourDummyClasses = new Hashtable();
            ourStereotypeCollector = new XMIElementCollector();
            ourDataTypeCollector = new DataTypeCollector();
            ourEventCollector = new XMIElementCollector();
            ourSignalCollector = new XMIElementCollector();
            ourUseCaseDiagramCollector = new XMIElementCollector();
            ourTaggedValueCollector = new XMIElementCollector();
            ourExportedElements = new Hashtable();
            ourExportedDiagrams = new Vector();
            ourOutOfScopeElements = new Hashtable();
            ourIncompatibleElements = new Hashtable();
            ourStateMachineStack = new Stack();
            ourCollaborationStack = new Stack();
            XMITaggedValue.initTables();
            String string = InterchangeUtils.getWizardData().getEncodingForJava();
            try {
                ourWriter = new XMLWriter(outputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Diagnostic.print("UnsupportedEncodingException *1* " + string);
                XMIWizardData xMIWizardData = InterchangeUtils.getWizardData();
                InterchangeUtils.getWizardData();
                xMIWizardData.setEncoding(XMIWizardData.getDefaultEncoding());
                string = InterchangeUtils.getWizardData().getEncodingForJava();
                try {
                    ourWriter = new XMLWriter(outputStream, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    Model model = InterchangeUtils.getWizardData().getModel();
                    Diagnostic.printError(XMIInterchangeMessages.getString("UnsupportedEncoding"), model.getUniqueName(), model.getUniqueName());
                    Diagnostic.print("UnsupportedEncodingException *2* " + string);
                    throw new InterruptedException();
                }
            }
            XMI11Export.createCollaboration();
            String string2 = "<?xml version = '1.0' encoding = '" + InterchangeUtils.getWizardData().getEncoding() + "' ?>";
            ourWriter.write(string2);
            ourWriter.writeStartTag("XMI");
            ourWriter.writeAttribute("xmi.version", XMI_VERSION);
            ourWriter.writeAttribute("xmlns:UML", "//org.omg/UML/1.3");
            ourWriter.writeCloseBrasket();
            ourWriter.writeStartTag("XMI.header", true);
            ourWriter.writeStartTag("XMI.documentation", true);
            ourWriter.writeStartTag("XMI.exporter", true);
            ourWriter.writeCDATA(EXPORTER_NAME);
            ourWriter.writeEndTag("XMI.exporter");
            ourWriter.writeStartTag("XMI.exporterVersion", true);
            if (XMI11Export.isRoseSpecificExport()) {
                ourWriter.writeCDATA(EXPORTER_VERSION_FOR_ROSE);
            } else {
                ourWriter.writeCDATA(EXPORTER_VERSION);
            }
            ourWriter.writeEndTag("XMI.exporterVersion");
            ourWriter.writeEndTag("XMI.documentation");
            ourWriter.writeStartTag("XMI.metamodel");
            ourWriter.writeAttribute("xmi.name", "UML");
            String string3 = "1.4";
            if (XMI11Export.isUnisysExport()) {
                string3 = "1.3";
            }
            ourWriter.writeAttribute("xmi.version", string3);
            ourWriter.writeCloseBrasket(true);
            ourWriter.writeEndTag("XMI.header");
            ourWriter.writeStartTag("XMI.content", true);
            ourWriter.writeStartTag("UML", "Model");
            Model model = InterchangeUtils.getWizardData().getModel();
            Entity entity = model.childEntities().next();
            ourMainModelID = XMI11Export.getElementID(model);
            ourWriter.writeAttribute("xmi.id", ourMainModelID);
            ourWriter.writeAttribute("name", "Project");
            ourWriter.writeAttribute("visibility", "public");
            ourWriter.writeCloseBrasket();
            XMI11Export.createStateMachine(ourMainModelID);
            ourWriter.writeStartTag("UML", "Namespace.ownedElement", true);
            EntityEnumeration entityEnumeration = model.childEntities();
            Entity entity2 = null;
            XMIPackage xMIPackage = null;
            Vector<XMIPackage> vector = new Vector<XMIPackage>();
            while (entityEnumeration.hasMoreElements()) {
                entity2 = entityEnumeration.next();
                if (entity2 == null) continue;
                if (InterchangeUtils.getWizardData().isExportedPackage(entity2)) {
                    xMIPackage = new XMIPackage(ourWriter, entity2, null, true);
                    vector.addElement(xMIPackage);
                    continue;
                }
                if (entity2.hasPropertyValue("$metaclass", "Package") || entity2.hasPropertyValue("$metaclass", "Model") || entity2.hasPropertyValue("$metaclass", "Root")) continue;
                xMIPackage = new XMIPackage(ourWriter, (Entity)model, null, true);
                vector.addElement(xMIPackage);
            }
            int n = 0;
            while (n < vector.size()) {
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ((XMIElement)vector.elementAt(n)).writeXMI11Element();
                iProgressMonitor.worked(1);
                ++n;
            }
            entityEnumeration = model.childEntities();
            while (entityEnumeration.hasMoreElements()) {
                entity2 = entityEnumeration.next();
                if (InterchangeUtils.getWizardData().isExportedPackage(entity2)) {
                    XMI11Export.recursiveDiagramWriter(entity2);
                    continue;
                }
                if (entity2.hasPropertyValue("$metaclass", "Package")) continue;
                XMI11Export.recursiveDiagramWriter((Entity)model);
            }
            XMI11Export.writeCurrentStateMachine();
            if (!ourCollaborationStack.isEmpty()) {
                XMICollaboration xMICollaboration = (XMICollaboration)ourCollaborationStack.pop();
                xMICollaboration.writeXMI11Element();
            }
            ourDataTypeCollector.write(ourWriter);
            ourDependencies.write(ourWriter);
            ourStereotypeCollector.write(ourWriter);
            ourAssociations.write(ourWriter);
            ourEventCollector.write(ourWriter);
            ourSignalCollector.write(ourWriter);
            XMI11Export.writeDummyClasses();
            XMI11Export.writeOutOfScopeElements();
            ourWriter.writeEndTag("UML", "Namespace.ownedElement");
            ourWriter.writeEndTag("UML", "Model");
            XMI11Export.exportDiagrams();
            ourTaggedValueCollector.write(ourWriter);
            ourWriter.writeEndTag("XMI.content");
            ourWriter.writeEndTag("XMI");
            if (ExportPage.isUML20Active(model)) {
                Diagnostic.printError(XMIInterchangeMessages.getString("Confirmation_UML20"), model.getUniqueName(), model.getUniqueName());
            }
            XMI11Export.showIncompatibleElementsList();
            ourWriter.close();
            Object var18_21 = null;
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            Diagnostic.finish();
            throw throwable;
        }
        Diagnostic.finish();
    }

    private static void recursiveDiagramWriter(Entity entity) {
        ReferenceCollectionEnumeration referenceCollectionEnumeration = entity.childReferenceCollections();
        ReferenceCollection referenceCollection = null;
        while (referenceCollectionEnumeration.hasMoreElements()) {
            referenceCollection = referenceCollectionEnumeration.next();
            try {
                ElementWriter.writeElement(ourWriter, (Entity)referenceCollection, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity2 = entityEnumeration.next();
            if (!"Package".equals(entity2.getPropertyValue("$metaclass")) || !InterchangeUtils.getWizardData().isExportedPackage(entity2)) continue;
            XMI11Export.recursiveDiagramWriter(entity2);
        }
    }

    public static void addStereotype(XMIStereotype xMIStereotype) {
        ourStereotypeCollector.addXMIElement(xMIStereotype);
    }

    public static String getModelID(Object object) {
        String string = ourModelIDManager.getID(object);
        return string;
    }

    public static boolean hasModelID(Entity entity) {
        if (entity == null) {
            return false;
        }
        return ourModelIDManager.containsKey(entity.getUniqueName());
    }

    public static boolean hasElementID(Entity entity) {
        if (entity == null) {
            return false;
        }
        return ourElementIDManager.containsKey(entity.getUniqueName());
    }

    public static boolean hasDiagramElementID(Entity entity) {
        if (entity == null) {
            return false;
        }
        return ourDiagramElementIDManager.containsKey(entity.getUniqueName());
    }

    public static String getElementID(Object object) {
        String string = ourElementIDManager.getID(object);
        return string;
    }

    public static String getDiagramElementID(Object object) {
        return ourDiagramElementIDManager.getID(object);
    }

    public static void addSignal(XMISignal xMISignal) {
        ourSignalCollector.addXMIElement(xMISignal);
    }

    public static boolean isExported(String string) {
        if (string == null) {
            return false;
        }
        return ourExportedElements.containsKey(string);
    }

    public static boolean isExported(Entity entity) {
        if (entity == null) {
            return false;
        }
        UniqueName uniqueName = entity.getUniqueName();
        if (uniqueName == null) {
            return false;
        }
        return ourExportedElements.containsKey(uniqueName);
    }

    public static void addExportedElement(Entity entity, String string) {
        if (entity == null) {
            return;
        }
        UniqueName uniqueName = entity.getUniqueName();
        if (uniqueName == null) {
            return;
        }
        ourExportedElements.put(uniqueName, string);
    }

    public static boolean isExportedDiagram(Entity entity) {
        if (entity == null) {
            return false;
        }
        String string = entity.getPropertyValue("$uniqueName");
        if (string == null) {
            return false;
        }
        return ourExportedDiagrams.contains(string);
    }

    public static String addDataType(Entity entity) {
        return ourDataTypeCollector.addDataType(entity);
    }

    public static String addDataType(String string) {
        return ourDataTypeCollector.addDataType(string);
    }

    public static void addTaggedValue(XMITaggedValue xMITaggedValue) {
        if (xMITaggedValue != null) {
            ourTaggedValueCollector.addXMIElement(xMITaggedValue);
        }
    }

    public static void addTaggedValue(Element element, XMLWriter xMLWriter, String string, String string2) {
        XMI11Export.addTaggedValue(element, xMLWriter, string, string2, false);
    }

    /*
     * Unable to fully structure code
     */
    public static void addTaggedValue(Element var0, XMLWriter var1_1, String var2_2, String var3_3, boolean var4_4) {
        block3: {
            var5_5 = var0.properties(var3_3);
            var6_6 = null;
            if (var5_5.hasMoreElements()) ** GOTO lbl11
            var6_6 = var0.getProperty(var3_3);
            if (var6_6 == null) break block3;
            XMI11Export._addTaggedValue(var6_6, var0, var1_1, var2_2, var3_3, var4_4);
            Diagnostic.print("!!! " + var0.getPropertyValue("$metaclass") + ".properties(" + var3_3 + ") incorrectly return EmptyEnumeration instead of { \"" + var6_6.getValue() + "\" }!!!");
            break block3;
lbl-1000:
            // 1 sources

            {
                var6_6 = var5_5.next();
                XMI11Export._addTaggedValue(var6_6, var0, var1_1, var2_2, var3_3, var4_4);
lbl11:
                // 2 sources

                ** while (var5_5.hasMoreElements())
            }
        }
    }

    private static void _addTaggedValue(Property property, Element element, XMLWriter xMLWriter, String string, String string2, boolean bl) {
        String string3 = property.getValue();
        if (string3 != null && string3.length() != 0) {
            String string4 = string2;
            if (bl) {
                if (string4.startsWith("@")) {
                    string4 = string4.substring(1);
                }
                string4 = XMITaggedValue.mapFromTWSEToRose(string4);
            }
            XMITaggedValue xMITaggedValue = new XMITaggedValue(xMLWriter, string, string4, string3);
            ourTaggedValueCollector.addXMIElement(xMITaggedValue);
        }
    }

    public static void addOutOfScopeElement(Entity entity, String string) {
        ourOutOfScopeElements.put(string, entity);
        XMI11Export.addExportedElement(entity, string);
    }

    public static String addDummyClass() {
        int n = ourDummyClasses.size();
        String string = "_DummyClass" + n + "_";
        String string2 = XMI11Export.getElementID(string);
        ourDummyClasses.put(string2, string);
        return string2;
    }

    public static void addAction(XMIAction xMIAction) {
        XMICollaboration xMICollaboration = (XMICollaboration)ourCollaborationStack.peek();
        if (xMICollaboration != null) {
            xMICollaboration.addAction(xMIAction);
        }
    }

    public static void addEvent(XMIEvent xMIEvent) {
        ourEventCollector.addXMIElement(xMIEvent);
    }

    public static void addAssociation(XMIAssociation xMIAssociation) {
        ourAssociations.addXMIElement(xMIAssociation);
    }

    public static void addDependency(XMIDependency xMIDependency) {
        ourDependencies.addXMIElement(xMIDependency);
    }

    public static void addState(XMIState xMIState) {
        XMIStateMachine xMIStateMachine = (XMIStateMachine)ourStateMachineStack.peek();
        if (xMIStateMachine != null) {
            xMIStateMachine.addState(xMIState);
        }
    }

    public static void addTransition(XMITransition xMITransition) {
        XMIStateMachine xMIStateMachine = (XMIStateMachine)ourStateMachineStack.peek();
        if (xMIStateMachine != null) {
            xMIStateMachine.addTransition(xMITransition);
        }
    }

    public static void addPartition(XMIPartition xMIPartition) {
        XMIStateMachine xMIStateMachine = (XMIStateMachine)ourStateMachineStack.peek();
        if (xMIStateMachine != null) {
            xMIStateMachine.addPartition(xMIPartition);
        }
    }

    public static void addStateObject(XMIClassifierRole xMIClassifierRole) {
        XMIStateMachine xMIStateMachine = (XMIStateMachine)ourStateMachineStack.peek();
        if (xMIStateMachine != null) {
            xMIStateMachine.addObject(xMIClassifierRole);
        }
    }

    public static void addClassifierRole(XMIClassifierRole xMIClassifierRole) {
        XMICollaboration xMICollaboration = (XMICollaboration)ourCollaborationStack.peek();
        if (xMICollaboration != null) {
            xMICollaboration.addClassifierRole(xMIClassifierRole);
        }
    }

    public static void addMessage(XMIMessage xMIMessage) {
        XMICollaboration xMICollaboration = (XMICollaboration)ourCollaborationStack.peek();
        if (xMICollaboration != null) {
            xMICollaboration.addMessage(xMIMessage);
        }
    }

    public static XMICollaboration getCurrentCollaboration() {
        XMICollaboration xMICollaboration = (XMICollaboration)ourCollaborationStack.peek();
        if (xMICollaboration != null) {
            return xMICollaboration;
        }
        return null;
    }

    public static void addDiagram(XMIDiagram xMIDiagram) {
        ourDiagrams.add(xMIDiagram);
    }

    public static void addExportedDiagram(Entity entity) {
        if (entity == null) {
            return;
        }
        String string = entity.getPropertyValue("$uniqueName");
        if (string == null) {
            return;
        }
        ourExportedDiagrams.addElement(string);
    }

    public static void addUseCaseDiagram(XMIDiagram xMIDiagram) {
        if (xMIDiagram != null && "Use Case Diagram".equals(xMIDiagram.getDiagramType())) {
            ourUseCaseDiagramCollector.addXMIElement(xMIDiagram);
        }
    }

    public static void writeUseCaseModel() throws Exception {
        if (!XMI11Export.isRoseSpecificExport()) {
            return;
        }
        if (ourUseCaseDiagramCollector.isEmpty()) {
            return;
        }
        ourWriter.writeStartTag("UML", "Model");
        ourWriter.writeAttribute("xmi.id", XMI11Export.getUseCaseModelID());
        ourWriter.writeAttribute("name", "Use Case View");
        ourWriter.writeAttribute("visibility", "public");
        ourWriter.writeAttribute("isSpecification", "false");
        ourWriter.writeAttribute("isAbstract", "false");
        ourWriter.writeCloseBrasket();
        ourWriter.writeStartTag("UML", "Namespace.ownedElement", true);
        ourUseCaseDiagramCollector.write(ourWriter);
        ourWriter.writeEndTag("UML", "Namespace.ownedElement");
        ourWriter.writeEndTag("UML", "Model");
        XMI11Export.addStereotype(new XMIStereotype(ourWriter, "useCaseModel", "Model", XMI11Export.getUseCaseModelID()));
    }

    public static String getUseCaseModelID() {
        return XMI11Export.getElementID("UseCaseModel");
    }

    public static String getIdref(String string) {
        if (string == null) {
            return null;
        }
        return (String)ourExportedElements.get(string);
    }

    public static String getIdref(Entity entity) {
        if (entity == null) {
            return null;
        }
        String string = entity.getPropertyValue("$uniqueName");
        if (string == null) {
            return null;
        }
        return (String)ourExportedElements.get(string);
    }

    public static boolean isUnisysExport() {
        return ourUnisysExtension;
    }

    public static String getMainModelID() {
        return ourMainModelID;
    }

    public static boolean isRoseSpecificExport() {
        return ourRoseSpecific;
    }

    public static boolean isTCCSpecificExport() {
        return ourTCCSpecific;
    }

    public static void addIncompatibleElement(Entity entity, Entity entity2) {
        if (entity2 == null) {
            entity2 = entity;
        }
        if (entity != null) {
            ourIncompatibleElements.put(entity, entity2);
        }
    }

    public static boolean isInProject(Entity entity) {
        boolean bl = false;
        if (entity != null && !entity.hasPropertyValue("$referenced", "true")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isExportedType(Entity entity) {
        if (entity == null) {
            return false;
        }
        String string = entity.getPropertyValue("$metaclass");
        if ("Sequence Diagram".equals(string) && "collaborationView".equals(entity.getPropertyValue("viewType"))) {
            string = "CollaborationDiagram";
        }
        return ourDiagramTypes == null || ourDiagramTypes.contains(string);
    }

    private static void exportDiagrams() throws Exception {
        if (!XMI11Export.isUnisysExport()) {
            return;
        }
        if (ourDiagrams != null) {
            int n = 0;
            while (n < ourDiagrams.size()) {
                if (ourDiagrams.elementAt(n) instanceof XMIDiagram) {
                    XMIDiagram xMIDiagram = (XMIDiagram)ourDiagrams.elementAt(n);
                    xMIDiagram.writeXMI11Diagram();
                }
                ++n;
            }
        }
    }

    public static boolean isSubpackageProcessing() {
        return ourProcessSubpackages;
    }

    public static void writeOutOfScopeElements() throws Exception {
        if (ourOutOfScopeElements == null || ourOutOfScopeElements.isEmpty()) {
            return;
        }
        Enumeration enumeration = ourOutOfScopeElements.elements();
        ourWriter.writeStartTag("UML", "Model");
        ourWriter.writeAttribute("xmi.id", XMI11Export.getElementID("outOfProjectElements"));
        ourWriter.writeAttribute("name", "__NotInProject__");
        ourWriter.writeCloseBrasket();
        ourWriter.writeStartTag("UML", "Namespace.ownedElement", true);
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            XMINotInProjectElement xMINotInProjectElement = new XMINotInProjectElement(ourWriter, entity);
            xMINotInProjectElement.writeXMI11Element();
        }
        ourWriter.writeEndTag("UML", "Namespace.ownedElement");
        ourWriter.writeEndTag("UML", "Model");
    }

    public static void createStateMachine(String string) {
        XMIStateMachine xMIStateMachine = new XMIStateMachine(ourWriter, string);
        ourStateMachineStack.push(xMIStateMachine);
    }

    public static void writeCurrentStateMachine() throws Exception {
        XMIStateMachine xMIStateMachine = (XMIStateMachine)ourStateMachineStack.peek();
        if (xMIStateMachine != null) {
            xMIStateMachine.writeXMI11Element();
        }
        ourStateMachineStack.pop();
    }

    public static String getStateMachineID() {
        XMIStateMachine xMIStateMachine = (XMIStateMachine)ourStateMachineStack.peek();
        if (xMIStateMachine != null) {
            return xMIStateMachine.getId();
        }
        return null;
    }

    public static void createCollaboration() {
        XMICollaboration xMICollaboration = new XMICollaboration(ourWriter);
        ourCollaborationStack.push(xMICollaboration);
    }

    public static String createInteraction(XMLWriter xMLWriter, XMIDiagram xMIDiagram) {
        XMICollaboration xMICollaboration = (XMICollaboration)ourCollaborationStack.peek();
        return xMICollaboration.createInteraction(xMLWriter, xMIDiagram);
    }

    public static String createInteraction(XMLWriter xMLWriter) {
        XMICollaboration xMICollaboration = (XMICollaboration)ourCollaborationStack.peek();
        return xMICollaboration.createInteraction(xMLWriter);
    }

    public static void writeCurrentCollaboration() throws Exception {
        XMICollaboration xMICollaboration = (XMICollaboration)ourCollaborationStack.peek();
        if (xMICollaboration != null) {
            xMICollaboration.writeXMI11Element();
        }
        ourCollaborationStack.pop();
    }

    public static void writeDummyClasses() throws Exception {
        Enumeration enumeration = ourDummyClasses.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)ourDummyClasses.get(string);
            ourWriter.writeStartTag("UML", "Class");
            ourWriter.writeAttribute("xmi.id", string);
            ourWriter.writeAttribute("name", string2);
            ourWriter.writeAttribute("visibility", "public");
            ourWriter.writeCloseBrasket(true);
        }
    }

    protected static void showIncompatibleElementsList() throws Exception {
        if (!(!ourRoseSpecific && ourTCCSpecific || ourIncompatibleElements.isEmpty())) {
            Enumeration enumeration = ourIncompatibleElements.keys();
            Entity entity = null;
            Entity entity2 = null;
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                entity = (Entity)enumeration.nextElement();
                if (entity == null) continue;
                entity2 = (Entity)ourIncompatibleElements.get(entity);
                String string3 = entity.getPropertyValue("$metaclass");
                String string4 = entity.getPropertyValue("$name");
                if (entity2 != entity) {
                    string2 = entity2.getPropertyValue("$name");
                    string = entity2.getPropertyValue("$metaclass");
                    Diagnostic.printError(XMIInterchangeMessages.getFormattedString("xmi.export.warning.element.unsupported.in", string3, string4, string, string2), entity2.getModel().getUniqueName(), entity.getUniqueName());
                    continue;
                }
                if (entity2 != null) {
                    string2 = entity2.getPropertyValue("$name");
                    string = entity2.getPropertyValue("$metaclass");
                    Diagnostic.printError(XMIInterchangeMessages.getFormattedString("xmi.export.warning.element.unsupported", string3, string4), entity2.getModel().getUniqueName(), entity.getUniqueName());
                    continue;
                }
                Diagnostic.printError(XMIInterchangeMessages.getFormattedString("xmi.export.warning.element.unsupported", string3, string4), null, null);
            }
        }
    }

    public static boolean isReferenceRoseCompatible(Reference reference) {
        if (reference == null) {
            return false;
        }
        Entity entity = reference.getEntity();
        ReferenceCollection referenceCollection = (ReferenceCollection)reference.getParent();
        String string = referenceCollection.getPropertyValue("$metaclass");
        if (entity == null) {
            return false;
        }
        String string2 = entity.getPropertyValue("$metaclass");
        boolean bl = true;
        if ("Association Link".equals(string2) && string.equals("Collaboration Diagram")) {
            bl = false;
        }
        if ("Object".equals(string2) && !string.equals("Sequence Diagram") && !string.equals("Collaboration Diagram")) {
            bl = false;
        }
        if ("Component".equals(string2) && !string.equals("Component Diagram")) {
            bl = false;
        }
        if ("System Boundary".equals(string2)) {
            bl = false;
        }
        if (!bl && !ourIncompatibleElements.contains(entity)) {
            XMI11Export.addIncompatibleElement(entity, (Entity)referenceCollection);
        }
        return bl;
    }

    public static boolean isRoseCompatible(Entity entity) {
        return entity != null;
    }

    public static boolean isWarningGenerated() {
        return ourWarningsGenerated;
    }

    public static void setWarningGenerated() {
        ourWarningsGenerated = true;
    }
}

