/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.Renamer$ConfirmationDialog;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.providers.resources.IRootManager;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class Renamer {
    private static List ourReservedKeywords = Arrays.asList("abstract", "double", "int", "strictfp", "boolean", "else", "interface", "super", "break", "extends", "long", "switch", "byte", "final", "native", "synchronized", "case", "finally", "new", "this", "catch", "float", "package", "throw", "char", "for", "private", "throws", "class", "goto", "protected", "transient", "const", "if", "public", "try", "continue", "implements", "return", "void", "default", "import", "short", "volatile", "do", "instanceof", "static", "while");

    public static Element setName(Entity entity, String string) throws XMIException {
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.set.property.null", "name");
        }
        if (string == null) {
            return null;
        }
        if (entity.isDeleted()) {
            return null;
        }
        string = Renamer.replaceProhibitedCharactersInName(string, entity);
        String string2 = entity.getPropertyValue("$metaclass");
        String string3 = entity.getPropertyValue("$name");
        Element element = null;
        if (entity.canSetPropertyValue("$name", string)) {
            Property property = entity.setPropertyValue("$name", string);
            element = entity;
        } else {
            element = Renamer.renameOrReplace(entity, string);
        }
        Diagnostic.print(string2 + " '" + string3 + "' successfully renamed to " + string);
        return element;
    }

    public static Element renameOrReplace(Entity entity, String string) throws XMIException {
        Entity entity2 = null;
        int n = XMI11Import.getReplacementType();
        if (n == 0) {
            String string2 = entity.getPropertyValue("$name");
            Renamer$ConfirmationDialog renamer$ConfirmationDialog = new Renamer$ConfirmationDialog(null, XMIInterchangeMessages.getFormattedString("Do_you_want_to_replace_existing_file_or_rename_it__39", string2));
            renamer$ConfirmationDialog.open();
            n = renamer$ConfirmationDialog.getChoice();
            if (renamer$ConfirmationDialog.isChecked()) {
                XMI11Import.setReplacementType(n);
            }
        }
        if (n == 2) {
            entity2 = entity;
        } else if (n == 1) {
            entity.delete();
            entity2 = entity;
        } else if (n == 4) {
            XMI11Import.getProgressMonitor().setCanceled(true);
        }
        return entity2;
    }

    public static void renamePackageIfExists(Entity entity, String string, Entity entity2) throws InterruptedException {
        Entity entity3;
        if (entity2 == null) {
            return;
        }
        String string2 = entity2.getPropertyValue("$name");
        if ("Package".equals(string) && (entity3 = Renamer.findPackage(entity, string2)) != null) {
            try {
                Element element = Renamer.renameOrReplace(entity3, string2);
                if (element == null) {
                    throw new InterruptedException();
                }
            }
            catch (XMIException xMIException) {
                Diagnostic.printError(xMIException);
            }
        }
    }

    private static Entity findPackage(Entity entity, String string) {
        Entity entity2 = null;
        if (string != null) {
            EntityEnumeration entityEnumeration = entity.childEntities();
            while (entityEnumeration.hasMoreElements()) {
                Entity entity3 = entityEnumeration.next();
                if (!"Package".equals(entity3.getPropertyValue("$metaclass")) || !string.equals(entity3.getPropertyValue("$name"))) continue;
                entity2 = entity3;
                break;
            }
        }
        return entity2;
    }

    private static Element renameElement(Entity entity, String string) throws XMIException {
        Element element = null;
        int n = 1;
        while (n < 1000) {
            if (entity.canSetPropertyValue("$name", string + n)) {
                Property property = entity.setPropertyValue("$name", string + n);
                element = property.getElement();
                entity.setPropertyValue("originalName", string);
                return element;
            }
            ++n;
        }
        throw new XMIException("xmi.import.error.cannot.rename", string);
    }

    private static Element replaceElement(Entity entity, String string) throws XMIException {
        Element element = null;
        if (entity == null) {
            throw new XMIException("xmi.import.error.unknown");
        }
        Model model = entity.getModel();
        IProject iProject = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        if (iProject == null || !iProject.isAccessible()) {
            throw new XMIException("xmi.import.error.unknown");
        }
        IRootManager iRootManager = RootManagerAccess.getRootManager((IProject)iProject);
        IRootRelativePath iRootRelativePath = iRootManager.extractRootRelativePath(entity.getUniqueName());
        IPath iPath = iRootRelativePath.removeLastSegments(1);
        RootRelativePath rootRelativePath = RootRelativePath.valueOf((IPath)(iPath = iPath.append(string)));
        UniqueName uniqueName = iRootManager.getUniqueName((IRootRelativePath)rootRelativePath);
        Entity entity2 = (Entity)model.findElement(uniqueName);
        if (entity2 == null) {
            throw new XMIException("xmi.import.error.unknown");
        }
        if (!entity2.canDelete()) {
            throw new XMIException("xmi.import.error.unknown");
        }
        entity2.delete();
        if (entity.canSetPropertyValue("$name", string)) {
            Property property = entity.setPropertyValue("$name", string);
            element = property.getElement();
            return element;
        }
        throw new XMIException("xmi.import.error.cannot.set.name", string);
    }

    private static String replaceProhibitedCharactersInName(String string, Entity entity) {
        if (string == null || entity == null) {
            return string;
        }
        String string2 = entity.getPropertyValue("$metaclass");
        if ("Class".equals(string2) || "Package".equals(string2) || "Actor".equals(string2) || "Operation".equals(string2) || "Attribute".equals(string2)) {
            boolean bl = false;
            String string3 = string;
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (!Character.isJavaIdentifierPart(stringBuffer.charAt(n))) {
                    stringBuffer.setCharAt(n, '_');
                    bl = true;
                }
                ++n;
            }
            string = stringBuffer.toString();
            if ("Attribute".equals(string2) && Renamer.isReservedKeyword(string)) {
                bl = true;
                string = string + "_";
            }
            if (bl && "Attribute".equals(string2)) {
                entity.setPropertyValue("@XMIName", string3);
                entity.setPropertyValue("@alias", string3);
            }
        }
        return string;
    }

    private static boolean isReservedKeyword(String string) {
        return ourReservedKeywords.contains(string);
    }
}

