/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.util.DefaultMapDescriptor;
import com.togethersoft.selena.xmi.util.IMapDescriptor;
import com.togethersoft.selena.xmi.wizard.XMIPlugin;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class MapsRegistryReader {
    public static final String CONVERT_TO_RATIONAL_MAP = "rationalMap";
    public static final String CONVERT_TO_TCC_MAP = "tccMap";
    static final String TAG_MAP = "map";
    static final String ATT_MAPNAME = "name";
    static final String ATT_MAPUID = "uid";
    static final String TAG_MAPENTRY = "map-entry";
    static final String ATT_EXTERNAL_TAG = "extenral_tag";
    static final String ATT_INTERNAL_TAG = "internal_tag";
    private static MapsRegistryReader myInstance;
    private HashMap myMaps = null;

    public static MapsRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new MapsRegistryReader();
        }
        return myInstance;
    }

    public IMapDescriptor getMap(String string) {
        if (this.myMaps == null) {
            this.myMaps = new HashMap();
            this.readRegistry();
        }
        return (IMapDescriptor)this.myMaps.get(string);
    }

    private void readRegistry() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        String string = XMIPlugin.getInstance().getDescriptor().getUniqueIdentifier();
        String string2 = "convert-map";
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(string, string2);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        IConfigurationElement[] iConfigurationElementArray = null;
        int n = 0;
        while (n < iExtensionArray.length) {
            iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                this.readElement(iConfigurationElementArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    private void readElement(IConfigurationElement iConfigurationElement) {
        if (TAG_MAP.equals(iConfigurationElement.getName())) {
            IMapDescriptor iMapDescriptor = this.registerMap(iConfigurationElement);
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.readEntry(iConfigurationElementArray[n], iMapDescriptor);
                ++n;
            }
        }
    }

    private void readEntry(IConfigurationElement iConfigurationElement, IMapDescriptor iMapDescriptor) {
        if (TAG_MAPENTRY.equals(iConfigurationElement.getName())) {
            this.registerMapEntry(iConfigurationElement, iMapDescriptor);
        }
    }

    private IMapDescriptor registerMap(IConfigurationElement iConfigurationElement) {
        IMapDescriptor iMapDescriptor = null;
        String string = iConfigurationElement.getAttribute(ATT_MAPNAME);
        String string2 = iConfigurationElement.getAttribute(ATT_MAPUID);
        if (string != null && string2 != null && (iMapDescriptor = (IMapDescriptor)this.myMaps.get(string2)) == null) {
            iMapDescriptor = new DefaultMapDescriptor(string, string2);
            this.myMaps.put(string2, iMapDescriptor);
        }
        return iMapDescriptor;
    }

    private void registerMapEntry(IConfigurationElement iConfigurationElement, IMapDescriptor iMapDescriptor) {
        String string = iConfigurationElement.getAttribute(ATT_EXTERNAL_TAG);
        String string2 = iConfigurationElement.getAttribute(ATT_INTERNAL_TAG);
        if (string != null && string2 != null) {
            iMapDescriptor.addPair(string2, string);
        }
    }
}

